/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Transformer;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerElementBean;

public class CmsContainerPageBean {
    private final Map<String, CmsContainerBean> m_containers;
    private transient Map<CmsUUID, Boolean> m_containsElement;
    private transient List<CmsUUID> m_elementIds;
    private transient List<CmsContainerElementBean> m_elements;
    private final Locale m_locale;
    private final List<String> m_names;
    private final Set<String> m_types;

    public CmsContainerPageBean(Locale locale, List<CmsContainerBean> containers) {
        this.m_locale = locale;
        LinkedHashMap<String, CmsContainerBean> cnts = new LinkedHashMap<String, CmsContainerBean>();
        HashSet<String> types = new HashSet<String>();
        ArrayList<String> names = new ArrayList<String>();
        for (CmsContainerBean container : containers) {
            cnts.put(container.getName(), container);
            types.add(container.getType());
            names.add(container.getName());
        }
        this.m_containers = Collections.unmodifiableMap(cnts);
        this.m_types = Collections.unmodifiableSet(types);
        this.m_names = Collections.unmodifiableList(names);
    }

    public boolean containsElement(CmsUUID elementId) {
        return this.getElementIds().contains(elementId);
    }

    public Map<String, CmsContainerBean> getContainers() {
        return this.m_containers;
    }

    public Map<CmsUUID, Boolean> getContainsElement() {
        if (this.m_containsElement == null) {
            this.m_containsElement = CmsCollectionsGenericWrapper.createLazyMap(new Transformer(){

                public Object transform(Object input) {
                    return CmsContainerPageBean.this.containsElement((CmsUUID)input);
                }
            });
        }
        return this.m_containsElement;
    }

    public List<CmsUUID> getElementIds() {
        if (this.m_elementIds == null) {
            this.m_elementIds = new ArrayList<CmsUUID>(this.getElements().size());
            for (CmsContainerElementBean element : this.getElements()) {
                this.m_elementIds.add(element.getId());
            }
        }
        return this.m_elementIds;
    }

    public List<CmsContainerElementBean> getElements() {
        if (this.m_elements == null) {
            this.m_elements = new ArrayList<CmsContainerElementBean>();
            for (CmsContainerBean container : this.m_containers.values()) {
                this.m_elements.addAll(container.getElements());
            }
        }
        return this.m_elements;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public List<String> getNames() {
        return this.m_names;
    }

    public Set<String> getTypes() {
        return this.m_types;
    }
}

