/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeJsp;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.containerpage.Messages;

public final class CmsFormatterConfiguration {
    public static final CmsFormatterConfiguration EMPTY_CONFIGURATION = new CmsFormatterConfiguration(null, null);
    public static final Log LOG = CmsLog.getLog(CmsFormatterConfiguration.class);
    private static CmsObject m_adminCms;
    private List<I_CmsFormatterBean> m_allFormatters;
    private Map<CmsUUID, Boolean> m_searchContent = Maps.newHashMap();

    private CmsFormatterConfiguration(CmsObject cms, List<I_CmsFormatterBean> formatters) {
        this.m_allFormatters = formatters == null ? Collections.emptyList() : new ArrayList<I_CmsFormatterBean>(formatters);
        this.init(cms, m_adminCms);
    }

    public static CmsFormatterConfiguration create(CmsObject cms, List<I_CmsFormatterBean> formatters) {
        if (formatters != null && formatters.size() > 0 && cms != null) {
            return new CmsFormatterConfiguration(cms, formatters);
        }
        return EMPTY_CONFIGURATION;
    }

    public static void initialize(CmsObject cms) throws CmsException {
        OpenCms.getRoleManager().checkRole(cms, CmsRole.ADMINISTRATOR);
        try {
            m_adminCms = OpenCms.initCmsObject(cms);
            m_adminCms.getRequestContext().setSiteRoot("");
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
    }

    public List<I_CmsFormatterBean> getAllFormatters() {
        return new ArrayList<I_CmsFormatterBean>(this.m_allFormatters);
    }

    public List<I_CmsFormatterBean> getAllMatchingFormatters(String containerType, int containerWidth) {
        return new ArrayList<I_CmsFormatterBean>(Collections2.filter(this.m_allFormatters, (Predicate)new MatchesTypeOrWidth(containerType, containerWidth)));
    }

    public I_CmsFormatterBean getDefaultFormatter(String containerType, int containerWidth) {
        Optional result = Iterables.tryFind(this.m_allFormatters, (Predicate)new MatchesTypeOrWidth(containerType, containerWidth));
        return (I_CmsFormatterBean)result.orNull();
    }

    public I_CmsFormatterBean getDefaultSchemaFormatter(String containerType, int containerWidth) {
        Optional result = Iterables.tryFind(this.m_allFormatters, (Predicate)Predicates.and((Predicate)new IsSchemaFormatter(), (Predicate)new MatchesTypeOrWidth(containerType, containerWidth)));
        return (I_CmsFormatterBean)result.orNull();
    }

    public I_CmsFormatterBean getDetailFormatter(String type, int containerWidth) {
        Predicate checkValidDetailFormatter = Predicates.and((Predicate)new MatchesTypeOrWidth(type, containerWidth), (Predicate)new IsDetail());
        Optional result = Iterables.tryFind(this.m_allFormatters, (Predicate)checkValidDetailFormatter);
        return (I_CmsFormatterBean)result.orNull();
    }

    public Collection<I_CmsFormatterBean> getDetailFormatters() {
        return Collections.unmodifiableCollection(Collections2.filter(this.m_allFormatters, (Predicate)new IsDetail()));
    }

    public Map<String, I_CmsFormatterBean> getFormatterSelection(String containerType, int containerWidth) {
        LinkedHashMap<String, I_CmsFormatterBean> result = new LinkedHashMap<String, I_CmsFormatterBean>();
        boolean hasSchemaFormatter = false;
        for (I_CmsFormatterBean formatter : Collections2.filter(this.m_allFormatters, (Predicate)new MatchesTypeOrWidth(containerType, containerWidth))) {
            if (formatter.isFromFormatterConfigFile()) {
                result.put(formatter.getId(), formatter);
                continue;
            }
            if (hasSchemaFormatter) continue;
            hasSchemaFormatter = true;
            result.put("schema_formatter", formatter);
        }
        return result;
    }

    public I_CmsFormatterBean getPreviewFormatter() {
        Optional result = Iterables.tryFind(this.m_allFormatters, (Predicate)new Predicate<I_CmsFormatterBean>(){

            public boolean apply(I_CmsFormatterBean formatter) {
                return formatter.isPreviewFormatter();
            }
        });
        if (!result.isPresent()) {
            result = Iterables.tryFind(this.m_allFormatters, (Predicate)new Predicate<I_CmsFormatterBean>(){

                public boolean apply(I_CmsFormatterBean formatter) {
                    if (formatter.isTypeFormatter()) {
                        return formatter.getContainerTypes().contains("_PREVIEW_");
                    }
                    return formatter.getMinWidth() <= 640 && 640 <= formatter.getMaxWidth();
                }
            });
        }
        if (!result.isPresent()) {
            result = Iterables.tryFind(this.m_allFormatters, (Predicate)new Predicate<I_CmsFormatterBean>(){

                public boolean apply(I_CmsFormatterBean formatter) {
                    return !formatter.isTypeFormatter() && formatter.getMaxWidth() >= 640;
                }
            });
        }
        if (!result.isPresent() && !this.m_allFormatters.isEmpty()) {
            result = Optional.fromNullable((Object)this.m_allFormatters.iterator().next());
        }
        return (I_CmsFormatterBean)result.orNull();
    }

    public boolean hasFormatter(String containerType, int containerWidth) {
        return this.getDefaultFormatter(containerType, containerWidth) != null;
    }

    public boolean hasFormatters() {
        return !this.m_allFormatters.isEmpty();
    }

    public boolean isSearchContent(CmsUUID formatterStructureId) {
        if (EMPTY_CONFIGURATION == this) {
            return false;
        }
        Boolean result = this.m_searchContent.get(formatterStructureId);
        if (result == null) {
            for (I_CmsFormatterBean formatter : this.m_allFormatters) {
                if (!formatter.getJspStructureId().equals(formatterStructureId)) continue;
                result = formatter.isSearchContent();
                break;
            }
            if (result == null) {
                result = Boolean.FALSE;
            }
            this.m_searchContent.put(formatterStructureId, result);
        }
        return result;
    }

    private void init(CmsObject userCms, CmsObject adminCms) {
        ArrayList<I_CmsFormatterBean> filteredFormatters = new ArrayList<I_CmsFormatterBean>();
        for (I_CmsFormatterBean formatter : this.m_allFormatters) {
            if (formatter.getJspStructureId() == null) {
                CmsResource res = null;
                try {
                    CmsObject cmsCopy = OpenCms.initCmsObject(adminCms);
                    cmsCopy.getRequestContext().setCurrentProject(userCms.getRequestContext().getCurrentProject());
                    cmsCopy.getRequestContext().setSiteRoot("");
                    res = cmsCopy.readResource(formatter.getJspRootPath());
                }
                catch (CmsException e) {
                    // empty catch block
                }
                if (res == null || !CmsResourceTypeJsp.isJsp(res)) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_FORMATTER_JSP_DONT_EXIST_1", formatter.getJspRootPath()));
                } else {
                    formatter.setJspStructureId(res.getStructureId());
                }
            }
            if (formatter.getJspStructureId() != null) {
                filteredFormatters.add(formatter);
                continue;
            }
            LOG.warn((Object)("Invalid formatter: " + formatter.getJspRootPath()));
        }
        Collections.sort(filteredFormatters, new FormatterComparator());
        this.m_allFormatters = Collections.unmodifiableList(filteredFormatters);
    }

    private class MatchesTypeOrWidth
    implements Predicate<I_CmsFormatterBean> {
        private String m_type;
        private int m_width;

        public MatchesTypeOrWidth(String type, int width) {
            this.m_type = type;
            this.m_width = width;
        }

        public boolean apply(I_CmsFormatterBean formatter) {
            if (formatter.isMatchAll()) {
                return true;
            }
            if (formatter.isTypeFormatter()) {
                return formatter.getContainerTypes().contains(this.m_type);
            }
            return formatter.getMinWidth() <= this.m_width && this.m_width <= formatter.getMaxWidth();
        }
    }

    public static class IsSchemaFormatter
    implements Predicate<I_CmsFormatterBean> {
        public boolean apply(I_CmsFormatterBean formatter) {
            return !formatter.isFromFormatterConfigFile();
        }
    }

    public static class IsDetail
    implements Predicate<I_CmsFormatterBean> {
        public boolean apply(I_CmsFormatterBean formatter) {
            return formatter.isDetailFormatter();
        }
    }

    public static class FormatterComparator
    implements Comparator<I_CmsFormatterBean> {
        @Override
        public int compare(I_CmsFormatterBean first, I_CmsFormatterBean second) {
            return ComparisonChain.start().compare(second.getRank(), first.getRank()).compare(second.isTypeFormatter() ? 1 : 0, first.isTypeFormatter() ? 1 : 0).compare(second.getMinWidth(), first.getMinWidth()).result();
        }
    }
}

