/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.acacia.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.List;
import java.util.Map;
import org.opencms.acacia.shared.CmsAttributeConfiguration;
import org.opencms.acacia.shared.CmsEntity;
import org.opencms.acacia.shared.CmsTabInfo;
import org.opencms.acacia.shared.CmsType;

public class CmsContentDefinition
implements IsSerializable {
    public static final String NATIVE_RENDERER = "native";
    public static final String FUNCTION_RENDER_FORM = "renderForm";
    public static final String FUNCTION_RENDER_INLINE = "renderInline";
    public static final String PARAM_INIT_CALL = "init";
    private Map<String, CmsAttributeConfiguration> m_configurations;
    private Map<String, CmsEntity> m_entities;
    private String m_entityId;
    private boolean m_groupOptionalFields;
    private String m_locale;
    private List<CmsTabInfo> m_tabInfos;
    private Map<String, CmsType> m_types;

    public CmsContentDefinition(String entityId, Map<String, CmsEntity> entities, Map<String, CmsAttributeConfiguration> configurations, Map<String, CmsType> types, List<CmsTabInfo> tabInfos, boolean groupOptionalFields, String locale) {
        this.m_entityId = entityId;
        this.m_entities = entities;
        this.m_configurations = configurations;
        this.m_types = types;
        this.m_tabInfos = tabInfos;
        this.m_groupOptionalFields = groupOptionalFields;
        this.m_locale = locale;
    }

    protected CmsContentDefinition() {
    }

    public static int extractIndex(String attributeName) {
        int index = 0;
        if (attributeName.endsWith("]") && attributeName.contains("[")) {
            try {
                String temp = attributeName.substring(attributeName.lastIndexOf("[") + 1, attributeName.length() - 1);
                index = Integer.parseInt(temp);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return index;
    }

    public static String removeIndex(String attributeName) {
        if (attributeName.endsWith("]") && attributeName.contains("[")) {
            attributeName = attributeName.substring(0, attributeName.lastIndexOf("["));
        }
        return attributeName;
    }

    public Map<String, CmsAttributeConfiguration> getConfigurations() {
        return this.m_configurations;
    }

    public Map<String, CmsEntity> getEntities() {
        return this.m_entities;
    }

    public CmsEntity getEntity() {
        return this.m_entities.get(this.m_entityId);
    }

    public String getEntityId() {
        return this.m_entityId;
    }

    public String getEntityTypeName() {
        return this.getEntity().getTypeName();
    }

    public String getLocale() {
        return this.m_locale;
    }

    public List<CmsTabInfo> getTabInfos() {
        return this.m_tabInfos;
    }

    public Map<String, CmsType> getTypes() {
        return this.m_types;
    }

    public boolean isGroupOptionalFields() {
        return this.m_groupOptionalFields;
    }
}

