/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.acacia.shared;

import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.SimpleEventBus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opencms.acacia.shared.CmsContentDefinition;
import org.opencms.acacia.shared.CmsEntityAttribute;

public class CmsEntity
implements HasValueChangeHandlers<CmsEntity>,
Serializable {
    private static final long serialVersionUID = -6933931178070025267L;
    private Map<String, List<CmsEntity>> m_entityAttributes;
    private String m_id;
    private Map<String, List<String>> m_simpleAttributes;
    private String m_typeName;
    private transient SimpleEventBus m_eventBus;
    private transient EntityChangeHandler m_childChangeHandler = new EntityChangeHandler();
    private transient Map<String, HandlerRegistration> m_changeHandlerRegistry;

    public CmsEntity(String id, String typeName) {
        this();
        this.m_id = id;
        this.m_typeName = typeName;
    }

    protected CmsEntity() {
        this.m_simpleAttributes = new HashMap<String, List<String>>();
        this.m_entityAttributes = new HashMap<String, List<CmsEntity>>();
        this.m_changeHandlerRegistry = new HashMap<String, HandlerRegistration>();
    }

    public static String getValueForPath(CmsEntity entity, String[] pathElements) {
        String result = null;
        if (pathElements != null && pathElements.length >= 1) {
            CmsEntityAttribute attribute;
            String attributeName = pathElements[0];
            int index = CmsContentDefinition.extractIndex(attributeName);
            if (index > 0) {
                --index;
            }
            if (!((attribute = entity.getAttribute(attributeName = entity.getTypeName() + "/" + CmsContentDefinition.removeIndex(attributeName))) == null || attribute.isComplexValue() && pathElements.length == 1)) {
                if (attribute.isSimpleValue()) {
                    if (pathElements.length == 1 && attribute.getValueCount() > 0) {
                        List<String> values = attribute.getSimpleValues();
                        result = values.get(index);
                    }
                } else if (attribute.getValueCount() > index) {
                    String[] childPathElements = new String[pathElements.length - 1];
                    for (int i = 1; i < pathElements.length; ++i) {
                        childPathElements[i - 1] = pathElements[i];
                    }
                    List<CmsEntity> values = attribute.getComplexValues();
                    result = CmsEntity.getValueForPath(values.get(index), childPathElements);
                }
            }
        }
        return result;
    }

    public void addAttributeValue(String attributeName, CmsEntity value) {
        if (this.m_simpleAttributes.containsKey(attributeName)) {
            throw new RuntimeException("Attribute already exists with a simple type value.");
        }
        if (this.m_entityAttributes.containsKey(attributeName)) {
            this.m_entityAttributes.get(attributeName).add(value);
        } else {
            ArrayList<CmsEntity> values = new ArrayList<CmsEntity>();
            values.add(value);
            this.m_entityAttributes.put(attributeName, values);
        }
        this.registerChangeHandler(value);
        this.fireChange();
    }

    public void addAttributeValue(String attributeName, String value) {
        if (this.m_entityAttributes.containsKey(attributeName)) {
            throw new RuntimeException("Attribute already exists with a entity type value.");
        }
        if (this.m_simpleAttributes.containsKey(attributeName)) {
            this.m_simpleAttributes.get(attributeName).add(value);
        } else {
            ArrayList<String> values = new ArrayList<String>();
            values.add(value);
            this.m_simpleAttributes.put(attributeName, values);
        }
        this.fireChange();
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<CmsEntity> handler) {
        return this.addHandler((EventHandler)handler, (GwtEvent.Type)ValueChangeEvent.getType());
    }

    public CmsEntity cloneEntity() {
        CmsEntity clone = new CmsEntity(this.getId(), this.getTypeName());
        for (CmsEntityAttribute attribute : this.getAttributes()) {
            List<Object> values;
            if (attribute.isSimpleValue()) {
                values = attribute.getSimpleValues();
                for (Object value : values) {
                    clone.addAttributeValue(attribute.getAttributeName(), (String)value);
                }
                continue;
            }
            values = attribute.getComplexValues();
            for (Object value : values) {
                clone.addAttributeValue(attribute.getAttributeName(), ((CmsEntity)value).cloneEntity());
            }
        }
        return clone;
    }

    public CmsEntity createDeepCopy(String entityId) {
        CmsEntity result = new CmsEntity(entityId, this.getTypeName());
        for (CmsEntityAttribute attribute : this.getAttributes()) {
            List<Object> values;
            if (attribute.isSimpleValue()) {
                values = attribute.getSimpleValues();
                for (Object value : values) {
                    result.addAttributeValue(attribute.getAttributeName(), (String)value);
                }
                continue;
            }
            values = attribute.getComplexValues();
            for (Object value : values) {
                result.addAttributeValue(attribute.getAttributeName(), ((CmsEntity)value).createDeepCopy(null));
            }
        }
        return result;
    }

    public void ensureChangeHandlers() {
        if (!this.m_changeHandlerRegistry.isEmpty()) {
            for (HandlerRegistration handlerRegistration : this.m_changeHandlerRegistry.values()) {
                handlerRegistration.removeHandler();
            }
            this.m_changeHandlerRegistry.clear();
        }
        for (List list : this.m_entityAttributes.values()) {
            for (CmsEntity child : list) {
                this.registerChangeHandler(child);
                child.ensureChangeHandlers();
            }
        }
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof CmsEntity) {
            CmsEntity test = (CmsEntity)obj;
            if (this.m_simpleAttributes.keySet().equals(test.m_simpleAttributes.keySet()) && this.m_entityAttributes.keySet().equals(test.m_entityAttributes.keySet())) {
                result = true;
                for (String attributeName : this.m_simpleAttributes.keySet()) {
                    if (this.m_simpleAttributes.get(attributeName).equals(test.m_simpleAttributes.get(attributeName))) continue;
                    result = false;
                    break;
                }
                if (result) {
                    for (String attributeName : this.m_entityAttributes.keySet()) {
                        if (this.m_entityAttributes.get(attributeName).equals(test.m_entityAttributes.get(attributeName))) continue;
                        result = false;
                        break;
                    }
                }
            }
        }
        return result;
    }

    public void fireEvent(GwtEvent<?> event) {
        this.ensureHandlers().fireEventFromSource(event, (Object)this);
    }

    public CmsEntityAttribute getAttribute(String attributeName) {
        if (this.m_simpleAttributes.containsKey(attributeName)) {
            return CmsEntityAttribute.createSimpleAttribute(attributeName, this.m_simpleAttributes.get(attributeName));
        }
        if (this.m_entityAttributes.containsKey(attributeName)) {
            return CmsEntityAttribute.createEntityAttribute(attributeName, this.m_entityAttributes.get(attributeName));
        }
        return null;
    }

    public List<CmsEntityAttribute> getAttributes() {
        ArrayList<CmsEntityAttribute> result = new ArrayList<CmsEntityAttribute>();
        for (String name : this.m_simpleAttributes.keySet()) {
            result.add(this.getAttribute(name));
        }
        for (String name : this.m_entityAttributes.keySet()) {
            result.add(this.getAttribute(name));
        }
        return result;
    }

    public CmsEntity getEntityById(String entityId) {
        CmsEntity result = null;
        if (this.m_id.equals(entityId)) {
            result = this;
        } else {
            for (List<CmsEntity> children : this.m_entityAttributes.values()) {
                CmsEntity child;
                Iterator<CmsEntity> i$ = children.iterator();
                while (i$.hasNext() && (result = (child = i$.next()).getEntityById(entityId)) == null) {
                }
                if (result == null) continue;
                break;
            }
        }
        return result;
    }

    public String getId() {
        return this.m_id;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public boolean hasAttribute(String attributeName) {
        return this.m_simpleAttributes.containsKey(attributeName) || this.m_entityAttributes.containsKey(attributeName);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void insertAttributeValue(String attributeName, CmsEntity value, int index) {
        if (this.m_entityAttributes.containsKey(attributeName)) {
            this.m_entityAttributes.get(attributeName).add(index, value);
        } else {
            this.setAttributeValue(attributeName, value);
        }
        this.registerChangeHandler(value);
        this.fireChange();
    }

    public void insertAttributeValue(String attributeName, String value, int index) {
        if (this.m_simpleAttributes.containsKey(attributeName)) {
            this.m_simpleAttributes.get(attributeName).add(index, value);
        } else {
            this.setAttributeValue(attributeName, value);
        }
        this.fireChange();
    }

    public void removeAttribute(String attributeName) {
        this.removeAttributeSilent(attributeName);
        this.fireChange();
    }

    public void removeAttributeSilent(String attributeName) {
        CmsEntityAttribute attr = this.getAttribute(attributeName);
        if (attr != null) {
            if (attr.isSimpleValue()) {
                this.m_simpleAttributes.remove(attributeName);
            } else {
                for (CmsEntity child : attr.getComplexValues()) {
                    this.removeChildChangeHandler(child);
                }
                this.m_entityAttributes.remove(attributeName);
            }
        }
    }

    public void removeAttributeValue(String attributeName, int index) {
        if (this.m_simpleAttributes.containsKey(attributeName)) {
            List<String> values = this.m_simpleAttributes.get(attributeName);
            if (values.size() == 1 && index == 0) {
                this.removeAttributeSilent(attributeName);
            } else {
                values.remove(index);
            }
        } else if (this.m_entityAttributes.containsKey(attributeName)) {
            List<CmsEntity> values = this.m_entityAttributes.get(attributeName);
            if (values.size() == 1 && index == 0) {
                this.removeAttributeSilent(attributeName);
            } else {
                CmsEntity child = values.remove(index);
                this.removeChildChangeHandler(child);
            }
        }
        this.fireChange();
    }

    public void setAttributeValue(String attributeName, CmsEntity value) {
        this.removeAttributeSilent(attributeName);
        this.addAttributeValue(attributeName, value);
    }

    public void setAttributeValue(String attributeName, CmsEntity value, int index) {
        if (this.m_simpleAttributes.containsKey(attributeName)) {
            throw new RuntimeException("Attribute already exists with a simple type value.");
        }
        if (!this.m_entityAttributes.containsKey(attributeName)) {
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            this.addAttributeValue(attributeName, value);
        } else {
            if (this.m_entityAttributes.get(attributeName).size() > index) {
                CmsEntity child = this.m_entityAttributes.get(attributeName).remove(index);
                this.removeChildChangeHandler(child);
            }
            this.m_entityAttributes.get(attributeName).add(index, value);
            this.fireChange();
        }
    }

    public void setAttributeValue(String attributeName, String value) {
        this.m_entityAttributes.remove(attributeName);
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        this.m_simpleAttributes.put(attributeName, values);
        this.fireChange();
    }

    public void setAttributeValue(String attributeName, String value, int index) {
        if (this.m_entityAttributes.containsKey(attributeName)) {
            throw new RuntimeException("Attribute already exists with a simple type value.");
        }
        if (!this.m_simpleAttributes.containsKey(attributeName)) {
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            this.addAttributeValue(attributeName, value);
        } else {
            if (this.m_simpleAttributes.get(attributeName).size() > index) {
                this.m_simpleAttributes.get(attributeName).remove(index);
            }
            this.m_simpleAttributes.get(attributeName).add(index, value);
            this.fireChange();
        }
    }

    public String toJSON() {
        boolean firstValue;
        StringBuffer result = new StringBuffer();
        result.append("{\n");
        for (Map.Entry<String, List<String>> entry : this.m_simpleAttributes.entrySet()) {
            result.append("\"").append(entry.getKey()).append("\"").append(": [\n");
            firstValue = true;
            for (String string : entry.getValue()) {
                if (firstValue) {
                    firstValue = false;
                } else {
                    result.append(",\n");
                }
                result.append("\"").append(string).append("\"");
            }
            result.append("],\n");
        }
        for (Map.Entry<String, List<Object>> entry : this.m_entityAttributes.entrySet()) {
            result.append("\"").append(entry.getKey()).append("\"").append(": [\n");
            firstValue = true;
            for (CmsEntity cmsEntity : entry.getValue()) {
                if (firstValue) {
                    firstValue = false;
                } else {
                    result.append(",\n");
                }
                result.append(cmsEntity.toJSON());
            }
            result.append("],\n");
        }
        result.append("\"id\": \"").append(this.m_id).append("\"");
        result.append("}");
        return result.toString();
    }

    public String toString() {
        return this.toJSON();
    }

    protected final <H extends EventHandler> HandlerRegistration addHandler(H handler, GwtEvent.Type<H> type) {
        return this.ensureHandlers().addHandlerToSource(type, (Object)this, handler);
    }

    void fireChange() {
        ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this);
    }

    private SimpleEventBus ensureHandlers() {
        if (this.m_eventBus == null) {
            this.m_eventBus = new SimpleEventBus();
        }
        return this.m_eventBus;
    }

    private void registerChangeHandler(CmsEntity child) {
        HandlerRegistration reg = child.addValueChangeHandler(this.m_childChangeHandler);
        this.m_changeHandlerRegistry.put(child.getId(), reg);
    }

    private void removeChildChangeHandler(CmsEntity child) {
        HandlerRegistration reg = this.m_changeHandlerRegistry.remove(child.getId());
        if (reg != null) {
            reg.removeHandler();
        }
    }

    protected class EntityChangeHandler
    implements ValueChangeHandler<CmsEntity> {
        protected EntityChangeHandler() {
        }

        public void onValueChange(ValueChangeEvent<CmsEntity> event) {
            CmsEntity.this.fireChange();
        }
    }
}

