/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigCacheState;
import org.opencms.ade.configuration.CmsADEConfigDataInternal;
import org.opencms.ade.configuration.CmsFunctionReference;
import org.opencms.ade.configuration.CmsModelPageConfig;
import org.opencms.ade.configuration.CmsPropertyConfig;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.ade.configuration.I_CmsConfigurationObject;
import org.opencms.ade.configuration.formatters.CmsFormatterChangeSet;
import org.opencms.ade.configuration.formatters.CmsFormatterConfigurationCacheState;
import org.opencms.ade.containerpage.shared.CmsContainer;
import org.opencms.ade.detailpage.CmsDetailPageInfo;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeFolder;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.content.CmsXmlContentProperty;

public class CmsADEConfigData {
    private static final Log LOG = CmsLog.getLog(CmsADEConfigData.class);
    protected CmsADEConfigDataInternal m_data;
    private CmsADEConfigCacheState m_cache;

    public CmsADEConfigData(CmsADEConfigDataInternal data, CmsADEConfigCacheState cache) {
        this.m_data = data;
        this.m_cache = cache;
    }

    public static <C extends I_CmsConfigurationObject<C>> List<C> combineConfigurationElements(List<C> parentConfigs, List<C> childConfigs, boolean preserveDisabled) {
        ArrayList<Object> result = new ArrayList();
        LinkedHashMap<String, I_CmsConfigurationObject> map = new LinkedHashMap<String, I_CmsConfigurationObject>();
        if (parentConfigs != null) {
            for (I_CmsConfigurationObject parent : Lists.reverse(parentConfigs)) {
                map.put(parent.getKey(), parent);
            }
        }
        if (childConfigs == null) {
            childConfigs = Collections.emptyList();
        }
        for (I_CmsConfigurationObject child : Lists.reverse(childConfigs)) {
            String childKey = child.getKey();
            if (child.isDisabled() && !preserveDisabled) {
                map.remove(childKey);
                continue;
            }
            I_CmsConfigurationObject parent = (I_CmsConfigurationObject)map.get(childKey);
            map.remove(childKey);
            I_CmsConfigurationObject newValue = parent != null ? parent.merge(child) : child;
            map.put(childKey, newValue);
        }
        result = new ArrayList(map.values());
        Collections.reverse(result);
        return result;
    }

    public void applyAllFormatterChanges(Map<CmsUUID, I_CmsFormatterBean> formatters, CmsFormatterConfigurationCacheState formatterCacheState) {
        for (CmsFormatterChangeSet changeSet : this.getFormatterChangeSets()) {
            changeSet.applyToFormatters(formatters, formatterCacheState);
        }
    }

    public Map<CmsUUID, I_CmsFormatterBean> getActiveFormatters() {
        CmsFormatterConfigurationCacheState cacheState = this.getCachedFormatters();
        HashMap result = Maps.newHashMap(cacheState.getAutoEnabledFormatters());
        this.applyAllFormatterChanges(result, cacheState);
        return result;
    }

    public List<CmsDetailPageInfo> getAllDetailPages() {
        return this.getAllDetailPages(true);
    }

    public List<CmsDetailPageInfo> getAllDetailPages(boolean update) {
        CmsADEConfigData parentData = this.parent();
        List<CmsDetailPageInfo> parentDetailPages = parentData != null ? parentData.getAllDetailPages(false) : Collections.emptyList();
        List<CmsDetailPageInfo> result = this.mergeDetailPages(parentDetailPages, this.m_data.getOwnDetailPages());
        if (update) {
            result = this.updateUris(result);
        }
        return result;
    }

    public String getBasePath() {
        return this.m_data.getBasePath();
    }

    public CmsFormatterConfigurationCacheState getCachedFormatters() {
        return OpenCms.getADEManager().getCachedFormatters(this.getCms().getRequestContext().getCurrentProject().isOnlineProject());
    }

    public String getContentFolderPath() {
        return CmsStringUtil.joinPaths(this.m_data.getBasePath(), ".content");
    }

    public List<CmsResourceTypeConfig> getCreatableTypes(CmsObject cms) throws CmsException {
        ArrayList<CmsResourceTypeConfig> result = new ArrayList<CmsResourceTypeConfig>();
        for (CmsResourceTypeConfig typeConfig : this.getResourceTypes()) {
            if (!typeConfig.checkCreatable(cms)) continue;
            result.add(typeConfig);
        }
        return result;
    }

    public CmsModelPageConfig getDefaultModelPage() {
        List<CmsModelPageConfig> modelPages = this.getModelPages();
        for (CmsModelPageConfig modelPageConfig : this.getModelPages()) {
            if (!modelPageConfig.isDefault()) continue;
            return modelPageConfig;
        }
        if (modelPages.isEmpty()) {
            return null;
        }
        return modelPages.get(0);
    }

    public List<CmsDetailPageInfo> getDetailPagesForType(String type) {
        ArrayList<CmsDetailPageInfo> result = new ArrayList<CmsDetailPageInfo>();
        for (CmsDetailPageInfo detailpage : this.getAllDetailPages(true)) {
            if (!detailpage.getType().equals(type)) continue;
            result.add(detailpage);
        }
        return result;
    }

    public List<CmsFormatterChangeSet> getFormatterChangeSets() {
        ArrayList result = Lists.newArrayList();
        for (CmsADEConfigData currentConfig = this; currentConfig != null; currentConfig = currentConfig.parent()) {
            CmsFormatterChangeSet changes = currentConfig.getOwnFormatterChangeSet();
            if (changes == null) continue;
            result.add(changes);
        }
        Collections.reverse(result);
        return result;
    }

    public CmsFormatterConfiguration getFormatters(CmsObject cms, CmsResource res) {
        try {
            int resTypeId = res.getTypeId();
            return this.getFormatters(cms, OpenCms.getResourceManager().getResourceType(resTypeId), this.getFormattersFromSchema(cms, res));
        }
        catch (CmsLoaderException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public CmsFunctionReference getFunctionReference(String name) {
        List<CmsFunctionReference> functionReferences = this.getFunctionReferences();
        for (CmsFunctionReference functionRef : functionReferences) {
            if (!functionRef.getName().equals(name)) continue;
            return functionRef;
        }
        return null;
    }

    public List<CmsFunctionReference> getFunctionReferences() {
        return this.internalGetFunctionReferences();
    }

    public Map<CmsUUID, I_CmsFormatterBean> getInactiveFormatters() {
        CmsFormatterConfigurationCacheState cacheState = this.getCachedFormatters();
        HashMap result = Maps.newHashMap(cacheState.getFormatters());
        result.keySet().removeAll(this.getActiveFormatters().keySet());
        return result;
    }

    public CmsDetailPageInfo getMainDetailPage(String type) {
        List<CmsDetailPageInfo> detailPages = this.getDetailPagesForType(type);
        if (detailPages == null || detailPages.isEmpty()) {
            return null;
        }
        return detailPages.get(0);
    }

    public List<CmsModelPageConfig> getModelPages() {
        CmsADEConfigData parentData = this.parent();
        List<Object> parentModelPages = parentData != null && !this.m_data.isDiscardInheritedModelPages() ? parentData.getModelPages() : Collections.emptyList();
        List<CmsModelPageConfig> result = CmsADEConfigData.combineConfigurationElements(parentModelPages, this.m_data.getOwnModelPageConfig(), false);
        return result;
    }

    public CmsFormatterChangeSet getOwnFormatterChangeSet() {
        return this.m_data.getFormatterChangeSet();
    }

    public List<CmsPropertyConfig> getPropertyConfiguration() {
        CmsADEConfigData parentData = this.parent();
        List<Object> parentProperties = parentData != null && !this.m_data.isDiscardInheritedProperties() ? parentData.getPropertyConfiguration() : Collections.emptyList();
        List<CmsPropertyConfig> result = CmsADEConfigData.combineConfigurationElements(parentProperties, this.m_data.getOwnPropertyConfigurations(), false);
        return result;
    }

    public Map<String, CmsXmlContentProperty> getPropertyConfigurationAsMap() {
        LinkedHashMap<String, CmsXmlContentProperty> result = new LinkedHashMap<String, CmsXmlContentProperty>();
        for (CmsPropertyConfig propConf : this.getPropertyConfiguration()) {
            result.put(propConf.getName(), propConf.getPropertyData());
        }
        return result;
    }

    public CmsResource getResource() {
        return this.m_data.getResource();
    }

    public CmsResourceTypeConfig getResourceType(String typeName) {
        for (CmsResourceTypeConfig type : this.getResourceTypes()) {
            if (!typeName.equals(type.getTypeName())) continue;
            return type;
        }
        return null;
    }

    public List<CmsResourceTypeConfig> getResourceTypes() {
        List<CmsResourceTypeConfig> result = this.internalGetResourceTypes(true);
        for (CmsResourceTypeConfig config : result) {
            config.initialize(this.getCms());
        }
        return result;
    }

    public Collection<CmsResourceTypeConfig> getSearchableTypes(CmsObject cms) {
        return this.getResourceTypes();
    }

    public Set<String> getTypesWithActiveSchemaFormatters() {
        HashSet result = Sets.newHashSet(this.getTypesWithModifiableFormatters());
        for (CmsFormatterChangeSet changeSet : this.getFormatterChangeSets()) {
            changeSet.applyToTypes(result);
        }
        return result;
    }

    public Set<String> getTypesWithModifiableFormatters() {
        HashSet<String> result = new HashSet<String>();
        for (I_CmsResourceType type : OpenCms.getResourceManager().getResourceTypes()) {
            if (!(type instanceof CmsResourceTypeXmlContent)) continue;
            CmsXmlContentDefinition contentDef = null;
            try {
                contentDef = CmsXmlContentDefinition.getContentDefinitionForType(this.getCms(), type.getTypeName());
                if (contentDef == null || !contentDef.getContentHandler().hasModifiableFormatters()) continue;
                result.add(type.getTypeName());
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public boolean hasFormatters(CmsObject cms, I_CmsResourceType resType, Collection<CmsContainer> containers) {
        try {
            if ("function".equals(resType.getTypeName())) {
                return true;
            }
            CmsXmlContentDefinition def = CmsXmlContentDefinition.getContentDefinitionForType(cms, resType.getTypeName());
            CmsFormatterConfiguration schemaFormatters = def.getContentHandler().getFormatterConfiguration(cms, null);
            CmsFormatterConfiguration formatters = this.getFormatters(cms, resType, schemaFormatters);
            for (CmsContainer cont : containers) {
                if (!cont.isEditable() || formatters.getAllMatchingFormatters(cont.getType(), cont.getWidth(), true).size() <= 0) continue;
                return true;
            }
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return false;
    }

    public boolean isCreateContentsLocally() {
        return this.m_data.isCreateContentsLocally();
    }

    public boolean isDiscardInheritedModelPages() {
        return this.m_data.isDiscardInheritedModelPages();
    }

    public boolean isDiscardInheritedProperties() {
        return this.m_data.isDiscardInheritedProperties();
    }

    public boolean isDiscardInheritedTypes() {
        return this.m_data.isDiscardInheritedTypes();
    }

    public boolean isModuleConfiguration() {
        return this.m_data.isModuleConfig();
    }

    public boolean isPreferDetailPagesForLocalContents() {
        return this.m_data.isPreferDetailPagesForLocalContents();
    }

    public CmsADEConfigData parent() {
        if (this.m_data.getBasePath() == null) {
            return null;
        }
        String parentPath = CmsResource.getParentFolder(this.m_data.getBasePath());
        return this.m_cache.lookupConfiguration(parentPath);
    }

    protected void createContentDirectory() throws CmsException {
        if (!this.isModuleConfiguration()) {
            String contentFolder = this.getContentFolderPath();
            if (!this.getCms().existsResource(contentFolder)) {
                this.getCms().createResource(contentFolder, OpenCms.getResourceManager().getResourceType(CmsResourceTypeFolder.getStaticTypeName()).getTypeId());
            }
        }
    }

    protected CmsObject getCms() {
        return this.m_cache.getCms();
    }

    protected CmsObject getCmsObject() {
        return this.getCms();
    }

    protected Map<String, List<CmsDetailPageInfo>> getDetailPagesMap(List<CmsDetailPageInfo> detailPages) {
        HashMap result = Maps.newHashMap();
        for (CmsDetailPageInfo detailpage : detailPages) {
            String type = detailpage.getType();
            if (!result.containsKey(type)) {
                result.put(type, new ArrayList());
            }
            ((List)result.get(type)).add(detailpage);
        }
        return result;
    }

    protected Map<String, String> getFolderTypes() throws CmsException {
        HashMap<String, String> result = new HashMap<String, String>();
        CmsObject cms = OpenCms.initCmsObject(this.getCms());
        if (this.m_data.isModuleConfig()) {
            Set<String> siteRoots = OpenCms.getSiteManager().getSiteRoots();
            for (String siteRoot : siteRoots) {
                cms.getRequestContext().setSiteRoot(siteRoot);
                for (CmsResourceTypeConfig config : this.getResourceTypes()) {
                    String typeName = config.getTypeName();
                    String folderPath = config.getFolderPath(cms);
                    result.put(CmsStringUtil.joinPaths(folderPath, "/"), typeName);
                }
            }
        } else {
            for (CmsResourceTypeConfig config : this.getResourceTypes()) {
                String typeName = config.getTypeName();
                String folderPath = config.getFolderPath(this.getCms());
                result.put(CmsStringUtil.joinPaths(folderPath, "/"), typeName);
            }
        }
        return result;
    }

    protected CmsFormatterConfiguration getFormatters(CmsObject cms, I_CmsResourceType resType, CmsFormatterConfiguration schemaFormatters) {
        String typeName = resType.getTypeName();
        CmsFormatterConfigurationCacheState formatterCacheState = this.getCachedFormatters();
        ArrayList<I_CmsFormatterBean> formatters = new ArrayList<I_CmsFormatterBean>();
        HashSet<String> types = new HashSet<String>();
        types.add(typeName);
        for (CmsFormatterChangeSet changeSet : this.getFormatterChangeSets()) {
            if (changeSet == null) continue;
            changeSet.applyToTypes(types);
        }
        if (types.contains(typeName)) {
            for (I_CmsFormatterBean formatter : schemaFormatters.getAllFormatters()) {
                formatters.add(formatter);
            }
        }
        HashMap externalFormattersById = Maps.newHashMap();
        for (I_CmsFormatterBean formatter : formatterCacheState.getFormattersForType(typeName, true)) {
            externalFormattersById.put(new CmsUUID(formatter.getId()), formatter);
        }
        this.applyAllFormatterChanges(externalFormattersById, formatterCacheState);
        for (I_CmsFormatterBean formatter : externalFormattersById.values()) {
            if (!typeName.equals(formatter.getResourceTypeName())) continue;
            formatters.add(formatter);
        }
        return CmsFormatterConfiguration.create(cms, formatters);
    }

    protected CmsFormatterConfiguration getFormattersFromSchema(CmsObject cms, CmsResource res) {
        try {
            return OpenCms.getResourceManager().getResourceType(res.getTypeId()).getFormattersForResource(cms, res);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return CmsFormatterConfiguration.EMPTY_CONFIGURATION;
        }
    }

    protected List<CmsFunctionReference> internalGetFunctionReferences() {
        CmsADEConfigData parentData = this.parent();
        if (parentData == null) {
            if (this.m_data.isModuleConfig()) {
                return Collections.unmodifiableList(this.m_data.getFunctionReferences());
            }
            return Lists.newArrayList();
        }
        return parentData.internalGetFunctionReferences();
    }

    protected List<CmsResourceTypeConfig> internalGetResourceTypes(boolean filterDisabled) {
        CmsADEConfigData parentData = this.parent();
        ArrayList parentResourceTypes = null;
        if (parentData == null) {
            parentResourceTypes = Lists.newArrayList();
        } else {
            parentResourceTypes = Lists.newArrayList();
            for (CmsResourceTypeConfig typeConfig : parentData.internalGetResourceTypes(false)) {
                CmsResourceTypeConfig copiedType = typeConfig.copy(this.m_data.isDiscardInheritedTypes());
                parentResourceTypes.add(copiedType);
            }
        }
        List<CmsResourceTypeConfig> result = CmsADEConfigData.combineConfigurationElements(parentResourceTypes, this.m_data.getOwnResourceTypes(), true);
        if (this.m_data.isCreateContentsLocally()) {
            for (CmsResourceTypeConfig typeConfig : result) {
                typeConfig.updateBasePath(CmsStringUtil.joinPaths(this.m_data.getBasePath(), ".content"));
            }
        }
        if (filterDisabled) {
            Iterator<CmsResourceTypeConfig> iter = result.iterator();
            while (iter.hasNext()) {
                CmsResourceTypeConfig typeConfig;
                typeConfig = iter.next();
                if (!typeConfig.isDisabled()) continue;
                iter.remove();
            }
        }
        return result;
    }

    protected List<CmsDetailPageInfo> mergeDetailPages(List<CmsDetailPageInfo> parentDetailPages, List<CmsDetailPageInfo> ownDetailPages) {
        ArrayList<CmsDetailPageInfo> result = new ArrayList<CmsDetailPageInfo>();
        HashMap resultDetailPageMap = Maps.newHashMap();
        resultDetailPageMap.putAll(this.getDetailPagesMap(parentDetailPages));
        resultDetailPageMap.putAll(this.getDetailPagesMap(ownDetailPages));
        result = new ArrayList();
        for (List pages : resultDetailPageMap.values()) {
            result.addAll(pages);
        }
        return result;
    }

    protected List<CmsDetailPageInfo> updateUris(List<CmsDetailPageInfo> detailPages) {
        ArrayList<CmsDetailPageInfo> result = new ArrayList<CmsDetailPageInfo>();
        for (CmsDetailPageInfo page : detailPages) {
            CmsUUID structureId = page.getId();
            try {
                String rootPath = OpenCms.getADEManager().getRootPath(structureId, this.getCms().getRequestContext().getCurrentProject().isOnlineProject());
                CmsDetailPageInfo correctedPage = new CmsDetailPageInfo(structureId, rootPath, page.getType());
                result.add(correctedPage);
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }
}

