/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigCacheState;
import org.opencms.ade.configuration.CmsADEConfigDataInternal;
import org.opencms.ade.configuration.CmsConfigurationReader;
import org.opencms.ade.configuration.CmsElementView;
import org.opencms.ade.configuration.CmsSynchronizedUpdateSet;
import org.opencms.ade.configuration.I_CmsGlobalConfigurationCache;
import org.opencms.db.CmsPublishedResource;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;
import org.opencms.util.CmsWaitHandle;

class CmsConfigurationCache
implements I_CmsGlobalConfigurationCache {
    public static final CmsUUID ID_UPDATE_ALL = CmsUUID.getConstantUUID("all");
    public static final CmsUUID ID_UPDATE_ELEMENT_VIEWS = CmsUUID.getConstantUUID("elementViews");
    public static final CmsUUID ID_UPDATE_FOLDERTYPES = CmsUUID.getConstantUUID("foldertypes");
    public static final CmsUUID ID_UPDATE_MODULES = CmsUUID.getNullUUID();
    public static final int TASK_DELAY_MILLIS = 3000;
    protected static boolean DEBUG;
    private static final Log LOG;
    protected I_CmsResourceType m_configType;
    protected I_CmsResourceType m_moduleConfigType;
    private CmsObject m_cms;
    private LoadingCache<CmsResource, Boolean> m_detailPageIdCache = CacheBuilder.newBuilder().expireAfterWrite(60L, TimeUnit.MINUTES).maximumSize(30000L).concurrencyLevel(8).build((CacheLoader)new CacheLoader<CmsResource, Boolean>(){

        public Boolean load(CmsResource key) throws Exception {
            if (CmsConfigurationCache.this.m_state == null) {
                return Boolean.FALSE;
            }
            try {
                return CmsConfigurationCache.this.m_state.isDetailPage(CmsConfigurationCache.this.m_cms, key);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return Boolean.FALSE;
            }
        }
    });
    private I_CmsResourceType m_elementViewType;
    private ConcurrentHashMap<CmsUUID, String> m_pathCache = new ConcurrentHashMap();
    private volatile CmsADEConfigCacheState m_state;
    private ScheduledFuture<?> m_taskFuture;
    private CmsSynchronizedUpdateSet<CmsUUID> m_updateSet = new CmsSynchronizedUpdateSet();
    private CmsWaitHandle m_waitHandle = new CmsWaitHandle();

    public CmsConfigurationCache(CmsObject cms, I_CmsResourceType configType, I_CmsResourceType moduleConfigType, I_CmsResourceType elementViewType) {
        this.m_cms = cms;
        this.m_configType = configType;
        this.m_moduleConfigType = moduleConfigType;
        this.m_elementViewType = elementViewType;
    }

    public static String getBasePath(String siteConfigFile) {
        if (siteConfigFile.endsWith("/.content/.config")) {
            return CmsResource.getParentFolder(CmsResource.getParentFolder(siteConfigFile));
        }
        return siteConfigFile;
    }

    @Override
    public void clear() {
        this.m_updateSet.add(ID_UPDATE_ALL);
        this.m_detailPageIdCache.invalidateAll();
    }

    public String getPathForStructureId(CmsUUID structureId) throws CmsException {
        String rootPath = this.m_pathCache.get(structureId);
        if (rootPath != null) {
            return rootPath;
        }
        CmsResource res = this.m_cms.readResource(structureId);
        this.m_pathCache.put(structureId, res.getRootPath());
        return res.getRootPath();
    }

    public CmsADEConfigCacheState getState() {
        return this.m_state;
    }

    public CmsWaitHandle getWaitHandleForUpdateTask() {
        return this.m_waitHandle;
    }

    public void initialize() {
        if (this.m_taskFuture != null) {
            this.m_taskFuture.cancel(false);
            this.m_taskFuture = null;
        }
        this.m_state = this.readCompleteConfiguration();
        long delay = DEBUG ? 500L : 3000L;
        this.m_taskFuture = OpenCms.getExecutor().scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                CmsConfigurationCache.this.performUpdate();
            }
        }, delay, delay, TimeUnit.MILLISECONDS);
    }

    public boolean isDetailPage(CmsObject cms, CmsResource resource) {
        try {
            boolean result = (Boolean)this.m_detailPageIdCache.get((Object)resource);
            if (!result) {
                this.m_detailPageIdCache.invalidate((Object)resource);
            }
            return result;
        }
        catch (ExecutionException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return true;
        }
    }

    public CmsADEConfigCacheState readCompleteConfiguration() {
        long beginTime = System.currentTimeMillis();
        HashMap siteConfigurations = Maps.newHashMap();
        if (this.m_cms.existsResource("/")) {
            try {
                List<CmsResource> configFileCandidates = this.m_cms.readResources("/", CmsResourceFilter.DEFAULT.addRequireType(this.m_configType.getTypeId()));
                for (CmsResource candidate : configFileCandidates) {
                    if (!this.isSitemapConfiguration(candidate.getRootPath(), candidate.getTypeId())) continue;
                    try {
                        CmsConfigurationReader reader = new CmsConfigurationReader(this.m_cms);
                        String basePath = CmsConfigurationCache.getBasePath(candidate.getRootPath());
                        CmsADEConfigDataInternal data = reader.parseSitemapConfiguration(basePath, candidate);
                        siteConfigurations.put(candidate.getStructureId(), data);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Error processing sitemap configuration " + candidate.getRootPath() + ": " + e.getLocalizedMessage()), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        List<CmsADEConfigDataInternal> moduleConfigs = this.loadModuleConfiguration();
        Map<CmsUUID, CmsElementView> elementViews = this.loadElementViews();
        CmsADEConfigCacheState result = new CmsADEConfigCacheState(this.m_cms, siteConfigurations, moduleConfigs, elementViews);
        long endTime = System.currentTimeMillis();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("readCompleteConfiguration took " + (endTime - beginTime) + "ms"));
        }
        return result;
    }

    @Override
    public void remove(CmsPublishedResource res) {
        this.remove(res.getStructureId(), res.getRootPath(), res.getType());
    }

    @Override
    public void remove(CmsResource res) {
        this.remove(res.getStructureId(), res.getRootPath(), res.getTypeId());
    }

    @Override
    public void update(CmsPublishedResource res) {
        try {
            this.update(res.getStructureId(), res.getRootPath(), res.getType(), res.getState());
        }
        catch (CmsRuntimeException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public void update(CmsResource res) {
        try {
            this.update(res.getStructureId(), res.getRootPath(), res.getTypeId(), res.getState());
        }
        catch (CmsRuntimeException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected boolean isModuleConfiguration(String rootPath, int type) {
        return type == this.m_moduleConfigType.getTypeId();
    }

    protected boolean isOnline() {
        return this.m_cms.getRequestContext().getCurrentProject().isOnlineProject();
    }

    protected boolean isSitemapConfiguration(String rootPath, int type) {
        return rootPath.endsWith("/.content/.config") && type == this.m_configType.getTypeId();
    }

    protected Map<CmsUUID, CmsElementView> loadElementViews() {
        ArrayList<CmsElementView> views = new ArrayList<CmsElementView>();
        views.add(CmsElementView.DEFAULT_ELEMENT_VIEW);
        try {
            CmsResourceFilter filter = CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireType(this.m_elementViewType.getTypeId());
            List<CmsResource> groups = this.m_cms.readResources("/", filter);
            for (CmsResource res : groups) {
                try {
                    views.add(new CmsElementView(this.m_cms, res));
                }
                catch (Exception e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        Collections.sort(views, new CmsElementView.ElementViewComparator());
        LinkedHashMap<CmsUUID, CmsElementView> elementViews = new LinkedHashMap<CmsUUID, CmsElementView>();
        for (CmsElementView view : views) {
            elementViews.put(view.getId(), view);
        }
        return elementViews;
    }

    protected List<CmsADEConfigDataInternal> loadModuleConfiguration() {
        if (this.m_cms.existsResource("/")) {
            CmsConfigurationReader reader = new CmsConfigurationReader(this.m_cms);
            List<CmsADEConfigDataInternal> moduleConfigs = reader.readModuleConfigurations();
            return moduleConfigs;
        }
        return Collections.emptyList();
    }

    protected void performUpdate() {
        block9: {
            try {
                Set<CmsUUID> updateIds = this.m_updateSet.removeAll();
                CmsADEConfigCacheState oldState = this.m_state;
                if (updateIds.isEmpty() && oldState != null) break block9;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (updateIds.contains(ID_UPDATE_ALL) || oldState == null) {
                    this.m_state = this.readCompleteConfiguration();
                } else {
                    boolean updateModules = updateIds.remove(ID_UPDATE_MODULES);
                    boolean updateElementViews = updateIds.remove(ID_UPDATE_ELEMENT_VIEWS);
                    updateIds.remove(ID_UPDATE_FOLDERTYPES);
                    HashMap updateMap = Maps.newHashMap();
                    for (CmsUUID structureId : updateIds) {
                        CmsADEConfigDataInternal sitemapConfig = this.parseSitemapConfiguration(structureId);
                        updateMap.put(structureId, sitemapConfig);
                    }
                    List<CmsADEConfigDataInternal> moduleConfigs = null;
                    if (updateModules) {
                        moduleConfigs = this.loadModuleConfiguration();
                    }
                    Map<CmsUUID, CmsElementView> elementViews = null;
                    if (updateElementViews) {
                        elementViews = this.loadElementViews();
                    }
                    this.m_state = oldState.createUpdatedCopy(updateMap, moduleConfigs, elementViews);
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Could not perform configuration cache update: " + e.getMessage()), (Throwable)e);
            }
        }
        this.m_waitHandle.release();
    }

    protected void remove(CmsUUID structureId, String rootPath, int type) {
        if (CmsResource.isTemporaryFileName(rootPath)) {
            return;
        }
        this.m_pathCache.remove(structureId);
        if (this.isSitemapConfiguration(rootPath, type)) {
            this.m_updateSet.add(structureId);
        } else if (this.isModuleConfiguration(rootPath, type)) {
            this.m_updateSet.add(ID_UPDATE_MODULES);
        } else if (this.isElementView(type)) {
            this.m_updateSet.add(ID_UPDATE_ELEMENT_VIEWS);
        } else if (this.m_state.getFolderTypes().containsKey(rootPath)) {
            this.m_updateSet.add(ID_UPDATE_FOLDERTYPES);
        }
    }

    protected void update(CmsUUID structureId, String rootPath, int type, CmsResourceState resState) {
        if (CmsResource.isTemporaryFileName(rootPath)) {
            return;
        }
        this.m_pathCache.replace(structureId, rootPath);
        if (this.isSitemapConfiguration(rootPath, type)) {
            this.m_updateSet.add(structureId);
        } else if (this.isModuleConfiguration(rootPath, type)) {
            LOG.info((Object)("Changed module configuration file " + rootPath + "(" + structureId + ")"));
            this.m_updateSet.add(ID_UPDATE_MODULES);
        } else if (this.isElementView(type)) {
            this.m_updateSet.add(ID_UPDATE_ELEMENT_VIEWS);
        } else if (this.m_state.getFolderTypes().containsKey(rootPath)) {
            this.m_updateSet.add(ID_UPDATE_FOLDERTYPES);
        }
    }

    CmsADEConfigDataInternal parseSitemapConfiguration(CmsUUID id) {
        try {
            CmsResource configResource = this.m_cms.readResource(id);
            if (this.isSitemapConfiguration(configResource.getRootPath(), configResource.getTypeId())) {
                CmsConfigurationReader reader = new CmsConfigurationReader(this.m_cms);
                String basePath = CmsConfigurationCache.getBasePath(configResource.getRootPath());
                CmsADEConfigDataInternal result = reader.parseSitemapConfiguration(basePath, configResource);
                return result;
            }
            LOG.info((Object)("Not a valid sitemap configuration anymore: " + configResource.getRootPath()));
            return null;
        }
        catch (Exception e) {
            if (e instanceof CmsVfsResourceNotFoundException) {
                LOG.info((Object)("Configuration file with ID " + id + " was not found."));
            } else {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return null;
        }
    }

    private boolean isElementView(int type) {
        return type == this.m_elementViewType.getTypeId();
    }

    static {
        LOG = CmsLog.getLog(CmsConfigurationCache.class);
    }
}

