/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration;

import java.util.Comparator;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsConfigurationReader;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsElementView {
    public static final CmsElementView DEFAULT_ELEMENT_VIEW = new CmsElementView();
    public static final String GUI_ELEMENT_VIEW_DEFAULT_TITLE_0 = "GUI_ELEMENT_VIEW_DEFAULT_TITLE_0";
    public static final String N_TITLE = "Title";
    public static final String N_TITLE_KEY = "TitleKey";
    public static final String N_ORDER = "Order";
    private static final Log LOG = CmsLog.getLog(CmsElementView.class);
    private CmsResource m_resource;
    String m_title;
    private String m_titleKey;
    private int m_order;

    public CmsElementView(CmsObject cms, CmsResource resource) throws Exception {
        this.m_resource = resource;
        this.init(cms);
    }

    private CmsElementView() {
        this.m_title = "Default";
        this.m_titleKey = GUI_ELEMENT_VIEW_DEFAULT_TITLE_0;
        this.m_order = Integer.MIN_VALUE;
    }

    public CmsUUID getId() {
        if (this.m_resource != null) {
            return this.m_resource.getStructureId();
        }
        return CmsUUID.getNullUUID();
    }

    public int getOrder() {
        return this.m_order;
    }

    public CmsResource getResource() {
        return this.m_resource;
    }

    public String getTitle(CmsObject cms, Locale locale) {
        if (this.m_titleKey == null) {
            return this.m_title;
        }
        return OpenCms.getWorkplaceManager().getMessages(locale).key(this.m_titleKey);
    }

    public boolean hasPermission(CmsObject cms) {
        try {
            if (this.m_resource != null) {
                return cms.hasPermissions(this.m_resource, CmsPermissionSet.ACCESS_VIEW, false, CmsResourceFilter.IGNORE_EXPIRATION.addRequireVisible());
            }
            return OpenCms.getRoleManager().hasRole(cms, CmsRole.ELEMENT_AUTHOR);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    private void init(CmsObject cms) throws Exception {
        I_CmsXmlContentValue orderVal;
        CmsFile configFile = cms.readFile(this.m_resource);
        CmsXmlContent content = CmsXmlContentFactory.unmarshal(cms, configFile);
        this.m_title = content.getValue(N_TITLE, CmsConfigurationReader.DEFAULT_LOCALE).getStringValue(cms);
        I_CmsXmlContentValue titleKey = content.getValue(N_TITLE_KEY, CmsConfigurationReader.DEFAULT_LOCALE);
        if (titleKey != null && CmsStringUtil.isNotEmptyOrWhitespaceOnly(titleKey.getStringValue(cms))) {
            this.m_titleKey = titleKey.getStringValue(cms);
        }
        if ((orderVal = content.getValue(N_ORDER, CmsConfigurationReader.DEFAULT_LOCALE)) != null) {
            try {
                this.m_order = Integer.parseInt(orderVal.getStringValue(cms));
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                this.m_order = Integer.MAX_VALUE;
            }
        } else {
            this.m_order = Integer.MAX_VALUE;
        }
    }

    public static class ElementViewComparator
    implements Comparator<CmsElementView> {
        @Override
        public int compare(CmsElementView o1, CmsElementView o2) {
            int result = o1.getOrder() == o2.getOrder() ? o1.m_title.compareTo(o2.m_title) : (o1.getOrder() > o2.getOrder() ? 1 : -1);
            return result;
        }
    }
}

