/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.containerpage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.ade.containerpage.Messages;
import org.opencms.ade.containerpage.inherited.CmsInheritanceReference;
import org.opencms.ade.containerpage.inherited.CmsInheritanceReferenceParser;
import org.opencms.ade.containerpage.inherited.CmsInheritedContainerState;
import org.opencms.ade.containerpage.shared.CmsContainer;
import org.opencms.ade.containerpage.shared.CmsContainerElement;
import org.opencms.ade.containerpage.shared.CmsContainerElementData;
import org.opencms.ade.containerpage.shared.CmsFormatterConfig;
import org.opencms.ade.containerpage.shared.CmsInheritanceInfo;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.gwt.shared.CmsPermissionInfo;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.loader.CmsTemplateLoaderFacade;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.galleries.CmsGallerySearch;
import org.opencms.search.galleries.CmsGallerySearchResult;
import org.opencms.util.CmsDateUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplaceMessages;
import org.opencms.workplace.editors.CmsWorkplaceEditorManager;
import org.opencms.workplace.editors.directedit.CmsAdvancedDirectEditProvider;
import org.opencms.workplace.editors.directedit.CmsDirectEditMode;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.xml.containerpage.CmsADESessionCache;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.containerpage.CmsGroupContainerBean;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;
import org.opencms.xml.containerpage.CmsXmlGroupContainer;
import org.opencms.xml.containerpage.CmsXmlGroupContainerFactory;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.content.CmsXmlContentPropertyHelper;

public class CmsElementUtil {
    public static final int MAX_NESTING_LEVEL = 5;
    private static final Log LOG = CmsLog.getLog(CmsElementUtil.class);
    private CmsADEConfigData m_adeConfig;
    private CmsObject m_cms;
    private String m_currentPageUri;
    private Locale m_locale;
    private CmsResource m_page;
    private Map<String, Object> m_parameterMap;
    private HttpServletRequest m_req;
    private HttpServletResponse m_res;
    private CmsJspStandardContextBean m_standardContext;

    public CmsElementUtil(CmsObject cms, String currentPageUri, CmsContainerPageBean containerPage, CmsUUID detailContentId, HttpServletRequest req, HttpServletResponse res, Locale locale) throws CmsException {
        this.m_cms = OpenCms.initCmsObject(cms);
        this.m_req = req;
        this.m_res = res;
        this.m_currentPageUri = currentPageUri;
        this.m_locale = locale;
        req.setAttribute("__cmsObject", (Object)this.m_cms);
        if (detailContentId != null) {
            CmsResource detailRes = this.m_cms.readResource(detailContentId);
            req.setAttribute("__opencms_detail_content_resource", (Object)detailRes);
        }
        this.m_standardContext = CmsJspStandardContextBean.getInstance((ServletRequest)req);
        this.m_page = this.m_cms.readResource(currentPageUri);
        this.m_standardContext.setPage(containerPage);
    }

    public CmsElementUtil(CmsObject cms, String currentPageUri, CmsUUID detailContentId, HttpServletRequest req, HttpServletResponse res, Locale locale) throws CmsException {
        this.m_cms = OpenCms.initCmsObject(cms);
        this.m_req = req;
        this.m_res = res;
        this.m_currentPageUri = currentPageUri;
        this.m_locale = locale;
        req.setAttribute("__cmsObject", (Object)this.m_cms);
        if (detailContentId != null) {
            CmsResource detailRes = this.m_cms.readResource(detailContentId);
            req.setAttribute("__opencms_detail_content_resource", (Object)detailRes);
        }
        this.m_standardContext = CmsJspStandardContextBean.getInstance((ServletRequest)req);
        this.m_page = this.m_cms.readResource(currentPageUri);
        CmsXmlContainerPage xmlContainerPage = CmsXmlContainerPageFactory.unmarshal(cms, this.m_page, (ServletRequest)req);
        CmsContainerPageBean containerPage = xmlContainerPage.getContainerPage(cms);
        this.m_standardContext.setPage(containerPage);
    }

    public CmsElementUtil(CmsObject cms, String currentPageUri, CmsUUID detailContentId, String requestParameters, HttpServletRequest req, HttpServletResponse res, Locale locale) throws CmsException {
        this(cms, currentPageUri, detailContentId, req, res, locale);
        this.m_parameterMap = this.parseRequestParameters(requestParameters);
    }

    public String getContentByContainer(CmsFile elementFile, String elementId, CmsContainer container, boolean allowNested) {
        CmsContainerElementBean element = CmsADESessionCache.getCache(this.m_req, this.m_cms).getCacheContainerElement(elementId);
        element = element.clone();
        element.setTemporaryFile(elementFile);
        CmsFormatterConfiguration configs = this.getFormatterConfiguration(element.getResource());
        return this.getContentByContainer(element, container, configs, allowNested);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CmsContainerElementData getElementData(CmsResource page, CmsContainerElementBean element, Collection<CmsContainer> containers, boolean allowNested) throws CmsException {
        Locale requestLocale = this.m_cms.getRequestContext().getLocale();
        this.m_cms.getRequestContext().setLocale(this.m_locale);
        element.initResource(this.m_cms);
        if (element.getResource().isFolder()) {
            return null;
        }
        CmsResourceUtil resUtil = new CmsResourceUtil(this.m_cms, element.getResource());
        CmsContainerElementData elementData = new CmsContainerElementData();
        this.setElementInfo(element, elementData);
        elementData.setLastModifiedDate(element.getResource().getDateLastModified());
        elementData.setLastModifiedByUser(this.m_cms.readUser(element.getResource().getUserLastModified()).getName());
        elementData.setNavText(resUtil.getNavText());
        Map<String, CmsXmlContentProperty> settingConfig = CmsXmlContentPropertyHelper.getPropertyInfo(this.m_cms, page, element.getResource());
        elementData.setSettings(CmsXmlContentPropertyHelper.convertPropertiesToClientFormat(this.m_cms, element.getIndividualSettings(), settingConfig));
        CmsFormatterConfiguration formatterConfiguraton = this.getFormatterConfiguration(element.getResource());
        HashMap<String, Map<String, CmsFormatterConfig>> formatters = new HashMap<String, Map<String, CmsFormatterConfig>>();
        HashMap<String, String> contents = new HashMap();
        if (element.isGroupContainer(this.m_cms)) {
            HashSet<String> types = new HashSet<String>();
            HashMap<String, CmsContainer> containersByName = new HashMap<String, CmsContainer>();
            for (CmsContainer container : containers) {
                types.add(container.getType());
                containersByName.put(container.getName(), container);
            }
            CmsXmlGroupContainer xmlGroupContainer = CmsXmlGroupContainerFactory.unmarshal(this.m_cms, element.getResource(), (ServletRequest)this.m_req);
            CmsGroupContainerBean groupContainer = xmlGroupContainer.getGroupContainer(this.m_cms);
            elementData.setTitle(groupContainer.getTitle());
            elementData.setTypes(groupContainer.getTypes());
            elementData.setDescription(groupContainer.getDescription());
            if (groupContainer.getTypes().isEmpty()) {
                if (!groupContainer.getElements().isEmpty()) return null;
                String emptySub = "<div>NEW AND EMPTY</div>";
                for (String name : containersByName.keySet()) {
                    contents.put(name, emptySub);
                }
            } else {
                for (CmsContainer cnt : containersByName.values()) {
                    String type = cnt.getType();
                    if (!groupContainer.getTypes().contains(type)) continue;
                    contents.put(cnt.getName(), "<div>should not be used</div>");
                }
            }
            ArrayList<String> subItems = new ArrayList<String>();
            for (CmsContainerElementBean subElement : groupContainer.getElements()) {
                subItems.add(subElement.editorHash());
            }
            elementData.setSubItems(subItems);
        } else if (element.isInheritedContainer(this.m_cms)) {
            CmsInheritanceReferenceParser parser = new CmsInheritanceReferenceParser(this.m_cms);
            parser.parse(element.getResource());
            CmsInheritanceReference ref = parser.getReference(this.m_locale);
            String name = null;
            if (ref != null) {
                name = ref.getName();
                elementData.setDescription(ref.getDescription());
                elementData.setTitle(ref.getTitle());
            }
            for (CmsContainer container : containers) {
                contents.put(container.getName(), "<div>should not be used</div>");
            }
            ArrayList<CmsInheritanceInfo> inheritanceInfos = new ArrayList<CmsInheritanceInfo>();
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(name)) {
                CmsInheritedContainerState result = OpenCms.getADEManager().getInheritedContainerState(this.m_cms, this.m_cms.addSiteRoot(this.m_currentPageUri), name);
                for (CmsContainerElementBean subElement : result.getElements(true)) {
                    CmsInheritanceInfo inheritanceInfo = subElement.getInheritanceInfo();
                    inheritanceInfo.setClientId(subElement.editorHash());
                    inheritanceInfos.add(inheritanceInfo);
                }
            } else {
                name = element.getResource().getStructureId().toString();
            }
            elementData.setInheritanceInfos(inheritanceInfos);
            elementData.setInheritanceName(name);
        } else {
            for (CmsContainer cnt : containers) {
                LinkedHashMap<String, CmsFormatterConfig> containerFormatters = new LinkedHashMap<String, CmsFormatterConfig>();
                boolean missesFormatterSetting = !elementData.getSettings().containsKey(CmsFormatterConfig.getSettingsKeyForContainer(cnt.getName()));
                boolean allowNestedCnt = allowNested && this.checkContainerTreeLevel(cnt, containers);
                Map<String, I_CmsFormatterBean> formatterSelection = formatterConfiguraton.getFormatterSelection(cnt.getType(), cnt.getWidth(), allowNestedCnt);
                for (Map.Entry<String, I_CmsFormatterBean> formatterEntry : formatterSelection.entrySet()) {
                    I_CmsFormatterBean formatter = formatterEntry.getValue();
                    String id = formatterEntry.getKey();
                    if (missesFormatterSetting && (element.getFormatterId() == null || element.getFormatterId().equals(formatter.getJspStructureId()))) {
                        elementData.getSettings().put(CmsFormatterConfig.getSettingsKeyForContainer(cnt.getName()), id);
                        missesFormatterSetting = false;
                    }
                    String label = formatter.getNiceName();
                    if (formatterEntry.getKey().equals("schema_formatter")) {
                        label = Messages.get().getBundle().key("GUI_SCHEMA_FORMATTER_LABEL_0");
                    }
                    if (CmsStringUtil.isEmptyOrWhitespaceOnly(label)) {
                        label = id;
                    }
                    CmsFormatterConfig config = new CmsFormatterConfig(id);
                    LinkedHashSet<String> cssResources = new LinkedHashSet<String>();
                    for (String cssSitePath : formatter.getCssHeadIncludes()) {
                        cssResources.add(OpenCms.getLinkManager().getOnlineLink(this.m_cms, cssSitePath));
                    }
                    config.setCssResources(cssResources);
                    config.setInlineCss(formatter.getInlineCss());
                    config.setLabel(label);
                    LinkedHashMap<String, CmsXmlContentProperty> linkedHashMap = new LinkedHashMap<String, CmsXmlContentProperty>(formatter.getSettings());
                    Map<String, CmsXmlContentProperty> map = CmsXmlContentPropertyHelper.resolveMacrosForPropertyInfo(this.m_cms, page, element.getResource(), linkedHashMap);
                    config.setSettingConfig(map);
                    config.setJspRootPath(formatter.getJspRootPath());
                    containerFormatters.put(id, config);
                }
                formatters.put(cnt.getName(), containerFormatters);
            }
            Map<String, String> contentsByName = this.getContentsByContainerName(element, containers, allowNested);
            contents = contentsByName;
        }
        elementData.setContents(contents);
        elementData.setFormatters(formatters);
        this.m_cms.getRequestContext().setLocale(requestLocale);
        return elementData;
    }

    public CmsResource getPage() {
        return this.m_page;
    }

    public CmsContainerElement setElementInfo(CmsContainerElementBean elementBean, CmsContainerElement result) throws CmsException {
        String subTitle;
        String title;
        CmsPermissionInfo permissionInfo;
        Locale wpLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(this.m_cms);
        elementBean.initResource(this.m_cms);
        boolean newEditorDisabled = !CmsWorkplaceEditorManager.checkAcaciaEditorAvailable(this.m_cms, elementBean.getResource());
        result.setNewEditorDisabled(newEditorDisabled);
        String typeName = OpenCms.getResourceManager().getResourceType(elementBean.getResource().getTypeId()).getTypeName();
        result.setResourceType(typeName);
        if (!elementBean.isInMemoryOnly()) {
            CmsGallerySearchResult searchResult;
            permissionInfo = OpenCms.getADEManager().getPermissionInfo(this.m_cms, elementBean.getResource(), this.m_page.getRootPath());
            if (CmsResourceTypeXmlContent.isXmlContent(elementBean.getResource())) {
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(permissionInfo.getNoEditReason()) && elementBean.isInheritedContainer(this.m_cms)) {
                    String requestUri = this.m_cms.getRequestContext().getUri();
                    String folderPath = CmsResource.getFolderPath(requestUri);
                    String configPath = CmsStringUtil.joinPaths(folderPath, ".inherited");
                    if (this.m_cms.existsResource(configPath)) {
                        permissionInfo.setNoEditReason(new CmsResourceUtil(this.m_cms, this.m_cms.readResource(configPath)).getNoEditReason(wpLocale, true));
                    } else if (!this.m_cms.getLock(folderPath).isLockableBy(this.m_cms.getRequestContext().getCurrentUser())) {
                        permissionInfo.setNoEditReason(org.opencms.workplace.explorer.Messages.get().getBundle(wpLocale).key("GUI_NO_EDIT_REASON_LOCK_1", new CmsResourceUtil(this.m_cms, this.m_cms.readResource(folderPath)).getLockedByName()));
                    }
                }
            } else {
                permissionInfo.setNoEditReason(Messages.get().getBundle().key("GUI_ELEMENT_RESOURCE_CAN_NOT_BE_EDITED_0"));
            }
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(title = (searchResult = CmsGallerySearch.searchById(this.m_cms, elementBean.getResource().getStructureId(), this.m_locale)).getTitle())) {
                elementBean.getResource().getName();
            }
            subTitle = searchResult.getUserLastModified();
            Date lastModDate = searchResult.getDateLastModified();
            if (lastModDate != null) {
                subTitle = subTitle + " / " + CmsDateUtil.getDateTime(lastModDate, 2, wpLocale);
            }
        } else {
            permissionInfo = new CmsPermissionInfo(true, true, "");
            title = CmsWorkplaceMessages.getResourceTypeName(wpLocale, typeName);
            subTitle = CmsWorkplaceMessages.getResourceTypeDescription(wpLocale, typeName);
        }
        result.setTitle(title);
        result.setSubTitle(subTitle);
        result.setClientId(elementBean.editorHash());
        result.setSitePath(elementBean.getSitePath());
        result.setNew(elementBean.isCreateNew());
        CmsResourceTypeConfig typeConfig = this.getConfigData().getResourceType(typeName);
        if (typeConfig != null) {
            result.setElementView(typeConfig.getElementView());
        }
        if (elementBean.isCreateNew() && CmsStringUtil.isEmptyOrWhitespaceOnly(permissionInfo.getNoEditReason()) && (typeConfig == null || !typeConfig.checkCreatable(this.m_cms))) {
            String niceName = CmsWorkplaceMessages.getResourceTypeName(wpLocale, typeName);
            permissionInfo.setNoEditReason(Messages.get().getBundle().key("GUI_CONTAINERPAGE_TYPE_NOT_CREATABLE_1", niceName));
        }
        result.setHasSettings(this.hasSettings(this.m_cms, elementBean.getResource()));
        result.setPermissionInfo(permissionInfo);
        result.setReleasedAndNotExpired(elementBean.isReleasedAndNotExpired());
        return result;
    }

    private boolean checkContainerTreeLevel(CmsContainer container, Collection<CmsContainer> containers) {
        HashMap<String, CmsContainer> containersByName = new HashMap<String, CmsContainer>();
        for (CmsContainer cnt : containers) {
            containersByName.put(cnt.getName(), cnt);
        }
        int level = 0;
        String parentName = container.getParentContainerName();
        while (CmsStringUtil.isNotEmptyOrWhitespaceOnly(parentName)) {
            ++level;
            parentName = containersByName.containsKey(parentName) ? ((CmsContainer)containersByName.get(parentName)).getParentContainerName() : null;
        }
        return 5 > level;
    }

    private CmsADEConfigData getConfigData() {
        if (this.m_adeConfig == null) {
            this.m_adeConfig = OpenCms.getADEManager().lookupConfiguration(this.m_cms, this.m_cms.addSiteRoot(this.m_currentPageUri));
        }
        return this.m_adeConfig;
    }

    private String getContentByContainer(CmsContainerElementBean element, CmsContainer container, CmsFormatterConfiguration configs, boolean allowNested) {
        I_CmsFormatterBean formatter;
        String content = null;
        String formatterId = element.getSettings().get(CmsFormatterConfig.getSettingsKeyForContainer(container.getName()));
        if (formatterId != null) {
            Map<String, I_CmsFormatterBean> formatters = configs.getFormatterSelection(container.getType(), container.getWidth(), allowNested);
            formatter = formatters.get(formatterId);
        } else {
            formatter = configs.getDefaultFormatter(container.getType(), container.getWidth(), allowNested);
        }
        if (formatter != null) {
            element.initSettings(this.m_cms, formatter);
            try {
                content = this.getElementContent(element, this.m_cms.readResource(formatter.getJspStructureId()), container);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            if (content != null) {
                content = this.removeScriptTags(content);
            }
        }
        return content;
    }

    private Map<String, String> getContentsByContainerName(CmsContainerElementBean element, Collection<CmsContainer> containers, boolean allowNested) {
        CmsFormatterConfiguration configs = this.getFormatterConfiguration(element.getResource());
        HashMap<String, String> result = new HashMap<String, String>();
        for (CmsContainer container : containers) {
            String content = this.getContentByContainer(element, container, configs, allowNested && this.checkContainerTreeLevel(container, containers));
            if (content != null) {
                content = this.removeScriptTags(content);
            }
            result.put(container.getName(), content);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getElementContent(CmsContainerElementBean element, CmsResource formatter, CmsContainer container) throws CmsException, ServletException, IOException {
        element.initResource(this.m_cms);
        CmsTemplateLoaderFacade loaderFacade = new CmsTemplateLoaderFacade(OpenCms.getResourceManager().getLoader(formatter), element.getResource(), formatter);
        CmsResource loaderRes = loaderFacade.getLoaderStartResource();
        CmsJspStandardContextBean.TemplateBean templateBean = CmsADESessionCache.getCache(this.m_req, this.m_cms).getTemplateBean(this.m_cms.addSiteRoot(this.m_currentPageUri), true);
        String oldUri = this.m_cms.getRequestContext().getUri();
        try {
            this.m_cms.getRequestContext().setUri(this.m_currentPageUri);
            CmsContainerBean containerBean = null;
            containerBean = this.m_standardContext.getPage() != null && this.m_standardContext.getPage().getContainers().containsKey(container.getName()) ? this.m_standardContext.getPage().getContainers().get(container.getName()) : new CmsContainerBean(container.getName(), container.getType(), container.getParentInstanceId(), container.getMaxElements(), Collections.<CmsContainerElementBean>emptyList());
            if (containerBean.getWidth() == null) {
                containerBean.setWidth(String.valueOf(container.getWidth()));
            }
            containerBean.setDetailOnly(container.isDetailOnly());
            this.m_standardContext.setContainer(containerBean);
            this.m_standardContext.setElement(element);
            this.m_standardContext.setEdited(true);
            CmsAdvancedDirectEditProvider eb = new CmsAdvancedDirectEditProvider();
            eb.init(this.m_cms, CmsDirectEditMode.TRUE, element.getSitePath());
            this.m_req.setAttribute("org.opencms.workplace.editors.directedit.__directEditProvider", (Object)eb);
            this.m_req.setAttribute("ATTR_TEMPLATE_BEAN", (Object)templateBean);
            String encoding = this.m_res.getCharacterEncoding();
            String string = new String(loaderFacade.getLoader().dump(this.m_cms, loaderRes, null, this.m_locale, this.m_req, this.m_res), encoding).trim();
            return string;
        }
        finally {
            this.m_cms.getRequestContext().setUri(oldUri);
        }
    }

    private CmsFormatterConfiguration getFormatterConfiguration(CmsResource resource) {
        return this.getConfigData().getFormatters(this.m_cms, resource);
    }

    private boolean hasSettings(CmsObject cms, CmsResource resource) throws CmsException {
        boolean result;
        if (!CmsResourceTypeXmlContent.isXmlContent(resource)) {
            return false;
        }
        CmsFormatterConfiguration formatters = this.getConfigData().getFormatters(this.m_cms, resource);
        boolean bl = result = formatters.getAllFormatters().size() > 1 || !CmsXmlContentPropertyHelper.getPropertyInfo(this.m_cms, null, resource).isEmpty();
        if (!result && formatters.getAllFormatters().size() == 1) {
            result = formatters.getAllFormatters().get(0).getSettings() != null && formatters.getAllFormatters().get(0).getSettings().size() > 0;
        }
        return result;
    }

    private Map<String, Object> parseRequestParameters(String requestParameters) {
        Map<String, Object> parameterMap;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(requestParameters)) {
            parameterMap = new HashMap();
            String[] params = requestParameters.split("&");
            for (int i = 0; i < params.length; ++i) {
                int position = params[i].indexOf("=");
                if (position < 0) continue;
                String key = params[i].substring(0, position);
                String value = params[i].substring(position + 1);
                if (value.contains(",")) {
                    parameterMap.put(key, value.split(","));
                    continue;
                }
                parameterMap.put(key, value);
            }
        } else {
            parameterMap = Collections.emptyMap();
        }
        return parameterMap;
    }

    private String removeScriptTags(String input) {
        Pattern removePattern = Pattern.compile("<script[^>]*?>[\\s\\S]*?<\\/script>");
        Matcher match = removePattern.matcher(input);
        return match.replaceAll("");
    }
}

