/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.contenteditor;

import java.util.Collection;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.ade.contenteditor.A_CmsXmlContentEditorChangeHandler;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsEditorChangeHandlerProperty
extends A_CmsXmlContentEditorChangeHandler {
    protected static final Log LOG = CmsLog.getLog(CmsEditorChangeHandlerProperty.class);
    private String m_propertyName;
    private String m_targetField;

    @Override
    public CmsXmlContent handleChange(CmsObject cms, CmsXmlContent content, Locale locale, Collection<String> changedPaths) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_propertyName) && CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_targetField)) {
            for (String path : changedPaths) {
                String val;
                I_CmsXmlContentValue value = content.getValue(path, locale);
                if (value == null || !CmsStringUtil.isNotEmptyOrWhitespaceOnly(val = value.getStringValue(cms))) continue;
                try {
                    CmsProperty prop = cms.readPropertyObject(val, this.m_propertyName, false);
                    if (prop.isNullProperty()) continue;
                    String target = this.resolveRelativePath(path, this.m_targetField);
                    if (content.hasValue(target, locale)) {
                        content.getValue(target, locale).setStringValue(cms, prop.getValue());
                        continue;
                    }
                    content.addValue(cms, target, locale, 0).setStringValue(cms, prop.getValue());
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        return content;
    }

    @Override
    public void setConfiguration(String configuration) {
        super.setConfiguration(configuration);
        String[] temp = this.m_configuration.split("\\|");
        if (temp.length == 2) {
            this.m_propertyName = temp[0];
            this.m_targetField = temp[1];
        }
    }
}

