/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.publish;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.ade.publish.Messages;
import org.opencms.ade.publish.shared.CmsPublishOptions;
import org.opencms.ade.publish.shared.CmsPublishResource;
import org.opencms.ade.publish.shared.CmsPublishResourceInfo;
import org.opencms.db.CmsPublishList;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.gwt.CmsVfsService;
import org.opencms.gwt.shared.CmsPermissionInfo;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.publish.CmsPublishManager;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationPublishValidator;
import org.opencms.relations.CmsRelationValidatorInfoEntry;
import org.opencms.report.CmsHtmlReport;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.explorer.CmsResourceUtil;

public class CmsPublish {
    protected static final int GROUP_DAYS_NUMBER = 3;
    protected static final int GROUP_SESSIONS_GAP = 28800000;
    protected static final int GROUP_SESSIONS_NUMBER = 2;
    private static final Log LOG = CmsLog.getLog(CmsPublish.class);
    protected final CmsObject m_cms;
    protected final CmsPublishOptions m_options;
    protected final Locale m_workplaceLocale;
    private CmsRelationPublishValidator m_relationValidator;

    public CmsPublish(CmsObject cms) {
        this(cms, new HashMap<String, String>());
    }

    public CmsPublish(CmsObject cms, CmsPublishOptions options) {
        this.m_cms = cms;
        this.m_workplaceLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(this.m_cms);
        this.m_options = options;
    }

    public CmsPublish(CmsObject cms, Map<String, String> params) {
        this(cms, new CmsPublishOptions(params));
    }

    protected static String getOuAwareName(CmsObject cms, String name) {
        String ou = CmsOrganizationalUnit.getParentFqn(name);
        if (ou.equals(cms.getRequestContext().getCurrentUser().getOuFqn())) {
            return CmsOrganizationalUnit.getSimpleName(name);
        }
        return "/" + name;
    }

    public List<CmsPublishResource> getBrokenResources(List<CmsResource> pubResources) {
        CmsRelationPublishValidator validator;
        CmsPublishList publishList;
        ArrayList<CmsPublishResource> resources = new ArrayList<CmsPublishResource>();
        CmsPublishManager publishManager = OpenCms.getPublishManager();
        try {
            publishList = OpenCms.getPublishManager().getPublishListAll(this.m_cms, pubResources, this.m_options.isIncludeSiblings(), true);
            if (this.m_options.isIncludeRelated()) {
                CmsPublishList related = publishManager.getRelatedResourcesToPublish(this.m_cms, publishList);
                publishList = publishManager.mergePublishLists(this.m_cms, publishList, related);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return resources;
        }
        this.m_relationValidator = validator = new CmsRelationPublishValidator(this.m_cms, publishList);
        for (String resourceName : validator.keySet()) {
            CmsRelationValidatorInfoEntry infoEntry = validator.getInfoEntry(resourceName);
            try {
                CmsResource resource = this.m_cms.readResource(this.m_cms.getRequestContext().removeSiteRoot(resourceName), CmsResourceFilter.ALL);
                if (resource.getState().isDeleted()) {
                    for (CmsRelation relation : infoEntry.getRelations()) {
                        try {
                            CmsResource theResource = relation.getSource(this.m_cms, CmsResourceFilter.ALL);
                            CmsPublishResourceInfo info = new CmsPublishResourceInfo(Messages.get().getBundle(this.m_workplaceLocale).key("GUI_BROKEN_LINK_ONLINE_0"), CmsPublishResourceInfo.Type.BROKENLINK);
                            ArrayList<CmsPublishResource> relatedList = new ArrayList<CmsPublishResource>();
                            relatedList.add(this.resourceToBean(resource, info, false, null));
                            CmsPublishResource pubRes = this.resourceToBean(theResource, null, false, relatedList);
                            resources.add(pubRes);
                        }
                        catch (CmsException e) {
                            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    continue;
                }
                try {
                    ArrayList<CmsPublishResource> related = new ArrayList<CmsPublishResource>();
                    for (CmsRelation relation : infoEntry.getRelations()) {
                        CmsPublishResource pubRes;
                        try {
                            CmsResource theResource = relation.getTarget(this.m_cms, CmsResourceFilter.ALL);
                            pubRes = this.resourceToBean(theResource, null, false, null);
                            related.add(pubRes);
                        }
                        catch (CmsException e) {
                            pubRes = this.relationToBean(relation);
                            related.add(pubRes);
                            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    CmsPublishResourceInfo info = new CmsPublishResourceInfo(Messages.get().getBundle(this.m_workplaceLocale).key("GUI_RESOURCE_MISSING_ONLINE_0"), CmsPublishResourceInfo.Type.MISSING);
                    CmsPublishResource pubRes = this.resourceToBean(resource, info, false, related);
                    resources.add(pubRes);
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return resources;
    }

    public CmsRelationPublishValidator getRelationValidator() {
        return this.m_relationValidator;
    }

    public void publishResources(List<CmsResource> resources) throws CmsException {
        CmsObject cms = this.m_cms;
        CmsHtmlReport report = new CmsHtmlReport(cms.getRequestContext().getLocale(), cms.getRequestContext().getSiteRoot());
        CmsPublishManager publishManager = OpenCms.getPublishManager();
        CmsPublishList publishList = publishManager.getPublishListAll(this.m_cms, resources, false, true);
        OpenCms.getPublishManager().publishProject(this.m_cms, report, publishList);
    }

    public CmsPublishResource relationToBean(CmsRelation relation) throws CmsException {
        CmsPermissionInfo permissionInfo = OpenCms.getADEManager().getPermissionInfo(this.m_cms, relation.getTarget(this.m_cms, CmsResourceFilter.ALL), null);
        return new CmsPublishResource(relation.getTargetId(), relation.getTargetPath(), relation.getTargetPath(), CmsResourceTypePlain.getStaticTypeName(), CmsResourceState.STATE_UNCHANGED, permissionInfo, 0L, null, null, false, null, null);
    }

    public void removeResourcesFromPublishList(Collection<CmsUUID> idsToRemove) throws CmsException {
        OpenCms.getPublishManager().removeResourceFromUsersPubList(this.m_cms, idsToRemove);
    }

    protected CmsPublishResource resourceToBean(CmsResource resource, CmsPublishResourceInfo info, boolean removable, List<CmsPublishResource> related) throws CmsException {
        CmsResourceUtil resUtil = new CmsResourceUtil(this.m_cms, resource);
        CmsPermissionInfo permissionInfo = OpenCms.getADEManager().getPermissionInfo(this.m_cms, resource, null);
        CmsPublishResource pubResource = new CmsPublishResource(resource.getStructureId(), resUtil.getFullPath(), resUtil.getTitle(), resUtil.getResourceTypeName(), resource.getState(), permissionInfo, resource.getDateLastModified(), resUtil.getUserLastModified(), CmsVfsService.formatDateTime(this.m_cms, resource.getDateLastModified()), removable, info, related);
        return pubResource;
    }

    public class ResourcesAndRelated {
        private Set<CmsResource> m_relatedResources = new HashSet<CmsResource>();
        private Set<CmsResource> m_resources = new HashSet<CmsResource>();

        public boolean contains(CmsResource resource) {
            return this.m_resources.contains(resource) || this.m_relatedResources.contains(resource);
        }

        public Set<CmsResource> getRelatedResources() {
            return this.m_relatedResources;
        }

        public Set<CmsResource> getResources() {
            return this.m_resources;
        }
    }
}

