/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.publish;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opencms.ade.publish.CmsDummyRelatedResourceProvider;
import org.opencms.ade.publish.I_CmsPublishRelatedResourceProvider;
import org.opencms.ade.publish.I_CmsVirtualProject;
import org.opencms.ade.publish.Messages;
import org.opencms.ade.publish.shared.CmsProjectBean;
import org.opencms.ade.publish.shared.CmsPublishOptions;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;
import org.opencms.workflow.CmsDefaultWorkflowManager;

public class CmsRealProjectVirtualWrapper
implements I_CmsVirtualProject {
    private CmsUUID m_projectId;

    public CmsRealProjectVirtualWrapper(CmsUUID id) {
        this.m_projectId = id;
    }

    @Override
    public CmsProjectBean getProjectBean(CmsObject cms, Map<String, String> params) {
        try {
            CmsProject project = cms.readProject(this.getProjectId());
            CmsProjectBean result = CmsDefaultWorkflowManager.createProjectBeanFromProject(cms, project);
            Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
            String name = Messages.get().getBundle(locale).key("GUI_NORMAL_PROJECT_1", project.getName());
            result.setDefaultGroupName(name);
            return result;
        }
        catch (CmsException e) {
            return null;
        }
    }

    @Override
    public CmsUUID getProjectId() {
        return this.m_projectId;
    }

    @Override
    public I_CmsPublishRelatedResourceProvider getRelatedResourceProvider(CmsObject cmsObject, CmsPublishOptions options) {
        return CmsDummyRelatedResourceProvider.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CmsResource> getResources(CmsObject cms, Map<String, String> params, String workflowId) throws CmsException {
        ArrayList<CmsResource> rawResourceList = new ArrayList<CmsResource>();
        CmsProject project = cms.getRequestContext().getCurrentProject();
        try {
            project = cms.readProject(this.getProjectId());
        }
        catch (CmsException e) {
            // empty catch block
        }
        CmsProject originalProject = cms.getRequestContext().getCurrentProject();
        try {
            cms.getRequestContext().setCurrentProject(project);
            rawResourceList.addAll(OpenCms.getPublishManager().getPublishList(cms).getAllResources());
        }
        finally {
            cms.getRequestContext().setCurrentProject(originalProject);
        }
        return rawResourceList;
    }

    @Override
    public boolean isAutoSelectable() {
        return false;
    }
}

