/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration.preferences;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsDefaultUserSettings;
import org.opencms.configuration.preferences.A_CmsPreference;
import org.opencms.configuration.preferences.CmsUserSettingsStringPropertyWrapper;
import org.opencms.main.CmsLog;
import org.opencms.xml.content.CmsXmlContentProperty;

public class CmsBuiltinPreference
extends A_CmsPreference {
    protected boolean m_basic;
    protected boolean m_hidden;
    private static final Log LOG = CmsLog.getLog(CmsBuiltinPreference.class);
    private String m_propName;

    public CmsBuiltinPreference(String propName) {
        this.m_propName = propName;
    }

    @Override
    public String getDefaultValue() {
        CmsUserSettingsStringPropertyWrapper wrapper = new CmsUserSettingsStringPropertyWrapper(CmsDefaultUserSettings.CURRENT_DEFAULT_SETTINGS);
        try {
            return BeanUtils.getProperty((Object)wrapper, (String)this.m_propName);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String getName() {
        return this.m_propName;
    }

    @Override
    public CmsXmlContentProperty getPropertyDefinition() {
        CmsXmlContentProperty prop = new CmsXmlContentProperty(this.m_propName, "string", null, null, null, null, null, null, null, null, null);
        return prop;
    }

    @Override
    public String getTab() {
        return this.m_hidden ? "hidden" : (this.m_basic ? "basic" : "extended");
    }

    @Override
    public String getValue(CmsDefaultUserSettings userSettings) {
        CmsUserSettingsStringPropertyWrapper wrapper = new CmsUserSettingsStringPropertyWrapper(userSettings);
        try {
            return BeanUtils.getProperty((Object)wrapper, (String)this.m_propName);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public void setValue(CmsDefaultUserSettings settings, String value) {
        CmsUserSettingsStringPropertyWrapper wrapper = new CmsUserSettingsStringPropertyWrapper(settings);
        try {
            BeanUtils.setProperty((Object)wrapper, (String)this.m_propName, (Object)value);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

