/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration.preferences;

import java.util.Collection;
import java.util.Locale;
import org.opencms.ade.configuration.CmsElementView;
import org.opencms.configuration.preferences.CmsBuiltinPreference;
import org.opencms.file.CmsObject;
import org.opencms.main.OpenCms;
import org.opencms.xml.content.CmsXmlContentProperty;

public class CmsElementViewPreference
extends CmsBuiltinPreference {
    public static final String PREFERENCE_NAME = "elementView";
    private static final String NICE_NAME = "%(key.GUI_PREF_ELEMENT_VIEW_0)";

    public CmsElementViewPreference(String propName) {
        super(propName);
        this.m_basic = false;
    }

    @Override
    public CmsXmlContentProperty getPropertyDefinition() {
        CmsXmlContentProperty prop = new CmsXmlContentProperty(this.getName(), "string", null, null, null, null, null, NICE_NAME, null, null, null);
        return prop;
    }

    @Override
    public CmsXmlContentProperty getPropertyDefinition(CmsObject cms) {
        Collection<CmsElementView> views = OpenCms.getADEManager().getElementViews(cms).values();
        Locale wpLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        StringBuffer resultBuffer = new StringBuffer();
        boolean first = true;
        for (CmsElementView view : views) {
            if (!view.hasPermission(cms)) continue;
            if (!first) {
                resultBuffer.append("|");
            }
            first = false;
            resultBuffer.append(view.getId().toString());
            resultBuffer.append(":");
            resultBuffer.append(view.getTitle(cms, wpLocale));
        }
        CmsXmlContentProperty prop = new CmsXmlContentProperty(this.getName(), "string", "select_notnull", resultBuffer.toString(), null, null, null, NICE_NAME, null, null, null);
        return prop;
    }
}

