/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration.preferences;

import org.dom4j.Element;
import org.opencms.configuration.CmsDefaultUserSettings;
import org.opencms.configuration.preferences.CmsPreferenceData;
import org.opencms.configuration.preferences.CmsUserDefinedPreference;
import org.opencms.configuration.preferences.I_CmsPreference;
import org.opencms.file.CmsObject;
import org.opencms.xml.content.CmsXmlContentProperty;

public class CmsWrapperPreference
implements I_CmsPreference {
    private CmsPreferenceData m_prefData;
    private I_CmsPreference m_wrappedPreference;

    public CmsWrapperPreference(CmsPreferenceData prefData, I_CmsPreference wrappedPref) {
        this.m_prefData = prefData;
        this.m_wrappedPreference = wrappedPref;
    }

    @Override
    public Element createConfigurationItem() {
        Element elem = this.m_wrappedPreference.createConfigurationItem();
        CmsUserDefinedPreference.fillAttributes(this.m_prefData, elem);
        return elem;
    }

    @Override
    public String getDefaultValue() {
        return this.firstNotNull(this.m_prefData.getDefaultValue(), this.m_wrappedPreference.getDefaultValue());
    }

    @Override
    public String getName() {
        return this.m_wrappedPreference.getName();
    }

    @Override
    public CmsXmlContentProperty getPropertyDefinition(CmsObject cms) {
        CmsXmlContentProperty configProp = this.m_prefData.getPropertyDefinition();
        CmsXmlContentProperty wrappedProp = this.m_wrappedPreference.getPropertyDefinition(cms);
        CmsXmlContentProperty prop = new CmsXmlContentProperty(this.getName(), "string", this.firstNotNull(configProp.getWidget(), wrappedProp.getWidget()), this.firstNotNull(configProp.getWidgetConfiguration(), wrappedProp.getWidgetConfiguration()), this.firstNotNull(configProp.getRuleRegex(), wrappedProp.getRuleRegex()), this.firstNotNull(configProp.getRuleType(), wrappedProp.getRuleType()), null, this.firstNotNull(configProp.getNiceName(), wrappedProp.getNiceName()), this.firstNotNull(configProp.getDescription(), wrappedProp.getDescription()), this.firstNotNull(configProp.getError(), wrappedProp.getError()), null);
        return prop;
    }

    @Override
    public String getTab() {
        return this.firstNotNull(this.m_prefData.getTab(), this.m_wrappedPreference.getTab());
    }

    @Override
    public String getValue(CmsDefaultUserSettings userSettings) {
        return this.m_wrappedPreference.getValue(userSettings);
    }

    @Override
    public void setValue(CmsDefaultUserSettings settings, String value) {
        this.m_wrappedPreference.setValue(settings, value);
    }

    String firstNotNull(String a, String b) {
        return a != null ? a : b;
    }
}

