/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import java.io.Serializable;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsResource;
import org.opencms.util.CmsUUID;

public class CmsPublishedResource
implements Serializable,
Comparable<CmsPublishedResource> {
    public static final CmsPublishedResourceState STATE_MOVED_DESTINATION = new CmsPublishedResourceState(12, 'M');
    public static final CmsPublishedResourceState STATE_MOVED_SOURCE = new CmsPublishedResourceState(11, ' ');
    private static final long serialVersionUID = -1054065812825770479L;
    private boolean m_isFolder;
    private boolean m_isMoved;
    private int m_publishTag;
    private CmsUUID m_resourceId;
    private CmsResourceState m_resourceState;
    private int m_resourceType;
    private String m_rootPath;
    private int m_siblingCount;
    private CmsUUID m_structureId;

    public CmsPublishedResource(CmsResource resource) {
        this(resource, -1);
    }

    public CmsPublishedResource(CmsResource resource, int publishTag) {
        this(resource, publishTag, resource.getState());
    }

    public CmsPublishedResource(CmsResource resource, int publishTag, CmsResourceState state) {
        this(resource.getStructureId(), resource.getResourceId(), publishTag, resource.getRootPath(), resource.getTypeId(), resource.isFolder(), state, resource.getSiblingCount());
    }

    public CmsPublishedResource(CmsUUID structureId, CmsUUID resourceId, int publishTag, String rootPath, int resourceType, boolean isFolder, CmsResourceState resourceState, int siblingCount) {
        this.m_structureId = structureId;
        this.m_resourceId = resourceId;
        this.m_publishTag = publishTag;
        this.m_rootPath = rootPath;
        this.m_resourceType = resourceType;
        this.m_isFolder = isFolder;
        if (resourceState instanceof CmsPublishedResourceState) {
            this.m_resourceState = ((CmsPublishedResourceState)resourceState).getResourceState();
            this.m_isMoved = true;
        } else {
            this.m_resourceState = resourceState;
        }
        this.m_siblingCount = siblingCount;
    }

    @Override
    public int compareTo(CmsPublishedResource obj) {
        if (obj == this) {
            return 0;
        }
        if (this.m_rootPath != null) {
            return this.m_rootPath.compareTo(obj.m_rootPath);
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsPublishedResource) {
            if (this.m_structureId.isNullUUID()) {
                return ((CmsPublishedResource)obj).m_resourceId.equals(this.m_resourceId);
            }
            return ((CmsPublishedResource)obj).m_structureId.equals(this.m_structureId);
        }
        return false;
    }

    public CmsResourceState getMovedState() {
        if (!this.m_isMoved) {
            return this.getState();
        }
        if (this.getState().isDeleted()) {
            return STATE_MOVED_SOURCE;
        }
        if (this.getState().isNew()) {
            return STATE_MOVED_DESTINATION;
        }
        return this.getState();
    }

    public int getPublishTag() {
        return this.m_publishTag;
    }

    public CmsUUID getResourceId() {
        return this.m_resourceId;
    }

    public String getRootPath() {
        return this.m_rootPath;
    }

    public int getSiblingCount() {
        return this.m_siblingCount;
    }

    public CmsResourceState getState() {
        return this.m_resourceState;
    }

    public CmsUUID getStructureId() {
        return this.m_structureId;
    }

    public int getType() {
        return this.m_resourceType;
    }

    public int hashCode() {
        return this.m_structureId.isNullUUID() ? this.m_resourceId.hashCode() : this.m_structureId.hashCode();
    }

    public boolean isFile() {
        return !this.m_isFolder;
    }

    public boolean isFolder() {
        return this.m_isFolder;
    }

    public boolean isMoved() {
        return this.m_isMoved;
    }

    public void setState(CmsResourceState state) {
        this.m_resourceState = state;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(128);
        result.append("[");
        result.append(this.getClass().getName());
        result.append(": root path: ");
        result.append(this.m_rootPath);
        result.append(", structure ID: ");
        result.append(this.m_structureId);
        result.append(", resource ID: ");
        result.append(this.m_resourceId);
        result.append(", publish tag: ");
        result.append(this.m_publishTag);
        result.append(", siblings: ");
        result.append(this.m_siblingCount);
        result.append(", state: ");
        result.append(this.m_resourceState);
        result.append(", type: ");
        result.append(this.m_resourceType);
        result.append("]");
        return result.toString();
    }

    public static class CmsPublishedResourceState
    extends CmsResourceState {
        private static final long serialVersionUID = -2901049208546972463L;

        protected CmsPublishedResourceState(int state, char abbrev) {
            super(state, abbrev);
        }

        public CmsResourceState getResourceState() {
            if (this == STATE_MOVED_SOURCE) {
                return CmsResource.STATE_DELETED;
            }
            if (this == STATE_MOVED_DESTINATION) {
                return CmsResource.STATE_NEW;
            }
            return null;
        }
    }
}

