/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import java.util.List;
import org.opencms.db.CmsSecurityManager;
import org.opencms.db.CmsSubscriptionFilter;
import org.opencms.db.CmsVisitedByFilter;
import org.opencms.db.Messages;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.history.I_CmsHistoryResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPrincipal;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.util.CmsStringUtil;

public class CmsSubscriptionManager {
    private static final int DEFAULT_MAX_VISITEDCOUNT = 1000;
    protected CmsSecurityManager m_securityManager;
    private boolean m_enabled;
    private boolean m_frozen = false;
    private int m_maxVisitedCount;
    private String m_poolName;

    public long getDateLastVisitedBy(CmsObject cms, CmsUser user, CmsResource resource) throws CmsException {
        return this.m_securityManager.getDateLastVisitedBy(cms.getRequestContext(), this.getPoolName(), user, resource);
    }

    public long getDateLastVisitedBy(CmsObject cms, CmsUser user, String resourcePath) throws CmsException {
        CmsResource resource = cms.readResource(resourcePath, CmsResourceFilter.ALL);
        return this.m_securityManager.getDateLastVisitedBy(cms.getRequestContext(), this.getPoolName(), user, resource);
    }

    public int getMaxVisitedCount() {
        if (this.m_maxVisitedCount < 1) {
            this.m_maxVisitedCount = 1000;
        }
        return this.m_maxVisitedCount;
    }

    public String getPoolName() {
        if (CmsStringUtil.isEmpty(this.m_poolName)) {
            this.m_poolName = OpenCms.getSqlManager().getDefaultDbPoolName();
        }
        return this.m_poolName;
    }

    public void initialize(CmsObject cms) throws CmsRoleViolationException {
        OpenCms.getRoleManager().checkRole(cms, CmsRole.ROOT_ADMIN);
        this.m_frozen = true;
    }

    public boolean isEnabled() {
        return this.m_enabled && this.m_securityManager != null && this.m_securityManager.isSubscriptionDriverAvailable();
    }

    public void markResourceAsVisitedBy(CmsObject cms, CmsResource resource, CmsUser user) throws CmsException {
        if (!this.isEnabled()) {
            throw new CmsRuntimeException(Messages.get().container("ERR_SUBSCRIPTION_MANAGER_DISABLED_0"));
        }
        this.m_securityManager.markResourceAsVisitedBy(cms.getRequestContext(), this.getPoolName(), resource, user);
    }

    public void markResourceAsVisitedBy(CmsObject cms, String resourcePath, CmsUser user) throws CmsException {
        CmsResource resource = cms.readResource(resourcePath, CmsResourceFilter.ALL);
        this.markResourceAsVisitedBy(cms, resource, user);
    }

    public List<CmsResource> readAllSubscribedResources(CmsObject cms, CmsPrincipal principal) throws CmsException {
        return this.m_securityManager.readAllSubscribedResources(cms.getRequestContext(), this.getPoolName(), principal);
    }

    public List<CmsResource> readResourcesVisitedBy(CmsObject cms, CmsVisitedByFilter filter) throws CmsException {
        return this.m_securityManager.readResourcesVisitedBy(cms.getRequestContext(), this.getPoolName(), filter);
    }

    public List<I_CmsHistoryResource> readSubscribedDeletedResources(CmsObject cms, CmsUser user, boolean includeGroups, String folderPath, boolean includeSubFolders, long deletedFrom) throws CmsException {
        List<CmsGroup> groups = null;
        if (includeGroups) {
            try {
                groups = cms.getGroupsOfUser(user.getName(), false);
            }
            catch (CmsException e) {
                // empty catch block
            }
        }
        CmsResource resource = null;
        if (CmsStringUtil.isNotEmpty(folderPath)) {
            resource = cms.readResource(folderPath, CmsResourceFilter.ALL);
        }
        return this.m_securityManager.readSubscribedDeletedResources(cms.getRequestContext(), this.getPoolName(), user, groups, resource, includeSubFolders, deletedFrom);
    }

    public List<CmsResource> readSubscribedResources(CmsObject cms, CmsSubscriptionFilter filter) throws CmsException {
        return this.m_securityManager.readSubscribedResources(cms.getRequestContext(), this.getPoolName(), filter);
    }

    public void setEnabled(boolean enabled) {
        if (this.m_frozen) {
            throw new CmsRuntimeException(Messages.get().container("ERR_CONFIG_SUBSCRIPTIONMANAGER_FROZEN_0"));
        }
        this.m_enabled = enabled;
    }

    public void setEnabled(String enabled) {
        if (this.m_frozen) {
            throw new CmsRuntimeException(Messages.get().container("ERR_CONFIG_SUBSCRIPTIONMANAGER_FROZEN_0"));
        }
        this.m_enabled = Boolean.valueOf(enabled);
    }

    public void setMaxVisitedCount(String maxVisitedCount) {
        if (this.m_frozen) {
            throw new CmsRuntimeException(Messages.get().container("ERR_CONFIG_SUBSCRIPTIONMANAGER_FROZEN_0"));
        }
        try {
            int intValue = Integer.parseInt(maxVisitedCount);
            this.m_maxVisitedCount = intValue > 0 ? intValue : 1000;
        }
        catch (NumberFormatException e) {
            this.m_maxVisitedCount = 1000;
        }
    }

    public void setPoolName(String poolName) {
        if (this.m_frozen) {
            throw new CmsRuntimeException(Messages.get().container("ERR_CONFIG_SUBSCRIPTIONMANAGER_FROZEN_0"));
        }
        this.m_poolName = poolName;
    }

    public void setSecurityManager(CmsSecurityManager securityManager) {
        if (this.m_frozen) {
            throw new CmsRuntimeException(Messages.get().container("ERR_CONFIG_SUBSCRIPTIONMANAGER_FROZEN_0"));
        }
        this.m_securityManager = securityManager;
    }

    public void setSubscribedResourceAsDeleted(CmsObject cms, CmsResource resource) throws CmsException {
        if (!this.isEnabled()) {
            throw new CmsRuntimeException(Messages.get().container("ERR_SUBSCRIPTION_MANAGER_DISABLED_0"));
        }
        this.m_securityManager.setSubscribedResourceAsDeleted(cms.getRequestContext(), this.getPoolName(), resource);
    }

    public void subscribeResourceFor(CmsObject cms, CmsPrincipal principal, CmsResource resource) throws CmsException {
        if (!this.isEnabled()) {
            throw new CmsRuntimeException(Messages.get().container("ERR_SUBSCRIPTION_MANAGER_DISABLED_0"));
        }
        this.m_securityManager.subscribeResourceFor(cms.getRequestContext(), this.getPoolName(), principal, resource);
    }

    public void subscribeResourceFor(CmsObject cms, CmsPrincipal principal, String resourcePath) throws CmsException {
        CmsResource resource = cms.readResource(resourcePath, CmsResourceFilter.ALL);
        this.subscribeResourceFor(cms, principal, resource);
    }

    public void unsubscribeAllDeletedResources(CmsObject cms, long deletedTo) throws CmsException {
        if (!this.isEnabled()) {
            throw new CmsRuntimeException(Messages.get().container("ERR_SUBSCRIPTION_MANAGER_DISABLED_0"));
        }
        this.m_securityManager.unsubscribeAllDeletedResources(cms.getRequestContext(), this.getPoolName(), deletedTo);
    }

    public void unsubscribeAllResourcesFor(CmsObject cms, CmsPrincipal principal) throws CmsException {
        if (!this.isEnabled()) {
            throw new CmsRuntimeException(Messages.get().container("ERR_SUBSCRIPTION_MANAGER_DISABLED_0"));
        }
        this.m_securityManager.unsubscribeAllResourcesFor(cms.getRequestContext(), this.getPoolName(), principal);
    }

    public void unsubscribeResourceFor(CmsObject cms, CmsPrincipal principal, CmsResource resource) throws CmsException {
        if (!this.isEnabled()) {
            throw new CmsRuntimeException(Messages.get().container("ERR_SUBSCRIPTION_MANAGER_DISABLED_0"));
        }
        this.m_securityManager.unsubscribeResourceFor(cms.getRequestContext(), this.getPoolName(), principal, resource);
    }

    public void unsubscribeResourceFor(CmsObject cms, CmsPrincipal principal, String resourcePath) throws CmsException {
        CmsResource resource = cms.readResource(resourcePath, CmsResourceFilter.ALL);
        this.unsubscribeResourceFor(cms, principal, resource);
    }

    public void unsubscribeResourceForAll(CmsObject cms, CmsResource resource) throws CmsException {
        if (!this.isEnabled()) {
            throw new CmsRuntimeException(Messages.get().container("ERR_SUBSCRIPTION_MANAGER_DISABLED_0"));
        }
        this.m_securityManager.unsubscribeResourceForAll(cms.getRequestContext(), this.getPoolName(), resource);
    }

    public void unsubscribeResourceForAll(CmsObject cms, String resourcePath) throws CmsException {
        CmsResource resource = cms.readResource(resourcePath, CmsResourceFilter.ALL);
        this.unsubscribeResourceForAll(cms, resource);
    }
}

