/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.opencms.ade.galleries.CmsPreviewService;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsPropertyDefinition;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.history.CmsHistoryProject;
import org.opencms.file.history.I_CmsHistoryResource;
import org.opencms.file.types.CmsResourceTypeBinary;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.file.types.CmsResourceTypePointer;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.gwt.CmsAliasHelper;
import org.opencms.gwt.CmsBrokenLinkRenderer;
import org.opencms.gwt.CmsDefaultResourceStatusProvider;
import org.opencms.gwt.CmsGwtService;
import org.opencms.gwt.CmsRpcException;
import org.opencms.gwt.CmsTemplateFinder;
import org.opencms.gwt.Messages;
import org.opencms.gwt.shared.CmsAvailabilityInfoBean;
import org.opencms.gwt.shared.CmsBrokenLinkBean;
import org.opencms.gwt.shared.CmsClientDateBean;
import org.opencms.gwt.shared.CmsDeleteResourceBean;
import org.opencms.gwt.shared.CmsExternalLinkInfoBean;
import org.opencms.gwt.shared.CmsHistoryResourceBean;
import org.opencms.gwt.shared.CmsHistoryResourceCollection;
import org.opencms.gwt.shared.CmsHistoryVersion;
import org.opencms.gwt.shared.CmsListInfoBean;
import org.opencms.gwt.shared.CmsLockReportInfo;
import org.opencms.gwt.shared.CmsPrepareEditResponse;
import org.opencms.gwt.shared.CmsPreviewInfo;
import org.opencms.gwt.shared.CmsPrincipalBean;
import org.opencms.gwt.shared.CmsRenameInfoBean;
import org.opencms.gwt.shared.CmsReplaceInfo;
import org.opencms.gwt.shared.CmsResourceStatusBean;
import org.opencms.gwt.shared.CmsRestoreInfoBean;
import org.opencms.gwt.shared.CmsVfsEntryBean;
import org.opencms.gwt.shared.alias.CmsAliasBean;
import org.opencms.gwt.shared.property.CmsClientProperty;
import org.opencms.gwt.shared.property.CmsPropertiesBean;
import org.opencms.gwt.shared.property.CmsPropertyChangeSet;
import org.opencms.gwt.shared.property.CmsPropertyModification;
import org.opencms.gwt.shared.rpc.I_CmsVfsService;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.CmsJspTagContainer;
import org.opencms.loader.CmsImageScaler;
import org.opencms.loader.CmsLoaderException;
import org.opencms.lock.CmsLock;
import org.opencms.lock.CmsLockActionRecord;
import org.opencms.lock.CmsLockType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.I_CmsPrincipal;
import org.opencms.util.CmsDateUtil;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplaceMessages;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.page.CmsXmlPageFactory;

public class CmsVfsService
extends CmsGwtService
implements I_CmsVfsService {
    private static final Log LOG = CmsLog.getLog(CmsVfsService.class);
    private static Set<String> m_previewMimeTypes = new HashSet<String>();
    private static final long serialVersionUID = -383483666952834348L;
    private CmsAliasHelper m_aliasHelper = new CmsAliasHelper();

    public static CmsListInfoBean addLockInfo(CmsObject cms, CmsResource resource, CmsListInfoBean resourceInfo) throws CmsException {
        CmsResourceUtil resourceUtil = new CmsResourceUtil(cms, resource);
        CmsLock lock = resourceUtil.getLock();
        CmsListInfoBean.LockIcon icon = CmsListInfoBean.LockIcon.NONE;
        String iconTitle = null;
        CmsLockType lockType = lock.getType();
        if (!lock.isOwnedBy(cms.getRequestContext().getCurrentUser())) {
            if (lockType == CmsLockType.EXCLUSIVE || lockType == CmsLockType.INHERITED || lockType == CmsLockType.TEMPORARY) {
                icon = CmsListInfoBean.LockIcon.CLOSED;
            } else if (lockType == CmsLockType.SHARED_EXCLUSIVE || lockType == CmsLockType.SHARED_INHERITED) {
                icon = CmsListInfoBean.LockIcon.SHARED_CLOSED;
            }
        } else if (lockType == CmsLockType.EXCLUSIVE || lockType == CmsLockType.INHERITED || lockType == CmsLockType.TEMPORARY) {
            icon = CmsListInfoBean.LockIcon.OPEN;
        } else if (lockType == CmsLockType.SHARED_EXCLUSIVE || lockType == CmsLockType.SHARED_INHERITED) {
            icon = CmsListInfoBean.LockIcon.SHARED_OPEN;
        }
        if (lock.getUserId() != null && !lock.getUserId().isNullUUID()) {
            CmsUser lockOwner = cms.readUser(lock.getUserId());
            iconTitle = Messages.get().getBundle().key("GUI_LOCKED_BY_1", lockOwner.getFullName());
            resourceInfo.addAdditionalInfo(Messages.get().getBundle().key("GUI_LOCKED_OWNER_0"), lockOwner.getFullName());
        }
        resourceInfo.setLockIcon(icon);
        resourceInfo.setLockIconTitle(iconTitle);
        if (icon != CmsListInfoBean.LockIcon.NONE) {
            resourceInfo.setTitle(resourceInfo.getTitle() + " (" + iconTitle + ")");
        }
        return resourceInfo;
    }

    public static String formatDateTime(CmsObject cms, long date) {
        return CmsDateUtil.getDateTime(new Date(date), 2, OpenCms.getWorkplaceManager().getWorkplaceLocale(cms));
    }

    public static String getNoPreviewReason(CmsObject cms, CmsResource resource) {
        String noPreviewReason = null;
        if (resource.getState().isDeleted() && !(resource instanceof I_CmsHistoryResource)) {
            noPreviewReason = Messages.get().getBundle().key("GUI_NO_PREVIEW_DELETED_0");
        } else if (resource.isFolder()) {
            noPreviewReason = Messages.get().getBundle().key("GUI_NO_PREVIEW_FOLDER_0");
        } else {
            String mimeType;
            String siteRoot = OpenCms.getSiteManager().getSiteRoot(resource.getRootPath());
            if (siteRoot != null && !siteRoot.equals(cms.getRequestContext().getSiteRoot())) {
                noPreviewReason = Messages.get().getBundle().key("GUI_NO_PREVIEW_OTHER_SITE_0");
            } else if (resource.getTypeId() == CmsResourceTypeBinary.getStaticTypeId() && !m_previewMimeTypes.contains(mimeType = OpenCms.getResourceManager().getMimeType(resource.getName(), null, "empty"))) {
                noPreviewReason = Messages.get().getBundle().key("GUI_NO_PREVIEW_WRONG_MIME_TYPE_0");
            }
        }
        return noPreviewReason;
    }

    public static CmsListInfoBean getPageInfo(CmsObject cms, CmsResource res) throws CmsException {
        CmsListInfoBean result = new CmsListInfoBean();
        CmsVfsService.addPageInfo(cms, res, result);
        return result;
    }

    public static CmsListInfoBean getPageInfoWithLock(CmsObject cms, CmsResource resource) throws CmsLoaderException, CmsException {
        CmsListInfoBean result = CmsVfsService.getPageInfo(cms, resource);
        CmsVfsService.addLockInfo(cms, resource, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CmsPropertiesBean loadPropertyData(CmsObject cms, CmsUUID id) throws CmsException {
        String originalSiteRoot = cms.getRequestContext().getSiteRoot();
        CmsPropertiesBean result = new CmsPropertiesBean();
        CmsResource resource = cms.readResource(id, CmsResourceFilter.IGNORE_EXPIRATION);
        boolean hasPermissions = cms.hasPermissions(resource, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.IGNORE_EXPIRATION);
        CmsLock lock = cms.getLock(resource);
        boolean lockedByOtherUser = !lock.isUnlocked() && !lock.isOwnedBy(cms.getRequestContext().getCurrentUser());
        result.setReadOnly(!hasPermissions || lockedByOtherUser);
        result.setFolder(resource.isFolder());
        result.setContainerPage(CmsResourceTypeXmlContainerPage.isContainerPage(resource));
        String sitePath = cms.getSitePath(resource);
        Map<String, CmsXmlContentProperty> propertyConfig = OpenCms.getADEManager().lookupConfiguration(cms, resource.getRootPath()).getPropertyConfigurationAsMap();
        Map<String, CmsXmlContentProperty> defaultProperties = CmsVfsService.internalGetDefaultProperties(cms, Collections.singletonList(resource.getStructureId())).get(resource.getStructureId());
        LinkedHashMap<String, CmsXmlContentProperty> mergedConfig = new LinkedHashMap<String, CmsXmlContentProperty>();
        mergedConfig.putAll(defaultProperties);
        mergedConfig.putAll(propertyConfig);
        propertyConfig = mergedConfig;
        result.setPropertyDefinitions(new LinkedHashMap<String, CmsXmlContentProperty>(propertyConfig));
        try {
            cms.getRequestContext().setSiteRoot("");
            String parentPath = CmsResource.getParentFolder(resource.getRootPath());
            CmsResource parent = cms.readResource(parentPath, CmsResourceFilter.IGNORE_EXPIRATION);
            List<CmsProperty> parentProperties = cms.readPropertyObjects(parent, true);
            List<CmsProperty> ownProperties = cms.readPropertyObjects(resource, false);
            result.setOwnProperties(CmsVfsService.convertProperties(ownProperties));
            result.setInheritedProperties(CmsVfsService.convertProperties(parentProperties));
            result.setPageInfo(CmsVfsService.getPageInfo(cms, resource));
            List<CmsPropertyDefinition> propDefs = cms.readAllPropertyDefinitions();
            ArrayList<String> propNames = new ArrayList<String>();
            for (CmsPropertyDefinition propDef : propDefs) {
                propNames.add(propDef.getName());
            }
            CmsTemplateFinder templateFinder = new CmsTemplateFinder(cms);
            result.setTemplates(templateFinder.getTemplates());
            result.setAllProperties(propNames);
            result.setStructureId(id);
            result.setSitePath(sitePath);
            CmsPropertiesBean cmsPropertiesBean = result;
            return cmsPropertiesBean;
        }
        finally {
            cms.getRequestContext().setSiteRoot(originalSiteRoot);
        }
    }

    public static String prepareFileNameForEditor(CmsObject cms, CmsResource res, String pathWithMacros) {
        String subsite = OpenCms.getADEManager().getSubSiteRoot(cms, res.getRootPath());
        CmsMacroResolver resolver = new CmsMacroResolver();
        if (subsite != null) {
            resolver.addMacro("subsite", cms.getRequestContext().removeSiteRoot(subsite));
        }
        String path = resolver.resolveMacros(pathWithMacros).replaceAll("/+", "/");
        return path;
    }

    protected static CmsListInfoBean addPageInfo(CmsObject cms, CmsResource resource, CmsListInfoBean listInfo) throws CmsException {
        listInfo.setResourceState(resource.getState());
        String title = cms.readPropertyObject(resource, "Title", false).getValue();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(title)) {
            listInfo.setTitle(title);
        } else {
            listInfo.setTitle(resource.getName());
        }
        listInfo.setSubTitle(cms.getSitePath(resource));
        String secure = cms.readPropertyObject(resource, "secure", true).getValue();
        if (Boolean.parseBoolean(secure)) {
            listInfo.setStateIcon(CmsListInfoBean.StateIcon.secure);
        } else {
            String export = cms.readPropertyObject(resource, "export", true).getValue();
            if (Boolean.parseBoolean(export)) {
                listInfo.setStateIcon(CmsListInfoBean.StateIcon.export);
            } else {
                listInfo.setStateIcon(CmsListInfoBean.StateIcon.standard);
            }
        }
        String resTypeName = OpenCms.getResourceManager().getResourceType(resource.getTypeId()).getTypeName();
        String key = OpenCms.getWorkplaceManager().getExplorerTypeSetting(resTypeName).getKey();
        Locale currentLocale = cms.getRequestContext().getLocale();
        CmsWorkplaceMessages messages = OpenCms.getWorkplaceManager().getMessages(currentLocale);
        String resTypeNiceName = messages.key(key);
        listInfo.addAdditionalInfo(messages.key("GUI_LABEL_TYPE_0"), resTypeNiceName);
        listInfo.setResourceType(resTypeName);
        return listInfo;
    }

    protected static Map<String, CmsClientProperty> convertProperties(List<CmsProperty> properties) {
        HashMap<String, CmsClientProperty> result = new HashMap<String, CmsClientProperty>();
        for (CmsProperty prop : properties) {
            CmsClientProperty clientProp = new CmsClientProperty(prop.getName(), prop.getStructureValue(), prop.getResourceValue());
            clientProp.setOrigin(prop.getOrigin());
            result.put(clientProp.getName(), clientProp);
        }
        return result;
    }

    protected static Map<String, CmsXmlContentProperty> getDefaultPropertiesForType(String typeName) {
        LinkedHashMap<String, CmsXmlContentProperty> propertyConfig = new LinkedHashMap<String, CmsXmlContentProperty>();
        CmsExplorerTypeSettings explorerType = OpenCms.getWorkplaceManager().getExplorerTypeSetting(typeName);
        if (explorerType != null) {
            List<String> defaultProps = explorerType.getProperties();
            for (String propName : defaultProps) {
                CmsXmlContentProperty property = new CmsXmlContentProperty(propName, "string", "string", "", "", "", "", null, "", "", "false");
                propertyConfig.put(propName, property);
            }
        }
        return propertyConfig;
    }

    protected static Map<CmsUUID, Map<String, CmsXmlContentProperty>> internalGetDefaultProperties(CmsObject cms, List<CmsUUID> structureIds) throws CmsException {
        HashMap result = Maps.newHashMap();
        for (CmsUUID structureId : structureIds) {
            CmsResource resource = cms.readResource(structureId, CmsResourceFilter.ALL);
            String typeName = OpenCms.getResourceManager().getResourceType(resource).getTypeName();
            Map<String, CmsXmlContentProperty> propertyConfig = CmsVfsService.getDefaultPropertiesForType(typeName);
            result.put(structureId, propertyConfig);
        }
        return result;
    }

    @Override
    public void createNewExternalLink(String title, String link, String resourceName, String parentFolderPath) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        try {
            CmsProperty titleProp = new CmsProperty("Title", title, null);
            CmsResource resource = cms.createResource(CmsStringUtil.joinPaths(parentFolderPath, resourceName), CmsResourceTypePointer.getStaticTypeId(), new byte[0], Collections.singletonList(titleProp));
            CmsFile file = cms.readFile(resource);
            file.setContents(link.getBytes(CmsLocaleManager.getResourceEncoding(cms, resource)));
            cms.writeFile(file);
            this.tryUnlock(resource);
            OpenCms.getSearchManager().updateOfflineIndexes(30000L);
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    @Override
    public void createPropertyDefinition(String name) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        try {
            cms.createPropertyDefinition(name.trim());
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    @Override
    public void deleteResource(CmsUUID structureId) throws CmsRpcException {
        try {
            CmsObject cms = this.getCmsObject();
            CmsResource res = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            this.deleteResource(res);
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    @Override
    public void deleteResource(String sitePath) throws CmsRpcException {
        try {
            CmsResource res = this.getCmsObject().readResource(sitePath, CmsResourceFilter.IGNORE_EXPIRATION);
            this.deleteResource(res);
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    @Override
    public void forceUnlock(CmsUUID structureId) throws CmsRpcException {
        try {
            CmsResource resource = this.getCmsObject().readResource(structureId, CmsResourceFilter.ALL);
            CmsLock currentLock = this.getCmsObject().getLock(resource);
            if (currentLock.getEditionLock().isUnlocked() && currentLock.getSystemLock().isUnlocked()) {
                this.getCmsObject().lockResourceTemporary(resource);
            } else {
                this.getCmsObject().changeLock(resource);
            }
            this.getCmsObject().unlockResource(resource);
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    @Override
    public List<CmsAliasBean> getAliasesForPage(CmsUUID uuid) throws CmsRpcException {
        try {
            return this.m_aliasHelper.getAliasesForPage(uuid);
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsAvailabilityInfoBean getAvailabilityInfo(CmsUUID structureId) throws CmsRpcException {
        try {
            CmsResource res = this.getCmsObject().readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            return this.getAvailabilityInfo(res);
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsAvailabilityInfoBean getAvailabilityInfo(String vfsPath) throws CmsRpcException {
        try {
            CmsResource res = this.getCmsObject().readResource(vfsPath, CmsResourceFilter.IGNORE_EXPIRATION);
            return this.getAvailabilityInfo(res);
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsDeleteResourceBean getBrokenLinks(CmsUUID structureId) throws CmsRpcException {
        try {
            CmsResource entryResource = this.getCmsObject().readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            return this.getBrokenLinks(entryResource);
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsDeleteResourceBean getBrokenLinks(String sitePath) throws CmsRpcException {
        try {
            CmsResource entryResource = this.getCmsObject().readResource(sitePath, CmsResourceFilter.IGNORE_EXPIRATION);
            return this.getBrokenLinks(entryResource);
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public List<CmsVfsEntryBean> getChildren(String path) throws CmsRpcException {
        try {
            CmsObject cms = this.getCmsObject();
            ArrayList<CmsResource> resources = new ArrayList<CmsResource>();
            resources.addAll(cms.getResourcesInFolder(path, CmsResourceFilter.DEFAULT));
            List<CmsVfsEntryBean> result = this.makeEntryBeans(resources, false);
            return result;
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public Map<CmsUUID, Map<String, CmsXmlContentProperty>> getDefaultProperties(List<CmsUUID> structureIds) throws CmsRpcException {
        try {
            return CmsVfsService.internalGetDefaultProperties(this.getCmsObject(), structureIds);
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public ArrayList<String> getDefinedProperties() throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        try {
            List<CmsPropertyDefinition> definitions = cms.readAllPropertyDefinitions();
            ArrayList<String> result = new ArrayList<String>();
            for (CmsPropertyDefinition def : definitions) {
                result.add(def.getName());
            }
            return result;
        }
        catch (Exception e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsReplaceInfo getFileReplaceInfo(CmsUUID structureId) throws CmsRpcException {
        CmsReplaceInfo result = null;
        try {
            CmsObject cms = this.getCmsObject();
            CmsResource res = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            CmsListInfoBean fileInfo = this.getPageInfo(res);
            boolean isLockable = cms.getLock(res).isLockableBy(cms.getRequestContext().getCurrentUser());
            long maxFileSize = OpenCms.getWorkplaceManager().getFileBytesMaxUploadSize(cms);
            result = new CmsReplaceInfo(fileInfo, cms.getSitePath(res), isLockable, maxFileSize);
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public CmsPreviewInfo getHistoryPreviewInfo(CmsUUID structureId, String locale, CmsHistoryVersion versionBean) throws CmsRpcException {
        try {
            CmsObject cms = this.getCmsObject();
            CmsResource previewResource = null;
            if (versionBean.getVersionNumber() != null) {
                previewResource = (CmsResource)((Object)cms.readResource(structureId, versionBean.getVersionNumber()));
            } else if (versionBean.isOffline()) {
                previewResource = cms.readResource(structureId, CmsResourceFilter.ALL);
            } else if (versionBean.isOnline()) {
                CmsProject online = cms.readProject(CmsProject.ONLINE_PROJECT_ID);
                cms = OpenCms.initCmsObject(cms);
                cms.getRequestContext().setCurrentProject(online);
                previewResource = cms.readResource(structureId, CmsResourceFilter.ALL);
            }
            CmsFile previewFile = cms.readFile(previewResource);
            return this.getPreviewInfo(cms, previewFile, CmsLocaleManager.getLocale(locale));
        }
        catch (Exception e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsLockReportInfo getLockReportInfo(CmsUUID structureId) throws CmsRpcException {
        CmsLockReportInfo result = null;
        CmsObject cms = this.getCmsObject();
        try {
            CmsResource resource = cms.readResource(structureId, CmsResourceFilter.ALL);
            ArrayList<CmsListInfoBean> lockedInfos = new ArrayList<CmsListInfoBean>();
            List<CmsResource> lockedResources = cms.getBlockingLockedResources(resource);
            if (lockedResources != null) {
                for (CmsResource lockedResource : lockedResources) {
                    lockedInfos.add(CmsVfsService.getPageInfoWithLock(cms, lockedResource));
                }
            }
            result = new CmsLockReportInfo(CmsVfsService.getPageInfoWithLock(cms, resource), lockedInfos);
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public CmsListInfoBean getPageInfo(CmsUUID structureId) throws CmsRpcException {
        try {
            CmsResource res = this.getCmsObject().readResource(structureId, CmsResourceFilter.ALL);
            return this.getPageInfo(res);
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsListInfoBean getPageInfo(String vfsPath) throws CmsRpcException {
        try {
            CmsResource res = this.getCmsObject().readResource(vfsPath, CmsResourceFilter.IGNORE_EXPIRATION);
            return this.getPageInfo(res);
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsPreviewInfo getPreviewInfo(CmsUUID structureId, String locale) throws CmsRpcException {
        CmsPreviewInfo result = null;
        try {
            result = this.getPreviewInfo(this.getCmsObject(), this.getCmsObject().readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION), CmsLocaleManager.getLocale(locale));
        }
        catch (Exception e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public CmsPreviewInfo getPreviewInfo(String sitePath, String locale) throws CmsRpcException {
        CmsPreviewInfo result = null;
        try {
            result = this.getPreviewInfo(this.getCmsObject(), this.getCmsObject().readResource(sitePath, CmsResourceFilter.IGNORE_EXPIRATION), CmsLocaleManager.getLocale(locale));
        }
        catch (Exception e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public CmsRenameInfoBean getRenameInfo(CmsUUID structureId) throws CmsRpcException {
        try {
            CmsObject cms = this.getCmsObject();
            CmsResource resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            CmsListInfoBean listInfo = this.getPageInfo(resource);
            String sitePath = cms.getSitePath(resource);
            return new CmsRenameInfoBean(sitePath, structureId, listInfo);
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsHistoryResourceCollection getResourceHistory(CmsUUID structureId) throws CmsRpcException {
        try {
            CmsHistoryResourceCollection result = new CmsHistoryResourceCollection();
            CmsObject cms = this.getCmsObject();
            CmsResource resource = cms.readResource(structureId, CmsResourceFilter.ALL);
            List<I_CmsHistoryResource> versions = cms.readAllAvailableVersions(resource);
            if (!resource.getState().isUnchanged()) {
                result.add(this.createHistoryResourceBean(cms, resource, true, -1));
            }
            int maxVersion = 0;
            if (versions.isEmpty()) {
                try {
                    CmsProject online = cms.readProject(CmsProject.ONLINE_PROJECT_ID);
                    CmsObject onlineCms = OpenCms.initCmsObject(cms);
                    onlineCms.getRequestContext().setCurrentProject(online);
                    CmsResource onlineResource = onlineCms.readResource(structureId, CmsResourceFilter.ALL);
                    CmsHistoryResourceBean onlineResBean = this.createHistoryResourceBean(onlineCms, onlineResource, false, 0);
                    result.add(onlineResBean);
                }
                catch (CmsVfsResourceNotFoundException e) {
                    LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            } else {
                for (I_CmsHistoryResource historyRes : versions) {
                    maxVersion = Math.max(maxVersion, historyRes.getVersion());
                }
                for (I_CmsHistoryResource historyRes : versions) {
                    CmsHistoryResourceBean historyBean = this.createHistoryResourceBean(cms, (CmsResource)((Object)historyRes), false, maxVersion);
                    result.add(historyBean);
                }
            }
            CmsListInfoBean info = this.getPageInfo(structureId);
            result.setContentInfo(info);
            return result;
        }
        catch (Exception e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsResourceStatusBean getResourceStatus(CmsUUID structureId, String contentLocale, boolean includeTargets, List<CmsUUID> additionalTargets) throws CmsRpcException {
        try {
            CmsObject cms = this.getCmsObject();
            CmsDefaultResourceStatusProvider provider = new CmsDefaultResourceStatusProvider();
            return provider.getResourceStatus(cms, structureId, contentLocale, includeTargets, additionalTargets);
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsRestoreInfoBean getRestoreInfo(CmsUUID structureId) throws CmsRpcException {
        try {
            CmsObject cms = this.getCmsObject();
            CmsResource resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            CmsListInfoBean listInfo = this.getPageInfo(resource);
            CmsRestoreInfoBean result = new CmsRestoreInfoBean();
            result.setListInfoBean(listInfo);
            CmsObject onlineCms = OpenCms.initCmsObject(cms);
            CmsProject onlineProject = cms.readProject("Online");
            onlineCms.getRequestContext().setCurrentProject(onlineProject);
            CmsResource onlineResource = onlineCms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            result.setOnlinePath(onlineResource.getRootPath());
            result.setOfflinePath(resource.getRootPath());
            String offlineDate = this.formatDateTime(resource.getDateLastModified());
            String onlineDate = this.formatDateTime(onlineResource.getDateLastModified());
            result.setOfflineDate(offlineDate);
            result.setOnlineDate(onlineDate);
            result.setStructureId(structureId);
            CmsObject offlineRootCms = OpenCms.initCmsObject(cms);
            offlineRootCms.getRequestContext().setSiteRoot("");
            CmsObject onlineRootCms = OpenCms.initCmsObject(onlineCms);
            onlineRootCms.getRequestContext().setSiteRoot("");
            String parent = CmsResource.getParentFolder(onlineResource.getRootPath());
            boolean canUndoMove = offlineRootCms.existsResource(parent, CmsResourceFilter.IGNORE_EXPIRATION);
            result.setCanUndoMove(canUndoMove);
            return result;
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public List<CmsVfsEntryBean> getRootEntries() throws CmsRpcException {
        try {
            CmsObject cms = this.getCmsObject();
            ArrayList<CmsResource> roots = new ArrayList<CmsResource>();
            roots.add(cms.readResource("/", CmsResourceFilter.IGNORE_EXPIRATION));
            return this.makeEntryBeans(roots, true);
        }
        catch (CmsException e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public String getSitePath(CmsUUID structureId) {
        try {
            CmsResource resource = this.getCmsObject().readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            return this.getCmsObject().getSitePath(resource);
        }
        catch (CmsException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)e.getMessageContainer(), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public CmsExternalLinkInfoBean loadLinkInfo(CmsUUID structureId) throws CmsRpcException {
        CmsExternalLinkInfoBean info = new CmsExternalLinkInfoBean();
        CmsObject cms = this.getCmsObject();
        try {
            CmsResource linkResource = cms.readResource(structureId, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
            CmsVfsService.addPageInfo(cms, linkResource, info);
            CmsFile linkFile = cms.readFile(linkResource);
            OpenCms.getLocaleManager();
            String link = new String(linkFile.getContents(), CmsLocaleManager.getResourceEncoding(cms, linkResource));
            info.setLink(link);
            info.setSitePath(cms.getSitePath(linkResource));
        }
        catch (Exception e) {
            this.error(e);
        }
        return info;
    }

    @Override
    public CmsPropertiesBean loadPropertyData(CmsUUID id) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        try {
            return CmsVfsService.loadPropertyData(cms, id);
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsPrepareEditResponse prepareEdit(CmsUUID currentPageId, String pathWithMacros) throws CmsRpcException {
        try {
            CmsObject cms = this.getCmsObject();
            CmsResource currentPage = cms.readResource(currentPageId, CmsResourceFilter.IGNORE_EXPIRATION);
            String path = CmsVfsService.prepareFileNameForEditor(cms, currentPage, pathWithMacros);
            CmsResource resource = cms.readResource(path, CmsResourceFilter.IGNORE_EXPIRATION);
            this.ensureLock(resource);
            CmsPrepareEditResponse result = new CmsPrepareEditResponse();
            result.setRootPath(resource.getRootPath());
            result.setSitePath(cms.getSitePath(resource));
            result.setStructureId(resource.getStructureId());
            return result;
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public String renameResource(CmsUUID structureId, String newName) throws CmsRpcException {
        try {
            return this.renameResourceInternal(structureId, newName);
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    public String renameResourceInternal(CmsUUID structureId, String newName) throws CmsException {
        CmsObject cms = this.getCmsObject();
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        try {
            CmsResource.checkResourceName(newName);
        }
        catch (CmsIllegalArgumentException e) {
            return e.getLocalizedMessage(locale);
        }
        CmsResource resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
        String oldSitePath = cms.getSitePath(resource);
        String parentPath = CmsResource.getParentFolder(oldSitePath);
        String newSitePath = CmsStringUtil.joinPaths(parentPath, newName);
        try {
            this.ensureLock(resource);
            cms.moveResource(oldSitePath, newSitePath);
            resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
        }
        catch (CmsException e) {
            return e.getLocalizedMessage(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms));
        }
        this.tryUnlock(resource);
        return null;
    }

    @Override
    public void restoreResource(CmsUUID structureId, int version) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        try {
            this.ensureLock(structureId);
            cms.restoreResourceVersion(structureId, version);
            try {
                CmsResource res = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
                cms.unlockResource(res);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        catch (Exception e) {
            this.error(e);
            return;
        }
    }

    @Override
    public void saveAliases(CmsUUID structureId, List<CmsAliasBean> aliasBeans) throws CmsRpcException {
        try {
            this.m_aliasHelper.saveAliases(structureId, aliasBeans);
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    @Override
    public void saveExternalLink(CmsUUID structureId, String title, String link, String fileName) throws CmsRpcException {
        try {
            CmsProperty titleProp;
            CmsObject cms = this.getCmsObject();
            CmsResource res = cms.readResource(structureId);
            this.ensureLock(res);
            CmsFile file = cms.readFile(res);
            String oldLink = new String(file.getContents(), CmsLocaleManager.getResourceEncoding(cms, res));
            if (!oldLink.equals(link)) {
                file.setContents(link.getBytes(CmsLocaleManager.getResourceEncoding(cms, res)));
                cms.writeFile(file);
            }
            if ((titleProp = cms.readPropertyObject(res, "Title", false)).isNullProperty()) {
                titleProp = new CmsProperty("Title", title, null);
                cms.writePropertyObject(cms.getSitePath(res), titleProp);
            } else if (!titleProp.getValue().equals(title)) {
                titleProp.setStructureValue(title);
                cms.writePropertyObject(cms.getSitePath(res), titleProp);
            }
            if (!res.getName().equals(fileName)) {
                String oldSitePath = cms.getSitePath(res);
                String newSitePath = CmsStringUtil.joinPaths(CmsResource.getParentFolder(oldSitePath), fileName);
                this.getCmsObject().renameResource(oldSitePath, newSitePath);
            }
            this.tryUnlock(res);
            OpenCms.getSearchManager().updateOfflineIndexes(30000L);
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveProperties(CmsPropertyChangeSet changes) throws CmsRpcException {
        String origSiteRoot = this.getCmsObject().getRequestContext().getSiteRoot();
        try {
            this.getCmsObject().getRequestContext().setSiteRoot("");
            this.internalSaveProperties(changes);
        }
        catch (Throwable t) {
            this.error(t);
        }
        finally {
            this.getCmsObject().getRequestContext().setSiteRoot(origSiteRoot);
        }
    }

    @Override
    public synchronized void setCms(CmsObject cms) {
        super.setCms(cms);
        this.m_aliasHelper.setCms(cms);
    }

    @Override
    public String substituteLinkForRootPath(String currentSiteRoot, String rootPath) throws CmsRpcException {
        String result = null;
        try {
            CmsObject cms = OpenCms.initCmsObject(this.getCmsObject());
            cms.getRequestContext().setSiteRoot(currentSiteRoot);
            result = OpenCms.getLinkManager().substituteLinkForRootPath(cms, rootPath);
        }
        catch (CmsException e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public void syncDeleteResource(CmsUUID structureId) throws CmsRpcException {
        this.deleteResource(structureId);
    }

    @Override
    public void undelete(CmsUUID structureId) throws CmsRpcException {
        try {
            CmsObject cms = OpenCms.initCmsObject(this.getCmsObject());
            cms.getRequestContext().setSiteRoot("");
            CmsResource resource = cms.readResource(structureId, CmsResourceFilter.ALL);
            this.ensureLock(resource);
            cms.undeleteResource(resource.getRootPath(), true);
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    @Override
    public void undoChanges(CmsUUID structureId, boolean undoMove) throws CmsRpcException {
        try {
            CmsObject cms = this.getCmsObject();
            CmsResource resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            this.ensureLock(resource);
            CmsResource.CmsResourceUndoMode mode = undoMove ? CmsResource.UNDO_MOVE_CONTENT : CmsResource.UNDO_CONTENT;
            String path = cms.getSitePath(resource);
            cms.undoChanges(path, mode);
            try {
                resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
                path = cms.getSitePath(resource);
                cms.unlockResource(path);
            }
            catch (CmsException e) {
                LOG.info((Object)("Could not unlock resource after undoing changes: " + e.getLocalizedMessage()), (Throwable)e);
            }
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    @Override
    public Map<String, String> validateAliases(CmsUUID uuid, Map<String, String> aliasPaths) throws CmsRpcException {
        try {
            return this.m_aliasHelper.validateAliases(uuid, aliasPaths);
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    protected CmsBrokenLinkBean createSitemapBrokenLinkBean(CmsResource resource) throws CmsException {
        String path;
        CmsObject cms = this.getCmsObject();
        CmsProperty titleProp = cms.readPropertyObject(resource, "Title", true);
        String typeName = OpenCms.getResourceManager().getResourceType(resource).getTypeName();
        String defaultTitle = "";
        String title = titleProp.getValue(defaultTitle);
        String subtitle = path = cms.getSitePath(resource);
        CmsBrokenLinkBean result = new CmsBrokenLinkBean(resource.getStructureId(), title, subtitle, typeName);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalSaveProperties(CmsPropertyChangeSet changes) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsResource resource = cms.readResource(changes.getTargetStructureId(), CmsResourceFilter.IGNORE_EXPIRATION);
        CmsLockActionRecord actionRecord = this.ensureLock(cms.getSitePath(resource));
        try {
            Map<String, CmsProperty> ownProps = this.getPropertiesByName(cms.readPropertyObjects(resource, false));
            boolean changeOwnTitle = this.shouldChangeTitle(ownProps);
            String hasNavTextChange = null;
            ArrayList<CmsProperty> ownPropertyChanges = new ArrayList<CmsProperty>();
            for (CmsPropertyModification propMod : changes.getChanges()) {
                if (propMod.isFileNameProperty()) {
                    if (!resource.getStructureId().equals(propMod.getId())) {
                        throw new IllegalStateException("Invalid structure id in property changes!");
                    }
                    CmsResource.checkResourceName(propMod.getValue());
                    String oldSitePath = cms.getSitePath(resource);
                    String parentPath = CmsResource.getParentFolder(oldSitePath);
                    String newSitePath = CmsStringUtil.joinPaths(parentPath, propMod.getValue());
                    cms.moveResource(oldSitePath, newSitePath);
                    resource = cms.readResource(resource.getStructureId(), CmsResourceFilter.IGNORE_EXPIRATION);
                    continue;
                }
                CmsProperty propToModify = null;
                if (resource.getStructureId().equals(propMod.getId())) {
                    if ("NavText".equals(propMod.getName())) {
                        hasNavTextChange = propMod.getValue();
                    } else if ("Title".equals(propMod.getName())) {
                        changeOwnTitle = false;
                    }
                    propToModify = ownProps.get(propMod.getName());
                    if (propToModify == null) {
                        propToModify = new CmsProperty(propMod.getName(), null, null);
                    }
                } else {
                    throw new IllegalStateException("Invalid structure id in property changes!");
                }
                ownPropertyChanges.add(propToModify);
                String newValue = propMod.getValue();
                if (newValue == null) {
                    newValue = "";
                }
                if (propMod.isStructureValue()) {
                    propToModify.setStructureValue(newValue);
                    continue;
                }
                propToModify.setResourceValue(newValue);
            }
            if (hasNavTextChange != null && changeOwnTitle) {
                CmsProperty titleProp = ownProps.get("Title");
                if (titleProp == null) {
                    titleProp = new CmsProperty("Title", null, null);
                }
                titleProp.setStructureValue(hasNavTextChange);
                ownPropertyChanges.add(titleProp);
            }
            if (!ownPropertyChanges.isEmpty()) {
                cms.writePropertyObjects(resource, ownPropertyChanges);
            }
        }
        finally {
            if (actionRecord.getChange() == CmsLockActionRecord.LockChange.locked) {
                cms.unlockResource(resource);
            }
        }
    }

    protected CmsVfsEntryBean makeEntryBean(CmsResource resource, boolean root) throws CmsException {
        List<CmsResource> children;
        CmsObject cms = this.getCmsObject();
        boolean isFolder = resource.isFolder();
        String name = root ? "/" : resource.getName();
        String path = cms.getSitePath(resource);
        boolean hasChildren = false;
        if (isFolder && !(children = cms.getResourcesInFolder(cms.getRequestContext().getSitePath(resource), CmsResourceFilter.DEFAULT)).isEmpty()) {
            hasChildren = true;
        }
        String resourceType = OpenCms.getResourceManager().getResourceType(resource.getTypeId()).getTypeName();
        return new CmsVfsEntryBean(path, name, resourceType, isFolder, hasChildren);
    }

    protected List<CmsVfsEntryBean> makeEntryBeans(List<CmsResource> resources, boolean root) throws CmsException {
        ArrayList<CmsVfsEntryBean> result = new ArrayList<CmsVfsEntryBean>();
        for (CmsResource res : resources) {
            result.add(this.makeEntryBean(res, root));
        }
        return result;
    }

    private void addBrokenLinkAdditionalInfo(CmsObject cms, CmsResource resource, CmsBrokenLinkBean result) {
        String dateLastModifiedLabel = org.opencms.workplace.commons.Messages.get().getBundle(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms)).key("GUI_LABEL_DATE_LAST_MODIFIED_0");
        String dateLastModified = CmsVfsService.formatDateTime(cms, resource.getDateLastModified());
        String userLastModifiedLabel = org.opencms.workplace.commons.Messages.get().getBundle(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms)).key("GUI_LABEL_USER_LAST_MODIFIED_0");
        String userLastModified = "" + resource.getUserLastModified();
        try {
            userLastModified = cms.readUser(resource.getUserLastModified()).getName();
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        result.addInfo(dateLastModifiedLabel, dateLastModified);
        result.addInfo(userLastModifiedLabel, userLastModified);
    }

    private CmsHistoryResourceBean createHistoryResourceBean(CmsObject cms, CmsResource historyRes, boolean offline, int maxVersion) throws CmsException {
        CmsHistoryResourceBean result = new CmsHistoryResourceBean();
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        result.setStructureId(historyRes.getStructureId());
        result.setRootPath(historyRes.getRootPath());
        result.setDateLastModified(this.formatDate(historyRes.getDateLastModified(), locale));
        CmsUUID userId = historyRes.getUserLastModified();
        String userName = userId.toString();
        try {
            CmsUser user = cms.readUser(userId);
            userName = user.getName();
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        result.setUserLastModified(userName);
        result.setSize(historyRes.getLength());
        if (historyRes instanceof I_CmsHistoryResource) {
            int publishTag = ((I_CmsHistoryResource)((Object)historyRes)).getPublishTag();
            CmsHistoryProject project = cms.readHistoryProject(publishTag);
            long publishDate = project.getPublishingDate();
            result.setDatePublished(this.formatDate(publishDate, locale));
            int version = ((I_CmsHistoryResource)((Object)historyRes)).getVersion();
            result.setVersion(new CmsHistoryVersion(historyRes.getVersion(), maxVersion == version ? CmsHistoryVersion.OfflineOnline.online : null));
            List<CmsProperty> historyProperties = cms.readHistoryPropertyObjects((I_CmsHistoryResource)((Object)historyRes));
            Map<String, CmsProperty> historyPropertyMap = CmsProperty.toObjectMap(historyProperties);
            CmsProperty titleProp = CmsProperty.wrapIfNull(historyPropertyMap.get("Title"));
            CmsProperty descProp = CmsProperty.wrapIfNull(historyPropertyMap.get("Description"));
            result.setTitle(titleProp.getValue());
            result.setDescription(descProp.getValue());
        } else if (offline) {
            result.setVersion(new CmsHistoryVersion(null, CmsHistoryVersion.OfflineOnline.offline));
        } else {
            result.setVersion(new CmsHistoryVersion(null, CmsHistoryVersion.OfflineOnline.online));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteResource(CmsResource resource) throws CmsException {
        String path = null;
        CmsObject cms = this.getCmsObject();
        try {
            path = cms.getSitePath(resource);
            cms.lockResource(path);
            cms.deleteResource(path, CmsResource.DELETE_PRESERVE_SIBLINGS);
            String detailContainers = CmsJspTagContainer.getDetailOnlyPageName(path);
            if (cms.existsResource(detailContainers, CmsResourceFilter.IGNORE_EXPIRATION)) {
                this.deleteResource(cms.readResource(detailContainers, CmsResourceFilter.IGNORE_EXPIRATION));
            }
        }
        finally {
            try {
                if (path != null) {
                    this.getCmsObject().unlockResource(path);
                }
            }
            catch (Exception e) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    private CmsClientDateBean formatDate(long date, Locale locale) {
        return new CmsClientDateBean(date, this.formatDateTime(date));
    }

    private String formatDateTime(long date) {
        CmsObject cms = this.getCmsObject();
        return CmsVfsService.formatDateTime(cms, date);
    }

    private CmsAvailabilityInfoBean getAvailabilityInfo(CmsResource res) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        try {
            String notificationEnabled;
            CmsAvailabilityInfoBean result = new CmsAvailabilityInfoBean();
            result.setPageInfo(this.getPageInfo(res));
            String resourceSitePath = cms.getRequestContext().removeSiteRoot(res.getRootPath());
            result.setVfsPath(resourceSitePath);
            I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(res.getTypeId());
            result.setResType(type.getTypeName());
            result.setDateReleased(res.getDateReleased());
            result.setDateExpired(res.getDateExpired());
            String notificationInterval = cms.readPropertyObject(res, "notification-interval", false).getValue();
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(notificationInterval)) {
                result.setNotificationInterval(Integer.valueOf(notificationInterval));
            }
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(notificationEnabled = cms.readPropertyObject(res, "enable-notification", false).getValue())) {
                result.setNotificationEnabled(Boolean.valueOf(notificationEnabled));
            }
            result.setHasSiblings(cms.readSiblings(resourceSitePath, CmsResourceFilter.ALL).size() > 1);
            result.setResponsibles(this.getResponsibles(res.getRootPath()));
            return result;
        }
        catch (CmsException e) {
            this.error(e);
            return null;
        }
    }

    private LinkedHashMap<String, String> getAvailableLocales(CmsResource resource) {
        LinkedHashMap<String, String> result = null;
        List<Locale> locales = null;
        try {
            if (CmsResourceTypeXmlPage.isXmlPage(resource)) {
                locales = CmsXmlPageFactory.unmarshal(this.getCmsObject(), resource, (ServletRequest)this.getRequest()).getLocales();
            } else if (CmsResourceTypeXmlContent.isXmlContent(resource)) {
                locales = CmsXmlContentFactory.unmarshal(this.getCmsObject(), resource, (ServletRequest)this.getRequest()).getLocales();
            } else if (CmsResourceTypeXmlContainerPage.isContainerPage(resource)) {
                locales = CmsXmlContainerPageFactory.unmarshal(this.getCmsObject(), resource).getLocales();
            }
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        if (locales != null) {
            Locale wpLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(this.getCmsObject());
            result = new LinkedHashMap<String, String>();
            for (Locale locale : locales) {
                result.put(locale.toString(), locale.getDisplayName(wpLocale));
            }
        }
        return result;
    }

    private List<CmsBrokenLinkBean> getBrokenLinkBeans(Multimap<CmsResource, CmsResource> linkMap) throws CmsException {
        CmsBrokenLinkRenderer brokenLinkRenderer = new CmsBrokenLinkRenderer(this.getCmsObject());
        HashMultimap resultMap = HashMultimap.create();
        for (CmsResource source : linkMap.keySet()) {
            for (CmsResource target : linkMap.get((Object)source)) {
                CmsBrokenLinkBean targetBean = this.createSitemapBrokenLinkBean(target);
                this.addBrokenLinkAdditionalInfo(this.getCmsObject(), target, targetBean);
                List<CmsBrokenLinkBean> brokenLinkBeans = brokenLinkRenderer.renderBrokenLink(target, source);
                for (CmsBrokenLinkBean childBean : brokenLinkBeans) {
                    this.addBrokenLinkAdditionalInfo(this.getCmsObject(), source, childBean);
                    resultMap.put((Object)childBean, (Object)targetBean);
                }
            }
        }
        for (CmsBrokenLinkBean parent : resultMap.keySet()) {
            for (CmsBrokenLinkBean child : resultMap.get((Object)parent)) {
                parent.addChild(child);
            }
        }
        return Lists.newArrayList((Iterable)resultMap.keySet());
    }

    private CmsDeleteResourceBean getBrokenLinks(CmsResource entryResource) throws CmsException {
        CmsDeleteResourceBean result = null;
        CmsListInfoBean info = null;
        List<CmsBrokenLinkBean> brokenLinks = null;
        CmsObject cms = this.getCmsObject();
        String resourceSitePath = cms.getSitePath(entryResource);
        this.ensureSession();
        ArrayList<CmsResource> descendants = new ArrayList<CmsResource>();
        HashSet<CmsUUID> deleteIds = new HashSet<CmsUUID>();
        descendants.add(entryResource);
        if (entryResource.isFolder()) {
            descendants.addAll(cms.readResources(resourceSitePath, CmsResourceFilter.IGNORE_EXPIRATION));
        }
        for (CmsResource deleteRes : descendants) {
            deleteIds.add(deleteRes.getStructureId());
        }
        HashMultimap linkMap = HashMultimap.create();
        for (CmsResource resource : descendants) {
            List<CmsResource> linkSources = this.getLinkSources(cms, resource, deleteIds);
            for (CmsResource source : linkSources) {
                linkMap.put((Object)source, (Object)resource);
            }
        }
        brokenLinks = this.getBrokenLinkBeans((Multimap<CmsResource, CmsResource>)linkMap);
        info = this.getPageInfo(entryResource);
        result = new CmsDeleteResourceBean(resourceSitePath, info, brokenLinks);
        return result;
    }

    private List<CmsResource> getLinkSources(CmsObject cms, CmsResource resource, HashSet<CmsUUID> deleteIds) throws CmsException {
        List<CmsRelation> relations = cms.getRelationsForResource(resource, CmsRelationFilter.SOURCES);
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        for (CmsRelation relation : relations) {
            CmsResource source;
            if (deleteIds.contains(relation.getSourceId()) || (source = relation.getSource(cms, CmsResourceFilter.ALL)).getState().isDeleted()) continue;
            result.add(source);
        }
        return result;
    }

    private CmsListInfoBean getPageInfo(CmsResource res) throws CmsException, CmsLoaderException {
        CmsObject cms = this.getCmsObject();
        return CmsVfsService.getPageInfo(cms, res);
    }

    private CmsPreviewInfo getPreviewInfo(CmsObject cms, CmsResource resource, Locale locale) {
        CmsPreviewInfo result;
        String title = "";
        try {
            CmsProperty titleProperty = cms.readPropertyObject(resource, "Title", false);
            title = titleProperty.getValue("");
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        String noPreviewReason = CmsVfsService.getNoPreviewReason(cms, resource);
        String previewContent = null;
        int height = 0;
        int width = 0;
        LinkedHashMap<String, String> locales = this.getAvailableLocales(resource);
        if (noPreviewReason != null) {
            previewContent = "<div>" + noPreviewReason + "</div>";
            return new CmsPreviewInfo("<div>" + noPreviewReason + "</div>", null, false, title, cms.getSitePath(resource), locale.toString());
        }
        if (CmsResourceTypeImage.getStaticTypeId() == resource.getTypeId()) {
            CmsImageScaler scaler = new CmsImageScaler(cms, resource);
            previewContent = "<img src=\"" + OpenCms.getLinkManager().substituteLinkForUnknownTarget(cms, resource.getRootPath()) + "\" title=\"" + title + "\" style=\"display:block\" />";
            height = scaler.getHeight();
            width = scaler.getWidth();
        } else if (CmsResourceTypeXmlContent.isXmlContent(resource)) {
            if (!locales.containsKey(locale.toString())) {
                locale = CmsLocaleManager.getMainLocale(cms, resource);
            }
            previewContent = CmsPreviewService.getPreviewContent(this.getRequest(), this.getResponse(), cms, resource, locale);
        } else if (CmsResourceTypePlain.getStaticTypeId() == resource.getTypeId()) {
            try {
                previewContent = "<pre><code>" + new String(cms.readFile(resource).getContents()) + "</code></pre>";
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                previewContent = "<div>" + Messages.get().getBundle().key("GUI_NO_PREVIEW_CAN_T_READ_CONTENT_0") + "</div>";
            }
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(previewContent)) {
            result = new CmsPreviewInfo(previewContent, null, false, title, cms.getSitePath(resource), locale.toString());
            result.setHeight(height);
            result.setWidth(width);
            result.setLocales(locales);
            return result;
        }
        if (CmsResourceTypeXmlContainerPage.isContainerPage(resource) || CmsResourceTypeXmlPage.isXmlPage(resource)) {
            result = new CmsPreviewInfo(null, OpenCms.getLinkManager().substituteLinkForUnknownTarget(cms, resource.getRootPath()) + "?" + "__disableDirectEdit" + "=true" + "&__locale=" + locale.toString(), false, title, cms.getSitePath(resource), locale.toString());
            result.setLocales(locales);
            return result;
        }
        return new CmsPreviewInfo(null, OpenCms.getLinkManager().substituteLinkForUnknownTarget(cms, resource.getRootPath()) + "?" + "__disableDirectEdit" + "=true", true, title, cms.getSitePath(resource), locale.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<CmsPrincipalBean, String> getResponsibles(String vfsPath) throws CmsRpcException {
        HashMap<CmsPrincipalBean, String> result = new HashMap<CmsPrincipalBean, String>();
        List<Object> parentResources = new ArrayList();
        CmsObject cms = this.getCmsObject();
        String resourceSitePath = cms.getRequestContext().removeSiteRoot(vfsPath);
        try {
            parentResources = cms.readPath(resourceSitePath, CmsResourceFilter.IGNORE_EXPIRATION);
        }
        catch (CmsException e) {
            this.error(e);
        }
        for (CmsResource cmsResource : parentResources) {
            String storedSiteRoot = cms.getRequestContext().getSiteRoot();
            String sitePath = cms.getRequestContext().removeSiteRoot(cmsResource.getRootPath());
            try {
                cms.getRequestContext().setSiteRoot("/");
                List<CmsAccessControlEntry> entries = cms.getAccessControlEntries(cmsResource.getRootPath(), false);
                for (CmsAccessControlEntry ace : entries) {
                    I_CmsPrincipal principal;
                    if (!ace.isResponsible() || (principal = cms.lookupPrincipal(ace.getPrincipal())) == null) continue;
                    CmsPrincipalBean prinBean = new CmsPrincipalBean(principal.getName(), principal.getDescription(), principal.isGroup());
                    if (!cmsResource.getRootPath().equals(vfsPath)) {
                        if (cmsResource.getRootPath().startsWith(storedSiteRoot)) {
                            result.put(prinBean, sitePath);
                            continue;
                        }
                        result.put(prinBean, cmsResource.getRootPath());
                        continue;
                    }
                    result.put(prinBean, null);
                }
            }
            catch (CmsException e) {
                this.error(e);
            }
            finally {
                cms.getRequestContext().setSiteRoot(storedSiteRoot);
            }
        }
        return result;
    }

    private boolean shouldChangeTitle(Map<String, CmsProperty> properties) {
        return properties == null || properties.get("Title") == null || properties.get("Title").getValue() == null || properties.get("NavText") != null && properties.get("Title").getValue().equals(properties.get("NavText").getValue());
    }

    static {
        CollectionUtils.addAll(m_previewMimeTypes, (Object[])new String[]{"application/msword", "application/pdf", "application/excel", "application/mspowerpoint", "application/zip"});
    }
}

