/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.flex.CmsFlexController;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.CmsJspScopedVarBodyTagSuport;
import org.opencms.jsp.Messages;
import org.opencms.jsp.util.CmsJspContentAccessBean;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;

public class CmsJspTagFormatter
extends CmsJspScopedVarBodyTagSuport {
    private static final Log LOG = CmsLog.getLog(CmsJspTagFormatter.class);
    private static final long serialVersionUID = -8232834808735187624L;
    protected transient CmsObject m_cms;
    protected CmsFlexController m_controller;
    protected transient CmsResource m_resource;
    private CmsContainerElementBean m_element;
    private Locale m_locale;
    private String m_rdfa;
    private String m_value;

    public CmsJspTagFormatter() {
    }

    public CmsJspTagFormatter(PageContext context, Locale locale) throws JspException {
        this.m_locale = locale;
        this.setPageContext(context);
        this.init();
    }

    public int doEndTag() throws JspException {
        this.release();
        return super.doEndTag();
    }

    public int doStartTag() throws JspException, CmsIllegalArgumentException {
        this.init();
        return 1;
    }

    public String getLocale() {
        return this.m_locale != null ? this.m_locale.toString() : "";
    }

    public String getRdfa() {
        return this.m_rdfa;
    }

    public String getVal() {
        return this.m_value;
    }

    @Override
    public void release() {
        this.m_locale = null;
        this.m_cms = null;
        this.m_resource = null;
        this.m_controller = null;
        super.release();
    }

    public void setLocale(String locale) {
        this.m_locale = CmsStringUtil.isEmpty(locale) ? null : CmsLocaleManager.getLocale(locale);
    }

    public void setRdfa(String rdfa) {
        this.m_rdfa = CmsStringUtil.isNotEmptyOrWhitespaceOnly(rdfa) ? rdfa.trim() : rdfa;
    }

    public void setVal(String val) {
        this.m_value = CmsStringUtil.isNotEmptyOrWhitespaceOnly(val) ? val.trim() : val;
    }

    protected void init() throws JspException {
        this.m_controller = CmsFlexController.getController(this.pageContext.getRequest());
        this.m_cms = this.m_controller.getCmsObject();
        try {
            CmsJspContentAccessBean bean;
            this.m_element = OpenCms.getADEManager().getCurrentElement(this.pageContext.getRequest());
            this.m_element.initResource(this.m_cms);
            if (this.m_cms.getRequestContext().getCurrentProject().isOnlineProject() && !this.m_element.isReleasedAndNotExpired()) {
                throw new CmsException(Messages.get().container("ERR_RESOURCE_IS_NOT_RELEASE_OR_EXPIRED_1", this.m_element.getResource().getRootPath()));
            }
            if (this.m_locale == null) {
                this.m_locale = this.m_cms.getRequestContext().getLocale();
            }
            if ((this.m_element.isInMemoryOnly() || this.m_element.isTemporaryContent()) && this.m_element.getResource() instanceof CmsFile) {
                CmsXmlContent xmlContent = CmsXmlContentFactory.unmarshal(this.m_cms, (CmsFile)this.m_element.getResource());
                bean = new CmsJspContentAccessBean(this.m_cms, this.m_locale, xmlContent);
            } else {
                bean = new CmsJspContentAccessBean(this.m_cms, this.m_locale, this.m_element.getResource());
            }
            this.storeAttribute(this.getVar(), bean);
            if (this.m_value != null) {
                this.storeAttribute(this.getVal(), bean.getValue());
            }
            if (this.m_rdfa != null) {
                this.storeAttribute(this.getRdfa(), bean.getRdfa());
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            this.m_controller.setThrowable(e, this.m_cms.getRequestContext().getUri());
            throw new JspException((Throwable)e);
        }
    }
}

