/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.io.Writer;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.flex.CmsFlexController;
import org.opencms.jsp.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.util.CmsStringUtil;

public class CmsJspTagLink
extends BodyTagSupport {
    private static final Log LOG = CmsLog.getLog(CmsJspTagLink.class);
    private static final long serialVersionUID = -2361021288258405388L;
    private String m_baseUri;

    public static String linkTagAction(String target, ServletRequest req) {
        return CmsJspTagLink.linkTagAction(target, req, null);
    }

    public static String linkTagAction(String target, ServletRequest req, String baseUri) {
        CmsFlexController controller = CmsFlexController.getController(req);
        String uri = CmsLinkManager.getAbsoluteUri(target, controller.getCurrentRequest().getElementUri());
        CmsObject cms = controller.getCmsObject();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(baseUri)) {
            try {
                cms = OpenCms.initCmsObject(cms);
                cms.getRequestContext().setUri(baseUri);
            }
            catch (CmsException e) {
                // empty catch block
            }
        }
        return OpenCms.getLinkManager().substituteLinkForUnknownTarget(cms, uri);
    }

    public int doEndTag() throws JspException {
        ServletRequest req = this.pageContext.getRequest();
        if (CmsFlexController.isCmsRequest(req)) {
            try {
                String link = this.getBodyContent().getString();
                this.getBodyContent().clear();
                String newlink = CmsJspTagLink.linkTagAction(link, req, this.getBaseUri());
                this.getBodyContent().print(newlink);
                this.getBodyContent().writeOut((Writer)this.pageContext.getOut());
            }
            catch (Exception ex) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_PROCESS_TAG_1", "link"), (Throwable)ex);
                }
                throw new JspException((Throwable)ex);
            }
        }
        return 6;
    }

    public String getBaseUri() {
        return this.m_baseUri;
    }

    public void release() {
        super.release();
    }

    public void setBaseUri(String baseUri) {
        this.m_baseUri = baseUri;
    }
}

