/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.ade.detailpage.CmsDetailPageResourceHandler;
import org.opencms.ade.detailpage.Messages;
import org.opencms.db.CmsAlias;
import org.opencms.db.CmsRewriteAliasMatcher;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.gwt.shared.alias.CmsAliasMode;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsResourceInitException;
import org.opencms.main.I_CmsResourceInit;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionViolationException;
import org.opencms.security.CmsSecurityException;
import org.opencms.util.CmsFileUtil;

public class CmsAliasResourceHandler
implements I_CmsResourceInit {
    public static final String ATTR_DETAIL_CONTENT_RESOURCE = "__opencms_detail_content_resource";
    private static final Log LOG = CmsLog.getLog(CmsDetailPageResourceHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CmsResource initResource(CmsResource resource, CmsObject cms, HttpServletRequest req, HttpServletResponse res) throws CmsResourceInitException, CmsSecurityException {
        block15: {
            boolean abort;
            boolean bl = abort = resource != null || cms.getRequestContext().getUri().startsWith("/system/");
            if (abort) {
                return resource;
            }
            String path = cms.getRequestContext().getUri();
            path = CmsFileUtil.removeTrailingSeparator(path);
            String siteRoot = cms.getRequestContext().getSiteRoot();
            if ("".equals(siteRoot) && (siteRoot = OpenCms.getSiteManager().getSiteRoot(path)) == null) {
                siteRoot = "";
            }
            try {
                String sitePath = path;
                String oldSiteRoot = cms.getRequestContext().getSiteRoot();
                try {
                    cms.getRequestContext().setSiteRoot(siteRoot);
                    sitePath = cms.getRequestContext().removeSiteRoot(path);
                }
                finally {
                    cms.getRequestContext().setSiteRoot(oldSiteRoot);
                }
                CmsRewriteAliasMatcher rewriteAliases = OpenCms.getAliasManager().getRewriteAliasMatcher(cms, siteRoot);
                CmsRewriteAliasMatcher.RewriteResult rewriteResult = rewriteAliases.match(sitePath);
                if (rewriteResult != null && res != null) {
                    String link = OpenCms.getLinkManager().substituteLink(cms, rewriteResult.getNewPath());
                    if (rewriteResult.getAlias().getMode().isRedirect()) {
                        this.redirectToTarget(req, res, link, rewriteResult.getAlias().getMode() == CmsAliasMode.permanentRedirect);
                    } else {
                        cms.getRequestContext().setUri(rewriteResult.getNewPath());
                    }
                    return null;
                }
                List<CmsAlias> aliases = OpenCms.getAliasManager().getAliasesForPath(cms, siteRoot, sitePath);
                assert (aliases.size() < 2);
                if (aliases.size() != 1) break block15;
                CmsAlias alias = aliases.get(0);
                CmsResource aliasTarget = cms.readResource(alias.getStructureId());
                if (alias.isRedirect()) {
                    String link = OpenCms.getLinkManager().substituteLink(cms, aliasTarget);
                    boolean isPermanent = alias.isPermanentRedirect();
                    this.redirectToTarget(req, res, link, isPermanent);
                    break block15;
                }
                cms.getRequestContext().setUri(cms.getSitePath(aliasTarget));
                return aliasTarget;
            }
            catch (CmsPermissionViolationException e) {
                throw e;
            }
            catch (CmsResourceInitException e) {
                throw e;
            }
            catch (Throwable e) {
                String uri = cms.getRequestContext().getUri();
                CmsMessageContainer msg = Messages.get().container("ERR_RESCOURCE_NOT_FOUND_1", uri);
                LOG.error((Object)e.getLocalizedMessage(), e);
                throw new CmsResourceInitException(msg, e);
            }
        }
        return null;
    }

    private void redirectToTarget(HttpServletRequest req, HttpServletResponse res, String link, boolean isPermanent) throws IOException, CmsResourceInitException {
        CmsResourceInitException resInitException = new CmsResourceInitException(this.getClass());
        if (res != null) {
            String query = req.getQueryString();
            if (query != null) {
                link = link + "?" + query;
            }
            resInitException.setClearErrors(true);
            if (isPermanent) {
                res.setStatus(301);
                res.setHeader("Location", link);
            } else {
                res.sendRedirect(link);
            }
        }
        throw resInitException;
    }
}

