/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.pdftools;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsPdfThumbnailLink {
    public static final String MARKER = "pdfthumbnail";
    public static final String PARAM_OPTIONS = "options";
    public static final String REGEX = "pdfthumbnail/([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})\\.(jpg|png|gif)$";
    public static final Pattern REGEX_COMPILED = Pattern.compile("pdfthumbnail/([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})\\.(jpg|png|gif)$");
    private static final Log LOG = CmsLog.getLog(CmsPdfThumbnailLink.class);
    private String m_format;
    private int m_height = -1;
    private String m_link;
    private String m_options;
    private int m_page = 0;
    private CmsResource m_pdfResource;
    private int m_width = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsPdfThumbnailLink(CmsObject cms, CmsResource pdfResource, int width, int height, String format) {
        this.m_pdfResource = pdfResource;
        this.m_width = width;
        this.m_height = height;
        this.m_format = format.toLowerCase();
        this.m_options = "w:" + this.m_width + ",h:" + this.m_height;
        cms.getRequestContext().setAttribute("IS_IMAGE_LINK", "true");
        try {
            this.m_link = OpenCms.getLinkManager().substituteLink(cms, "/pdfthumbnail/" + pdfResource.getStructureId() + "." + format);
        }
        finally {
            cms.getRequestContext().removeAttribute("IS_IMAGE_LINK");
        }
    }

    public CmsPdfThumbnailLink(CmsObject cms, String link, String options) throws ParseException, CmsException {
        this.m_link = link;
        Map<String, String> optionMap = CmsStringUtil.splitAsMap(options, ",", ":");
        Matcher matcher = REGEX_COMPILED.matcher(link);
        if (!matcher.find()) {
            throw new ParseException("Link " + link + " does not match pattern");
        }
        String uuidStr = matcher.group(1);
        this.m_format = matcher.group(2);
        this.m_options = options;
        CmsUUID uuid = new CmsUUID(uuidStr);
        this.m_pdfResource = cms.readResource(uuid);
        try {
            String widthStr = optionMap.get("w");
            this.m_width = Integer.parseInt(widthStr);
        }
        catch (Exception e) {
            LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        try {
            String heightStr = optionMap.get("h");
            this.m_height = Integer.parseInt(heightStr);
        }
        catch (Exception e) {
            LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        try {
            String pageStr = optionMap.get("page");
            this.m_page = Integer.parseInt(pageStr);
        }
        catch (Exception e) {
            LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public String getFormat() {
        return this.m_format;
    }

    public int getHeight() {
        return this.m_height;
    }

    public String getLinkWithOptions() {
        return this.m_link + "?" + PARAM_OPTIONS + "=" + this.m_options;
    }

    public int getPage() {
        return this.m_page;
    }

    public int getWidth() {
        return this.m_width;
    }

    CmsResource getPdfResource() {
        return this.m_pdfResource;
    }

    public static class ParseException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ParseException(String message) {
            super(message);
        }
    }
}

