/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.scheduler;

import java.util.Collections;
import java.util.Date;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.configuration.I_CmsConfigurationParameterHandler;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.CmsContextInfo;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.scheduler.I_CmsScheduledJob;
import org.opencms.scheduler.Messages;
import org.opencms.util.CmsStringUtil;
import org.quartz.CronTrigger;
import org.quartz.Trigger;

public class CmsScheduledJobInfo
implements I_CmsConfigurationParameterHandler {
    private static final Log LOG = CmsLog.getLog(CmsScheduledJobInfo.class);
    private boolean m_active;
    private String m_className;
    private CmsContextInfo m_context;
    private String m_cronExpression;
    private boolean m_frozen;
    private String m_id;
    private I_CmsScheduledJob m_jobInstance;
    private String m_jobName;
    private SortedMap<String, String> m_parameters;
    private boolean m_reuseInstance;
    private Trigger m_trigger;

    public CmsScheduledJobInfo() {
        this.m_reuseInstance = false;
        this.m_frozen = false;
        this.m_parameters = new TreeMap<String, String>();
        this.m_active = true;
    }

    public CmsScheduledJobInfo(String id, String jobName, String className, CmsContextInfo context, String cronExpression, boolean reuseInstance, boolean active, SortedMap<String, String> parameters) {
        this.m_frozen = false;
        this.setId(id);
        if (CmsStringUtil.isNotEmpty(jobName)) {
            this.setJobName(jobName);
        }
        this.setClassName(className);
        this.setContextInfo(context);
        this.setCronExpression(cronExpression);
        this.setReuseInstance(reuseInstance);
        this.setActive(active);
        this.setParameters(parameters);
    }

    @Override
    public void addConfigurationParameter(String paramName, String paramValue) {
        this.checkFrozen();
        this.m_parameters.put(paramName, paramValue);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)org.opencms.configuration.Messages.get().getBundle().key("LOG_ADD_CONFIG_PARAM_3", paramName, paramValue, this));
        }
    }

    public void clearId() {
        this.setId(null);
    }

    public Object clone() {
        CmsScheduledJobInfo result = new CmsScheduledJobInfo();
        result.m_id = this.m_id;
        result.m_active = false;
        result.m_frozen = false;
        result.m_className = this.m_className;
        if (this.isReuseInstance()) {
            result.m_jobInstance = this.m_jobInstance;
        }
        result.m_reuseInstance = this.m_reuseInstance;
        result.m_context = (CmsContextInfo)this.m_context.clone();
        result.m_cronExpression = this.m_cronExpression;
        result.m_jobName = this.m_jobName;
        result.m_parameters = new TreeMap<String, String>(this.m_parameters);
        result.m_trigger = null;
        return result;
    }

    public String getClassName() {
        return this.m_className;
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)org.opencms.configuration.Messages.get().getBundle().key("LOG_GET_CONFIGURATION_1", this));
        }
        return new CmsParameterConfiguration(this.getParameters());
    }

    public CmsContextInfo getContextInfo() {
        return this.m_context;
    }

    public String getCronExpression() {
        return this.m_cronExpression;
    }

    public Date getExecutionTimeAfter(Date date) {
        if (!this.m_active || this.m_trigger == null) {
            return null;
        }
        return this.m_trigger.getFireTimeAfter(date);
    }

    public Date getExecutionTimeNext() {
        if (!this.m_active || this.m_trigger == null) {
            return null;
        }
        return this.m_trigger.getNextFireTime();
    }

    public Date getExecutionTimePrevious() {
        if (!this.m_active || this.m_trigger == null) {
            return null;
        }
        return this.m_trigger.getPreviousFireTime();
    }

    public String getId() {
        return this.m_id;
    }

    public synchronized I_CmsScheduledJob getJobInstance() {
        if (this.m_jobInstance != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_REUSING_INSTANCE_1", this.m_jobInstance.getClass().getName()));
            }
            return this.m_jobInstance;
        }
        I_CmsScheduledJob job = null;
        try {
            job = (I_CmsScheduledJob)Class.forName(this.getClassName()).newInstance();
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_CLASS_NOT_FOUND_1", this.getClassName()), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_ILLEGAL_ACCESS_0"), (Throwable)e);
        }
        catch (InstantiationException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_INSTANCE_GENERATION_0"), (Throwable)e);
        }
        catch (ClassCastException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_BAD_INTERFACE_0"), (Throwable)e);
        }
        if (this.m_reuseInstance) {
            this.m_jobInstance = job;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_JOB_CREATED_1", this.getClassName()));
        }
        if (job == null) {
            this.setActive(false);
        }
        return job;
    }

    public String getJobName() {
        return this.m_jobName;
    }

    public SortedMap<String, String> getParameters() {
        return this.m_parameters;
    }

    @Override
    public void initConfiguration() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)org.opencms.configuration.Messages.get().getBundle().key("LOG_INIT_CONFIGURATION_1", this));
        }
        this.setFrozen(true);
    }

    public boolean isActive() {
        return this.m_active;
    }

    public boolean isReuseInstance() {
        return this.m_reuseInstance;
    }

    public void setActive(boolean active) {
        this.checkFrozen();
        this.m_active = active;
    }

    public void setClassName(String className) {
        this.checkFrozen();
        if (className != null) {
            className = className.trim();
        }
        if (!CmsStringUtil.isValidJavaClassName(className)) {
            CmsMessageContainer message = Messages.get().container("ERR_BAD_JOB_CLASS_NAME_1", className);
            if (OpenCms.getRunLevel() > 2) {
                throw new CmsIllegalArgumentException(message);
            }
            LOG.warn((Object)message.key());
        } else {
            try {
                Class<?> jobClass = Class.forName(className);
                if (!I_CmsScheduledJob.class.isAssignableFrom(jobClass)) {
                    CmsMessageContainer message = Messages.get().container("ERR_JOB_CLASS_BAD_INTERFACE_2", className, I_CmsScheduledJob.class.getName());
                    if (OpenCms.getRunLevel() > 2) {
                        throw new CmsIllegalArgumentException(message);
                    }
                    LOG.warn((Object)message.key());
                }
            }
            catch (ClassNotFoundException e) {
                CmsMessageContainer message = Messages.get().container("ERR_JOB_CLASS_NOT_FOUND_1", className);
                if (OpenCms.getRunLevel() > 2) {
                    throw new CmsIllegalArgumentException(message);
                }
                LOG.warn((Object)message.key());
            }
        }
        this.m_className = className;
        if (this.getJobName() == null) {
            this.setJobName(className);
        }
    }

    public void setContextInfo(CmsContextInfo contextInfo) {
        this.checkFrozen();
        if (contextInfo == null) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_BAD_CONTEXT_INFO_0"));
        }
        this.m_context = contextInfo;
    }

    public void setCronExpression(String cronExpression) {
        this.checkFrozen();
        try {
            new CronTrigger().setCronExpression(cronExpression);
        }
        catch (Exception e) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_BAD_CRON_EXPRESSION_2", this.getJobName(), cronExpression));
        }
        this.m_cronExpression = cronExpression;
    }

    public void setJobName(String jobName) {
        this.checkFrozen();
        if (CmsStringUtil.isEmpty(jobName) || !jobName.trim().equals(jobName)) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_BAD_JOB_NAME_1", jobName));
        }
        this.m_jobName = jobName;
    }

    public void setParameters(SortedMap<String, String> parameters) {
        this.checkFrozen();
        if (parameters == null) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_BAD_JOB_PARAMS_0"));
        }
        this.m_parameters = new TreeMap<String, String>(parameters);
    }

    public void setReuseInstance(boolean reuseInstance) {
        this.checkFrozen();
        this.m_reuseInstance = reuseInstance;
    }

    protected void checkFrozen() throws CmsRuntimeException {
        if (this.m_frozen) {
            throw new CmsRuntimeException(Messages.get().container("ERR_JOB_INFO_FROZEN_1", this.getJobName()));
        }
    }

    protected Trigger getTrigger() {
        return this.m_trigger;
    }

    protected synchronized void setFrozen(boolean frozen) {
        if (frozen && !this.m_frozen) {
            this.m_parameters = Collections.unmodifiableSortedMap(this.m_parameters);
            this.m_context.freeze();
            this.m_frozen = true;
        } else if (!frozen && this.m_frozen) {
            this.m_parameters = new TreeMap<String, String>(this.m_parameters);
            this.m_frozen = false;
        }
    }

    protected void setId(String id) {
        this.checkFrozen();
        this.m_id = id;
    }

    protected void setTrigger(Trigger trigger) {
        this.checkFrozen();
        this.m_trigger = trigger;
    }

    protected void updateContextRequestTime() {
        CmsContextInfo context = (CmsContextInfo)this.m_context.clone();
        context.setRequestTime(System.currentTimeMillis());
        context.freeze();
        this.m_context = context;
    }
}

