/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.fields;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.opencms.search.fields.I_CmsSearchFieldMapping;
import org.opencms.util.CmsStringUtil;

public class CmsSearchField
implements Serializable {
    public static final float BOOST_DEFAULT = 1.0f;
    public static final String FIELD_CATEGORY = "category";
    public static final String FIELD_CONTENT = "content";
    public static final String FIELD_CONTENT_BLOB = "contentblob";
    public static final String FIELD_CONTENT_LOCALES = "con_locales";
    public static final String FIELD_DATE_CONTENT = "contentdate";
    public static final String FIELD_DATE_CREATED = "created";
    public static final String FIELD_DATE_CREATED_LOOKUP = "created_lookup";
    public static final String FIELD_DATE_EXPIRED = "expired";
    public static final String FIELD_DATE_LASTMODIFIED = "lastmodified";
    public static final String FIELD_DATE_LASTMODIFIED_LOOKUP = "lastmodified_lookup";
    public static final String FIELD_DATE_LOOKUP_SUFFIX = "_lookup";
    public static final String FIELD_DATE_RELEASED = "released";
    public static final String FIELD_DEPENDENCY_TYPE = "dependencyType";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_DYNAMIC_EXACT = "_exact";
    public static final String FIELD_DYNAMIC_PROPERTIES = "_prop";
    public static final String FIELD_EXCERPT = "_excerpt";
    public static final String FIELD_FILENAME = "filename";
    public static final String FIELD_ID = "id";
    public static final String FIELD_KEYWORDS = "keywords";
    public static final String FIELD_LINK = "link";
    public static final String FIELD_META = "meta";
    public static final String FIELD_MIMETYPE = "mimetype";
    public static final String FIELD_PARENT_FOLDERS = "parent-folders";
    public static final String FIELD_PATH = "path";
    public static final String FIELD_PREFIX_DEPENDENCY = "dep_";
    public static final String FIELD_PREFIX_DYNAMIC = "*_";
    public static final String FIELD_PREFIX_TEXT = "text_";
    public static final String FIELD_PRIORITY = "priority";
    public static final String FIELD_RESOURCE_LOCALES = "res_locales";
    public static final String FIELD_SCORE = "score";
    public static final String FIELD_SEARCH_EXCLUDE = "search_exclude";
    public static final String FIELD_SIZE = "size";
    public static final String FIELD_SORT_TITLE = "sort-title";
    public static final String FIELD_STATE = "state";
    public static final String FIELD_SUFFIX = "suffix";
    public static final String FIELD_TEXT = "text";
    public static final String FIELD_TITLE = "title-key";
    public static final String FIELD_TITLE_UNSTORED = "title";
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_USER_CREATED = "userCreated";
    public static final String FIELD_USER_LAST_MODIFIED = "userLastModified";
    public static final String FIELD_VERSION = "version";
    private static final long serialVersionUID = 3185631015824549119L;
    private float m_boost = 1.0f;
    private String m_defaultValue;
    private boolean m_excerpt;
    private boolean m_indexed;
    private List<I_CmsSearchFieldMapping> m_mappings = new ArrayList<I_CmsSearchFieldMapping>();
    private String m_name;
    private boolean m_stored;

    public CmsSearchField() {
    }

    public CmsSearchField(String name, String defaultValue, float boost) {
        this();
        this.m_name = name;
        this.m_boost = boost;
        this.m_defaultValue = defaultValue;
    }

    public void addMapping(I_CmsSearchFieldMapping mapping) {
        this.m_mappings.add(mapping);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CmsSearchField) {
            return CmsStringUtil.isEqual(this.m_name, ((CmsSearchField)obj).getName());
        }
        return false;
    }

    public float getBoost() {
        return this.m_boost;
    }

    public String getDefaultValue() {
        return this.m_defaultValue;
    }

    public String getIndexed() {
        return null;
    }

    public List<I_CmsSearchFieldMapping> getMappings() {
        return this.m_mappings;
    }

    public String getName() {
        return this.m_name;
    }

    public int hashCode() {
        return this.m_name == null ? 41 : this.m_name.hashCode();
    }

    public boolean isIndexed() {
        return this.m_indexed;
    }

    public boolean isInExcerpt() {
        return this.m_excerpt;
    }

    public boolean isStored() {
        return this.m_stored;
    }

    public void setBoost(float boost) {
        if (boost < 0.0f) {
            boost = 0.0f;
        }
        this.m_boost = boost;
    }

    public void setBoost(String boostAsString) {
        try {
            this.setBoost(Float.valueOf(boostAsString).floatValue());
        }
        catch (NumberFormatException e) {
            this.setBoost(1.0f);
        }
    }

    public void setDefaultValue(String defaultValue) {
        this.m_defaultValue = CmsStringUtil.isNotEmptyOrWhitespaceOnly(defaultValue) ? defaultValue.trim() : null;
    }

    public void setIndexed(boolean indexed) {
        this.m_indexed = indexed;
    }

    public void setInExcerpt(boolean excerpt) {
        this.m_excerpt = excerpt;
    }

    public void setName(String fieldName) {
        this.m_name = fieldName;
    }

    public void setStored(boolean stored) {
        this.m_stored = stored;
    }

    public String toString() {
        return this.getName();
    }
}

