/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.staticexport;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsExternalLinksValidationResult;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.site.CmsSite;
import org.opencms.staticexport.CmsDefaultLinkSubstitutionHandler;
import org.opencms.staticexport.I_CmsLinkSubstitutionHandler;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsLinkManager {
    private static final Log LOG = CmsLog.getLog(CmsLinkManager.class);
    private static URL m_baseUrl = null;
    private I_CmsLinkSubstitutionHandler m_linkSubstitutionHandler;
    private CmsExternalLinksValidationResult m_pointerLinkValidationResult;

    public CmsLinkManager(I_CmsLinkSubstitutionHandler linkSubstitutionHandler) {
        this.m_linkSubstitutionHandler = linkSubstitutionHandler;
        if (this.m_linkSubstitutionHandler == null) {
            this.m_linkSubstitutionHandler = new CmsDefaultLinkSubstitutionHandler();
        }
    }

    public static String getAbsoluteUri(String relativeUri, String baseUri) {
        if (CmsLinkManager.isAbsoluteUri(relativeUri)) {
            return relativeUri;
        }
        try {
            URL url = new URL(new URL(m_baseUrl, baseUri), relativeUri);
            StringBuffer result = new StringBuffer(100);
            result.append(url.getPath());
            if (url.getQuery() != null) {
                result.append('?');
                result.append(url.getQuery());
            }
            if (url.getRef() != null) {
                result.append('#');
                result.append(url.getRef());
            }
            return result.toString();
        }
        catch (MalformedURLException e) {
            return relativeUri;
        }
    }

    public static String getRelativeUri(String fromUri, String toUri) {
        int i;
        StringBuffer result = new StringBuffer();
        int pos = 0;
        while (true) {
            i = fromUri.indexOf(47, pos);
            int j = toUri.indexOf(47, pos);
            if (i == -1 || i != j || !fromUri.regionMatches(pos, toUri, pos, i - pos)) break;
            pos = i + 1;
        }
        i = fromUri.indexOf(47, pos);
        while (i > 0) {
            result.append("../");
            i = fromUri.indexOf(47, i + 1);
        }
        result.append(toUri.substring(pos));
        if (result.length() == 0) {
            result.append("./");
        }
        return result.toString();
    }

    @Deprecated
    public static String getSitePath(CmsObject cms, String basePath, String targetUri) {
        return OpenCms.getLinkManager().getRootPath(cms, targetUri, basePath);
    }

    public static boolean hasScheme(String uri) {
        int pos = uri.indexOf(58);
        return pos > -1 && pos < 10;
    }

    public static boolean isAbsoluteUri(String uri) {
        return uri == null || uri.length() >= 1 && (uri.charAt(0) == '/' || CmsLinkManager.hasScheme(uri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOnlineLink(CmsObject cms, String resourceName) {
        String result;
        block5: {
            result = "";
            try {
                CmsProject currentProject = cms.getRequestContext().getCurrentProject();
                try {
                    cms.getRequestContext().setCurrentProject(cms.readProject(CmsProject.ONLINE_PROJECT_ID));
                    result = this.substituteLinkForUnknownTarget(cms, resourceName);
                    result = this.appendServerPrefix(cms, result, resourceName);
                }
                finally {
                    cms.getRequestContext().setCurrentProject(currentProject);
                }
            }
            catch (CmsException e) {
                result = e.getLocalizedMessage();
                if (!LOG.isErrorEnabled()) break block5;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public String getPermalink(CmsObject cms, String resourceName) {
        return this.getPermalink(cms, resourceName, null);
    }

    public String getPermalink(CmsObject cms, String resourceName, CmsUUID detailContentId) {
        String permalink;
        block5: {
            permalink = "";
            try {
                String serverPrefix;
                String ext;
                permalink = this.substituteLink(cms, "/permalink/");
                String id = cms.readResource(resourceName, CmsResourceFilter.ALL).getStructureId().toString();
                permalink = permalink + id;
                if (detailContentId != null) {
                    permalink = permalink + ":" + detailContentId;
                }
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(ext = CmsFileUtil.getExtension(resourceName))) {
                    permalink = permalink + ext;
                }
                if (!permalink.startsWith(serverPrefix = OpenCms.getSiteManager().getCurrentSite(cms).getServerPrefix(cms, resourceName))) {
                    permalink = serverPrefix + permalink;
                }
            }
            catch (CmsException e) {
                permalink = e.getLocalizedMessage();
                if (!LOG.isErrorEnabled()) break block5;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return permalink;
    }

    public String getPermalinkForCurrentPage(CmsObject cms) {
        return this.getPermalink(cms, cms.getRequestContext().getUri(), cms.getRequestContext().getDetailContentId());
    }

    public CmsExternalLinksValidationResult getPointerLinkValidationResult() {
        return this.m_pointerLinkValidationResult;
    }

    public String getRootPath(CmsObject cms, String targetUri) {
        return this.getRootPath(cms, targetUri, null);
    }

    public String getRootPath(CmsObject cms, String targetUri, String basePath) {
        return this.m_linkSubstitutionHandler.getRootPath(cms, targetUri, basePath);
    }

    public String getServerLink(CmsObject cms, String resourceName) {
        String result = this.substituteLinkForUnknownTarget(cms, resourceName);
        return this.appendServerPrefix(cms, result, resourceName);
    }

    public void setLinkSubstitutionHandler(CmsObject cms, I_CmsLinkSubstitutionHandler linkSubstitutionHandler) throws CmsRoleViolationException {
        OpenCms.getRoleManager().checkRole(cms, CmsRole.ROOT_ADMIN);
        this.m_linkSubstitutionHandler = linkSubstitutionHandler;
    }

    public void setPointerLinkValidationResult(CmsExternalLinksValidationResult externLinkValidationResult) {
        this.m_pointerLinkValidationResult = externLinkValidationResult;
    }

    public String substituteLink(CmsObject cms, CmsResource resource) {
        return this.substituteLinkForRootPath(cms, resource.getRootPath());
    }

    public String substituteLink(CmsObject cms, String link) {
        return this.substituteLink(cms, link, null, false);
    }

    public String substituteLink(CmsObject cms, String link, String siteRoot) {
        return this.substituteLink(cms, link, siteRoot, false);
    }

    public String substituteLink(CmsObject cms, String link, String siteRoot, boolean forceSecure) {
        return this.m_linkSubstitutionHandler.getLink(cms, link, siteRoot, forceSecure);
    }

    public String substituteLinkForRootPath(CmsObject cms, String rootPath) {
        String siteRoot = OpenCms.getSiteManager().getSiteRoot(rootPath);
        if (siteRoot == null) {
            siteRoot = cms.getRequestContext().getSiteRoot();
        }
        String sitePath = rootPath.startsWith(siteRoot) ? rootPath.substring(siteRoot.length()) : rootPath;
        return this.substituteLink(cms, sitePath, siteRoot, false);
    }

    public String substituteLinkForUnknownTarget(CmsObject cms, String link) {
        if (CmsStringUtil.isEmpty(link)) {
            return "";
        }
        String sitePath = link;
        String siteRoot = null;
        if (CmsLinkManager.hasScheme(link) && (sitePath = this.getRootPath(cms, link)) == null) {
            return link;
        }
        siteRoot = OpenCms.getSiteManager().getSiteRoot(sitePath);
        if (siteRoot == null) {
            siteRoot = cms.getRequestContext().getSiteRoot();
        } else {
            sitePath = sitePath.substring(siteRoot.length());
        }
        return this.substituteLink(cms, sitePath, siteRoot, false);
    }

    private String appendServerPrefix(CmsObject cms, String link, String pathWithOptionalParameters) {
        String resourceName;
        int paramPos = pathWithOptionalParameters.indexOf("?");
        String string = resourceName = paramPos > -1 ? pathWithOptionalParameters.substring(0, paramPos) : pathWithOptionalParameters;
        if (CmsLinkManager.isAbsoluteUri(link) && !CmsLinkManager.hasScheme(link)) {
            String serverPrefix;
            if (cms.getRequestContext().getCurrentProject().isOnlineProject()) {
                String overrideSiteRoot = (String)cms.getRequestContext().getAttribute("OVERRIDE_SITEROOT:" + link);
                CmsSite currentSite = OpenCms.getSiteManager().getSite(overrideSiteRoot != null ? overrideSiteRoot : resourceName, cms.getRequestContext().getSiteRoot());
                serverPrefix = currentSite.getServerPrefix(cms, resourceName);
            } else {
                serverPrefix = OpenCms.getSiteManager().getWorkplaceServer();
            }
            link = serverPrefix + link;
        }
        return link;
    }

    static {
        try {
            m_baseUrl = new URL("http://127.0.0.1");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }
}

