/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.I_CmsRegexSubstitution;

public final class CmsColorReplaceHelper {
    public static final String A_PATTERN_STR = "(/\\*begin-color ([a-zA-Z]+)\\*/)(.+?)(/\\*end-color\\*/)";
    public static final String BASEDIR = "/home/user/workspace/opencms-core";
    public static final String[] FILE_LIST = new String[]{"modules/org.opencms.editors.codemirror/resources/system/workplace/resources/editors/codemirror/codemirror-ocms.css", "modules/org.opencms.editors/resources/system/workplace/editors/dialogs/property.jsp", "modules/org.opencms.editors/resources/system/workplace/editors/dialogs/table_new.jsp", "modules/org.opencms.editors/resources/system/workplace/editors/direct_edit_include.txt", "modules/org.opencms.editors/resources/system/workplace/editors/direct_edit.jsp", "modules/org.opencms.editors.tinymce/resources/system/workplace/editors/tinymce/editor.jsp", "modules/org.opencms.jquery/resources/system/modules/org.opencms.jquery/resources/css/ui-ocms/jquery.ui.ocms.css", "modules/org.opencms.workplace.explorer/resources/system/workplace/commons/property_custom.jsp", "modules/org.opencms.workplace.explorer/resources/system/workplace/resources/commons/explorer.css", "modules/org.opencms.workplace.explorer/resources/system/workplace/resources/commons/tree.js", "modules/org.opencms.workplace/resources/system/workplace/commons/includes/report.jsp", "modules/org.opencms.workplace/resources/system/workplace/commons/style/menu.css", "modules/org.opencms.workplace/resources/system/workplace/commons/style/report.css", "modules/org.opencms.workplace/resources/system/workplace/galleries/downloadgallery/css/dialog.css", "modules/org.opencms.workplace/resources/system/workplace/galleries/imagegallery/css/crop.css", "modules/org.opencms.workplace/resources/system/workplace/galleries/imagegallery/css/editor.css", "modules/org.opencms.workplace/resources/system/workplace/resources/components/js_calendar/calendar-opencms.css", "modules/org.opencms.workplace/resources/system/workplace/resources/components/js_calendar/calendar-system.css", "modules/org.opencms.workplace/resources/system/workplace/resources/components/js_colorpicker/index.html", "src/org/opencms/jsp/util/errorpage.properties", "src/org/opencms/main/CmsException.java", "src/org/opencms/workplace/CmsReport.java", "src/org/opencms/workplace/CmsWorkplaceCustomFoot.java"};
    public static Pattern PATTERN = Pattern.compile("(/\\*begin-color ([a-zA-Z]+)\\*/)(.+?)(/\\*end-color\\*/)");
    public static String[][] SUBSTITUTION_LIST = new String[][]{{"ActiveBorder|ButtonFace|InactiveBorder|Menu|ThreeDFace|ThreeDLightShadow|ScrollBar|InactiveCaptionText", "#f0f0f0"}, {"AppWorkspace|ButtonShadow|GrayText|InactiveCaption|ThreeDShadow", "#999999"}, {"InfoBackground", "#f9f9f9"}, {"TextHover", "#b31b34"}, {"ThreeDDarkShadow", "#606161"}, {"ActiveCaption|Highlight", "#1f232a"}, {"ThreeDHighlight|ButtonHighlight|CaptionText|HighlightText|Window|InfoText", "#ffffff"}, {"Background|WindowFrame|WindowText|MenuText|ButtonText", "#000000"}};
    public static Map<String, String> SUBSTITUTION_MAP = CmsColorReplaceHelper.mapFromArray(SUBSTITUTION_LIST);

    private CmsColorReplaceHelper() {
    }

    public static String lookupColor(String name) {
        return SUBSTITUTION_MAP.get(name.trim().toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        for (String filePath : FILE_LIST) {
            File file = new File("/home/user/workspace/opencms-core/" + filePath);
            StringBuffer output = new StringBuffer();
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(file));
                String line = null;
                while ((line = br.readLine()) != null) {
                    String processed = CmsColorReplaceHelper.processLine(line);
                    output.append(processed);
                    output.append("\n");
                }
            }
            finally {
                if (br != null) {
                    br.close();
                }
            }
            byte[] data = output.toString().getBytes("UTF-8");
            Files.write((byte[])data, (File)file);
        }
    }

    public static Map<String, String> mapFromArray(String[][] stringData) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String[] entry : stringData) {
            for (String key : CmsStringUtil.splitAsList(entry[0], "|")) {
                result.put(key.toLowerCase(), entry[1]);
            }
        }
        return result;
    }

    public static String processLine(String line) {
        String result = CmsStringUtil.substitute(PATTERN, line, new I_CmsRegexSubstitution(){

            @Override
            public String substituteMatch(String string, Matcher matcher) {
                String maybeQuote = matcher.group(3).contains("\"") ? "\"" : "";
                return matcher.group(1) + maybeQuote + CmsColorReplaceHelper.lookupColor(matcher.group(2)) + maybeQuote + matcher.group(4);
            }
        });
        return result;
    }
}

