/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsConfigurationReader;
import org.opencms.ade.configuration.formatters.CmsFormatterChangeSet;
import org.opencms.ade.configuration.formatters.CmsFormatterConfigurationCacheState;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;
import org.opencms.widgets.CmsSelectWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.widgets.Messages;
import org.opencms.workplace.CmsWorkplaceMessages;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;

public abstract class A_CmsFormatterWidget
extends CmsSelectWidget {
    private static final Log LOG = CmsLog.getLog(A_CmsFormatterWidget.class);

    public static CmsSelectWidgetOption getWidgetOptionForFormatter(CmsObject cms, I_CmsFormatterBean formatter) {
        String name = formatter.getNiceName() + " [" + formatter.getResourceTypeName() + "]  " + " (" + formatter.getJspRootPath() + ")";
        CmsSelectWidgetOption option = new CmsSelectWidgetOption(formatter.getId(), false, name);
        return option;
    }

    public static CmsSelectWidgetOption getWidgetOptionForType(CmsObject cms, String typeName) {
        String niceTypeName = typeName;
        try {
            Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
            niceTypeName = CmsWorkplaceMessages.getResourceTypeName(locale, typeName);
        }
        catch (Exception e) {
            // empty catch block
        }
        CmsSelectWidgetOption option = new CmsSelectWidgetOption(CmsFormatterChangeSet.keyForType(typeName), false, A_CmsFormatterWidget.getMessage(cms, "GUI_SCHEMA_FORMATTER_OPTION_1", niceTypeName));
        return option;
    }

    static String getMessage(CmsObject cms, String message, Object ... args) {
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        return Messages.get().getBundle(locale).key(message, args);
    }

    protected abstract List<CmsSelectWidgetOption> getFormatterOptions(CmsObject var1, CmsADEConfigData var2);

    protected abstract Set<String> getSelectedInFile(CmsConfigurationReader var1, CmsXmlContent var2);

    protected abstract List<CmsSelectWidgetOption> getTypeOptions(CmsObject var1, CmsADEConfigData var2);

    @Override
    protected List<CmsSelectWidgetOption> parseSelectOptions(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String path = this.getResourcePath(cms, widgetDialog);
        try {
            cms = OpenCms.initCmsObject(cms);
            cms.getRequestContext().setSiteRoot("");
            CmsADEConfigData adeConfig = OpenCms.getADEManager().lookupConfiguration(cms, path);
            if (adeConfig.parent() != null) {
                adeConfig = adeConfig.parent();
            }
            HashSet<String> added = new HashSet<String>();
            ArrayList options = Lists.newArrayList();
            options.add(new CmsSelectWidgetOption("", true, A_CmsFormatterWidget.getMessage(cms, "GUI_FORMATTER_EMPTY_SELECTION_0", new Object[0])));
            List<CmsSelectWidgetOption> formatterOptions = this.getFormatterOptions(cms, adeConfig);
            options.addAll(formatterOptions);
            List<CmsSelectWidgetOption> typeOptions = this.getTypeOptions(cms, adeConfig);
            options.addAll(typeOptions);
            for (CmsSelectWidgetOption option : options) {
                added.add(option.getValue());
            }
            try {
                CmsResource content = cms.readResource(path);
                CmsFile contentFile = cms.readFile(content);
                CmsXmlContent xmlContent = CmsXmlContentFactory.unmarshal(cms, contentFile);
                CmsConfigurationReader reader = new CmsConfigurationReader(cms);
                Set<String> selected = this.getSelectedInFile(reader, xmlContent);
                Iterator<String> i$ = selected.iterator();
                while (i$.hasNext()) {
                    CmsSelectWidgetOption option;
                    String formatterKey;
                    String title = formatterKey = i$.next();
                    if (CmsUUID.isValidUUID(formatterKey)) {
                        CmsFormatterConfigurationCacheState cacheState = OpenCms.getADEManager().getCachedFormatters(cms.getRequestContext().getCurrentProject().isOnlineProject());
                        CmsUUID mapKey = new CmsUUID(formatterKey);
                        I_CmsFormatterBean formatter = cacheState.getFormatters().get(mapKey);
                        if (formatter != null) {
                            title = A_CmsFormatterWidget.getWidgetOptionForFormatter(cms, formatter).getOption();
                        }
                    }
                    if (added.contains((option = new CmsSelectWidgetOption(formatterKey, false, title)).getValue())) continue;
                    options.add(option);
                }
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return options;
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public static class FormatterSelectComparator
    implements Comparator<I_CmsFormatterBean> {
        @Override
        public int compare(I_CmsFormatterBean first, I_CmsFormatterBean second) {
            return ComparisonChain.start().compare((Comparable)((Object)first.getResourceTypeName()), (Comparable)((Object)second.getResourceTypeName())).compare(first.getRank(), second.getRank()).result();
        }
    }
}

