/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.htmlparser.util.ParserException;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsHtmlExtractor;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsTextareaWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.widgets.Messages;

public final class CmsTextareaWidgetPlaintext
extends CmsTextareaWidget {
    private static final Log LOG = CmsLog.getLog(CmsTextareaWidgetPlaintext.class);

    @Override
    public I_CmsWidget newInstance() {
        return new CmsTextareaWidgetPlaintext();
    }

    @Override
    public void setEditorValue(CmsObject cms, Map<String, String[]> formParameters, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String[] values = formParameters.get(param.getId());
        if (values != null && values.length > 0) {
            String value;
            block7: {
                value = values[0];
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(value)) {
                    try {
                        value = CmsHtmlExtractor.extractText(value, "UTF-8");
                    }
                    catch (ParserException e) {
                        if (LOG.isErrorEnabled()) {
                            LOG.error((Object)Messages.get().getBundle().key("LOG_ERR_WIDGET_PLAINTEXT_EXTRACT_HTML_1", value));
                        }
                        break block7;
                    }
                    catch (UnsupportedEncodingException e) {
                        if (LOG.isErrorEnabled()) {
                            LOG.error((Object)Messages.get().getBundle().key("LOG_ERR_WIDGET_PLAINTEXT_EXTRACT_HTML_1", value));
                        }
                        break block7;
                    }
                }
                value = "";
            }
            param.setStringValue(cms, value);
        }
    }
}

