/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.lock.CmsLockFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.Messages;
import org.opencms.workplace.commons.CmsLock;
import org.opencms.workplace.editors.CmsPreEditorAction;
import org.opencms.workplace.tools.CmsToolDialog;
import org.opencms.workplace.tools.CmsToolManager;

public class CmsDialog
extends CmsToolDialog {
    public static final int ACTION_CANCEL = 4;
    public static final int ACTION_CLOSEPOPUP = 6;
    public static final int ACTION_CLOSEPOPUP_SAVE = 7;
    public static final int ACTION_CONFIRMED = 1;
    public static final int ACTION_CONTINUE = 8;
    public static final int ACTION_DEFAULT = 0;
    public static final int ACTION_LOCKS_CONFIRMED = 99;
    public static final int ACTION_OK = 3;
    public static final int ACTION_REPORT_BEGIN = 90;
    public static final int ACTION_REPORT_END = 92;
    public static final int ACTION_REPORT_UPDATE = 91;
    public static final int ACTION_SET = 5;
    public static final int ACTION_WAIT = 2;
    public static final int BUTTON_ADVANCED = 3;
    public static final int BUTTON_BACK = 9;
    public static final int BUTTON_CANCEL = 1;
    public static final int BUTTON_CLOSE = 2;
    public static final int BUTTON_CONTINUE = 10;
    public static final int BUTTON_DETAILS = 5;
    public static final int BUTTON_DISCARD = 8;
    public static final int BUTTON_EDIT = 7;
    public static final int BUTTON_OK = 0;
    public static final int BUTTON_OK_NO_SUBMIT = 6;
    public static final int BUTTON_SET = 4;
    public static final String DIALOG_BACK = "back";
    public static final String DIALOG_CANCEL = "cancel";
    public static final String DIALOG_CONFIRMED = "confirmed";
    public static final String DIALOG_CONTINUE = "continue";
    public static final String DIALOG_INITIAL = "initial";
    public static final String DIALOG_LOCKS_CONFIRMED = "locksconfirmed";
    public static final String DIALOG_OK = "ok";
    public static final String DIALOG_SET = "set";
    public static final String DIALOG_WAIT = "wait";
    public static final String PARAM_ACTION = "action";
    public static final String PARAM_CLOSELINK = "closelink";
    public static final String PARAM_DIALOGTYPE = "dialogtype";
    public static final String PARAM_ERRORSTACK = "errorstack";
    public static final String PARAM_FILE = "file";
    public static final String PARAM_FRAMENAME = "framename";
    public static final String PARAM_ISPOPUP = "ispopup";
    public static final String PARAM_LOCK = "lock";
    public static final String PARAM_MESSAGE = "message";
    public static final String PARAM_ORIGINALPARAMS = "originalparams";
    public static final String PARAM_PREACTIONDONE = "preactiondone";
    public static final String PARAM_REDIRECT = "redirect";
    public static final String PARAM_RESOURCE = "resource";
    public static final String PARAM_TARGET = "target";
    public static final String PARAM_THREAD = "thread";
    public static final String PARAM_THREAD_HASNEXT = "threadhasnext";
    public static final String PARAM_TITLE = "title";
    public static final String REPORT_BEGIN = "reportbegin";
    public static final String REPORT_END = "reportend";
    public static final String REPORT_UPDATE = "reportupdate";
    protected static final String ATTRIBUTE_THROWABLE = "throwable";
    private static final Log LOG = CmsLog.getLog(CmsDialog.class);
    private int m_action;
    private String m_onlineHelpUriCustom;
    private String m_paramAction;
    private String m_paramCloseLink;
    private String m_paramDialogtype;
    private String m_paramFrameName;
    private String m_paramIsPopup;
    private String m_paramMessage;
    private String m_paramOriginalParams;
    private String m_paramPreActionDone;
    private String m_paramRedirect;
    private String m_paramResource;
    private String m_paramTitle;

    public CmsDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public static CmsDialog initCmsDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        CmsDialog wp = (CmsDialog)req.getAttribute("__CmsWorkplace.WORKPLACE_CLASS");
        if (wp == null) {
            wp = new CmsDialog(new CmsJspActionElement(context, req, res));
            wp.fillParamValues(req);
        }
        return wp;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionCloseDialog() throws JspException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(PARAM_RESOURCE, "");
        if (this.isPopup()) {
            try {
                JspWriter out = this.getJsp().getJspContext().getOut();
                out.write("<html><head></head>\n");
                out.write("<body onload=\"top.close();\">\n");
                out.write("</body>\n");
                out.write("</html>\n");
                return;
            }
            catch (IOException e) {
                this.getJsp().include("/system/workplace/views/explorer/explorer_files.jsp", null, params);
            }
            return;
        } else if (this.getParamCloseLink() != null) {
            try {
                if (Boolean.valueOf(this.getParamRedirect()).booleanValue()) {
                    this.getJsp().getResponse().sendRedirect(this.getParamCloseLink());
                    return;
                }
                if (this.isForwarded()) return;
                this.setForwarded(true);
                CmsRequestUtil.forwardRequest(this.getParamCloseLink(), this.getJsp().getRequest(), this.getJsp().getResponse());
                return;
            }
            catch (Exception e) {
                throw new JspException(e.getMessage(), (Throwable)e);
            }
        } else if (this.getParamFramename() != null) {
            String frameUri = this.getSettings().getFrameUris().get(this.getParamFramename());
            params.put(PARAM_ACTION, "");
            if (frameUri != null) {
                if (frameUri.startsWith(OpenCms.getSystemInfo().getOpenCmsContext())) {
                    frameUri = frameUri.substring(OpenCms.getSystemInfo().getOpenCmsContext().length());
                }
                this.getJsp().include(frameUri, null, params);
                return;
            } else {
                this.getJsp().include("/system/workplace/views/explorer/explorer_files.jsp", null, params);
            }
            return;
        } else {
            this.getJsp().include("/system/workplace/views/explorer/explorer_files.jsp", null, params);
        }
    }

    public String buildAjaxResultContainer(String title) {
        StringBuffer html = new StringBuffer(512);
        html.append(this.dialogBlockStart(title));
        html.append(this.dialogWhiteBoxStart());
        html.append("<div id='ajaxreport' >");
        html.append(this.buildAjaxWaitMessage());
        html.append("</div>\n");
        html.append(this.dialogWhiteBoxEnd());
        html.append(this.dialogBlockEnd());
        html.append("&nbsp;<br>\n");
        return html.toString();
    }

    public String buildLockAdditionalOptions() {
        return "";
    }

    public String buildLockConfirmationMessageJS() {
        StringBuffer html = new StringBuffer(512);
        html.append("<script type='text/javascript'><!--\n");
        html.append("function setConfirmationMessage(locks, blockinglocks) {\n");
        html.append("\tvar confMsg = document.getElementById('conf-msg');\n");
        html.append("\tif (locks > -1) {\n");
        html.append("\t\tif (blockinglocks > '0') {\n");
        html.append("\t\t\tshowAjaxReportContent();\n");
        html.append("\t\t\tdocument.getElementById('lock-body-id').className = '';\n");
        html.append("\t\t\tdocument.getElementById('butClose').className = '';\n");
        html.append("\t\t\tdocument.getElementById('butContinue').className = 'hide';\n");
        html.append("\t\t\tconfMsg.innerHTML = '");
        html.append(this.key("GUI_OPERATION_BLOCKING_LOCKS_0"));
        html.append("';\n");
        html.append("\t\t} else {\n");
        html.append("\t\t\tsubmitAction('");
        html.append(DIALOG_OK);
        html.append("', null, 'main');\n");
        html.append("\t\t\tdocument.forms['main'].submit();\n");
        html.append("\t\t}\n");
        html.append("\t} else {\n");
        html.append("\t\tdocument.getElementById('butClose').className = '';\n");
        html.append("\t\tdocument.getElementById('butContinue').className = 'hide';\n");
        html.append("\t\tconfMsg.innerHTML = '");
        html.append(this.key("GUI_AJAX_REPORT_WAIT_0"));
        html.append("';\n");
        html.append("\t}\n");
        html.append("}\n");
        html.append("// -->\n");
        html.append("</script>\n");
        return html.toString();
    }

    public String buildLockDialog() throws CmsException {
        return this.buildLockDialog(null, null, 2000, false);
    }

    public String buildLockDialog(CmsLockFilter nonBlockingFilter, CmsLockFilter blockingFilter, int hiddenTimeout, boolean includeRelated) throws CmsException {
        this.setParamAction(DIALOG_LOCKS_CONFIRMED);
        CmsLock lockwp = new CmsLock(this.getJsp());
        lockwp.setBlockingFilter(blockingFilter);
        lockwp.setNonBlockingFilter(nonBlockingFilter);
        StringBuffer html = new StringBuffer(512);
        html.append(this.htmlStart("help.explorer.contextmenu.lock"));
        html.append(lockwp.buildIncludeJs());
        html.append(this.buildLockConfirmationMessageJS());
        html.append(this.bodyStart("dialog"));
        html.append("<div id='lock-body-id' class='hide'>\n");
        html.append(this.dialogStart());
        html.append(this.dialogContentStart(this.getParamTitle()));
        html.append(this.buildLockHeaderBox());
        html.append(this.dialogSpacer());
        html.append("<form name='main' action='");
        html.append(this.getDialogUri());
        html.append("' method='post' class='nomargin' onsubmit=\"return submitAction('");
        html.append(DIALOG_OK);
        html.append("', null, 'main');\">\n");
        html.append(this.paramsAsHidden());
        html.append("<input type='hidden' name='");
        html.append(PARAM_FRAMENAME);
        html.append("' value=''>\n");
        html.append(this.buildAjaxResultContainer(this.key("GUI_LOCK_RESOURCES_TITLE_0")));
        html.append("<div id='conf-msg'></div>\n");
        html.append(this.buildLockAdditionalOptions());
        html.append(this.dialogContentEnd());
        html.append(this.dialogLockButtons());
        html.append("</form>\n");
        html.append(this.dialogEnd());
        html.append("</div>\n");
        html.append(this.bodyEnd());
        html.append(lockwp.buildLockRequest(hiddenTimeout, includeRelated));
        html.append(this.htmlEnd());
        return html.toString();
    }

    public String buildLockHeaderBox() throws CmsException {
        StringBuffer html = new StringBuffer(512);
        html.append(this.dialogBlockStart(null));
        html.append(this.key("GUI_LABEL_TITLE_0"));
        html.append(": ");
        html.append(this.getJsp().property("Title", this.getParamResource(), ""));
        html.append("<br>\n");
        html.append(this.key("GUI_LABEL_STATE_0"));
        html.append(": ");
        html.append(this.getState());
        html.append("<br>\n");
        html.append(this.key("GUI_LABEL_PERMALINK_0"));
        html.append(": ");
        html.append(OpenCms.getLinkManager().getPermalink(this.getCms(), this.getParamResource()));
        html.append(this.dialogBlockEnd());
        return html.toString();
    }

    public String dialog(int segment, String attributes) {
        if (segment == 0) {
            StringBuffer html = new StringBuffer(512);
            if (this.useNewStyle()) {
                html.append(this.dialogTitle());
            }
            html.append("<table class=\"dialog\" cellpadding=\"0\" cellspacing=\"0\"");
            if (attributes != null) {
                html.append(" ");
                html.append(attributes);
            }
            html.append("><tr><td>\n<table class=\"dialogbox\" cellpadding=\"0\" cellspacing=\"0\">\n");
            html.append("<tr><td>\n");
            if (this.useNewStyle() && this.getToolManager().hasToolPathForUrl(this.getJsp().getRequestContext().getUri())) {
                html.append(this.getAdminTool().groupHtml(this));
            }
            return html.toString();
        }
        return "</td></tr></table>\n</td></tr></table>\n<p>&nbsp;</p>\n";
    }

    public String dialogBlock(int segment, String headline, boolean error) {
        if (segment == 0) {
            StringBuffer result = new StringBuffer(512);
            String errorStyle = "";
            if (error) {
                errorStyle = " dialogerror";
            }
            result.append("<!-- 3D block start -->\n");
            result.append("<fieldset class=\"dialogblock\">\n");
            if (CmsStringUtil.isNotEmpty(headline)) {
                result.append("<legend>");
                result.append("<span class=\"textbold");
                result.append(errorStyle);
                result.append("\" unselectable=\"on\">");
                result.append(headline);
                result.append("</span></legend>\n");
            }
            return result.toString();
        }
        return "</fieldset>\n<!-- 3D block end -->\n";
    }

    public String dialogBlockEnd() {
        return this.dialogBlock(1, null, false);
    }

    public String dialogBlockStart(String headline) {
        return this.dialogBlock(0, headline, false);
    }

    public String dialogButtonRow(int segment) {
        if (segment == 0) {
            return "<!-- button row start -->\n<div class=\"dialogbuttons\" unselectable=\"on\">\n";
        }
        return "</div>\n<!-- button row end -->\n";
    }

    public String dialogButtonRowEnd() {
        return this.dialogButtonRow(1);
    }

    public String dialogButtonRowStart() {
        return this.dialogButtonRow(0);
    }

    public String dialogButtons(int[] buttons, String[] attributes) {
        StringBuffer result = new StringBuffer(256);
        result.append(this.dialogButtonRow(0));
        for (int i = 0; i < buttons.length; ++i) {
            this.dialogButtonsHtml(result, buttons[i], attributes[i]);
        }
        result.append(this.dialogButtonRow(1));
        return result.toString();
    }

    public String dialogButtonsClose() {
        return this.dialogButtons(new int[]{2}, new String[1]);
    }

    public String dialogButtonsClose(String closeAttribute) {
        return this.dialogButtons(new int[]{2}, new String[]{closeAttribute});
    }

    public String dialogButtonsCloseDetails(String closeAttribute, String detailsAttribute) {
        return this.dialogButtons(new int[]{2, 5}, new String[]{closeAttribute, detailsAttribute});
    }

    public String dialogButtonsOk() {
        return this.dialogButtons(new int[]{0}, new String[1]);
    }

    public String dialogButtonsOk(String okAttribute) {
        return this.dialogButtons(new int[]{0}, new String[]{okAttribute});
    }

    public String dialogButtonsOkCancel() {
        return this.dialogButtons(new int[]{0, 1}, new String[2]);
    }

    public String dialogButtonsOkCancel(String okAttributes, String cancelAttributes) {
        return this.dialogButtons(new int[]{0, 1}, new String[]{okAttributes, cancelAttributes});
    }

    public String dialogButtonsOkCancelAdvanced(String okAttributes, String cancelAttributes, String advancedAttributes) {
        return this.dialogButtons(new int[]{0, 1, 3}, new String[]{okAttributes, cancelAttributes, advancedAttributes});
    }

    public String dialogButtonsSetOkCancel(String setAttributes, String okAttributes, String cancelAttributes) {
        return this.dialogButtons(new int[]{4, 0, 1}, new String[]{setAttributes, okAttributes, cancelAttributes});
    }

    public String dialogContent(int segment, String title) {
        if (segment == 0) {
            StringBuffer result = new StringBuffer(512);
            result.append(this.dialogHead(title));
            result.append("<div class=\"dialogcontent\" unselectable=\"on\">\n");
            result.append("<!-- dialogcontent start -->\n");
            return result.toString();
        }
        return "<!-- dialogcontent end -->\n</div>\n";
    }

    public String dialogContentEnd() {
        return this.dialogContent(1, null);
    }

    public String dialogContentStart(String title) {
        return this.dialogContent(0, title);
    }

    public String dialogEnd() {
        return this.dialog(1, null);
    }

    public String dialogHead(String title) {
        String escapedTitle = title == null ? "" : CmsEncoder.escapeHtml(title);
        return "<div class=\"dialoghead\" unselectable=\"on\">" + escapedTitle + "</div>";
    }

    public String dialogHorizontalSpacer(int width) {
        return "<td><span style=\"display:block; height: 1px; width: " + width + "px;\"></span></td>";
    }

    public String dialogLockButtons() {
        StringBuffer html = new StringBuffer(512);
        html.append("<div id='butClose' >\n");
        html.append(this.dialogButtonsClose());
        html.append("</div>\n");
        html.append("<div id='butContinue' class='hide' >\n");
        html.append(this.dialogButtons(new int[]{10, 1}, new String[]{" onclick=\"submitAction('ok', form); form.submit();\"", ""}));
        html.append("</div>\n");
        return html.toString();
    }

    public String dialogRow(int segment) {
        if (segment == 0) {
            return "<div class=\"dialogrow\">";
        }
        return "</div>\n";
    }

    public String dialogRowEnd() {
        return this.dialogRow(1);
    }

    public String dialogRowStart() {
        return this.dialogRow(0);
    }

    @Override
    public String dialogScriptSubmit() {
        if (this.useNewStyle()) {
            return super.dialogScriptSubmit();
        }
        StringBuffer result = new StringBuffer(512);
        result.append("function submitAction(actionValue, theForm, formName) {\n");
        result.append("\tif (theForm == null) {\n");
        result.append("\t\ttheForm = document.forms[formName];\n");
        result.append("\t}\n");
        result.append("\ttheForm.framename.value = window.name;\n");
        result.append("\tif (actionValue == \"ok\") {\n");
        result.append("\t\treturn true;\n");
        result.append("\t}\n");
        result.append("\ttheForm.action.value = actionValue;\n");
        result.append("\ttheForm.submit();\n");
        result.append("\treturn false;\n");
        result.append("}\n");
        return result.toString();
    }

    public String dialogSeparator() {
        return "<div class=\"dialogseparator\" unselectable=\"on\"></div>";
    }

    public String dialogSpacer() {
        return "<div class=\"dialogspacer\" unselectable=\"on\">&nbsp;</div>";
    }

    public String dialogStart() {
        return this.dialog(0, null);
    }

    public String dialogStart(String attributes) {
        return this.dialog(0, attributes);
    }

    public String dialogSubheadline(String headline) {
        StringBuffer retValue = new StringBuffer(128);
        retValue.append("<div class=\"dialogsubheader\" unselectable=\"on\">");
        retValue.append(headline);
        retValue.append("</div>\n");
        return retValue.toString();
    }

    public String dialogToggleStart(String headline, String id, boolean show) {
        StringBuffer result = new StringBuffer(512);
        String image = "plus.png";
        String styleClass = "hide";
        if (show) {
            image = "minus.png";
            styleClass = "show";
        }
        result.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n");
        result.append("<tr>\n");
        result.append("\t<td style=\"vertical-align: bottom; padding-bottom: 2px;\"><a href=\"javascript:toggleDetail('");
        result.append(id);
        result.append("');\"><img src=\"");
        result.append(CmsDialog.getSkinUri());
        result.append("commons/");
        result.append(image);
        result.append("\" class=\"noborder\" id=\"ic-");
        result.append(id);
        result.append("\"></a></td>\n");
        result.append("\t<td>");
        result.append(this.dialogSubheadline(headline));
        result.append("</td>\n");
        result.append("</tr>\n");
        result.append("</table>\n");
        result.append("<div class=\"");
        result.append(styleClass);
        result.append("\" id=\"");
        result.append(id);
        result.append("\">\n");
        return result.toString();
    }

    public String dialogWhiteBox(int segment) {
        if (segment == 0) {
            return "<!-- white box start -->\n<div class=\"dialoginnerboxborder\">\n<div class=\"dialoginnerbox\" unselectable=\"off\">\n";
        }
        return "</div>\n</div>\n<!-- white box end -->\n";
    }

    public String dialogWhiteBoxEnd() {
        return this.dialogWhiteBox(1);
    }

    public String dialogWhiteBoxStart() {
        return this.dialogWhiteBox(0);
    }

    public int getAction() {
        return this.m_action;
    }

    public String getCancelAction() {
        return DIALOG_CANCEL;
    }

    public String getDialogRealUri() {
        return this.getJsp().link(this.getJsp().getRequestContext().getUri());
    }

    public String getDialogUri() {
        if (!this.useNewStyle()) {
            return this.getDialogRealUri();
        }
        return CmsToolManager.linkForToolPath(this.getJsp(), this.getCurrentToolPath());
    }

    public String getOnlineHelpUriCustom() {
        if (this.m_onlineHelpUriCustom == null) {
            return null;
        }
        StringBuffer result = new StringBuffer(this.m_onlineHelpUriCustom.length() + 4);
        result.append("\"");
        result.append(this.m_onlineHelpUriCustom);
        result.append("\"");
        return result.toString();
    }

    public String getParamAction() {
        return this.m_paramAction;
    }

    public String getParamCloseLink() {
        if (this.m_paramCloseLink == null || "null".equals(this.m_paramCloseLink)) {
            return null;
        }
        return this.m_paramCloseLink;
    }

    public String getParamDialogtype() {
        return this.m_paramDialogtype;
    }

    public String getParamFramename() {
        if (this.m_paramFrameName != null && !"null".equals(this.m_paramFrameName)) {
            return this.m_paramFrameName;
        }
        return null;
    }

    public String getParamIsPopup() {
        return this.m_paramIsPopup;
    }

    public String getParamMessage() {
        return this.m_paramMessage;
    }

    public String getParamOriginalParams() {
        return this.m_paramOriginalParams;
    }

    public String getParamPreActionDone() {
        return this.m_paramPreActionDone;
    }

    public String getParamRedirect() {
        return this.m_paramRedirect;
    }

    public String getParamResource() {
        if (this.m_paramResource != null && !"null".equals(this.m_paramResource)) {
            return this.m_paramResource;
        }
        return null;
    }

    public String getParamTitle() {
        return this.m_paramTitle;
    }

    public String getState() throws CmsException {
        if (CmsStringUtil.isNotEmpty(this.getParamResource())) {
            CmsResource file = this.getCms().readResource(this.getParamResource(), CmsResourceFilter.ALL);
            if (this.getCms().isInsideCurrentProject(this.getParamResource())) {
                return this.key(Messages.getStateKey(file.getState()));
            }
            return this.key("GUI_EXPLORER_STATENIP_0");
        }
        return "+++ resource parameter not found +++";
    }

    public boolean hasCorrectLockstate() {
        org.opencms.lock.CmsLock lock = null;
        try {
            lock = this.getCms().getLock(this.getParamResource());
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(this.getLocale()), (Throwable)e);
            return false;
        }
        boolean autoLockFeature = lock.isNullLock() && OpenCms.getWorkplaceManager().autoLockResources();
        return autoLockFeature || lock.isExclusive() || lock.isInherited();
    }

    public boolean hasSiblings() {
        try {
            return this.getCms().readResource(this.getParamResource(), CmsResourceFilter.ALL).getSiblingCount() > 1;
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(this.getLocale()), (Throwable)e);
            return false;
        }
    }

    public String htmlStart() {
        return this.pageHtml(0, null);
    }

    @Override
    public String htmlStart(String helpUrl) {
        return this.pageHtml(0, helpUrl);
    }

    public String htmlStart(String helpUrl, String title) {
        return this.pageHtml(0, helpUrl, title);
    }

    public String htmlStartStyle(String title, String stylesheet) {
        return this.pageHtmlStyle(0, title, stylesheet);
    }

    public void includeErrorpage(CmsWorkplace wp, Throwable t) throws JspException {
        CmsLog.getLog(wp).error((Object)Messages.get().getBundle().key("ERR_WORKPLACE_DIALOG_0"), t);
        this.getJsp().getRequest().setAttribute("__CmsWorkplace.WORKPLACE_CLASS", (Object)wp);
        this.getJsp().getRequest().setAttribute(ATTRIBUTE_THROWABLE, (Object)t);
        this.getJsp().include("/system/workplace/commons/includes/errorpage.jsp");
    }

    public boolean isPopup() {
        return Boolean.valueOf(this.getParamIsPopup());
    }

    public boolean isPreEditor() {
        return CmsPreEditorAction.isPreEditorMode(this);
    }

    @Override
    public String pageHtml(int segment, String helpUrl) {
        return this.pageHtml(segment, helpUrl, null);
    }

    public String pageHtml(int segment, String helpUrl, String title) {
        if (segment == 0) {
            String stylesheet = null;
            if (this.isPopup() && !this.useNewStyle()) {
                stylesheet = "popup.css";
            }
            StringBuffer result = new StringBuffer(this.pageHtmlStyle(segment, title, stylesheet));
            if (this.getSettings().isViewExplorer()) {
                result.append("<script type=\"text/javascript\" src=\"");
                result.append(CmsDialog.getSkinUri());
                result.append("commons/explorer.js\"></script>\n");
            }
            result.append("<script type=\"text/javascript\">\n");
            result.append(this.dialogScriptSubmit());
            if (helpUrl != null) {
                result.append("if (top.head && top.head.helpUrl) {\n");
                result.append("\ttop.head.helpUrl=\"");
                result.append(helpUrl + "\";\n");
                result.append("}\n\n");
            }
            result.append("var onlineHelpUriCustom = ");
            result.append(this.getOnlineHelpUriCustom());
            result.append(";\n");
            result.append("</script>\n");
            return result.toString();
        }
        return super.pageHtml(segment, null);
    }

    public void setOnlineHelpUriCustom(String uri) {
        this.m_onlineHelpUriCustom = uri;
    }

    public void setParamAction(String value) {
        this.m_paramAction = value;
    }

    public void setParamCloseLink(String value) {
        this.m_paramCloseLink = value;
    }

    public void setParamDialogtype(String value) {
        this.m_paramDialogtype = value;
    }

    public void setParamFramename(String value) {
        this.m_paramFrameName = value;
    }

    public void setParamIsPopup(String value) {
        this.m_paramIsPopup = value;
    }

    public void setParamMessage(String value) {
        this.m_paramMessage = value;
    }

    public void setParamOriginalParams(String paramOriginalParams) {
        this.m_paramOriginalParams = paramOriginalParams;
    }

    public void setParamPreActionDone(String paramPreActionDone) {
        this.m_paramPreActionDone = paramPreActionDone;
    }

    public void setParamRedirect(String redirect) {
        this.m_paramRedirect = redirect;
    }

    public void setParamResource(String value) {
        this.m_paramResource = value;
    }

    public void setParamTitle(String value) {
        this.m_paramTitle = value;
    }

    protected String appendDelimiter(String attribute) {
        if (CmsStringUtil.isNotEmpty(attribute)) {
            if (!attribute.startsWith(" ")) {
                return " " + attribute;
            }
            return attribute;
        }
        return "";
    }

    protected String buildAjaxWaitMessage() {
        StringBuffer html = new StringBuffer(512);
        html.append("<table border='0' style='vertical-align:middle; height: 150px;'>\n");
        html.append("<tr><td width='40' align='center' valign='middle'><img src='");
        html.append(CmsWorkplace.getSkinUri());
        html.append("commons/wait.gif' id='ajaxreport-img' width='32' height='32' alt=''></td>\n");
        html.append("<td valign='middle'><span id='ajaxreport-txt' style='color: #000099; font-weight: bold;'>\n");
        html.append(this.key("GUI_AJAX_REPORT_WAIT_0"));
        html.append("</span><br></td></tr></table>\n");
        return html.toString();
    }

    protected boolean checkResourcePermissions(CmsPermissionSet required, boolean neededForFolder) {
        return this.checkResourcePermissions(required, neededForFolder, Messages.get().container("GUI_ERR_RESOURCE_PERMISSIONS_2", this.getParamResource(), required.getPermissionString()));
    }

    protected boolean checkResourcePermissions(CmsPermissionSet required, boolean neededForFolder, CmsMessageContainer errorMessage) {
        boolean hasPermissions;
        block3: {
            hasPermissions = false;
            try {
                CmsResource res = neededForFolder ? this.getCms().readResource(CmsResource.getParentFolder(this.getParamResource()), CmsResourceFilter.ALL) : this.getCms().readResource(this.getParamResource(), CmsResourceFilter.ALL);
                hasPermissions = this.getCms().hasPermissions(res, required, false, CmsResourceFilter.ALL);
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) break block3;
                LOG.info((Object)e);
            }
        }
        if (!hasPermissions) {
            this.getSettings().setErrorMessage(errorMessage);
        }
        return hasPermissions;
    }

    protected String computeCurrentFolder() {
        String currentFolder = this.getSettings().getExplorerResource();
        if (currentFolder == null) {
            try {
                currentFolder = this.getCms().getSitePath(this.getCms().readFolder("/", CmsResourceFilter.IGNORE_EXPIRATION));
            }
            catch (CmsException e) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)e);
                }
                currentFolder = "/";
            }
        }
        if (!currentFolder.endsWith("/")) {
            currentFolder = currentFolder + "/";
        }
        return currentFolder;
    }

    protected void dialogButtonsHtml(StringBuffer result, int button, String attribute) {
        attribute = this.appendDelimiter(attribute);
        switch (button) {
            case 0: {
                result.append("<input name=\"ok\" value=\"");
                result.append(this.key("GUI_DIALOG_BUTTON_OK_0") + "\"");
                if (attribute.toLowerCase().indexOf("onclick") == -1) {
                    result.append(" type=\"submit\"");
                } else {
                    result.append(" type=\"button\"");
                }
                result.append(" class=\"dialogbutton\"");
                result.append(attribute);
                result.append(">\n");
                break;
            }
            case 1: {
                result.append("<input name=\"cancel\" type=\"button\" value=\"");
                result.append(this.key("GUI_DIALOG_BUTTON_CANCEL_0") + "\"");
                if (attribute.toLowerCase().indexOf("onclick") == -1) {
                    result.append(" onclick=\"submitAction('cancel', form);\"");
                }
                result.append(" class=\"dialogbutton\"");
                result.append(attribute);
                result.append(">\n");
                break;
            }
            case 7: {
                result.append("<input name=\"ok\" value=\"");
                result.append(this.key("GUI_DIALOG_BUTTON_EDIT_0") + "\"");
                if (attribute.toLowerCase().indexOf("onclick") == -1) {
                    result.append(" type=\"submit\"");
                } else {
                    result.append(" type=\"button\"");
                }
                result.append(" class=\"dialogbutton\"");
                result.append(attribute);
                result.append(">\n");
                break;
            }
            case 8: {
                result.append("<input name=\"cancel\" type=\"button\" value=\"");
                result.append(this.key("GUI_DIALOG_BUTTON_DISCARD_0") + "\"");
                if (attribute.toLowerCase().indexOf("onclick") == -1) {
                    result.append(" onclick=\"submitAction('cancel', form);\"");
                }
                result.append(" class=\"dialogbutton\"");
                result.append(attribute);
                result.append(">\n");
                break;
            }
            case 2: {
                result.append("<input name=\"close\" type=\"button\" value=\"");
                result.append(this.key("GUI_DIALOG_BUTTON_CLOSE_0") + "\"");
                if (attribute.toLowerCase().indexOf("onclick") == -1) {
                    result.append(" onclick=\"submitAction('cancel', form);\"");
                }
                result.append(" class=\"dialogbutton\"");
                result.append(attribute);
                result.append(">\n");
                break;
            }
            case 3: {
                result.append("<input name=\"advanced\" type=\"button\" value=\"");
                result.append(this.key("GUI_DIALOG_BUTTON_ADVANCED_0") + "\"");
                result.append(" class=\"dialogbutton\"");
                result.append(attribute);
                result.append(">\n");
                break;
            }
            case 4: {
                result.append("<input name=\"set\" type=\"button\" value=\"");
                result.append(this.key("GUI_DIALOG_BUTTON_SET_0") + "\"");
                if (attribute.toLowerCase().indexOf("onclick") == -1) {
                    result.append(" onclick=\"submitAction('set', form);\"");
                }
                result.append(" class=\"dialogbutton\"");
                result.append(attribute);
                result.append(">\n");
                break;
            }
            case 9: {
                result.append("<input name=\"set\" type=\"button\" value=\"");
                result.append(this.key("GUI_DIALOG_BUTTON_BACK_0") + "\"");
                if (attribute.toLowerCase().indexOf("onclick") == -1) {
                    result.append(" onclick=\"submitAction('back', form);\"");
                }
                result.append(" class=\"dialogbutton\"");
                result.append(attribute);
                result.append(">\n");
                break;
            }
            case 10: {
                result.append("<input name=\"set\" type=\"button\" value=\"");
                result.append(this.key("GUI_DIALOG_BUTTON_CONTINUE_0") + "\"");
                if (attribute.toLowerCase().indexOf("onclick") == -1) {
                    result.append(" onclick=\"submitAction('continue', form);\"");
                }
                result.append(" class=\"dialogbutton\"");
                result.append(attribute);
                result.append(">\n");
                break;
            }
            case 5: {
                result.append("<input name=\"details\" type=\"button\" value=\"");
                result.append(this.key("GUI_DIALOG_BUTTON_DETAIL_0") + "\"");
                result.append(" class=\"dialogbutton\"");
                result.append(attribute);
                result.append(">\n");
                break;
            }
            default: {
                result.append("<!-- invalid button code: ");
                result.append(button);
                result.append(" -->\n");
            }
        }
    }

    protected String getAdministrationBackLink() {
        return "/system/workplace/action/administration_content_top.html?sender=" + CmsResource.getParentFolder(this.getJsp().getRequestContext().getFolderUri());
    }

    @Override
    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        if (DIALOG_CANCEL.equals(this.getParamAction())) {
            this.setAction(4);
        }
    }

    protected void setAction(int value) {
        this.m_action = value;
    }
}

