/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace;

import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;

public class CmsWorkplaceCustomFoot {
    public static final String DEFAUL_COLOR = "/*begin-color WindowText*/#000000/*end-color*/";
    public static final String DEFAULT_BACKGROUNDCOLOR = "/*begin-color ThreeDFace*/#f0f0f0/*end-color*/";
    public static final String DEFAULT_TEXT = "%(key.GUI_LABEL_USER_0) %(currentuser.fullname) %(key.GUI_LABEL_LOGINTIME_0) %(currentuser.lastlogin) %(key.GUI_LABEL_LOGINADDRESS_0) %(opencms.remoteaddress) ";
    public static final String DEFAULT_TEXT_WITH_OU = "%(key.GUI_LABEL_USER_0) %(currentuser.fullname) %(key.GUI_LABEL_LOGINTIME_0) %(currentuser.lastlogin) %(key.GUI_LABEL_LOGINADDRESS_0) %(opencms.remoteaddress) [%(key.GUI_LABEL_OU_0) %(currentou.description)] ";
    private String m_backgroundColor = "/*begin-color ThreeDFace*/#f0f0f0/*end-color*/";
    private String m_color = "/*begin-color WindowText*/#000000/*end-color*/";
    private boolean m_replaceDefault;
    private String m_text = "";
    private String m_textShown;

    public String getBackgroundColor() {
        return this.m_backgroundColor;
    }

    public String getColor() {
        return this.m_color;
    }

    public String getText() {
        return this.m_text;
    }

    public String getTextResolved(CmsWorkplace wp) {
        CmsMacroResolver resolver = CmsMacroResolver.newInstance();
        resolver.setCmsObject(wp.getCms());
        resolver.setJspPageContext(wp.getJsp().getJspContext());
        resolver.setMessages(wp.getMessages());
        if (this.m_textShown == null) {
            StringBuffer text = new StringBuffer(512);
            if (!this.isReplaceDefault()) {
                try {
                    if (OpenCms.getOrgUnitManager().getOrganizationalUnits(wp.getCms(), "", true).isEmpty()) {
                        text.append(DEFAULT_TEXT).append(" ");
                    } else {
                        text.append(DEFAULT_TEXT_WITH_OU).append(" ");
                    }
                }
                catch (CmsException e) {
                    text.append(DEFAULT_TEXT).append(" ");
                }
            }
            text.append(this.m_text);
            this.m_textShown = text.toString();
        }
        return resolver.resolveMacros(this.m_textShown);
    }

    public boolean isReplaceDefault() {
        return this.m_replaceDefault;
    }

    public void setBackgroundColor(String backgroundColor) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(backgroundColor)) {
            this.m_backgroundColor = backgroundColor;
        }
    }

    public void setColor(String color) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(color)) {
            this.m_color = color;
        }
    }

    public void setText(String text, String replaceDefault) {
        this.m_replaceDefault = Boolean.valueOf(replaceDefault);
        this.m_text = text;
    }
}

