/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsPrincipal;
import org.opencms.security.CmsRole;
import org.opencms.security.I_CmsPrincipal;
import org.opencms.workplace.I_CmsGroupNameTranslation;
import org.opencms.workplace.commons.Messages;
import org.opencms.workplace.list.A_CmsListDefaultJsAction;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListIndependentAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListItemDetailsFormatter;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.CmsListSearchAction;
import org.opencms.workplace.list.I_CmsListItemComparator;

public class CmsPrincipalSelectionList
extends A_CmsListDialog {
    public static final String LIST_ACTION_ICON = "ai";
    public static final String LIST_ACTION_SELECT = "js";
    public static final String LIST_COLUMN_DESCRIPTION = "cd";
    public static final String LIST_COLUMN_DISPLAY = "cdn";
    public static final String LIST_COLUMN_ICON = "ci";
    public static final String LIST_COLUMN_NAME = "cn";
    public static final String LIST_COLUMN_ORGUNIT = "cou";
    public static final String LIST_DETAIL_OTHEROU = "doo";
    public static final String LIST_IACTION_GROUPS = "iag";
    public static final String LIST_IACTION_USERS = "iau";
    public static final String LIST_ID = "lus";
    public static final String PATH_BUTTONS = "tools/accounts/buttons/";
    private static final I_CmsListItemComparator LIST_ITEM_COMPARATOR = new I_CmsListItemComparator(){

        public Comparator getComparator(final String columnId, Locale locale) {
            final Collator collator = Collator.getInstance(locale);
            final String overwriteAll = Messages.get().getBundle(locale).key("GUI_LABEL_OVERWRITEALL_0");
            final String allOthers = Messages.get().getBundle(locale).key("GUI_LABEL_ALLOTHERS_0");
            return new Comparator(){

                public int compare(Object o1, Object o2) {
                    String id2;
                    if (o1 == o2 || !(o1 instanceof CmsListItem) || !(o2 instanceof CmsListItem)) {
                        return 0;
                    }
                    CmsListItem li1 = (CmsListItem)o1;
                    CmsListItem li2 = (CmsListItem)o2;
                    String id1 = (String)li1.get(CmsPrincipalSelectionList.LIST_COLUMN_DISPLAY);
                    if (id1.equals(id2 = (String)li2.get(CmsPrincipalSelectionList.LIST_COLUMN_DISPLAY))) {
                        return 0;
                    }
                    if (id1.equals(overwriteAll)) {
                        return -1;
                    }
                    if (id1.equals(allOthers)) {
                        if (id2.equals(overwriteAll)) {
                            return 1;
                        }
                        return -1;
                    }
                    if (id2.equals(allOthers)) {
                        if (id1.equals(overwriteAll)) {
                            return -1;
                        }
                        return 1;
                    }
                    if (id2.equals(overwriteAll)) {
                        return 1;
                    }
                    Comparable c1 = (Comparable)li1.get(columnId);
                    Comparable c2 = (Comparable)li2.get(columnId);
                    if (c1 instanceof String && c2 instanceof String) {
                        return collator.compare(c1, c2);
                    }
                    if (c1 != null) {
                        if (c2 == null) {
                            return 1;
                        }
                        return c1.compareTo(c2);
                    }
                    if (c2 != null) {
                        return -1;
                    }
                    return 0;
                }
            };
        }
    };
    private Boolean m_hasPrincipalsInOtherOus;
    private String m_paramFlags;
    private String m_paramUseparent;

    public CmsPrincipalSelectionList(CmsJspActionElement jsp) {
        super(jsp, LIST_ID, Messages.get().container("GUI_PRINCIPALSELECTION_LIST_NAME_0"), LIST_COLUMN_DISPLAY, CmsListOrderEnum.ORDER_ASCENDING, null);
    }

    public CmsPrincipalSelectionList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    @Override
    public String dialogTitle() {
        StringBuffer html = new StringBuffer(512);
        html.append("<div class='screenTitle'>\n");
        html.append("\t<table width='100%' cellspacing='0'>\n");
        html.append("\t\t<tr>\n");
        html.append("\t\t\t<td>\n");
        if (this.getList().getMetadata().getIndependentAction(LIST_IACTION_USERS).isVisible()) {
            html.append(this.key("GUI_GROUPSELECTION_INTRO_TITLE_0"));
            this.getList().setName(Messages.get().container("GUI_GROUPSELECTION_LIST_NAME_0"));
            this.getList().getMetadata().getIndependentAction(LIST_DETAIL_OTHEROU);
        } else {
            html.append(this.key("GUI_USERSELECTION_INTRO_TITLE_1", new Object[]{""}));
            this.getList().setName(Messages.get().container("GUI_USERSELECTION_LIST_NAME_0"));
        }
        html.append("\n\t\t\t</td>");
        html.append("\t\t</tr>\n");
        html.append("\t</table>\n");
        html.append("</div>\n");
        return html.toString();
    }

    @Override
    public void executeListIndepActions() {
        if (LIST_IACTION_USERS.equals(this.getParamListAction())) {
            this.getList().getMetadata().getIndependentAction(LIST_IACTION_USERS).setVisible(false);
            this.getList().getMetadata().getIndependentAction(LIST_IACTION_GROUPS).setVisible(true);
        } else if (LIST_IACTION_GROUPS.equals(this.getParamListAction())) {
            this.getList().getMetadata().getIndependentAction(LIST_IACTION_USERS).setVisible(true);
            this.getList().getMetadata().getIndependentAction(LIST_IACTION_GROUPS).setVisible(false);
        }
        super.executeListIndepActions();
    }

    @Override
    public void executeListMultiActions() throws CmsRuntimeException {
        this.throwListUnsupportedActionException();
    }

    @Override
    public void executeListSingleActions() throws CmsRuntimeException {
        this.throwListUnsupportedActionException();
    }

    public String getIconPath(CmsListItem item) {
        boolean showingUsers = this.isShowingUsers();
        try {
            CmsPrincipal principal = showingUsers ? this.getCms().readUser((String)item.get(LIST_COLUMN_NAME)) : this.getCms().readGroup((String)item.get(LIST_COLUMN_NAME));
            if (principal.getOuFqn().equals(this.getCms().getRequestContext().getCurrentUser().getOuFqn())) {
                if (showingUsers) {
                    return "tools/accounts/buttons/user.png";
                }
                return "tools/accounts/buttons/group.png";
            }
            if (showingUsers) {
                return "tools/accounts/buttons/user_other_ou.png";
            }
            return "tools/accounts/buttons/group_other_ou.png";
        }
        catch (CmsException e) {
            if (item.get(LIST_COLUMN_DISPLAY).equals(this.key("GUI_LABEL_OVERWRITEALL_0"))) {
                return "commons/" + "OVERWRITE_ALL".toLowerCase() + ".png";
            }
            if (item.get(LIST_COLUMN_DISPLAY).equals(this.key("GUI_LABEL_ALLOTHERS_0"))) {
                return "commons/" + "ALL_OTHERS".toLowerCase() + ".png";
            }
            if (showingUsers) {
                return "tools/accounts/buttons/user.png";
            }
            return "tools/accounts/buttons/group.png";
        }
    }

    public String getParamFlags() {
        return this.m_paramFlags;
    }

    public String getParamUseparent() {
        return this.m_paramUseparent;
    }

    public boolean hasPrincipalsInOtherOus() {
        if (this.m_hasPrincipalsInOtherOus == null) {
            this.m_hasPrincipalsInOtherOus = Boolean.FALSE;
            try {
                for (CmsPrincipal principal : this.getPrincipals(true)) {
                    if (principal.getOuFqn().equals(this.getCms().getRequestContext().getCurrentUser().getOuFqn())) continue;
                    this.m_hasPrincipalsInOtherOus = Boolean.TRUE;
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.m_hasPrincipalsInOtherOus;
    }

    public boolean isShowingUsers() {
        return this.getList().getMetadata().getIndependentAction(LIST_IACTION_GROUPS).isVisible();
    }

    public void setParamFlags(String flags) {
        this.m_paramFlags = flags;
    }

    public void setParamUseparent(String useParent) {
        this.m_paramUseparent = useParent;
    }

    @Override
    protected void fillDetails(String detailId) {
    }

    @Override
    protected List<CmsListItem> getListItems() throws CmsException {
        ArrayList<CmsListItem> ret = new ArrayList<CmsListItem>();
        boolean withOtherOus = this.hasPrincipalsInOtherOus() && this.getList().getMetadata().getItemDetailDefinition(LIST_DETAIL_OTHEROU).isVisible();
        for (I_CmsPrincipal i_CmsPrincipal : this.getPrincipals(withOtherOus)) {
            CmsListItem item = this.getList().newItem(i_CmsPrincipal.getId().toString());
            item.set(LIST_COLUMN_NAME, i_CmsPrincipal.getName());
            I_CmsGroupNameTranslation translation = OpenCms.getWorkplaceManager().getGroupNameTranslation();
            if (i_CmsPrincipal.isGroup()) {
                item.set(LIST_COLUMN_DISPLAY, translation.translateGroupName(i_CmsPrincipal.getName(), false));
            } else {
                item.set(LIST_COLUMN_DISPLAY, i_CmsPrincipal.getSimpleName());
            }
            if (i_CmsPrincipal.isUser()) {
                if (i_CmsPrincipal.getId().equals(CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID) || i_CmsPrincipal.getId().equals(CmsAccessControlEntry.PRINCIPAL_OVERWRITE_ALL_ID)) {
                    item.set(LIST_COLUMN_DESCRIPTION, ((CmsUser)i_CmsPrincipal).getDescription(this.getLocale()));
                } else {
                    item.set(LIST_COLUMN_DESCRIPTION, ((CmsUser)i_CmsPrincipal).getFullName());
                }
            } else {
                item.set(LIST_COLUMN_DESCRIPTION, ((CmsGroup)i_CmsPrincipal).getDescription(this.getLocale()));
            }
            item.set(LIST_COLUMN_ORGUNIT, "/" + i_CmsPrincipal.getOuFqn());
            ret.add(item);
        }
        return ret;
    }

    protected List<CmsPrincipal> getPrincipals(boolean includeOtherOus) throws CmsException {
        String ou = this.getCms().getRequestContext().getCurrentUser().getOuFqn();
        HashSet<CmsPrincipal> principals = new HashSet<CmsPrincipal>();
        if (this.isShowingUsers()) {
            CmsUser user;
            if (OpenCms.getRoleManager().hasRole(this.getCms(), CmsRole.VFS_MANAGER)) {
                user = new CmsUser(CmsAccessControlEntry.PRINCIPAL_OVERWRITE_ALL_ID, this.key("GUI_LABEL_OVERWRITEALL_0"), "", "", "", "", 0L, 0, 0L, null);
                user.setDescription(this.key("GUI_DESCRIPTION_OVERWRITEALL_0"));
                principals.add(user);
            }
            user = new CmsUser(CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID, this.key("GUI_LABEL_ALLOTHERS_0"), "", "", "", "", 0L, 0, 0L, null);
            user.setDescription(this.key("GUI_DESCRIPTION_ALLOTHERS_0"));
            principals.add(user);
            if (includeOtherOus) {
                principals.addAll(OpenCms.getRoleManager().getManageableUsers(this.getCms(), "", true));
                principals.addAll(OpenCms.getOrgUnitManager().getUsers(this.getCms(), ou, true));
            } else {
                principals.addAll(OpenCms.getOrgUnitManager().getUsers(this.getCms(), ou, false));
            }
        } else {
            if (OpenCms.getRoleManager().hasRole(this.getCms(), CmsRole.VFS_MANAGER)) {
                principals.add(new CmsGroup(CmsAccessControlEntry.PRINCIPAL_OVERWRITE_ALL_ID, null, this.key("GUI_LABEL_OVERWRITEALL_0"), this.key("GUI_DESCRIPTION_OVERWRITEALL_0"), 0));
            }
            principals.add(new CmsGroup(CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID, null, this.key("GUI_LABEL_ALLOTHERS_0"), this.key("GUI_DESCRIPTION_ALLOTHERS_0"), 0));
            if (includeOtherOus) {
                principals.addAll(OpenCms.getRoleManager().getManageableGroups(this.getCms(), "", true));
                principals.addAll(OpenCms.getOrgUnitManager().getGroups(this.getCms(), ou, true));
            } else {
                principals.addAll(OpenCms.getOrgUnitManager().getGroups(this.getCms(), ou, false));
            }
        }
        ArrayList<CmsPrincipal> ret = new ArrayList<CmsPrincipal>(principals);
        if (this.getParamFlags() != null) {
            int flags = Integer.parseInt(this.getParamFlags());
            return new ArrayList<CmsPrincipal>(CmsPrincipal.filterFlag(ret, flags));
        }
        return ret;
    }

    @Override
    protected void initializeDetail(String detailId) {
        super.initializeDetail(detailId);
        if (detailId.equals(LIST_DETAIL_OTHEROU)) {
            boolean visible = this.hasPrincipalsInOtherOus() && this.getList().getMetadata().getItemDetailDefinition(LIST_DETAIL_OTHEROU).isVisible();
            this.getList().getMetadata().getColumnDefinition(LIST_COLUMN_ORGUNIT).setVisible(visible);
            this.getList().getMetadata().getColumnDefinition(LIST_COLUMN_ORGUNIT).setPrintable(visible);
        }
    }

    @Override
    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition iconCol = new CmsListColumnDefinition(LIST_COLUMN_ICON);
        iconCol.setName(Messages.get().container("GUI_PRINCIPALSELECTION_LIST_COLS_ICON_0"));
        iconCol.setHelpText(Messages.get().container("GUI_PRINCIPALSELECTION_LIST_COLS_ICON_HELP_0"));
        iconCol.setWidth("20");
        iconCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        iconCol.setSorteable(false);
        CmsListDirectAction iconAction = new CmsListDirectAction(LIST_ACTION_ICON){

            @Override
            public String getIconPath() {
                return ((CmsPrincipalSelectionList)this.getWp()).getIconPath(this.getItem());
            }
        };
        iconAction.setName(Messages.get().container("GUI_PRINCIPALSELECTION_LIST_ICON_NAME_0"));
        iconAction.setHelpText(Messages.get().container("GUI_PRINCIPALSELECTION_LIST_ICON_HELP_0"));
        iconAction.setEnabled(false);
        iconCol.addDirectAction(iconAction);
        metadata.addColumn(iconCol);
        CmsListColumnDefinition loginCol = new CmsListColumnDefinition(LIST_COLUMN_NAME);
        loginCol.setVisible(false);
        metadata.addColumn(loginCol);
        loginCol.setPrintable(false);
        CmsListColumnDefinition displayNameCol = new CmsListColumnDefinition(LIST_COLUMN_DISPLAY);
        displayNameCol.setName(Messages.get().container("GUI_PRINCIPALSELECTION_LIST_COLS_NAME_0"));
        displayNameCol.setWidth("40%");
        displayNameCol.setListItemComparator(LIST_ITEM_COMPARATOR);
        A_CmsListDefaultJsAction selectAction = new A_CmsListDefaultJsAction(LIST_ACTION_SELECT){

            @Override
            public String jsCode() {
                if (Boolean.parseBoolean(CmsPrincipalSelectionList.this.getParamUseparent())) {
                    return "parent.setPrincipalFormValue(" + (((CmsPrincipalSelectionList)this.getWp()).isShowingUsers() ? 1 : 0) + ",'" + this.getItem().get(CmsPrincipalSelectionList.LIST_COLUMN_NAME) + "');";
                }
                return "window.opener.setPrincipalFormValue(" + (((CmsPrincipalSelectionList)this.getWp()).isShowingUsers() ? 1 : 0) + ",'" + this.getItem().get(CmsPrincipalSelectionList.LIST_COLUMN_NAME) + "'); window.opener.focus(); window.close();";
            }
        };
        selectAction.setName(Messages.get().container("GUI_PRINCIPALSELECTION_LIST_ACTION_SELECT_NAME_0"));
        selectAction.setHelpText(Messages.get().container("GUI_PRINCIPALSELECTION_LIST_ACTION_SELECT_HELP_0"));
        displayNameCol.addDefaultAction(selectAction);
        metadata.addColumn(displayNameCol);
        CmsListColumnDefinition descriptionCol = new CmsListColumnDefinition(LIST_COLUMN_DESCRIPTION);
        descriptionCol.setName(Messages.get().container("GUI_PRINCIPALSELECTION_LIST_COLS_DESCRIPTION_0"));
        descriptionCol.setWidth("60%");
        descriptionCol.setTextWrapping(true);
        descriptionCol.setListItemComparator(LIST_ITEM_COMPARATOR);
        metadata.addColumn(descriptionCol);
        CmsListColumnDefinition ouCol = new CmsListColumnDefinition(LIST_COLUMN_ORGUNIT);
        ouCol.setName(Messages.get().container("GUI_PRINCIPALSELECTION_LIST_COLS_ORGUNIT_0"));
        ouCol.setWidth("40%");
        ouCol.setTextWrapping(true);
        ouCol.setListItemComparator(LIST_ITEM_COMPARATOR);
        metadata.addColumn(ouCol);
    }

    @Override
    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListItemDetails otherOuDetails = new CmsListItemDetails(LIST_DETAIL_OTHEROU);
        otherOuDetails.setVisible(false);
        otherOuDetails.setHideAction(new CmsListIndependentAction(LIST_DETAIL_OTHEROU){

            @Override
            public CmsMessageContainer getHelpText() {
                if (this.getWp().getList().getMetadata().getIndependentAction(CmsPrincipalSelectionList.LIST_IACTION_USERS).isVisible()) {
                    return Messages.get().container("GUI_GROUPS_DETAIL_HIDE_OTHEROU_HELP_0");
                }
                return Messages.get().container("GUI_USERS_DETAIL_HIDE_OTHEROU_HELP_0");
            }

            @Override
            public String getIconPath() {
                return "list/details_hide.png";
            }

            @Override
            public CmsMessageContainer getName() {
                if (this.getWp().getList().getMetadata().getIndependentAction(CmsPrincipalSelectionList.LIST_IACTION_USERS).isVisible()) {
                    return Messages.get().container("GUI_GROUPS_DETAIL_HIDE_OTHEROU_NAME_0");
                }
                return Messages.get().container("GUI_USERS_DETAIL_HIDE_OTHEROU_NAME_0");
            }

            @Override
            public boolean isVisible() {
                return ((CmsPrincipalSelectionList)this.getWp()).hasPrincipalsInOtherOus();
            }
        });
        otherOuDetails.setShowAction(new CmsListIndependentAction(LIST_DETAIL_OTHEROU){

            @Override
            public CmsMessageContainer getHelpText() {
                if (this.getWp().getList().getMetadata().getIndependentAction(CmsPrincipalSelectionList.LIST_IACTION_USERS).isVisible()) {
                    return Messages.get().container("GUI_GROUPS_DETAIL_SHOW_OTHEROU_HELP_0");
                }
                return Messages.get().container("GUI_USERS_DETAIL_SHOW_OTHEROU_HELP_0");
            }

            @Override
            public String getIconPath() {
                return "list/details_show.png";
            }

            @Override
            public CmsMessageContainer getName() {
                if (this.getWp().getList().getMetadata().getIndependentAction(CmsPrincipalSelectionList.LIST_IACTION_USERS).isVisible()) {
                    return Messages.get().container("GUI_GROUPS_DETAIL_SHOW_OTHEROU_NAME_0");
                }
                return Messages.get().container("GUI_USERS_DETAIL_SHOW_OTHEROU_NAME_0");
            }

            @Override
            public boolean isVisible() {
                return ((CmsPrincipalSelectionList)this.getWp()).hasPrincipalsInOtherOus();
            }
        });
        otherOuDetails.setName(Messages.get().container("GUI_PRINCIPALS_DETAIL_OTHEROU_NAME_0"));
        otherOuDetails.setFormatter(new CmsListItemDetailsFormatter(Messages.get().container("GUI_PRINCIPALS_DETAIL_OTHEROU_NAME_0")));
        metadata.addItemDetails(otherOuDetails);
        CmsListIndependentAction usersAction = new CmsListIndependentAction(LIST_IACTION_USERS);
        usersAction.setName(Messages.get().container("GUI_PRINCIPALS_IA_USERS_NAME_0"));
        usersAction.setHelpText(Messages.get().container("GUI_PRINCIPALS_IA_USERS_HELP_0"));
        usersAction.setIconPath("tools/accounts/buttons/user.png");
        usersAction.setVisible(true);
        metadata.addIndependentAction(usersAction);
        CmsListIndependentAction groupsAction = new CmsListIndependentAction(LIST_IACTION_GROUPS);
        groupsAction.setName(Messages.get().container("GUI_PRINCIPALS_IA_GROUPS_NAME_0"));
        groupsAction.setHelpText(Messages.get().container("GUI_PRINCIPALS_IA_GROUPS_HELP_0"));
        groupsAction.setIconPath("tools/accounts/buttons/group.png");
        groupsAction.setVisible(false);
        metadata.addIndependentAction(groupsAction);
        CmsListSearchAction searchAction = new CmsListSearchAction(metadata.getColumnDefinition(LIST_COLUMN_DISPLAY));
        searchAction.addColumn(metadata.getColumnDefinition(LIST_COLUMN_DESCRIPTION));
        searchAction.setCaseInSensitive(true);
        metadata.setSearchAction(searchAction);
    }

    @Override
    protected void setMultiActions(CmsListMetadata metadata) {
    }

    @Override
    protected void validateParamaters() throws Exception {
        try {
            Integer.valueOf(this.getParamFlags());
        }
        catch (Throwable e) {
            this.setParamFlags(null);
        }
    }
}

