/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.search.CmsSearch;
import org.opencms.search.CmsSearchParameters;
import org.opencms.search.CmsSearchResult;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.workplace.list.A_CmsListExplorerDialog;
import org.opencms.workplace.list.A_CmsListResourceCollector;
import org.opencms.workplace.list.CmsListItem;

public class CmsSearchResourcesCollector
extends A_CmsListResourceCollector {
    public static final String COLLECTOR_NAME = "searchresources";
    public static final String PARAM_FIELDS = "fields";
    public static final String PARAM_INDEXNAME = "indexName";
    public static final String PARAM_MAXCREATIONDATE = "maxCreationDate";
    public static final String PARAM_MAXLASTMODIFICATIONDATE = "maxLastModificationDate";
    public static final String PARAM_MINCREATIONDATE = "minCreationDate";
    public static final String PARAM_MINLASTMODIFICATIONDATE = "minLastModificationDate";
    public static final String PARAM_QUERY = "query";
    public static final String PARAM_SORT = "sort";
    protected Map<String, CmsSearchResult> m_srCache = new HashMap<String, CmsSearchResult>();
    private CmsSearch m_searchBean;
    private List<CmsSearchResult> m_searchResults;
    private static final Log LOG = CmsLog.getLog(CmsSearchResourcesCollector.class);

    public CmsSearchResourcesCollector(A_CmsListExplorerDialog wp, String query, String sort, String fields, List<String> searchRoots, String minCreationDate, String maxCreationDate, String minLastModificationDate, String maxLastModificationDate, String indexName) {
        super(wp);
        this.m_collectorParameter = this.m_collectorParameter + "|indexName:" + indexName;
        this.m_collectorParameter = this.m_collectorParameter + "|query:" + query;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(sort)) {
            this.m_collectorParameter = this.m_collectorParameter + "|sort:" + sort;
        }
        this.m_collectorParameter = this.m_collectorParameter + "|fields:" + fields;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(minCreationDate) && !minCreationDate.equals("0")) {
            this.m_collectorParameter = this.m_collectorParameter + "|minCreationDate:" + minCreationDate;
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(maxCreationDate) && !maxCreationDate.equals("0")) {
            this.m_collectorParameter = this.m_collectorParameter + "|maxCreationDate:" + maxCreationDate;
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(minLastModificationDate) && !minLastModificationDate.equals("0")) {
            this.m_collectorParameter = this.m_collectorParameter + "|minLastModificationDate:" + minLastModificationDate;
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(maxLastModificationDate) && !maxLastModificationDate.equals("0")) {
            this.m_collectorParameter = this.m_collectorParameter + "|maxLastModificationDate:" + maxLastModificationDate;
        }
        this.setResourcesParam(searchRoots);
    }

    @Override
    public List<String> getCollectorNames() {
        return Arrays.asList(COLLECTOR_NAME);
    }

    @Override
    public List<CmsResource> getResources(CmsObject cms, Map<String, String> params) {
        List<CmsSearchResult> result = this.getSearchResults(params);
        ArrayList<CmsResource> resources = new ArrayList<CmsResource>();
        String siteRoot = cms.getRequestContext().getSiteRoot();
        int siteLen = siteRoot.length();
        for (CmsSearchResult sr : result) {
            try {
                String resultPath = sr.getPath();
                if (resultPath.startsWith(siteRoot)) {
                    resultPath = sr.getPath().substring(siteLen);
                }
                CmsResource resource = cms.readResource(resultPath, CmsResourceFilter.ALL);
                this.m_resCache.put(resource.getStructureId().toString(), resource);
                this.m_srCache.put(resource.getStructureId().toString(), sr);
                resources.add(resource);
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return resources;
    }

    public CmsSearchResult getSearchResult(String structureId) {
        return this.m_srCache.get(structureId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPage(int page) {
        CmsSearchResourcesCollector cmsSearchResourcesCollector = this;
        synchronized (cmsSearchResourcesCollector) {
            super.setPage(page);
            this.m_searchBean = null;
            this.m_searchResults = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<CmsResource> getInternalResources(CmsObject cms, Map<String, String> params) {
        CmsSearchResourcesCollector cmsSearchResourcesCollector = this;
        synchronized (cmsSearchResourcesCollector) {
            if (this.m_resources == null) {
                this.m_resources = this.getResources(cms, params);
            }
        }
        return this.m_resources;
    }

    @Override
    protected void setAdditionalColumns(CmsListItem item, CmsResourceUtil resUtil) {
        item.set("cs", new Integer(this.getSearchResult(item.getId()).getScore()));
    }

    private CmsSearch getSearchBean(Map<String, String> params) {
        if (this.m_searchBean == null) {
            this.m_searchBean = new CmsSearch();
            this.m_searchBean.init(this.getWp().getCms());
            this.m_searchBean.setParameters(this.getSearchParameters(params));
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_searchBean.getIndex())) {
                this.m_searchBean.setIndex(this.getWp().getSettings().getUserSettings().getWorkplaceSearchIndexName());
            }
            this.m_searchBean.setMatchesPerPage(this.getWp().getSettings().getUserSettings().getExplorerFileEntries());
            this.m_searchBean.setSearchPage(Integer.parseInt(params.get("page")));
            List<String> resources = this.getResourceNamesFromParam(params);
            String[] searchRoots = new String[resources.size()];
            resources.toArray(searchRoots);
            this.m_searchBean.setSearchRoots(searchRoots);
        } else {
            int page = Integer.parseInt(params.get("page"));
            if (this.m_searchBean.getSearchPage() != page) {
                this.m_searchBean.setSearchPage(page);
                this.m_searchResults = null;
            }
        }
        return this.m_searchBean;
    }

    private CmsSearchParameters getSearchParameters(Map<String, String> params) {
        CmsSearchParameters searchParams = new CmsSearchParameters();
        searchParams.setQuery(params.get(PARAM_QUERY));
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(params.get(PARAM_SORT))) {
            searchParams.setSortName(params.get(PARAM_SORT));
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(params.get(PARAM_MINCREATIONDATE))) {
            searchParams.setMinDateCreated(Long.parseLong(params.get(PARAM_MINCREATIONDATE)));
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(params.get(PARAM_MAXCREATIONDATE))) {
            searchParams.setMaxDateCreated(Long.parseLong(params.get(PARAM_MAXCREATIONDATE)));
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(params.get(PARAM_MINLASTMODIFICATIONDATE))) {
            searchParams.setMinDateLastModified(Long.parseLong(params.get(PARAM_MINLASTMODIFICATIONDATE)));
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(params.get(PARAM_MAXLASTMODIFICATIONDATE))) {
            searchParams.setMaxDateLastModified(Long.parseLong(params.get(PARAM_MAXLASTMODIFICATIONDATE)));
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(params.get(PARAM_INDEXNAME))) {
            searchParams.setIndex(params.get(PARAM_INDEXNAME));
        }
        List<String> fields = CmsStringUtil.splitAsList(params.get(PARAM_FIELDS), ',');
        searchParams.setFields(fields);
        searchParams.setSearchPage(Integer.parseInt(params.get("page")));
        return searchParams;
    }

    private List<CmsSearchResult> getSearchResults(Map<String, String> params) {
        if (this.m_searchResults == null) {
            this.m_searchResults = this.getSearchBean(params).getSearchResult();
        }
        return this.m_searchResults;
    }
}

