/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.list.NodeCachingLinkedList;
import org.opencms.ade.configuration.CmsElementView;
import org.opencms.file.CmsObject;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.content.CmsXmlContent;

public final class CmsADESessionCache {
    public static final String SESSION_ATTR_ADE_CACHE = "__OCMS_ADE_CACHE__";
    private Map<String, CmsContainerElementBean> m_containerElements;
    private CmsUUID m_elementView;
    private boolean m_isEditSmallElements;
    private List<CmsContainerElementBean> m_recentLists;
    private Map<String, CmsJspStandardContextBean.TemplateBean> m_templateBeanCache = new HashMap<String, CmsJspStandardContextBean.TemplateBean>();
    private boolean m_toolbarVisible;
    private Map<CmsUUID, CmsXmlContent> m_xmlContents;

    protected CmsADESessionCache(CmsObject cms, HttpServletRequest request) {
        HashMap lruMapCntElem = new HashMap();
        this.m_containerElements = Collections.synchronizedMap(lruMapCntElem);
        int maxElems = 10;
        maxElems = OpenCms.getADEManager().getRecentListMaxSize(cms.getRequestContext().getCurrentUser());
        List adeRecentList = CmsCollectionsGenericWrapper.list(new NodeCachingLinkedList(maxElems));
        this.m_recentLists = Collections.synchronizedList(adeRecentList);
        this.m_xmlContents = Collections.synchronizedMap(new HashMap());
        String elementView = null;
        if (request != null) {
            elementView = CmsWorkplace.getWorkplaceSettings(cms, request).getUserSettings().getAdditionalPreference("elementView", false);
        }
        if (elementView == null) {
            this.m_elementView = CmsElementView.DEFAULT_ELEMENT_VIEW.getId();
        } else {
            try {
                this.m_elementView = new CmsUUID(elementView);
            }
            catch (NumberFormatException e) {
                this.m_elementView = CmsElementView.DEFAULT_ELEMENT_VIEW.getId();
            }
        }
    }

    public static CmsADESessionCache getCache(HttpServletRequest request, CmsObject cms) {
        CmsADESessionCache cache = (CmsADESessionCache)request.getSession().getAttribute(SESSION_ATTR_ADE_CACHE);
        if (cache == null) {
            cache = new CmsADESessionCache(cms, request);
            request.getSession().setAttribute(SESSION_ATTR_ADE_CACHE, (Object)cache);
        }
        return cache;
    }

    public CmsContainerElementBean getCacheContainerElement(String key) {
        return this.m_containerElements.get(key);
    }

    public CmsXmlContent getCacheXmlContent(CmsUUID structureId) {
        return this.m_xmlContents.get(structureId);
    }

    public CmsUUID getElementView() {
        return this.m_elementView;
    }

    public List<CmsContainerElementBean> getRecentList() {
        return this.m_recentLists;
    }

    public CmsJspStandardContextBean.TemplateBean getTemplateBean(String uri, boolean safe) {
        CmsJspStandardContextBean.TemplateBean templateBean = this.m_templateBeanCache.get(uri);
        if (templateBean != null || !safe) {
            return templateBean;
        }
        return new CmsJspStandardContextBean.TemplateBean("", "");
    }

    public boolean isEditSmallElements() {
        return this.m_isEditSmallElements;
    }

    public boolean isToolbarVisible() {
        return this.m_toolbarVisible;
    }

    public void setCacheContainerElement(String key, CmsContainerElementBean containerElement) {
        this.m_containerElements.put(key, containerElement);
    }

    public void setCacheRecentList(List<CmsContainerElementBean> list) {
        this.m_recentLists.clear();
        this.m_recentLists.addAll(list);
        for (CmsContainerElementBean element : this.m_recentLists) {
            this.setCacheContainerElement(element.editorHash(), element);
        }
    }

    public void setCacheXmlContent(CmsUUID structureId, CmsXmlContent xmlContent) {
        this.m_xmlContents.put(structureId, xmlContent);
    }

    public void setEditSmallElements(boolean editSmallElements) {
        this.m_isEditSmallElements = editSmallElements;
    }

    public void setElementView(CmsUUID elementView) {
        this.m_elementView = elementView;
    }

    public void setTemplateBean(String uri, CmsJspStandardContextBean.TemplateBean templateBean) {
        this.m_templateBeanCache.put(uri, templateBean);
    }

    public void setToolbarVisible(boolean toolbarVisible) {
        this.m_toolbarVisible = toolbarVisible;
    }

    public void uncacheXmlContent(CmsUUID structureId) {
        this.m_xmlContents.remove(structureId);
    }
}

