/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.xml.containerpage.CmsDynamicFunctionBean;
import org.opencms.xml.containerpage.CmsDynamicFunctionParser;
import org.opencms.xml.containerpage.CmsFormatterBean;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.containerpage.CmsSchemaFormatterBeanWrapper;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.content.CmsDefaultXmlContentHandler;
import org.opencms.xml.content.CmsXmlContentProperty;

public class CmsXmlDynamicFunctionHandler
extends CmsDefaultXmlContentHandler {
    public static final String FORMATTER_PATH = "/system/modules/org.opencms.ade.containerpage/formatters/function.jsp";
    public static final String N_CONTAINER_SETTINGS = "ContainerSettings";
    public static final String TYPE_FUNCTION = "function";

    @Override
    public CmsFormatterConfiguration getFormatterConfiguration(CmsObject cms, CmsResource resource) {
        try {
            CmsDynamicFunctionParser parser = new CmsDynamicFunctionParser();
            CmsDynamicFunctionBean functionBean = parser.parseFunctionBean(cms, resource);
            List<CmsFormatterBean> formatters = functionBean.getFormatters();
            ArrayList<I_CmsFormatterBean> wrappers = new ArrayList<I_CmsFormatterBean>();
            for (CmsFormatterBean formatter : formatters) {
                wrappers.add(new CmsSchemaFormatterBeanWrapper(cms, formatter, this, resource));
            }
            return CmsFormatterConfiguration.create(cms, wrappers);
        }
        catch (CmsException e) {
            return CmsFormatterConfiguration.EMPTY_CONFIGURATION;
        }
    }

    @Override
    public Map<String, CmsXmlContentProperty> getSettings(CmsObject cms, CmsResource res) {
        try {
            CmsDynamicFunctionParser parser = new CmsDynamicFunctionParser();
            CmsDynamicFunctionBean functionBean = parser.parseFunctionBean(cms, res);
            return functionBean.getSettings();
        }
        catch (CmsException e) {
            return Collections.emptyMap();
        }
    }

    @Override
    public boolean hasModifiableFormatters() {
        return false;
    }
}

