/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.types;

import java.util.Locale;
import java.util.regex.Pattern;
import org.dom4j.Element;
import org.opencms.xml.I_CmsXmlDocument;
import org.opencms.xml.types.A_CmsXmlValueTextBase;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public class CmsXmlColorValue
extends A_CmsXmlValueTextBase {
    public static final String TYPE_NAME = "OpenCmsColor";
    public static final String TYPE_RULE = "(#([a-f]|[A-F]|[0-9]){3}(([a-f]|[A-F]|[0-9]){3})?)|ActiveBorder|ActiveCaption|ActiveCaptionText|AppWorkspace|Background|ButtonFace|ButtonHighlight|ButtonShadow|ButtonText|CaptionText|GrayText|Highlight|HighlightText|InactiveBorder|InactiveCaption|InactiveCaptionText|InfoBackground|InfoBackground|InfoText|MenuText|Menu|ScrollBar|ThreeDDarkShadow|ThreeDFace|ThreeDHighlight|ThreeDLightShadow|ThreeDShadow|Window|WindowFrame|WindowText";
    private static final Pattern TYPE_PATTERN = Pattern.compile("(#([a-f]|[A-F]|[0-9]){3}(([a-f]|[A-F]|[0-9]){3})?)|ActiveBorder|ActiveCaption|ActiveCaptionText|AppWorkspace|Background|ButtonFace|ButtonHighlight|ButtonShadow|ButtonText|CaptionText|GrayText|Highlight|HighlightText|InactiveBorder|InactiveCaption|InactiveCaptionText|InfoBackground|InfoBackground|InfoText|MenuText|Menu|ScrollBar|ThreeDDarkShadow|ThreeDFace|ThreeDHighlight|ThreeDLightShadow|ThreeDShadow|Window|WindowFrame|WindowText");

    public CmsXmlColorValue() {
    }

    public CmsXmlColorValue(I_CmsXmlDocument document, Element element, Locale locale, I_CmsXmlSchemaType type) {
        super(document, element, locale, type);
    }

    public CmsXmlColorValue(String name, String minOccurs, String maxOccurs) {
        super(name, minOccurs, maxOccurs);
    }

    @Override
    public I_CmsXmlContentValue createValue(I_CmsXmlDocument document, Element element, Locale locale) {
        return new CmsXmlColorValue(document, element, locale, this);
    }

    @Override
    public String getDefault(Locale locale) {
        if (this.m_defaultValue != null) {
            return this.m_defaultValue;
        }
        return "#000000";
    }

    @Override
    public String getSchemaDefinition() {
        return "<xsd:simpleType name=\"OpenCmsColor\"><xsd:restriction base=\"xsd:string\"><xsd:pattern value=\"(#([a-f]|[A-F]|[0-9]){3}(([a-f]|[A-F]|[0-9]){3})?)|ActiveBorder|ActiveCaption|ActiveCaptionText|AppWorkspace|Background|ButtonFace|ButtonHighlight|ButtonShadow|ButtonText|CaptionText|GrayText|Highlight|HighlightText|InactiveBorder|InactiveCaption|InactiveCaptionText|InfoBackground|InfoBackground|InfoText|MenuText|Menu|ScrollBar|ThreeDDarkShadow|ThreeDFace|ThreeDHighlight|ThreeDLightShadow|ThreeDShadow|Window|WindowFrame|WindowText\" /></xsd:restriction></xsd:simpleType>";
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isSearchable() {
        return false;
    }

    @Override
    public I_CmsXmlSchemaType newInstance(String name, String minOccurs, String maxOccurs) {
        return new CmsXmlColorValue(name, minOccurs, maxOccurs);
    }

    @Override
    public boolean validateValue(String value) {
        return TYPE_PATTERN.matcher(value).matches();
    }
}

