/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.types;

import java.util.Locale;
import java.util.regex.Pattern;
import org.dom4j.Element;
import org.opencms.xml.I_CmsXmlDocument;
import org.opencms.xml.types.A_CmsXmlValueTextBase;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public class CmsXmlLocaleValue
extends A_CmsXmlValueTextBase {
    public static final String TYPE_NAME = "OpenCmsLocale";
    public static final String TYPE_RULE = "[a-z]{2,3}(_[A-Z]{2}(_[a-zA-Z0-9]+){0,1}){0,1}";
    private static final Pattern TYPE_PATTERN = Pattern.compile("[a-z]{2,3}(_[A-Z]{2}(_[a-zA-Z0-9]+){0,1}){0,1}");

    public CmsXmlLocaleValue() {
    }

    public CmsXmlLocaleValue(I_CmsXmlDocument document, Element element, Locale locale, I_CmsXmlSchemaType type) {
        super(document, element, locale, type);
    }

    public CmsXmlLocaleValue(String name, String minOccurs, String maxOccurs) {
        super(name, minOccurs, maxOccurs);
    }

    @Override
    public I_CmsXmlContentValue createValue(I_CmsXmlDocument document, Element element, Locale locale) {
        return new CmsXmlLocaleValue(document, element, locale, this);
    }

    @Override
    public String getSchemaDefinition() {
        return "<xsd:simpleType name=\"OpenCmsLocale\"><xsd:restriction base=\"xsd:string\"><xsd:pattern value=\"[a-z]{2,3}(_[A-Z]{2}(_[a-zA-Z0-9]+){0,1}){0,1}\" /></xsd:restriction></xsd:simpleType>";
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isSearchable() {
        return false;
    }

    @Override
    public I_CmsXmlSchemaType newInstance(String name, String minOccurs, String maxOccurs) {
        return new CmsXmlLocaleValue(name, minOccurs, maxOccurs);
    }

    @Override
    public boolean validateValue(String value) {
        return TYPE_PATTERN.matcher(value).matches();
    }
}

