/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsADEConfigDataInternal;
import org.opencms.ade.configuration.CmsElementView;
import org.opencms.ade.detailpage.CmsDetailPageInfo;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsADEConfigCacheState {
    private static final Log LOG = CmsLog.getLog(CmsADEConfigCacheState.class);
    private CmsObject m_cms;
    private volatile Set<String> m_detailPageTypes;
    private Map<String, String> m_folderTypes = new HashMap<String, String>();
    private CmsADEConfigData m_moduleConfiguration;
    private List<CmsADEConfigDataInternal> m_moduleConfigurations;
    private Map<CmsUUID, CmsADEConfigDataInternal> m_siteConfigurations = new HashMap<CmsUUID, CmsADEConfigDataInternal>();
    private Map<String, CmsADEConfigDataInternal> m_siteConfigurationsByPath = new HashMap<String, CmsADEConfigDataInternal>();
    private Map<CmsUUID, CmsElementView> m_elementViews;

    public CmsADEConfigCacheState(CmsObject cms, Map<CmsUUID, CmsADEConfigDataInternal> siteConfigurations, List<CmsADEConfigDataInternal> moduleConfigs, Map<CmsUUID, CmsElementView> elementViews) {
        this.m_cms = cms;
        this.m_siteConfigurations = siteConfigurations;
        this.m_moduleConfigurations = moduleConfigs;
        this.m_elementViews = elementViews;
        for (CmsADEConfigDataInternal data : siteConfigurations.values()) {
            if (data.getBasePath() != null) {
                this.m_siteConfigurationsByPath.put(data.getBasePath(), data);
                continue;
            }
            LOG.warn((Object)"Empty base path for sitemap configuration!");
        }
        this.m_moduleConfiguration = this.wrap(this.mergeConfigurations(moduleConfigs));
        try {
            this.m_folderTypes = this.computeFolderTypes();
        }
        catch (Exception e) {
            this.m_folderTypes = Maps.newHashMap();
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static CmsADEConfigCacheState emptyState(CmsObject cms) {
        return new CmsADEConfigCacheState(cms, Collections.<CmsUUID, CmsADEConfigDataInternal>emptyMap(), Collections.<CmsADEConfigDataInternal>emptyList(), Collections.<CmsUUID, CmsElementView>emptyMap());
    }

    public Map<String, String> computeFolderTypes() throws CmsException {
        HashMap folderTypes = Maps.newHashMap();
        if (this.m_moduleConfiguration != null) {
            folderTypes.putAll(this.m_moduleConfiguration.getFolderTypes());
        }
        ArrayList<CmsADEConfigDataInternal> configDataObjects = new ArrayList<CmsADEConfigDataInternal>(this.m_siteConfigurationsByPath.values());
        for (CmsADEConfigDataInternal configData : configDataObjects) {
            folderTypes.putAll(this.wrap(configData).getFolderTypes());
        }
        return folderTypes;
    }

    public CmsADEConfigCacheState createUpdatedCopy(Map<CmsUUID, CmsADEConfigDataInternal> sitemapUpdates, List<CmsADEConfigDataInternal> moduleUpdates, Map<CmsUUID, CmsElementView> elementViewUpdates) {
        HashMap newSitemapConfigs = Maps.newHashMap(this.m_siteConfigurations);
        if (sitemapUpdates != null) {
            for (Map.Entry<CmsUUID, CmsADEConfigDataInternal> entry : sitemapUpdates.entrySet()) {
                CmsUUID key = entry.getKey();
                CmsADEConfigDataInternal value = entry.getValue();
                if (value != null) {
                    newSitemapConfigs.put(key, value);
                    continue;
                }
                newSitemapConfigs.remove(key);
            }
        }
        List<CmsADEConfigDataInternal> newModuleConfigs = this.m_moduleConfigurations;
        if (moduleUpdates != null) {
            newModuleConfigs = moduleUpdates;
        }
        Map<CmsUUID, CmsElementView> newElementViews = this.m_elementViews;
        if (elementViewUpdates != null) {
            newElementViews = elementViewUpdates;
        }
        return new CmsADEConfigCacheState(this.m_cms, newSitemapConfigs, newModuleConfigs, newElementViews);
    }

    public Set<String> getDetailPageTypes() {
        if (this.m_detailPageTypes != null) {
            return this.m_detailPageTypes;
        }
        HashSet<String> result = new HashSet<String>();
        for (CmsADEConfigDataInternal configData : this.m_siteConfigurationsByPath.values()) {
            List<CmsDetailPageInfo> detailPageInfos = configData.getOwnDetailPages();
            for (CmsDetailPageInfo info : detailPageInfos) {
                result.add(info.getType());
            }
        }
        this.m_detailPageTypes = result;
        return result;
    }

    public Map<CmsUUID, CmsElementView> getElementViews() {
        return Collections.unmodifiableMap(this.m_elementViews);
    }

    public Map<String, String> getFolderTypes() {
        return Collections.unmodifiableMap(this.m_folderTypes);
    }

    public String getParentFolderType(String rootPath) {
        String parent = CmsResource.getParentFolder(rootPath);
        if (parent == null) {
            return null;
        }
        String type = this.m_folderTypes.get(parent);
        return type;
    }

    public Set<String> getSiteConfigurationPaths() {
        return this.m_siteConfigurationsByPath.keySet();
    }

    public CmsADEConfigData lookupConfiguration(String rootPath) {
        CmsADEConfigDataInternal internalSiteConfig = this.getSiteConfigData(rootPath);
        CmsADEConfigData result = internalSiteConfig == null ? this.m_moduleConfiguration : this.wrap(internalSiteConfig);
        return result;
    }

    public CmsADEConfigData wrap(CmsADEConfigDataInternal config) {
        return new CmsADEConfigData(config, this);
    }

    protected List<CmsDetailPageInfo> getAllDetailPages() {
        ArrayList<CmsDetailPageInfo> result = new ArrayList<CmsDetailPageInfo>();
        for (CmsADEConfigDataInternal configData : this.m_siteConfigurationsByPath.values()) {
            result.addAll(this.wrap(configData).getAllDetailPages(true));
        }
        return result;
    }

    protected CmsObject getCms() {
        return this.m_cms;
    }

    protected List<String> getDetailPages(String type) {
        ArrayList<String> result = new ArrayList<String>();
        for (CmsADEConfigDataInternal configData : this.m_siteConfigurationsByPath.values()) {
            for (CmsDetailPageInfo pageInfo : this.wrap(configData).getDetailPagesForType(type)) {
                result.add(pageInfo.getUri());
            }
        }
        return result;
    }

    protected CmsADEConfigData getModuleConfiguration() {
        return this.m_moduleConfiguration;
    }

    protected CmsADEConfigDataInternal getSiteConfigData(String path) {
        if (path == null) {
            return null;
        }
        String normalizedPath = CmsStringUtil.joinPaths("/", path, "/");
        ArrayList<String> prefixes = new ArrayList<String>();
        ArrayList<String> parents = new ArrayList<String>();
        String currentPath = normalizedPath;
        while (currentPath != null) {
            parents.add(currentPath);
            currentPath = CmsResource.getParentFolder(currentPath);
        }
        for (String parent : parents) {
            if (!this.m_siteConfigurationsByPath.containsKey(parent)) continue;
            prefixes.add(parent);
        }
        if (prefixes.size() == 0) {
            return null;
        }
        Collections.sort(prefixes);
        return this.m_siteConfigurationsByPath.get(prefixes.get(prefixes.size() - 1));
    }

    protected boolean isDetailPage(CmsObject cms, CmsResource resource) {
        CmsResource folder;
        if (resource.isFile()) {
            if (!CmsResourceTypeXmlContainerPage.isContainerPage(resource)) {
                return false;
            }
            try {
                folder = this.getCms().readResource(CmsResource.getParentFolder(resource.getRootPath()));
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return false;
            }
        } else {
            folder = resource;
        }
        ArrayList<CmsDetailPageInfo> allDetailPages = new ArrayList<CmsDetailPageInfo>();
        for (CmsADEConfigDataInternal configData : this.m_siteConfigurationsByPath.values()) {
            List<CmsDetailPageInfo> detailPageInfos = this.wrap(configData).getAllDetailPages();
            allDetailPages.addAll(detailPageInfos);
        }
        for (CmsDetailPageInfo info : allDetailPages) {
            if (!folder.getStructureId().equals(info.getId()) && !folder.getRootPath().equals(info.getUri()) && !resource.getStructureId().equals(info.getId()) && !resource.getRootPath().equals(info.getUri())) continue;
            return true;
        }
        String normalizedFolderRootPath = CmsStringUtil.joinPaths(folder.getRootPath(), "/");
        for (CmsDetailPageInfo info : allDetailPages) {
            String parentPath = CmsResource.getParentFolder(info.getUri());
            String normalizedParentPath = CmsStringUtil.joinPaths(parentPath, "/");
            if (!normalizedParentPath.equals(normalizedFolderRootPath)) continue;
            try {
                CmsResource infoResource = this.getCms().readResource(info.getId());
                if (!infoResource.isFile()) continue;
                return true;
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return false;
    }

    protected CmsADEConfigDataInternal mergeConfigurations(List<CmsADEConfigDataInternal> configurations) {
        if (configurations.isEmpty()) {
            return new CmsADEConfigDataInternal(null);
        }
        for (int i = 0; i < configurations.size() - 1; ++i) {
            configurations.get(i + 1).mergeParent(configurations.get(i));
        }
        CmsADEConfigDataInternal result = configurations.get(configurations.size() - 1);
        result.processModuleOrdering();
        return result;
    }
}

