/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsFunctionReference;
import org.opencms.ade.configuration.CmsModelPageConfig;
import org.opencms.ade.configuration.CmsPropertyConfig;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.ade.configuration.formatters.CmsFormatterChangeSet;
import org.opencms.ade.detailpage.CmsDetailPageInfo;
import org.opencms.file.CmsResource;

public class CmsADEConfigDataInternal {
    protected boolean m_createContentsLocally;
    protected boolean m_discardInheritedModelPages;
    protected boolean m_discardInheritedProperties;
    protected boolean m_discardInheritedTypes;
    protected CmsFormatterChangeSet m_formatterChangeSet = new CmsFormatterChangeSet();
    protected boolean m_isModuleConfig;
    private String m_basePath;
    private List<CmsFunctionReference> m_functionReferences = Lists.newArrayList();
    private List<CmsDetailPageInfo> m_ownDetailPages = Lists.newArrayList();
    private List<CmsModelPageConfig> m_ownModelPageConfig = Lists.newArrayList();
    private List<CmsPropertyConfig> m_ownPropertyConfigurations = Lists.newArrayList();
    private List<CmsResourceTypeConfig> m_ownResourceTypes = Lists.newArrayList();
    private CmsResource m_resource;
    private boolean m_preferDetailPagesForLocalContents;

    public CmsADEConfigDataInternal(CmsResource resource, boolean isModuleConfig, String basePath, List<CmsResourceTypeConfig> resourceTypeConfig, boolean discardInheritedTypes, List<CmsPropertyConfig> propertyConfig, boolean discardInheritedProperties, List<CmsDetailPageInfo> detailPageInfos, List<CmsModelPageConfig> modelPages, List<CmsFunctionReference> functionReferences, boolean discardInheritedModelPages, boolean createContentsLocally, boolean preferDetailPagesForLocalContents, CmsFormatterChangeSet formatterChangeSet) {
        this.m_resource = resource;
        this.m_basePath = basePath;
        this.m_ownResourceTypes = resourceTypeConfig;
        this.m_ownPropertyConfigurations = propertyConfig;
        this.m_ownModelPageConfig = modelPages;
        this.m_ownDetailPages = detailPageInfos;
        this.m_functionReferences = functionReferences;
        this.m_isModuleConfig = isModuleConfig;
        this.m_discardInheritedTypes = discardInheritedTypes;
        this.m_discardInheritedProperties = discardInheritedProperties;
        this.m_discardInheritedModelPages = discardInheritedModelPages;
        this.m_createContentsLocally = createContentsLocally;
        this.m_preferDetailPagesForLocalContents = preferDetailPagesForLocalContents;
        this.m_formatterChangeSet = formatterChangeSet;
    }

    public CmsADEConfigDataInternal(String basePath) {
        this.m_basePath = basePath;
    }

    public static CmsADEConfigDataInternal emptyConfiguration(String basePath) {
        return new CmsADEConfigDataInternal(basePath);
    }

    public String getBasePath() {
        return this.m_basePath;
    }

    public CmsFormatterChangeSet getFormatterChangeSet() {
        return this.m_formatterChangeSet;
    }

    public List<CmsFunctionReference> getFunctionReferences() {
        return this.m_functionReferences;
    }

    public List<CmsDetailPageInfo> getOwnDetailPages() {
        return this.m_ownDetailPages;
    }

    public List<CmsModelPageConfig> getOwnModelPageConfig() {
        return this.m_ownModelPageConfig;
    }

    public List<CmsPropertyConfig> getOwnPropertyConfigurations() {
        return this.m_ownPropertyConfigurations;
    }

    public List<CmsResourceTypeConfig> getOwnResourceTypes() {
        return this.m_ownResourceTypes;
    }

    public CmsResource getResource() {
        return this.m_resource;
    }

    public boolean isCreateContentsLocally() {
        return this.m_createContentsLocally;
    }

    public boolean isDiscardInheritedModelPages() {
        return this.m_discardInheritedModelPages;
    }

    public boolean isDiscardInheritedProperties() {
        return this.m_discardInheritedProperties;
    }

    public boolean isDiscardInheritedTypes() {
        return this.m_discardInheritedTypes;
    }

    public boolean isModuleConfig() {
        return this.m_isModuleConfig;
    }

    public boolean isPreferDetailPagesForLocalContents() {
        return this.m_preferDetailPagesForLocalContents;
    }

    protected void mergeParent(CmsADEConfigDataInternal parent) {
        List<Object> parentTypes = null;
        parentTypes = parent != null ? parent.m_ownResourceTypes : Collections.emptyList();
        List<Object> parentProperties = null;
        parentProperties = parent != null ? parent.m_ownPropertyConfigurations : Collections.emptyList();
        List<Object> parentModelPages = null;
        parentModelPages = parent != null ? parent.m_ownModelPageConfig : Collections.emptyList();
        List<Object> parentFunctionRefs = null;
        parentFunctionRefs = parent != null ? parent.m_functionReferences : Collections.emptyList();
        this.m_ownResourceTypes = CmsADEConfigData.combineConfigurationElements(parentTypes, this.m_ownResourceTypes, false);
        this.m_ownPropertyConfigurations = CmsADEConfigData.combineConfigurationElements(parentProperties, this.m_ownPropertyConfigurations, false);
        this.m_ownModelPageConfig = CmsADEConfigData.combineConfigurationElements(parentModelPages, this.m_ownModelPageConfig, false);
        this.m_functionReferences = CmsADEConfigData.combineConfigurationElements(parentFunctionRefs, this.m_functionReferences, false);
    }

    protected void processModuleOrdering() {
        Collections.sort(this.m_ownResourceTypes, new Comparator<CmsResourceTypeConfig>(){

            @Override
            public int compare(CmsResourceTypeConfig a, CmsResourceTypeConfig b) {
                return ComparisonChain.start().compare(a.getOrder(), b.getOrder()).compare((Comparable)((Object)a.getTypeName()), (Comparable)((Object)b.getTypeName())).result();
            }
        });
        Collections.sort(this.m_ownPropertyConfigurations, new Comparator<CmsPropertyConfig>(){

            @Override
            public int compare(CmsPropertyConfig a, CmsPropertyConfig b) {
                return ComparisonChain.start().compare(a.getOrder(), b.getOrder()).compare((Comparable)((Object)a.getName()), (Comparable)((Object)b.getName())).result();
            }
        });
        Collections.sort(this.m_functionReferences, new Comparator<CmsFunctionReference>(){

            @Override
            public int compare(CmsFunctionReference a, CmsFunctionReference b) {
                return ComparisonChain.start().compare(a.getOrder(), b.getOrder()).compare((Comparable)((Object)a.getName()), (Comparable)((Object)b.getName())).result();
            }
        });
    }
}

