/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.containerpage.inherited;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opencms.ade.containerpage.inherited.CmsContainerConfiguration;
import org.opencms.ade.containerpage.inherited.CmsContainerConfigurationCache;
import org.opencms.ade.containerpage.shared.CmsInheritanceInfo;
import org.opencms.file.CmsResource;
import org.opencms.xml.containerpage.CmsContainerElementBean;

public class CmsInheritedContainerState {
    private List<CmsContainerConfiguration> m_parentConfigurations = new ArrayList<CmsContainerConfiguration>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfigurations(CmsContainerConfigurationCache cache, String rootPath, String name) {
        String currentPath = rootPath;
        ArrayList<CmsContainerConfiguration> configurations = new ArrayList<CmsContainerConfiguration>();
        CmsContainerConfigurationCache cmsContainerConfigurationCache = cache;
        synchronized (cmsContainerConfigurationCache) {
            while (currentPath != null) {
                CmsContainerConfiguration configuration = cache.getContainerConfiguration(currentPath, name);
                if (configuration == null) {
                    configuration = CmsContainerConfiguration.emptyConfiguration();
                }
                configuration.setPath(currentPath);
                configurations.add(configuration);
                currentPath = CmsResource.getParentFolder(currentPath);
            }
        }
        Collections.reverse(configurations);
        for (CmsContainerConfiguration configuration : configurations) {
            if (configuration == null) continue;
            this.addConfiguration(configuration);
        }
    }

    public List<CmsContainerElementBean> getElements(boolean includeHidden) {
        CmsInheritanceInfo info;
        if (this.m_parentConfigurations.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, CmsContainerElementBean> elementsByKey = new HashMap<String, CmsContainerElementBean>();
        for (CmsContainerConfiguration bean : this.m_parentConfigurations) {
            elementsByKey.putAll(bean.getNewElements());
        }
        ArrayList<CmsContainerElementBean> result = new ArrayList<CmsContainerElementBean>();
        CmsContainerConfiguration lastElement = this.m_parentConfigurations.get(this.m_parentConfigurations.size() - 1);
        HashSet<String> newKeys = new HashSet<String>();
        for (Map.Entry<String, CmsContainerElementBean> entry : lastElement.getNewElements().entrySet()) {
            String key = entry.getKey();
            newKeys.add(key);
        }
        HashSet<String> keysUsed = new HashSet<String>();
        HashMap<String, String> pathsByKey = new HashMap<String, String>();
        List<Object> ordering = null;
        for (CmsContainerConfiguration configuration : Lists.reverse(this.m_parentConfigurations)) {
            if (configuration.getOrdering() == null) continue;
            ordering = configuration.getOrdering();
            break;
        }
        if (ordering == null) {
            ordering = new ArrayList();
        }
        for (String key : ordering) {
            CmsContainerElementBean element = (CmsContainerElementBean)elementsByKey.get(key);
            if (element == null || keysUsed.contains(key)) continue;
            CmsContainerElementBean elementToAdd = CmsContainerElementBean.cloneWithSettings(element, element.getIndividualSettings());
            info = new CmsInheritanceInfo();
            info.setKey(key);
            elementToAdd.setInheritanceInfo(info);
            result.add(elementToAdd);
            keysUsed.add(key);
        }
        for (int i = 0; i < this.m_parentConfigurations.size(); ++i) {
            CmsContainerConfiguration currentConfig = this.m_parentConfigurations.get(i);
            for (Map.Entry<String, CmsContainerElementBean> entry : currentConfig.getNewElementsInOrder().entrySet()) {
                String key = entry.getKey();
                pathsByKey.put(key, currentConfig.getPath());
                if (keysUsed.contains(key)) continue;
                CmsContainerElementBean elementToAdd = CmsContainerElementBean.cloneWithSettings(entry.getValue(), entry.getValue().getIndividualSettings());
                CmsInheritanceInfo info2 = new CmsInheritanceInfo();
                info2.setKey(key);
                elementToAdd.setInheritanceInfo(info2);
                result.add(elementToAdd);
            }
        }
        for (CmsContainerElementBean resultElement : result) {
            CmsInheritanceInfo info3 = resultElement.getInheritanceInfo();
            String key = info3.getKey();
            List<Boolean> visibilities = this.getVisibilities(key);
            this.computeVisibility(visibilities, info3);
            info3.setIsNew(newKeys.contains(info3.getKey()));
        }
        ArrayList<CmsContainerElementBean> resultWithoutHidden = new ArrayList<CmsContainerElementBean>();
        ArrayList<CmsContainerElementBean> hiddenElements = new ArrayList<CmsContainerElementBean>();
        for (CmsContainerElementBean resultElement : result) {
            info = resultElement.getInheritanceInfo();
            if (!info.isVisible()) {
                hiddenElements.add(resultElement);
                continue;
            }
            resultWithoutHidden.add(resultElement);
        }
        result = resultWithoutHidden;
        if (includeHidden) {
            result.addAll(hiddenElements);
        }
        for (CmsContainerElementBean elementBean : result) {
            info = elementBean.getInheritanceInfo();
            String path = (String)pathsByKey.get(info.getKey());
            info.setPath(path);
        }
        return result;
    }

    public Set<String> getNewElementKeys() {
        HashSet<String> result = new HashSet<String>();
        for (CmsContainerConfiguration configuration : this.m_parentConfigurations) {
            result.addAll(configuration.getNewElements().keySet());
        }
        return result;
    }

    public boolean hasElementWithKey(String key) {
        for (CmsContainerConfiguration configuration : this.m_parentConfigurations) {
            if (!configuration.getNewElements().containsKey(key)) continue;
            return true;
        }
        return false;
    }

    protected void addConfiguration(CmsContainerConfiguration configuration) {
        this.m_parentConfigurations.add(configuration);
    }

    protected List<Boolean> getVisibilities(String key) {
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        for (CmsContainerConfiguration config : this.m_parentConfigurations) {
            result.add(config.getVisibility().get(key));
        }
        return result;
    }

    void computeVisibility(List<Boolean> visibilities, CmsInheritanceInfo info) {
        boolean visible = true;
        boolean inherited = true;
        boolean parentVisible = true;
        for (Boolean visibility : visibilities) {
            parentVisible = visible;
            if (visibility == Boolean.TRUE) {
                visible = true;
                inherited = false;
                continue;
            }
            if (visibility == Boolean.FALSE) {
                visible = false;
                inherited = false;
                continue;
            }
            inherited = true;
        }
        info.setVisible(visible);
        info.setVisibilityInherited(inherited);
        info.setParentVisible(parentVisible);
    }
}

