/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.publish.shared;

import com.google.common.collect.ComparisonChain;
import com.google.gwt.user.client.rpc.IsSerializable;
import org.opencms.util.CmsUUID;

public class CmsProjectBean
implements IsSerializable,
Comparable<CmsProjectBean> {
    private String m_defaultGroupName;
    private String m_description;
    private CmsUUID m_id;
    private String m_name;
    private int m_rank = 1000;
    private int m_type;

    public CmsProjectBean(CmsUUID id, int type, String name, String description) {
        this.m_id = id;
        this.m_name = name;
        this.m_type = type;
        this.m_description = description;
    }

    protected CmsProjectBean() {
    }

    @Override
    public int compareTo(CmsProjectBean otherProject) {
        return ComparisonChain.start().compare(this.m_rank, otherProject.getRank()).compare((Comparable)((Object)this.m_name), (Comparable)((Object)otherProject.getName())).result();
    }

    public String getDefaultGroupName() {
        return this.m_defaultGroupName;
    }

    public String getDescription() {
        return this.m_description;
    }

    public CmsUUID getId() {
        return this.m_id;
    }

    public String getName() {
        return this.m_name;
    }

    public int getRank() {
        return this.m_rank;
    }

    public int getType() {
        return this.m_type;
    }

    public boolean isWorkflowProject() {
        return this.m_type == 2;
    }

    public void setDefaultGroupName(String defaultGroupName) {
        this.m_defaultGroupName = defaultGroupName;
    }

    public void setRank(int rank) {
        this.m_rank = rank;
    }
}

