/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.sitemap;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsFunctionReference;
import org.opencms.ade.configuration.CmsModelPageConfig;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.ade.detailpage.CmsDetailPageConfigurationWriter;
import org.opencms.ade.detailpage.CmsDetailPageInfo;
import org.opencms.ade.sitemap.CmsAliasBulkEditHelper;
import org.opencms.ade.sitemap.CmsAliasEditorLockTable;
import org.opencms.ade.sitemap.CmsAliasImportResponseTable;
import org.opencms.ade.sitemap.CmsModelPageHelper;
import org.opencms.ade.sitemap.CmsSitemapNavPosCalculator;
import org.opencms.ade.sitemap.Messages;
import org.opencms.ade.sitemap.shared.CmsClientSitemapEntry;
import org.opencms.ade.sitemap.shared.CmsDetailPageTable;
import org.opencms.ade.sitemap.shared.CmsGalleryFolderEntry;
import org.opencms.ade.sitemap.shared.CmsGalleryType;
import org.opencms.ade.sitemap.shared.CmsModelPageEntry;
import org.opencms.ade.sitemap.shared.CmsNewResourceInfo;
import org.opencms.ade.sitemap.shared.CmsSitemapCategoryData;
import org.opencms.ade.sitemap.shared.CmsSitemapChange;
import org.opencms.ade.sitemap.shared.CmsSitemapClipboardData;
import org.opencms.ade.sitemap.shared.CmsSitemapData;
import org.opencms.ade.sitemap.shared.CmsSitemapInfo;
import org.opencms.ade.sitemap.shared.rpc.I_CmsSitemapService;
import org.opencms.configuration.CmsDefaultUserSettings;
import org.opencms.db.CmsAlias;
import org.opencms.db.CmsAliasManager;
import org.opencms.db.CmsRewriteAlias;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsPropertyDefinition;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.history.CmsHistoryResourceHandler;
import org.opencms.file.types.CmsResourceTypeFolder;
import org.opencms.file.types.CmsResourceTypeFolderExtended;
import org.opencms.file.types.CmsResourceTypeFolderSubSitemap;
import org.opencms.file.types.CmsResourceTypeUnknownFolder;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.flex.CmsFlexController;
import org.opencms.gwt.CmsCoreService;
import org.opencms.gwt.CmsGwtService;
import org.opencms.gwt.CmsRpcException;
import org.opencms.gwt.CmsTemplateFinder;
import org.opencms.gwt.shared.CmsBrokenLinkBean;
import org.opencms.gwt.shared.CmsCategoryTreeEntry;
import org.opencms.gwt.shared.CmsClientLock;
import org.opencms.gwt.shared.CmsCoreData;
import org.opencms.gwt.shared.CmsListInfoBean;
import org.opencms.gwt.shared.alias.CmsAliasEditValidationReply;
import org.opencms.gwt.shared.alias.CmsAliasEditValidationRequest;
import org.opencms.gwt.shared.alias.CmsAliasImportResult;
import org.opencms.gwt.shared.alias.CmsAliasInitialFetchResult;
import org.opencms.gwt.shared.alias.CmsAliasSaveValidationRequest;
import org.opencms.gwt.shared.alias.CmsAliasTableRow;
import org.opencms.gwt.shared.alias.CmsRewriteAliasTableRow;
import org.opencms.gwt.shared.alias.CmsRewriteAliasValidationReply;
import org.opencms.gwt.shared.alias.CmsRewriteAliasValidationRequest;
import org.opencms.gwt.shared.property.CmsClientProperty;
import org.opencms.gwt.shared.property.CmsPropertyModification;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.json.JSONArray;
import org.opencms.jsp.CmsJspNavBuilder;
import org.opencms.jsp.CmsJspNavElement;
import org.opencms.loader.CmsLoaderException;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsCategory;
import org.opencms.relations.CmsCategoryService;
import org.opencms.search.galleries.CmsGallerySearch;
import org.opencms.search.galleries.CmsGallerySearchResult;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.security.CmsSecurityException;
import org.opencms.site.CmsSite;
import org.opencms.util.CmsDateUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplaceManager;
import org.opencms.workplace.CmsWorkplaceMessages;
import org.opencms.workplace.explorer.CmsExplorerTypeAccess;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.galleries.A_CmsAjaxGallery;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsVfsSitemapService
extends CmsGwtService
implements I_CmsSitemapService {
    public static final String ALIAS_DOWNLOAD_PATH = "/system/modules/org.opencms.ade.sitemap/pages/download-aliases.jsp";
    public static final String ALIAS_IMPORT_PATH = "/system/modules/org.opencms.ade.sitemap/pages/import-aliases.jsp";
    public static final String GALLERIES_FOLDER_NAME = ".galleries";
    public static final String KEY_FUNCTION_DETAIL = "functionDetail";
    private static final String ADDINFO_ADE_DELETED_LIST = "ADE_DELETED_LIST";
    private static final String ADDINFO_ADE_MODIFIED_LIST = "ADE_MODIFIED_LIST";
    private static CmsAliasEditorLockTable aliasEditorLockTable = new CmsAliasEditorLockTable();
    private static CmsAliasImportResponseTable aliasImportResponseTable = new CmsAliasImportResponseTable();
    private static final Log LOG = CmsLog.getLog(CmsVfsSitemapService.class);
    private static final String RECOURCE_TYPE_NAME_REDIRECT = "htmlredirect";
    private static final String REDIRECT_LINK_TARGET_XPATH = "Link";
    private static final long serialVersionUID = -7236544324371767330L;
    private static final String SUB_LEVEL_REDIRECT_COPY_PAGE = "/system/modules/org.opencms.ade.sitemap/pages/sub-level-redirect.html";
    private CmsJspNavBuilder m_navBuilder;

    public static String addAliasImportResult(List<CmsAliasImportResult> results) {
        return aliasImportResponseTable.addImportResult(results);
    }

    public static CmsClientProperty createClientProperty(CmsProperty prop, boolean preserveOrigin) {
        CmsClientProperty result = new CmsClientProperty(prop.getName(), prop.getStructureValue(), prop.getResourceValue());
        if (preserveOrigin) {
            result.setOrigin(prop.getOrigin());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CmsSitemapData prefetch(HttpServletRequest request, String sitemapUri) throws CmsRpcException {
        CmsVfsSitemapService service = new CmsVfsSitemapService();
        service.setCms(CmsFlexController.getCmsObject((ServletRequest)request));
        service.setRequest(request);
        CmsSitemapData result = null;
        try {
            result = service.prefetch(sitemapUri);
        }
        finally {
            service.clearThreadStorage();
        }
        return result;
    }

    @Override
    public void changeCategory(String entryPoint, CmsUUID id, String title, String name) throws CmsRpcException {
        try {
            name = OpenCms.getResourceManager().getFileTranslator().translateResource(name.trim().replace('/', '-'));
            CmsObject cms = this.getCmsObject();
            CmsResource categoryResource = cms.readResource(id);
            this.ensureLock(categoryResource);
            String sitePath = cms.getSitePath(categoryResource);
            String newPath = CmsStringUtil.joinPaths(CmsResource.getParentFolder(sitePath), name);
            cms.writePropertyObject(sitePath, new CmsProperty("Title", title, null));
            if (!CmsStringUtil.joinPaths("/", newPath, "/").equals(CmsStringUtil.joinPaths("/", sitePath, "/"))) {
                cms.moveResource(sitePath, newPath);
            }
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    @Override
    public void checkPermissions(CmsObject cms) throws CmsRoleViolationException {
        OpenCms.getRoleManager().checkRole(cms, CmsRole.EDITOR);
    }

    @Override
    public void createCategory(String entryPoint, CmsUUID id, String title, String name) throws CmsRpcException {
        try {
            name = OpenCms.getResourceManager().getFileTranslator().translateResource(name.trim().replace('/', '-'));
            CmsObject cms = this.getCmsObject();
            CmsCategoryService catService = CmsCategoryService.getInstance();
            CmsCategory createdCategory = null;
            if (id.isNullUUID()) {
                String localRepositoryPath = CmsStringUtil.joinPaths(entryPoint, OpenCms.getWorkplaceManager().getCategoryFolder());
                if (!cms.existsResource(localRepositoryPath)) {
                    this.tryUnlock(cms.createResource(localRepositoryPath, OpenCms.getResourceManager().getResourceType(CmsResourceTypeFolder.getStaticTypeName()).getTypeId()));
                }
                createdCategory = catService.createCategory(cms, null, name, title, "", localRepositoryPath);
            } else {
                CmsResource parentResource = cms.readResource(id);
                CmsCategory parent = catService.getCategory(cms, parentResource);
                createdCategory = catService.createCategory(cms, parent, name, title, "", cms.getRequestContext().removeSiteRoot(parentResource.getRootPath()));
            }
            this.tryUnlock(cms.readResource(createdCategory.getId()));
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    @Override
    public CmsGalleryFolderEntry createNewGalleryFolder(String parentFolder, String title, int folderTypeId) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        CmsGalleryFolderEntry folderEntry = null;
        try {
            if (!cms.existsResource(parentFolder, CmsResourceFilter.IGNORE_EXPIRATION)) {
                CmsResource parent = cms.createResource(parentFolder, CmsResourceTypeFolder.getStaticTypeId());
                this.tryUnlock(parent);
            }
            String folderName = OpenCms.getResourceManager().getFileTranslator().translateResource(title);
            folderName = OpenCms.getResourceManager().getNameGenerator().getUniqueFileName(cms, parentFolder, folderName);
            String folderPath = CmsStringUtil.joinPaths(parentFolder, folderName);
            CmsResource galleryFolder = cms.createResource(folderPath, folderTypeId, null, Collections.singletonList(new CmsProperty("Title", title, null)));
            folderEntry = this.readGalleryFolderEntry(galleryFolder, OpenCms.getResourceManager().getResourceType(galleryFolder).getTypeName());
            this.tryUnlock(galleryFolder);
        }
        catch (CmsException e) {
            this.error(e);
        }
        return folderEntry;
    }

    @Override
    public CmsModelPageEntry createNewModelPage(String entryPointUri, String title, String description, CmsUUID copyId) throws CmsRpcException {
        try {
            CmsObject cms = this.getCmsObject();
            CmsResource rootResource = cms.readResource(entryPointUri);
            CmsModelPageHelper helper = new CmsModelPageHelper(this.getCmsObject(), rootResource);
            CmsResource page = helper.createPageInModelFolder(title, description, copyId);
            String configPath = CmsStringUtil.joinPaths(entryPointUri, ".content/.config");
            CmsResource configResource = cms.readResource(configPath);
            helper.addModelPageToSitemapConfiguration(configResource, page, false);
            CmsModelPageEntry result = helper.createModelPageEntry(page);
            OpenCms.getADEManager().waitForCacheUpdate(false);
            return result;
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsSitemapChange createSubSitemap(CmsUUID entryId) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        try {
            this.ensureSession();
            CmsResource subSitemapFolder = cms.readResource(entryId);
            this.ensureLock(subSitemapFolder);
            String sitePath = cms.getSitePath(subSitemapFolder);
            this.createSitemapContentFolder(cms, subSitemapFolder);
            subSitemapFolder.setType(this.getSubsitemapType());
            cms.writeResource(subSitemapFolder);
            this.tryUnlock(subSitemapFolder);
            CmsSitemapClipboardData clipboard = this.getClipboardData();
            CmsClientSitemapEntry entry = this.toClientEntry(this.getNavBuilder().getNavigationForResource(sitePath, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED), false);
            clipboard.addModified(entry);
            this.setClipboardData(clipboard);
            CmsSitemapChange result = new CmsSitemapChange(entry.getId(), entry.getSitePath(), CmsSitemapChange.ChangeType.modify);
            result.setUpdatedEntry(entry);
            return result;
        }
        catch (Exception e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public List<CmsAliasImportResult> getAliasImportResult(String resultKey) {
        return aliasImportResponseTable.getAndRemove(resultKey);
    }

    @Override
    public CmsAliasInitialFetchResult getAliasTable() throws CmsRpcException {
        try {
            CmsObject cms = this.getCmsObject();
            CmsAliasManager aliasManager = OpenCms.getAliasManager();
            List<CmsAlias> aliases = aliasManager.getAliasesForSite(cms, cms.getRequestContext().getSiteRoot());
            ArrayList<CmsAliasTableRow> rows = new ArrayList<CmsAliasTableRow>();
            CmsAliasInitialFetchResult result = new CmsAliasInitialFetchResult();
            for (CmsAlias alias : aliases) {
                CmsAliasTableRow row = this.createAliasTableEntry(cms, alias);
                rows.add(row);
            }
            result.setRows(rows);
            List<CmsRewriteAlias> rewriteAliases = aliasManager.getRewriteAliases(cms, cms.getRequestContext().getSiteRoot());
            ArrayList<CmsRewriteAliasTableRow> rewriteRows = new ArrayList<CmsRewriteAliasTableRow>();
            for (CmsRewriteAlias rewriteAlias : rewriteAliases) {
                CmsRewriteAliasTableRow rewriteRow = new CmsRewriteAliasTableRow(rewriteAlias.getId(), rewriteAlias.getPatternString(), rewriteAlias.getReplacementString(), rewriteAlias.getMode());
                rewriteRows.add(rewriteRow);
            }
            result.setRewriteRows(rewriteRows);
            CmsUser otherLockOwner = aliasEditorLockTable.update(cms, cms.getRequestContext().getSiteRoot());
            if (otherLockOwner != null) {
                result.setAliasLockOwner(otherLockOwner.getName());
            }
            result.setDownloadUrl(OpenCms.getLinkManager().substituteLinkForRootPath(cms, ALIAS_DOWNLOAD_PATH));
            return result;
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsSitemapCategoryData getCategoryData(String entryPoint) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        try {
            List<CmsCategoryTreeEntry> entries = CmsCoreService.getCategoriesForSitePathStatic(cms, entryPoint);
            CmsSitemapCategoryData categoryData = new CmsSitemapCategoryData();
            for (CmsCategoryTreeEntry entry : entries) {
                categoryData.add(entry);
            }
            CmsResource entryPointResource = cms.readResource(entryPoint);
            String basePath = CmsStringUtil.joinPaths(entryPointResource.getRootPath(), OpenCms.getWorkplaceManager().getCategoryFolder());
            categoryData.setBasePath(basePath);
            return categoryData;
        }
        catch (Exception e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsClientSitemapEntry getChildren(String entryPointUri, CmsUUID entryId, int levels) throws CmsRpcException {
        CmsClientSitemapEntry entry = null;
        try {
            CmsObject cms = this.getCmsObject();
            CmsResource rootRes = cms.readResource(entryId, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
            String root = cms.getSitePath(rootRes);
            CmsJspNavElement navElement = this.getNavBuilder().getNavigationForResource(root, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
            boolean isRoot = root.equals(entryPointUri);
            entry = this.toClientEntry(navElement, isRoot);
            if (levels > 0 && (isRoot || rootRes.isFolder())) {
                entry.setSubEntries(this.getChildren(root, levels, null), null);
            }
        }
        catch (Throwable e) {
            this.error(e);
        }
        return entry;
    }

    @Override
    public Map<CmsGalleryType, List<CmsGalleryFolderEntry>> getGalleryData(String entryPointUri) {
        List<String> subSitePaths = OpenCms.getADEManager().getSubSitePaths(this.getCmsObject(), this.getCmsObject().getRequestContext().addSiteRoot(entryPointUri));
        List<CmsGalleryType> galleryTypes = this.collectGalleryTypes();
        HashMap<CmsGalleryType, List<CmsGalleryFolderEntry>> result = new HashMap<CmsGalleryType, List<CmsGalleryFolderEntry>>();
        for (CmsGalleryType type : galleryTypes) {
            List<CmsGalleryFolderEntry> galleries = null;
            try {
                galleries = this.getGalleriesForType(entryPointUri, type, subSitePaths);
            }
            catch (CmsException e) {
                this.log(e.getLocalizedMessage(), e);
            }
            result.put(type, galleries);
        }
        return result;
    }

    @Override
    public List<CmsModelPageEntry> getModelPages(CmsUUID rootId) throws CmsRpcException {
        try {
            CmsObject cms = this.getCmsObject();
            CmsResource rootResource = cms.readResource(rootId);
            CmsModelPageHelper modelPageHelper = new CmsModelPageHelper(this.getCmsObject(), rootResource);
            List<CmsModelPageEntry> entries = modelPageHelper.getModelPages();
            return entries;
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public List<CmsNewResourceInfo> getNewElementInfo(String entryPointUri) throws CmsRpcException {
        try {
            CmsObject cms = this.getCmsObject();
            String rootPath = cms.getRequestContext().addSiteRoot(entryPointUri);
            CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(cms, rootPath);
            Locale locale = this.getLocaleForNewResourceInfos(cms, config);
            List<CmsNewResourceInfo> result = this.getNewResourceInfos(cms, config, locale);
            return result;
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsSitemapChange mergeSubSitemap(String entryPoint, CmsUUID subSitemapId) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        try {
            this.ensureSession();
            CmsResource subSitemapFolder = cms.readResource(subSitemapId, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
            this.ensureLock(subSitemapFolder);
            subSitemapFolder.setType(OpenCms.getResourceManager().getResourceType("folder").getTypeId());
            cms.writeResource(subSitemapFolder);
            String sitePath = cms.getSitePath(subSitemapFolder);
            String sitemapConfigName = CmsStringUtil.joinPaths(sitePath, ".content", ".config");
            if (cms.existsResource(sitemapConfigName)) {
                cms.deleteResource(sitemapConfigName, CmsResource.DELETE_PRESERVE_SIBLINGS);
            }
            this.tryUnlock(subSitemapFolder);
            CmsSitemapClipboardData clipboard = this.getClipboardData();
            CmsClientSitemapEntry entry = this.toClientEntry(this.getNavBuilder().getNavigationForResource(cms.getSitePath(subSitemapFolder), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED), false);
            clipboard.addModified(entry);
            this.setClipboardData(clipboard);
            entry = this.getChildren(entryPoint, subSitemapId, 1);
            CmsSitemapChange result = new CmsSitemapChange(entry.getId(), entry.getSitePath(), CmsSitemapChange.ChangeType.modify);
            result.setUpdatedEntry(entry);
            return result;
        }
        catch (Exception e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsSitemapData prefetch(String sitemapUri) throws CmsRpcException {
        CmsSitemapData result = null;
        CmsObject cms = this.getCmsObject();
        try {
            CmsADEConfigData parentConfigData;
            OpenCms.getRoleManager().checkRole(cms, CmsRole.EDITOR);
            String openPath = this.getRequest().getParameter("path");
            if (!this.isValidOpenPath(cms, openPath)) {
                openPath = "/";
            }
            CmsADEConfigData configData = OpenCms.getADEManager().lookupConfiguration(cms, cms.getRequestContext().addSiteRoot(openPath));
            LinkedHashMap<String, CmsXmlContentProperty> propertyConfig = new LinkedHashMap<String, CmsXmlContentProperty>(configData.getPropertyConfigurationAsMap());
            Map<String, CmsClientProperty> parentProperties = this.generateParentProperties(configData.getBasePath());
            String siteRoot = cms.getRequestContext().getSiteRoot();
            String exportRfsPrefix = OpenCms.getStaticExportManager().getDefaultRfsPrefix();
            CmsSite site = OpenCms.getSiteManager().getSiteForSiteRoot(siteRoot);
            boolean isSecure = site.hasSecureServer();
            String parentSitemap = null;
            if (configData.getBasePath() != null && (parentSitemap = (parentConfigData = OpenCms.getADEManager().lookupConfiguration(cms, CmsResource.getParentFolder(configData.getBasePath()))).getBasePath()) != null) {
                parentSitemap = cms.getRequestContext().removeSiteRoot(parentSitemap);
            }
            String noEdit = "";
            CmsNewResourceInfo defaultNewInfo = null;
            List<CmsNewResourceInfo> newResourceInfos = null;
            CmsDetailPageTable detailPages = null;
            List<CmsNewResourceInfo> resourceTypeInfos = null;
            boolean canEditDetailPages = false;
            boolean isOnlineProject = CmsProject.isOnlineProject(cms.getRequestContext().getCurrentProject().getUuid());
            String defaultGalleryFolder = GALLERIES_FOLDER_NAME;
            Locale locale = this.getLocaleForNewResourceInfos(cms, configData);
            try {
                String basePath = configData.getBasePath();
                CmsObject rootCms = OpenCms.initCmsObject(cms);
                rootCms.getRequestContext().setSiteRoot("");
                CmsResource baseDir = rootCms.readResource(basePath, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
                CmsProperty galleryFolderProp = cms.readPropertyObject(baseDir, "galleries.folder", true);
                if (!galleryFolderProp.isNullProperty() && CmsStringUtil.isNotEmptyOrWhitespaceOnly(galleryFolderProp.getValue())) {
                    defaultGalleryFolder = galleryFolderProp.getValue();
                }
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            detailPages = new CmsDetailPageTable(configData.getAllDetailPages());
            if (!isOnlineProject) {
                newResourceInfos = this.getNewResourceInfos(cms, configData, locale);
                CmsResource modelResource = null;
                if (configData.getDefaultModelPage() != null) {
                    if (cms.existsResource(configData.getDefaultModelPage().getResource().getStructureId())) {
                        modelResource = configData.getDefaultModelPage().getResource();
                    } else {
                        try {
                            modelResource = cms.readResource(cms.getSitePath(configData.getDefaultModelPage().getResource()), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
                        }
                        catch (CmsException e) {
                            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                }
                if (modelResource == null && !newResourceInfos.isEmpty()) {
                    try {
                        modelResource = cms.readResource(newResourceInfos.get(0).getCopyResourceId());
                    }
                    catch (CmsException e) {
                        LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                if (modelResource != null) {
                    resourceTypeInfos = this.getResourceTypeInfos(this.getCmsObject(), configData.getResourceTypes(), configData.getFunctionReferences(), modelResource, locale);
                    try {
                        defaultNewInfo = this.createNewResourceInfo(cms, modelResource, locale);
                    }
                    catch (CmsException e) {
                        LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                boolean bl = canEditDetailPages = !configData.isModuleConfiguration();
            }
            if (isOnlineProject) {
                noEdit = Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_SITEMAP_NO_EDIT_ONLINE_0");
            }
            List<String> allPropNames = this.getPropertyNames(cms);
            String returnCode = this.getRequest().getParameter("returncode");
            if (!this.isValidReturnCode(returnCode)) {
                returnCode = null;
            }
            cms.getRequestContext().getSiteRoot();
            String aliasImportUrl = OpenCms.getLinkManager().substituteLinkForRootPath(cms, ALIAS_IMPORT_PATH);
            boolean canEditAliases = OpenCms.getAliasManager().hasPermissionsForMassEdit(cms, siteRoot);
            List<CmsListInfoBean> subsitemapFolderTypeInfos = this.collectSitemapTypeInfos(cms, configData);
            CmsSitemapData.EditorMode editorMode = CmsSitemapData.EditorMode.navigation;
            String modeParam = this.getRequest().getParameter("editormode");
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(modeParam)) {
                try {
                    editorMode = CmsSitemapData.EditorMode.valueOf(modeParam);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            result = new CmsSitemapData(new CmsTemplateFinder(cms).getTemplates(), propertyConfig, this.getClipboardData(), CmsCoreService.getContextMenuEntries(cms, configData.getResource().getStructureId(), CmsCoreData.AdeContext.sitemap), parentProperties, allPropNames, exportRfsPrefix, isSecure, noEdit, this.isDisplayToolbar(this.getRequest()), defaultNewInfo, newResourceInfos, this.createResourceTypeInfo(OpenCms.getResourceManager().getResourceType(RECOURCE_TYPE_NAME_REDIRECT), null), this.createNavigationLevelTypeInfo(), this.getSitemapInfo(configData.getBasePath()), parentSitemap, this.getRootEntry(configData.getBasePath(), CmsResource.getFolderPath(openPath)), openPath, 30, detailPages, resourceTypeInfos, returnCode, canEditDetailPages, aliasImportUrl, canEditAliases, OpenCms.getWorkplaceManager().getDefaultUserSettings().getSubsitemapCreationMode() == CmsDefaultUserSettings.SubsitemapCreationMode.createfolder, OpenCms.getRoleManager().hasRole(cms, CmsRole.GALLERY_EDITOR), OpenCms.getRoleManager().hasRole(cms, CmsRole.CATEGORY_EDITOR), subsitemapFolderTypeInfos, editorMode, defaultGalleryFolder);
            CmsUUID rootId = cms.readResource("/", CmsResourceFilter.ALL).getStructureId();
            result.setSiteRootId(rootId);
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public void removeModelPage(String entryPointUri, CmsUUID id) throws CmsRpcException {
        try {
            CmsObject cms = this.getCmsObject();
            CmsResource rootResource = cms.readResource(entryPointUri);
            CmsModelPageHelper helper = new CmsModelPageHelper(this.getCmsObject(), rootResource);
            String configPath = CmsStringUtil.joinPaths(entryPointUri, ".content/.config");
            CmsResource configResource = cms.readResource(configPath);
            helper.removeModelPage(configResource, id);
            OpenCms.getADEManager().waitForCacheUpdate(false);
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    @Override
    public CmsSitemapChange save(String entryPoint, CmsSitemapChange change) throws CmsRpcException {
        CmsSitemapChange result = null;
        try {
            result = this.saveInternal(entryPoint, change);
        }
        catch (Exception e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public CmsAliasEditValidationReply saveAliases(CmsAliasSaveValidationRequest saveRequest) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        CmsAliasBulkEditHelper helper = new CmsAliasBulkEditHelper(cms);
        try {
            return helper.saveAliases(saveRequest);
        }
        catch (Exception e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsSitemapChange saveSync(String entryPoint, CmsSitemapChange change) throws CmsRpcException {
        return this.save(entryPoint, change);
    }

    @Override
    public void updateAliasEditorStatus(boolean editing) {
        CmsObject cms = this.getCmsObject();
        if (editing) {
            aliasEditorLockTable.update(cms, cms.getRequestContext().getSiteRoot());
        } else {
            aliasEditorLockTable.clear(cms, cms.getRequestContext().getSiteRoot());
        }
    }

    @Override
    public CmsAliasEditValidationReply validateAliases(CmsAliasEditValidationRequest validationRequest) {
        CmsObject cms = this.getCmsObject();
        CmsAliasBulkEditHelper helper = new CmsAliasBulkEditHelper(cms);
        return helper.validateAliases(validationRequest);
    }

    @Override
    public CmsRewriteAliasValidationReply validateRewriteAliases(CmsRewriteAliasValidationRequest validationRequest) {
        CmsRewriteAliasValidationReply result = new CmsRewriteAliasValidationReply();
        for (CmsRewriteAliasTableRow editedRow : validationRequest.getEditedRewriteAliases()) {
            try {
                String patternString = editedRow.getPatternString();
                Pattern.compile(patternString);
            }
            catch (PatternSyntaxException e) {
                result.addError(editedRow.getId(), "Syntax error in regular expression: " + e.getMessage());
            }
        }
        return result;
    }

    protected CmsBrokenLinkBean createSitemapBrokenLinkBean(CmsResource resource) throws CmsException {
        String path;
        CmsObject cms = this.getCmsObject();
        CmsProperty titleProp = cms.readPropertyObject(resource, "Title", true);
        String defaultTitle = "";
        String title = titleProp.getValue(defaultTitle);
        String subtitle = path = cms.getSitePath(resource);
        return new CmsBrokenLinkBean(resource.getStructureId(), title, subtitle);
    }

    protected LockInfo ensureLockAndGetInfo(CmsResource resource) throws CmsException {
        CmsObject cms = this.getCmsObject();
        boolean justLocked = false;
        List<CmsResource> blockingResources = cms.getBlockingLockedResources(resource);
        if (blockingResources != null && !blockingResources.isEmpty()) {
            throw new CmsException(org.opencms.gwt.Messages.get().container("ERR_RESOURCE_HAS_BLOCKING_LOCKED_CHILDREN_1", cms.getSitePath(resource)));
        }
        CmsUser user = cms.getRequestContext().getCurrentUser();
        CmsLock lock = cms.getLock(resource);
        if (!lock.isOwnedBy(user)) {
            cms.lockResourceTemporary(resource);
            lock = cms.getLock(resource);
            justLocked = true;
        } else if (!lock.isOwnedInProjectBy(user, cms.getRequestContext().getCurrentProject())) {
            cms.changeLock(resource);
            lock = cms.getLock(resource);
            justLocked = true;
        }
        return new LockInfo(lock, justLocked);
    }

    protected CmsSitemapChange saveInternal(String entryPoint, CmsSitemapChange change) throws CmsException {
        this.ensureSession();
        switch (change.getChangeType()) {
            case clipboardOnly: {
                break;
            }
            case remove: {
                change = this.removeEntryFromNavigation(change);
                break;
            }
            case undelete: {
                change = this.undelete(change);
                break;
            }
            default: {
                change = this.applyChange(entryPoint, change);
            }
        }
        this.setClipboardData(change.getClipBoardData());
        return change;
    }

    Map<String, CmsClientProperty> createClientProperties(Iterable<CmsProperty> props, boolean preserveOrigin) {
        HashMap<String, CmsClientProperty> result = new HashMap<String, CmsClientProperty>();
        for (CmsProperty prop : props) {
            CmsClientProperty clientProp = CmsVfsSitemapService.createClientProperty(prop, preserveOrigin);
            result.put(prop.getName(), clientProp);
        }
        return result;
    }

    void ensureSingleLocale(CmsXmlContainerPage containerPage, CmsResource localeRes) throws CmsException {
        CmsObject cms = this.getCmsObject();
        Locale mainLocale = CmsLocaleManager.getMainLocale(cms, localeRes);
        OpenCms.getLocaleManager();
        Locale defaultLocale = CmsLocaleManager.getDefaultLocale();
        if (containerPage.hasLocale(mainLocale)) {
            this.removeAllLocalesExcept(containerPage, mainLocale);
        } else if (containerPage.hasLocale(defaultLocale)) {
            containerPage.copyLocale(defaultLocale, mainLocale);
            this.removeAllLocalesExcept(containerPage, mainLocale);
        } else if (containerPage.getLocales().size() > 0) {
            containerPage.copyLocale(containerPage.getLocales().get(0), mainLocale);
            this.removeAllLocalesExcept(containerPage, mainLocale);
        } else {
            containerPage.addLocale(cms, mainLocale);
        }
    }

    Map<String, CmsClientProperty> getClientProperties(CmsObject cms, CmsResource res, boolean search) throws CmsException {
        List<CmsProperty> props = cms.readPropertyObjects(res, search);
        Map<String, CmsClientProperty> result = this.createClientProperties(props, false);
        return result;
    }

    private void addFunctionDetailElement(CmsObject cms, CmsXmlContainerPage page, String containerName, CmsUUID elementId, CmsUUID formatterId) throws CmsException {
        CmsContainerPageBean bean = page.getContainerPage(cms);
        ArrayList<CmsContainerBean> containerBeans = new ArrayList<CmsContainerBean>();
        Collection<CmsContainerBean> originalContainers = bean.getContainers().values();
        if (containerName == null && !originalContainers.isEmpty()) {
            CmsContainerBean firstContainer = originalContainers.iterator().next();
            containerName = firstContainer.getName();
        }
        boolean foundContainer = false;
        for (CmsContainerBean cntBean : originalContainers) {
            boolean isDetailTarget = cntBean.getName().equals(containerName);
            if (isDetailTarget && !foundContainer) {
                foundContainer = true;
                ArrayList<CmsContainerElementBean> newElems = new ArrayList<CmsContainerElementBean>();
                newElems.addAll(cntBean.getElements());
                CmsContainerElementBean newElement = new CmsContainerElementBean(elementId, formatterId, new HashMap<String, String>(), false);
                newElems.add(0, newElement);
                CmsContainerBean newCntBean = new CmsContainerBean(cntBean.getName(), cntBean.getType(), cntBean.getParentInstanceId(), newElems);
                containerBeans.add(newCntBean);
                continue;
            }
            containerBeans.add(cntBean);
        }
        if (!foundContainer) {
            throw new CmsException(Messages.get().container("ERR_NO_FUNCTION_DETAIL_CONTAINER_1", page.getFile().getRootPath()));
        }
        CmsContainerPageBean bean2 = new CmsContainerPageBean(new ArrayList<CmsContainerBean>(containerBeans));
        page.writeContainerPage(cms, bean2);
    }

    private CmsSitemapChange applyChange(String entryPoint, CmsSitemapChange change) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsResource configFile = null;
        if (change.hasDetailPageInfos()) {
            CmsADEConfigData configData = OpenCms.getADEManager().lookupConfiguration(cms, cms.getRequestContext().addSiteRoot(entryPoint));
            if (!configData.isModuleConfiguration() && configData.getResource() != null) {
                configFile = configData.getResource();
            }
            if (configFile != null) {
                this.ensureLock(configFile);
            }
        }
        if (change.isNew()) {
            CmsClientSitemapEntry newEntry = this.createNewEntry(entryPoint, change);
            change.setUpdatedEntry(newEntry);
            change.setEntryId(newEntry.getId());
        } else if (change.getChangeType() == CmsSitemapChange.ChangeType.delete) {
            this.delete(change);
        } else if (change.getEntryId() != null) {
            this.modifyEntry(change);
        }
        if (change.hasDetailPageInfos() && configFile != null) {
            this.saveDetailPages(change.getDetailPageInfos(), configFile, change.getEntryId(), change.getUpdatedEntry());
            this.tryUnlock(configFile);
        }
        return change;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyNavigationChanges(CmsSitemapChange change, CmsResource entryFolder) throws CmsException {
        CmsObject cms = this.getCmsObject();
        String parentPath = null;
        if (change.hasNewParent()) {
            CmsResource parent = cms.readResource(change.getParentId());
            parentPath = cms.getSitePath(parent);
        } else {
            parentPath = CmsResource.getParentFolder(cms.getSitePath(entryFolder));
        }
        List<CmsJspNavElement> navElements = this.getNavBuilder().getNavigationForFolder(parentPath, CmsJspNavBuilder.Visibility.all, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
        CmsSitemapNavPosCalculator npc = new CmsSitemapNavPosCalculator(navElements, entryFolder, change.getPosition());
        List<CmsJspNavElement> navs = npc.getNavigationChanges();
        ArrayList<CmsResource> needToUnlock = new ArrayList<CmsResource>();
        try {
            for (CmsJspNavElement nav : navs) {
                LockInfo lockInfo = this.ensureLockAndGetInfo(nav.getResource());
                if (nav.getResource().equals(entryFolder) || !lockInfo.wasJustLocked()) continue;
                needToUnlock.add(nav.getResource());
            }
            for (CmsJspNavElement nav : navs) {
                CmsProperty property = new CmsProperty("NavPos", "" + nav.getNavPosition(), null);
                cms.writePropertyObject(cms.getSitePath(nav.getResource()), property);
            }
        }
        finally {
            for (CmsResource lockedRes : needToUnlock) {
                try {
                    cms.unlockResource(lockedRes);
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }

    private CmsListInfoBean buildSitemapTypeInfo(I_CmsResourceType sitemapType) {
        CmsListInfoBean result = new CmsListInfoBean();
        CmsWorkplaceManager wm = OpenCms.getWorkplaceManager();
        String typeName = sitemapType.getTypeName();
        Locale wpLocale = wm.getWorkplaceLocale(this.getCmsObject());
        String title = typeName;
        String description = "";
        try {
            title = CmsWorkplaceMessages.getResourceTypeName(wpLocale, typeName);
        }
        catch (Throwable e) {
            LOG.warn((Object)e.getLocalizedMessage(), e);
        }
        try {
            description = CmsWorkplaceMessages.getResourceTypeDescription(wpLocale, typeName);
        }
        catch (Throwable e) {
            LOG.warn((Object)e.getLocalizedMessage(), e);
        }
        result.setResourceType(typeName);
        result.setTitle(title);
        result.setSubTitle(description);
        return result;
    }

    private List<CmsGalleryType> collectGalleryTypes() {
        Locale wpLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(this.getCmsObject());
        HashMap<String, ArrayList<String>> galleryContentTypes = new HashMap<String, ArrayList<String>>();
        ArrayList<CmsGalleryType> result = new ArrayList<CmsGalleryType>();
        for (I_CmsResourceType resourceType : OpenCms.getResourceManager().getResourceTypes()) {
            if (resourceType instanceof CmsResourceTypeFolderExtended) {
                CmsResourceTypeFolderExtended galleryType = (CmsResourceTypeFolderExtended)resourceType;
                String folderClassName = galleryType.getFolderClassName();
                if (!CmsStringUtil.isNotEmpty(folderClassName)) continue;
                try {
                    if (!A_CmsAjaxGallery.class.isAssignableFrom(Class.forName(folderClassName))) continue;
                    CmsGalleryType gallery = new CmsGalleryType();
                    gallery.setTypeId(resourceType.getTypeId());
                    gallery.setTypeName(resourceType.getTypeName());
                    gallery.setNiceName(CmsWorkplaceMessages.getResourceTypeName(wpLocale, resourceType.getTypeName()));
                    gallery.setDescription(CmsWorkplaceMessages.getResourceTypeDescription(wpLocale, resourceType.getTypeName()));
                    result.add(gallery);
                }
                catch (Exception e) {
                    this.log(e.getLocalizedMessage(), e);
                }
                continue;
            }
            List<I_CmsResourceType> galleryTypes = resourceType.getGalleryTypes();
            if (galleryTypes == null || galleryTypes.isEmpty()) continue;
            for (I_CmsResourceType galleryType : galleryTypes) {
                ArrayList<String> typeList = (ArrayList<String>)galleryContentTypes.get(galleryType.getTypeName());
                if (typeList == null) {
                    typeList = new ArrayList<String>();
                    galleryContentTypes.put(galleryType.getTypeName(), typeList);
                }
                typeList.add(resourceType.getTypeName());
            }
        }
        for (CmsGalleryType galleryType : result) {
            galleryType.setContentTypeNames((List)galleryContentTypes.get(galleryType.getTypeName()));
        }
        return result;
    }

    private List<CmsListInfoBean> collectSitemapTypeInfos(CmsObject cms, CmsADEConfigData configData) {
        ArrayList<CmsListInfoBean> subsitemapFolderTypeInfos = new ArrayList<CmsListInfoBean>();
        List<Integer> sitemapTypeIds = CmsResourceTypeFolderSubSitemap.getSubSitemapResourceTypeIds();
        String checkPath = configData.getBasePath();
        checkPath = checkPath != null ? cms.getRequestContext().removeSiteRoot(checkPath) : "/";
        CmsResource checkResource = null;
        try {
            checkResource = cms.readResource(checkPath);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        for (Integer typeId : sitemapTypeIds) {
            try {
                I_CmsResourceType sitemapType = OpenCms.getResourceManager().getResourceType(typeId);
                String typeName = sitemapType.getTypeName();
                CmsExplorerTypeSettings explorerType = OpenCms.getWorkplaceManager().getExplorerTypeSetting(typeName);
                if (explorerType != null && checkResource != null) {
                    try {
                        CmsExplorerTypeAccess access = explorerType.getAccess();
                        if (!access.getPermissions(cms, checkResource).requiresControlPermission()) {
                            continue;
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                CmsListInfoBean infoBean = this.buildSitemapTypeInfo(sitemapType);
                subsitemapFolderTypeInfos.add(infoBean);
            }
            catch (CmsLoaderException e) {
                LOG.warn((Object)("Could not read sitemap folder type " + typeId + ": " + e.getLocalizedMessage()), (Throwable)e);
            }
        }
        return subsitemapFolderTypeInfos;
    }

    private CmsAliasTableRow createAliasTableEntry(CmsObject cms, CmsAlias alias) throws CmsException {
        CmsResource resource = cms.readResource(alias.getStructureId(), CmsResourceFilter.ALL);
        CmsAliasTableRow result = new CmsAliasTableRow();
        result.setStructureId(alias.getStructureId());
        result.setOriginalStructureId(alias.getStructureId());
        result.setAliasPath(alias.getAliasPath());
        result.setResourcePath(cms.getSitePath(resource));
        result.setKey(new CmsUUID().toString());
        result.setMode(alias.getMode());
        result.setChanged(false);
        return result;
    }

    private CmsNewResourceInfo createNavigationLevelTypeInfo() throws CmsException {
        String name = CmsResourceTypeFolder.getStaticTypeName();
        Locale locale = this.getWorkplaceLocale();
        String subtitle = Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_NAVIGATION_LEVEL_SUBTITLE_0");
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(subtitle)) {
            subtitle = CmsWorkplaceMessages.getResourceTypeName(locale, name);
        }
        CmsNewResourceInfo result = new CmsNewResourceInfo(CmsResourceTypeFolder.getStaticTypeId(), name, Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_NAVIGATION_LEVEL_TITLE_0"), subtitle, this.getCmsObject().readResource(SUB_LEVEL_REDIRECT_COPY_PAGE).getStructureId(), false, subtitle);
        result.setCreateParameter("##navigation_level_folder##");
        return result;
    }

    private void createNewContainerElements(CmsObject cms, CmsXmlContainerPage page, String sitePath) throws CmsException {
        CmsADEConfigData configData = OpenCms.getADEManager().lookupConfiguration(cms, cms.addSiteRoot(sitePath));
        Locale contentLocale = page.getLocales().get(0);
        CmsObject cloneCms = OpenCms.initCmsObject(cms);
        cloneCms.getRequestContext().setLocale(contentLocale);
        CmsContainerPageBean pageBean = page.getContainerPage(cms);
        boolean needsChanges = false;
        ArrayList<CmsContainerBean> updatedContainers = new ArrayList<CmsContainerBean>();
        for (CmsContainerBean container : pageBean.getContainers().values()) {
            ArrayList<CmsContainerElementBean> updatedElements = new ArrayList<CmsContainerElementBean>();
            for (CmsContainerElementBean element : container.getElements()) {
                if (element.isCreateNew() && !element.isGroupContainer(cms) && !element.isInheritedContainer(cms)) {
                    needsChanges = true;
                    String typeName = OpenCms.getResourceManager().getResourceType(element.getResource()).getTypeName();
                    CmsResourceTypeConfig typeConfig = configData.getResourceType(typeName);
                    if (typeConfig == null) {
                        throw new IllegalArgumentException("Can not copy template model element '" + element.getResource().getRootPath() + "' because the resource type '" + typeName + "' is not available in this sitemap.");
                    }
                    CmsResource newResource = typeConfig.createNewElement(cloneCms, element.getResource());
                    CmsContainerElementBean newBean = new CmsContainerElementBean(newResource.getStructureId(), element.getFormatterId(), element.getIndividualSettings(), false);
                    updatedElements.add(newBean);
                    continue;
                }
                updatedElements.add(element);
            }
            CmsContainerBean updatedContainer = new CmsContainerBean(container.getName(), container.getType(), container.getParentInstanceId(), container.getMaxElements(), updatedElements);
            updatedContainers.add(updatedContainer);
        }
        if (needsChanges) {
            CmsContainerPageBean updatedPage = new CmsContainerPageBean(updatedContainers);
            page.writeContainerPage(cms, updatedPage);
        }
    }

    private CmsClientSitemapEntry createNewEntry(String entryPoint, CmsSitemapChange change) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsClientSitemapEntry newEntry = null;
        if (change.getParentId() != null) {
            CmsResource parentFolder = cms.readResource(change.getParentId(), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
            String entryPath = "";
            CmsResource entryFolder = null;
            CmsResource newRes = null;
            byte[] content = null;
            List<CmsProperty> properties = Collections.emptyList();
            CmsResource copyPage = null;
            if (change.getNewCopyResourceId() != null) {
                copyPage = cms.readResource(change.getNewCopyResourceId(), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
                content = cms.readFile(copyPage).getContents();
                properties = cms.readPropertyObjects(copyPage, false);
            }
            ArrayList filteredProperties = new ArrayList();
            for (CmsProperty property : properties) {
                if (property.getName().equals("Description")) continue;
                filteredProperties.add(property);
            }
            properties = filteredProperties;
            if (this.isRedirectType(change.getNewResourceTypeId())) {
                entryPath = CmsStringUtil.joinPaths(cms.getSitePath(parentFolder), change.getName());
                newRes = cms.createResource(entryPath, change.getNewResourceTypeId(), null, Collections.singletonList(new CmsProperty("Title", change.getName(), null)));
                cms.writePropertyObjects(newRes, this.generateInheritProperties(change, newRes));
                this.applyNavigationChanges(change, newRes);
            } else {
                boolean isContainerPage;
                boolean idWasNull;
                String entryFolderPath = CmsStringUtil.joinPaths(cms.getSitePath(parentFolder), change.getName() + "/");
                boolean bl = idWasNull = change.getEntryId() == null;
                if (idWasNull) {
                    change.setEntryId(new CmsUUID());
                }
                boolean isFunctionDetail = false;
                boolean isNavigationLevel = false;
                if (change.getCreateParameter() != null) {
                    if (CmsUUID.isValidUUID(change.getCreateParameter())) {
                        isFunctionDetail = true;
                    } else if ("##navigation_level_folder##".equals(change.getCreateParameter())) {
                        isNavigationLevel = true;
                    }
                }
                String folderType = CmsResourceTypeFolder.getStaticTypeName();
                String createSitemapFolderType = change.getCreateSitemapFolderType();
                if (createSitemapFolderType != null) {
                    folderType = createSitemapFolderType;
                }
                int folderTypeId = OpenCms.getResourceManager().getResourceType(folderType).getTypeId();
                entryFolder = new CmsResource(change.getEntryId(), new CmsUUID(), entryFolderPath, folderTypeId, true, 0, cms.getRequestContext().getCurrentProject().getUuid(), CmsResource.STATE_NEW, System.currentTimeMillis(), cms.getRequestContext().getCurrentUser().getId(), System.currentTimeMillis(), cms.getRequestContext().getCurrentUser().getId(), 0L, Long.MAX_VALUE, 1, 0, System.currentTimeMillis(), 0);
                List<CmsProperty> folderProperties = this.generateInheritProperties(change, entryFolder);
                if (isNavigationLevel) {
                    folderProperties.add(new CmsProperty("default-file", "##navigation_level_folder##", null));
                }
                entryFolder = cms.createResource(entryFolderPath, folderTypeId, null, folderProperties);
                if (createSitemapFolderType != null) {
                    this.createSitemapContentFolder(cms, entryFolder);
                }
                if (idWasNull) {
                    change.setEntryId(entryFolder.getStructureId());
                }
                this.applyNavigationChanges(change, entryFolder);
                entryPath = CmsStringUtil.joinPaths(entryFolderPath, "index.html");
                boolean bl2 = isContainerPage = change.getNewResourceTypeId() == CmsResourceTypeXmlContainerPage.getContainerPageTypeIdSafely();
                if (isContainerPage && copyPage != null) {
                    CmsXmlContainerPage page = CmsXmlContainerPageFactory.unmarshal(cms, cms.readFile(copyPage), true, true);
                    this.ensureSingleLocale(page, entryFolder);
                    if (isFunctionDetail) {
                        String functionDetailContainer = this.getFunctionDetailContainerName(parentFolder);
                        CmsUUID functionStructureId = new CmsUUID(change.getCreateParameter());
                        CmsResource functionFormatter = cms.readResource("/system/modules/org.opencms.ade.containerpage/formatters/function.jsp", CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
                        this.addFunctionDetailElement(cms, page, functionDetailContainer, functionStructureId, functionFormatter.getStructureId());
                    }
                    this.createNewContainerElements(cms, page, entryPath);
                    content = page.marshal();
                }
                newRes = cms.createResource(entryPath, copyPage != null ? copyPage.getTypeId() : change.getNewResourceTypeId(), content, properties);
                cms.writePropertyObjects(newRes, this.generateOwnProperties(change));
            }
            if (entryFolder != null) {
                this.tryUnlock(entryFolder);
                String sitePath = cms.getSitePath(entryFolder);
                newEntry = this.toClientEntry(this.getNavBuilder().getNavigationForResource(sitePath, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED), false);
                newEntry.setSubEntries(this.getChildren(sitePath, 1, null), null);
                newEntry.setChildrenLoadedInitially(true);
            }
            if (newRes != null) {
                this.tryUnlock(newRes);
            }
            if (newEntry == null) {
                newEntry = this.toClientEntry(this.getNavBuilder().getNavigationForResource(cms.getSitePath(newRes), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED), false);
            }
            newEntry.setPosition(-1);
            newEntry.setNew(true);
            change.getClipBoardData().getModifications().remove(null);
            change.getClipBoardData().getModifications().put(newEntry.getId(), newEntry);
        }
        return newEntry;
    }

    private CmsNewResourceInfo createNewResourceInfo(CmsObject cms, CmsResource modelResource, Locale locale) throws CmsException {
        if (!cms.existsResource(modelResource.getStructureId(), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED)) {
            modelResource = cms.readResource(cms.getSitePath(modelResource), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
        }
        int typeId = modelResource.getTypeId();
        String name = OpenCms.getResourceManager().getResourceType(typeId).getTypeName();
        String title = cms.readPropertyObject(modelResource, "Title", false).getValue();
        String description = cms.readPropertyObject(modelResource, "Description", false).getValue();
        try {
            CmsGallerySearchResult result = CmsGallerySearch.searchById(cms, modelResource.getStructureId(), locale);
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly(result.getTitle())) {
                title = result.getTitle();
            }
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly(result.getDescription())) {
                description = result.getDescription();
            }
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        boolean editable = false;
        try {
            CmsResource freshModelResource = cms.readResource(modelResource.getStructureId(), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
            editable = cms.hasPermissions(freshModelResource, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.DEFAULT);
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        CmsNewResourceInfo info = new CmsNewResourceInfo(typeId, name, title, description, modelResource.getStructureId(), editable, description);
        Float navpos = null;
        try {
            CmsProperty navposProp = cms.readPropertyObject(modelResource, "NavPos", true);
            String navposStr = navposProp.getValue();
            if (navposStr != null) {
                try {
                    navpos = Float.valueOf(navposStr);
                }
                catch (NumberFormatException e) {}
            }
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        info.setNavPos(navpos);
        info.setDate(CmsDateUtil.getDate(new Date(modelResource.getDateLastModified()), 1, this.getWorkplaceLocale()));
        info.setVfsPath(modelResource.getRootPath());
        return info;
    }

    private CmsNewResourceInfo createResourceTypeInfo(I_CmsResourceType resType, CmsResource copyResource) {
        String name = resType.getTypeName();
        Locale locale = this.getWorkplaceLocale();
        String subtitle = CmsWorkplaceMessages.getResourceTypeDescription(locale, name);
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(subtitle)) {
            subtitle = CmsWorkplaceMessages.getResourceTypeName(locale, name);
        }
        if (copyResource != null) {
            return new CmsNewResourceInfo(copyResource.getTypeId(), name, CmsWorkplaceMessages.getResourceTypeName(locale, name), CmsWorkplaceMessages.getResourceTypeDescription(locale, name), copyResource.getStructureId(), false, subtitle);
        }
        return new CmsNewResourceInfo(resType.getTypeId(), name, CmsWorkplaceMessages.getResourceTypeName(locale, name), CmsWorkplaceMessages.getResourceTypeDescription(locale, name), null, false, subtitle);
    }

    private void createSitemapContentFolder(CmsObject cms, CmsResource subSitemapFolder) throws CmsException {
        String sitePath = cms.getSitePath(subSitemapFolder);
        String folderName = CmsStringUtil.joinPaths(sitePath, ".content/");
        String sitemapConfigName = CmsStringUtil.joinPaths(folderName, ".config");
        if (!cms.existsResource(folderName)) {
            cms.createResource(folderName, OpenCms.getResourceManager().getResourceType("content_folder").getTypeId());
        }
        I_CmsResourceType configType = OpenCms.getResourceManager().getResourceType("sitemap_config");
        if (cms.existsResource(sitemapConfigName)) {
            CmsResource configFile = cms.readResource(sitemapConfigName);
            if (configFile.getTypeId() != configType.getTypeId()) {
                throw new CmsException(Messages.get().container("ERR_CREATING_SUB_SITEMAP_WRONG_CONFIG_FILE_TYPE_2", sitemapConfigName, "sitemap_config"));
            }
        } else {
            cms.createResource(sitemapConfigName, OpenCms.getResourceManager().getResourceType("sitemap_config").getTypeId());
        }
    }

    private CmsClientSitemapEntry delete(CmsSitemapChange change) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsResource resource = cms.readResource(change.getEntryId(), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
        this.ensureLock(resource);
        cms.deleteResource(cms.getSitePath(resource), CmsResource.DELETE_PRESERVE_SIBLINGS);
        this.tryUnlock(resource);
        return null;
    }

    private CmsClientLock generateClientLock(CmsResource resource) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsLock lock = cms.getLock(resource);
        CmsClientLock clientLock = new CmsClientLock();
        clientLock.setLockType(CmsClientLock.LockType.valueOf(lock.getType().getMode()));
        CmsUUID ownerId = lock.getUserId();
        if (!lock.isUnlocked() && ownerId != null) {
            clientLock.setLockOwner(cms.readUser(ownerId).getDisplayName(cms, cms.getRequestContext().getLocale()));
            clientLock.setOwnedByUser(cms.getRequestContext().getCurrentUser().getId().equals(ownerId));
        }
        return clientLock;
    }

    private List<CmsProperty> generateInheritProperties(CmsSitemapChange change, CmsResource entryFolder) {
        ArrayList<CmsProperty> result = new ArrayList<CmsProperty>();
        Map<String, CmsClientProperty> clientProps = change.getOwnInternalProperties();
        if (clientProps != null) {
            for (CmsClientProperty clientProp : clientProps.values()) {
                CmsProperty prop = new CmsProperty(clientProp.getName(), clientProp.getStructureValue(), clientProp.getResourceValue());
                result.add(prop);
            }
        }
        result.add(new CmsProperty("Title", change.getName(), null));
        return result;
    }

    private List<CmsProperty> generateOwnProperties(CmsSitemapChange change) {
        ArrayList<CmsProperty> result = new ArrayList<CmsProperty>();
        Map<String, CmsClientProperty> clientProps = change.getDefaultFileProperties();
        if (clientProps != null) {
            for (CmsClientProperty clientProp : clientProps.values()) {
                CmsProperty prop = new CmsProperty(clientProp.getName(), clientProp.getStructureValue(), clientProp.getResourceValue());
                result.add(prop);
            }
        }
        result.add(new CmsProperty("Title", change.getName(), null));
        return result;
    }

    private Map<String, CmsClientProperty> generateParentProperties(String rootPath) throws CmsException {
        CmsObject cms = this.getCmsObject();
        if (rootPath == null) {
            rootPath = cms.getRequestContext().addSiteRoot("/");
        }
        CmsObject rootCms = OpenCms.initCmsObject(cms);
        rootCms.getRequestContext().setSiteRoot("");
        String parentRootPath = CmsResource.getParentFolder(rootPath);
        HashMap<String, CmsClientProperty> result = new HashMap<String, CmsClientProperty>();
        if (parentRootPath != null) {
            List<CmsProperty> props = rootCms.readPropertyObjects(parentRootPath, true);
            for (CmsProperty prop : props) {
                CmsClientProperty clientProp = CmsVfsSitemapService.createClientProperty(prop, true);
                result.put(clientProp.getName(), clientProp);
            }
        }
        return result;
    }

    private List<CmsClientSitemapEntry> getChildren(String root, int levels, String targetPath) throws CmsException {
        ArrayList<CmsClientSitemapEntry> children = new ArrayList<CmsClientSitemapEntry>();
        int i = 0;
        for (CmsJspNavElement navElement : this.getNavBuilder().getNavigationForFolder(root, CmsJspNavBuilder.Visibility.all, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED)) {
            CmsClientSitemapEntry child = this.toClientEntry(navElement, false);
            if (child == null) continue;
            child.setPosition(i);
            children.add(child);
            int nextLevels = levels;
            if (nextLevels == 2 && targetPath != null && targetPath.startsWith(child.getSitePath())) {
                nextLevels = 3;
            }
            if (child.isFolderType() && (nextLevels > 1 || nextLevels == -1) && !this.isSubSitemap(navElement)) {
                child.setSubEntries(this.getChildren(child.getSitePath(), nextLevels - 1, targetPath), null);
                child.setChildrenLoadedInitially(true);
            }
            ++i;
        }
        return children;
    }

    private CmsSitemapClipboardData getClipboardData() {
        CmsSitemapClipboardData result = new CmsSitemapClipboardData();
        result.setModifications(this.getModifiedList());
        result.setDeletions(this.getDeletedList());
        return result;
    }

    private LinkedHashMap<CmsUUID, CmsClientSitemapEntry> getDeletedList() {
        CmsObject cms = this.getCmsObject();
        CmsUser user = cms.getRequestContext().getCurrentUser();
        Object obj = user.getAdditionalInfo(ADDINFO_ADE_DELETED_LIST);
        LinkedHashMap<CmsUUID, CmsClientSitemapEntry> result = new LinkedHashMap<CmsUUID, CmsClientSitemapEntry>();
        if (obj instanceof String) {
            try {
                JSONArray array = new JSONArray((String)obj);
                for (int i = 0; i < array.length(); ++i) {
                    try {
                        CmsUUID delId = new CmsUUID(array.getString(i));
                        CmsResource res = cms.readResource(delId, CmsResourceFilter.ALL);
                        if (!res.getState().isDeleted()) continue;
                        CmsClientSitemapEntry delEntry = new CmsClientSitemapEntry();
                        delEntry.setSitePath(cms.getSitePath(res));
                        delEntry.setOwnProperties(this.getClientProperties(cms, res, false));
                        delEntry.setName(res.getName());
                        delEntry.setVfsPath(cms.getSitePath(res));
                        delEntry.setResourceTypeName(OpenCms.getResourceManager().getResourceType(res).getTypeName());
                        delEntry.setEntryType(res.isFolder() ? CmsClientSitemapEntry.EntryType.folder : (this.isRedirectType(res.getTypeId()) ? CmsClientSitemapEntry.EntryType.redirect : CmsClientSitemapEntry.EntryType.leaf));
                        delEntry.setId(delId);
                        result.put(delId, delEntry);
                        continue;
                    }
                    catch (Throwable e) {
                        LOG.warn((Object)e.getLocalizedMessage());
                    }
                }
            }
            catch (Throwable e) {
                LOG.warn((Object)e.getLocalizedMessage());
            }
        }
        return result;
    }

    private String getFunctionDetailContainerName(CmsResource parent) {
        CmsObject cms = this.getCmsObject();
        String notFound = null;
        String containerInfo = OpenCms.getTemplateContextManager().readPropertyFromTemplate(cms, parent, "container.info", notFound);
        if (containerInfo == notFound) {
            return null;
        }
        Map<String, String> attrs = CmsStringUtil.splitAsMap(containerInfo, "|", "=");
        String functionDetailContainerName = attrs.get(KEY_FUNCTION_DETAIL);
        return functionDetailContainerName;
    }

    private List<CmsGalleryFolderEntry> getGalleriesForType(String entryPointUri, CmsGalleryType galleryType, List<String> subSitePaths) throws CmsException {
        ArrayList<CmsGalleryFolderEntry> galleries = new ArrayList<CmsGalleryFolderEntry>();
        List<CmsResource> galleryFolders = this.getCmsObject().readResources(entryPointUri, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireType(galleryType.getTypeId()));
        for (CmsResource folder : galleryFolders) {
            try {
                if (this.isInSubsite(subSitePaths, folder.getRootPath())) continue;
                galleries.add(this.readGalleryFolderEntry(folder, galleryType.getTypeName()));
            }
            catch (CmsException ex) {
                this.log(ex.getLocalizedMessage(), ex);
            }
        }
        Collections.sort(galleries, new Comparator<CmsGalleryFolderEntry>(){

            @Override
            public int compare(CmsGalleryFolderEntry o1, CmsGalleryFolderEntry o2) {
                return o1.getSitePath().compareTo(o2.getSitePath());
            }
        });
        ArrayList<CmsGalleryFolderEntry> galleryTree = new ArrayList<CmsGalleryFolderEntry>();
        for (int i = 0; i < galleries.size(); ++i) {
            boolean isSubGallery = false;
            if (i > 0) {
                for (int j = i - 1; j >= 0; --j) {
                    if (!((CmsGalleryFolderEntry)galleries.get(i)).getSitePath().startsWith(((CmsGalleryFolderEntry)galleries.get(j)).getSitePath())) continue;
                    ((CmsGalleryFolderEntry)galleries.get(j)).addSubGallery((CmsGalleryFolderEntry)galleries.get(i));
                    isSubGallery = true;
                    break;
                }
            }
            if (isSubGallery) continue;
            galleryTree.add((CmsGalleryFolderEntry)galleries.get(i));
        }
        return galleryTree;
    }

    private Locale getLocaleForNewResourceInfos(CmsObject cms, CmsADEConfigData configData) {
        Locale locale = CmsLocaleManager.getDefaultLocale();
        try {
            String basePath = configData.getBasePath();
            CmsObject rootCms = OpenCms.initCmsObject(cms);
            rootCms.getRequestContext().setSiteRoot("");
            CmsResource baseDir = rootCms.readResource(basePath, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
            locale = CmsLocaleManager.getMainLocale(cms, baseDir);
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return locale;
    }

    private LinkedHashMap<CmsUUID, CmsClientSitemapEntry> getModifiedList() {
        CmsObject cms = this.getCmsObject();
        CmsUser user = cms.getRequestContext().getCurrentUser();
        Object obj = user.getAdditionalInfo(ADDINFO_ADE_MODIFIED_LIST);
        LinkedHashMap<CmsUUID, CmsClientSitemapEntry> result = new LinkedHashMap<CmsUUID, CmsClientSitemapEntry>();
        if (obj instanceof String) {
            try {
                JSONArray array = new JSONArray((String)obj);
                for (int i = 0; i < array.length(); ++i) {
                    try {
                        CmsUUID modId = new CmsUUID(array.getString(i));
                        CmsResource res = cms.readResource(modId, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
                        String sitePath = cms.getSitePath(res);
                        CmsJspNavElement navEntry = this.getNavBuilder().getNavigationForResource(sitePath, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
                        if (!navEntry.isInNavigation()) continue;
                        CmsClientSitemapEntry modEntry = this.toClientEntry(navEntry, false);
                        result.put(modId, modEntry);
                        continue;
                    }
                    catch (Throwable e) {
                        LOG.warn((Object)e.getLocalizedMessage());
                    }
                }
            }
            catch (Throwable e) {
                LOG.warn((Object)e.getLocalizedMessage());
            }
        }
        return result;
    }

    private CmsJspNavBuilder getNavBuilder() {
        if (this.m_navBuilder == null) {
            this.m_navBuilder = new CmsJspNavBuilder(this.getCmsObject());
        }
        return this.m_navBuilder;
    }

    private List<CmsNewResourceInfo> getNewResourceInfos(CmsObject cms, CmsADEConfigData configData, Locale locale) {
        ArrayList<CmsNewResourceInfo> result = new ArrayList<CmsNewResourceInfo>();
        for (CmsModelPageConfig modelConfig : configData.getModelPages()) {
            try {
                result.add(this.createNewResourceInfo(cms, modelConfig.getResource(), locale));
            }
            catch (CmsException e) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        Collections.sort(result, new Comparator<CmsNewResourceInfo>(){

            @Override
            public int compare(CmsNewResourceInfo a, CmsNewResourceInfo b) {
                return ComparisonChain.start().compare((Object)a.getNavPos(), (Object)b.getNavPos(), (Comparator)Ordering.natural().nullsLast()).result();
            }
        });
        return result;
    }

    private List<String> getPropertyNames(CmsObject cms) throws CmsException {
        List<CmsPropertyDefinition> propDefs = cms.readAllPropertyDefinitions();
        ArrayList<String> result = new ArrayList<String>();
        for (CmsPropertyDefinition propDef : propDefs) {
            result.add(propDef.getName());
        }
        return result;
    }

    private List<CmsNewResourceInfo> getResourceTypeInfos(CmsObject cms, List<CmsResourceTypeConfig> resourceTypeConfigs, List<CmsFunctionReference> functionReferences, CmsResource modelResource, Locale locale) {
        ArrayList<CmsNewResourceInfo> result = new ArrayList<CmsNewResourceInfo>();
        for (CmsResourceTypeConfig typeConfig : resourceTypeConfigs) {
            if (typeConfig.isDetailPagesDisabled()) continue;
            String typeName = typeConfig.getTypeName();
            try {
                I_CmsResourceType resourceType = OpenCms.getResourceManager().getResourceType(typeName);
                result.add(this.createResourceTypeInfo(resourceType, modelResource));
            }
            catch (CmsLoaderException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        for (CmsFunctionReference functionRef : functionReferences) {
            try {
                String description;
                CmsResource functionRes = cms.readResource(functionRef.getStructureId());
                String subtitle = description = cms.readPropertyObject(functionRes, "Description", false).getValue();
                try {
                    CmsGallerySearchResult searchResult = CmsGallerySearch.searchById(cms, functionRef.getStructureId(), this.getWorkplaceLocale());
                    subtitle = searchResult.getDescription();
                }
                catch (CmsException e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                CmsNewResourceInfo info = new CmsNewResourceInfo(modelResource.getTypeId(), "function@" + functionRef.getName(), functionRef.getName(), description, modelResource.getStructureId(), false, subtitle);
                info.setCreateParameter(functionRef.getStructureId().toString());
                info.setIsFunction(true);
                result.add(info);
            }
            catch (CmsVfsResourceNotFoundException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private CmsClientSitemapEntry getRootEntry(String rootPath, String targetPath) throws CmsSecurityException, CmsException {
        CmsJspNavElement navElement;
        CmsClientSitemapEntry result;
        String sitePath = "/";
        if (rootPath != null) {
            sitePath = this.getCmsObject().getRequestContext().removeSiteRoot(rootPath);
        }
        if ((result = this.toClientEntry(navElement = this.getNavBuilder().getNavigationForResource(sitePath, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED), true)) != null) {
            result.setPosition(0);
            result.setChildrenLoadedInitially(true);
            result.setSubEntries(this.getChildren(sitePath, 2, targetPath), null);
        }
        return result;
    }

    private CmsSitemapInfo getSitemapInfo(String basePath) throws CmsException {
        String description;
        CmsObject cms = this.getCmsObject();
        CmsResource baseFolder = null;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(basePath)) {
            baseFolder = cms.readResource(cms.getRequestContext().removeSiteRoot(basePath), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
        } else {
            basePath = "/";
            baseFolder = cms.readResource("/");
        }
        CmsResource defaultFile = cms.readDefaultFile(baseFolder, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
        String title = cms.readPropertyObject(baseFolder, "Title", false).getValue();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(title) && defaultFile != null) {
            title = cms.readPropertyObject(defaultFile, "Title", false).getValue();
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(description = cms.readPropertyObject(baseFolder, "Description", false).getValue()) && defaultFile != null) {
            description = cms.readPropertyObject(defaultFile, "Description", false).getValue();
        }
        return new CmsSitemapInfo(cms.getRequestContext().getCurrentProject().getName(), description, OpenCms.getLocaleManager().getDefaultLocale(cms, baseFolder).toString(), OpenCms.getSiteManager().getCurrentSite(cms).getUrl() + OpenCms.getLinkManager().substituteLinkForUnknownTarget(cms, basePath), title);
    }

    private int getSubsitemapType() throws CmsRpcException {
        try {
            return OpenCms.getResourceManager().getResourceType("subsitemap").getTypeId();
        }
        catch (CmsLoaderException e) {
            this.error(e);
            return CmsResourceTypeUnknownFolder.getStaticTypeId();
        }
    }

    private Locale getWorkplaceLocale() {
        Locale result = OpenCms.getWorkplaceManager().getWorkplaceLocale(this.getCmsObject());
        if (result == null) {
            result = CmsLocaleManager.getDefaultLocale();
        }
        if (result == null) {
            result = Locale.getDefault();
        }
        return result;
    }

    private boolean hasDefaultFileChanges(CmsSitemapChange change) {
        return change.getDefaultFileId() != null && !change.isNew();
    }

    private boolean hasOwnChanges(CmsSitemapChange change) {
        return !change.isNew();
    }

    private boolean isDefaultFile(CmsResource resource) throws CmsException {
        CmsObject cms = this.getCmsObject();
        if (resource.isFolder()) {
            return false;
        }
        CmsResource parent = cms.readResource(CmsResource.getParentFolder(cms.getSitePath(resource)), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
        CmsResource defaultFile = cms.readDefaultFile(parent, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
        return resource.equals(defaultFile);
    }

    private boolean isDisplayToolbar(HttpServletRequest request) {
        boolean displayToolbar = true;
        if (CmsHistoryResourceHandler.isHistoryRequest((ServletRequest)request)) {
            displayToolbar = false;
        }
        return displayToolbar;
    }

    private boolean isInSubsite(List<String> subSitePaths, String path) {
        boolean result = false;
        for (String subSite : subSitePaths) {
            if (!path.startsWith(subSite)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isRedirectType(int typeId) {
        try {
            return typeId == OpenCms.getResourceManager().getResourceType(RECOURCE_TYPE_NAME_REDIRECT).getTypeId();
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isSubSitemap(CmsJspNavElement navElement) {
        return CmsResourceTypeFolderSubSitemap.isSubSitemap(navElement.getResource());
    }

    private boolean isValidOpenPath(CmsObject cms, String openPath) {
        String parent;
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(openPath)) {
            return false;
        }
        return cms.existsResource(openPath) || !CmsStringUtil.isEmptyOrWhitespaceOnly(parent = CmsResource.getParentFolder(openPath)) && cms.existsResource(parent);
    }

    private boolean isValidReturnCode(String returnCode) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(returnCode)) {
            return false;
        }
        int pos = returnCode.indexOf(":");
        if (pos > 0) {
            return CmsUUID.isValidUUID(returnCode.substring(0, pos)) && CmsUUID.isValidUUID(returnCode.substring(pos + 1));
        }
        return CmsUUID.isValidUUID(returnCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyEntry(CmsSitemapChange change) throws CmsException {
        CmsResource entryFolder;
        block17: {
            CmsObject cms = this.getCmsObject();
            CmsResource entryPage = null;
            entryFolder = null;
            CmsResource ownRes = null;
            CmsResource defaultFileRes = null;
            try {
                if (this.hasOwnChanges(change)) {
                    ownRes = cms.readResource(change.getEntryId(), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
                    this.ensureLock(ownRes);
                }
                if (this.hasDefaultFileChanges(change)) {
                    defaultFileRes = cms.readResource(change.getDefaultFileId(), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
                    this.ensureLock(defaultFileRes);
                }
                if (ownRes != null && ownRes.isFolder()) {
                    entryFolder = ownRes;
                }
                if (ownRes != null && ownRes.isFile()) {
                    entryPage = ownRes;
                }
                if (defaultFileRes != null) {
                    entryPage = defaultFileRes;
                }
                if (change.isLeafType()) {
                    entryFolder = entryPage;
                }
                this.updateProperties(cms, ownRes, defaultFileRes, change.getPropertyChanges());
                if (change.hasChangedPosition()) {
                    this.updateNavPos(ownRes, change);
                }
                if (entryFolder != null && (change.hasNewParent() || change.hasChangedName())) {
                    String destinationPath;
                    if (change.hasNewParent()) {
                        CmsResource futureParent = cms.readResource(change.getParentId(), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
                        destinationPath = CmsStringUtil.joinPaths(cms.getSitePath(futureParent), change.getName());
                    } else {
                        destinationPath = CmsStringUtil.joinPaths(CmsResource.getParentFolder(cms.getSitePath(entryFolder)), change.getName());
                    }
                    if (change.isLeafType() && destinationPath.endsWith("/")) {
                        destinationPath = destinationPath.substring(0, destinationPath.length() - 1);
                    }
                    if (!cms.getSitePath(entryFolder).equals(destinationPath)) {
                        cms.moveResource(cms.getSitePath(entryFolder), destinationPath);
                    }
                    entryFolder = cms.readResource(entryFolder.getStructureId(), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
                }
                if (entryPage == null) break block17;
            }
            catch (Throwable throwable) {
                if (entryPage != null) {
                    this.tryUnlock(entryPage);
                }
                if (entryFolder != null) {
                    this.tryUnlock(entryFolder);
                }
                throw throwable;
            }
            this.tryUnlock(entryPage);
        }
        if (entryFolder != null) {
            this.tryUnlock(entryFolder);
        }
    }

    private CmsGalleryFolderEntry readGalleryFolderEntry(CmsResource folder, String typeName) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsGalleryFolderEntry folderEntry = new CmsGalleryFolderEntry();
        folderEntry.setResourceType(typeName);
        folderEntry.setSitePath(cms.getSitePath(folder));
        folderEntry.setStructureId(folder.getStructureId());
        folderEntry.setOwnProperties(this.getClientProperties(cms, folder, false));
        return folderEntry;
    }

    private void removeAllLocalesExcept(CmsXmlContainerPage page, Locale localeToKeep) throws CmsXmlException {
        List<Locale> locales = page.getLocales();
        for (Locale locale : locales) {
            if (locale.equals(localeToKeep)) continue;
            page.removeLocale(locale);
        }
    }

    private CmsSitemapChange removeEntryFromNavigation(CmsSitemapChange change) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsResource entryFolder = cms.readResource(change.getEntryId(), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
        this.ensureLock(entryFolder);
        ArrayList<CmsProperty> properties = new ArrayList<CmsProperty>();
        properties.add(new CmsProperty("NavText", "", ""));
        properties.add(new CmsProperty("NavPos", "", ""));
        cms.writePropertyObjects(cms.getSitePath(entryFolder), properties);
        this.tryUnlock(entryFolder);
        return change;
    }

    private void saveDetailPages(List<CmsDetailPageInfo> detailPages, CmsResource resource, CmsUUID newId, CmsClientSitemapEntry updateEntry) throws CmsException {
        CmsObject cms = this.getCmsObject();
        if (updateEntry != null) {
            for (CmsDetailPageInfo info : detailPages) {
                if (info.getId() != null) continue;
                updateEntry.setDetailpageTypeName(info.getType());
                break;
            }
        }
        CmsDetailPageConfigurationWriter writer = new CmsDetailPageConfigurationWriter(cms, resource);
        writer.updateAndSave(detailPages, newId);
    }

    private void setClipboardData(CmsSitemapClipboardData clipboardData) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsUser user = cms.getRequestContext().getCurrentUser();
        if (clipboardData != null) {
            JSONArray modified = new JSONArray();
            if (clipboardData.getModifications() != null) {
                for (CmsUUID id : clipboardData.getModifications().keySet()) {
                    if (id == null) continue;
                    modified.put(id.toString());
                }
            }
            user.setAdditionalInfo(ADDINFO_ADE_MODIFIED_LIST, modified.toString());
            JSONArray deleted = new JSONArray();
            if (clipboardData.getDeletions() != null) {
                for (CmsUUID id : clipboardData.getDeletions().keySet()) {
                    if (id == null) continue;
                    deleted.put(id.toString());
                }
            }
            user.setAdditionalInfo(ADDINFO_ADE_DELETED_LIST, deleted.toString());
            cms.writeUser(user);
        }
    }

    private boolean shouldChangeDefaultFileTitle(Map<String, CmsProperty> properties, CmsProperty folderNavtext) {
        return properties == null || properties.get("Title") == null || properties.get("Title").getValue() == null || folderNavtext != null && properties.get("Title").getValue().equals(folderNavtext.getValue());
    }

    private boolean shouldChangeTitle(Map<String, CmsProperty> properties) {
        return properties == null || properties.get("Title") == null || properties.get("Title").getValue() == null || properties.get("NavText") != null && properties.get("Title").getValue().equals(properties.get("NavText").getValue());
    }

    private CmsClientSitemapEntry toClientEntry(CmsJspNavElement navElement, boolean isRoot) throws CmsException {
        long dateReleased;
        long dateExpired;
        List<CmsAlias> aliases;
        CmsResource entryPage = null;
        CmsObject cms = this.getCmsObject();
        CmsClientSitemapEntry clientEntry = new CmsClientSitemapEntry();
        CmsResource entryFolder = null;
        CmsResource ownResource = navElement.getResource();
        clientEntry.setResourceState(ownResource.getState());
        CmsResource defaultFileResource = null;
        if (ownResource.isFolder() && !navElement.isNavigationLevel()) {
            defaultFileResource = cms.readDefaultFile(ownResource, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
        }
        Map<String, CmsClientProperty> ownProps = this.getClientProperties(cms, ownResource, false);
        HashMap<String, CmsClientProperty> defaultFileProps = null;
        if (defaultFileResource != null) {
            defaultFileProps = this.getClientProperties(cms, defaultFileResource, false);
            clientEntry.setDefaultFileId(defaultFileResource.getStructureId());
            clientEntry.setDefaultFileType(OpenCms.getResourceManager().getResourceType(defaultFileResource.getTypeId()).getTypeName());
        } else {
            defaultFileProps = new HashMap();
        }
        boolean isDefault = this.isDefaultFile(ownResource);
        clientEntry.setId(ownResource.getStructureId());
        clientEntry.setResourceTypeId(ownResource.getTypeId());
        clientEntry.setFolderDefaultPage(isDefault);
        if (navElement.getResource().isFolder()) {
            entryFolder = navElement.getResource();
            entryPage = defaultFileResource;
            clientEntry.setName(entryFolder.getName());
            if (entryPage == null) {
                entryPage = entryFolder;
            }
            if (!isRoot && this.isSubSitemap(navElement)) {
                clientEntry.setEntryType(CmsClientSitemapEntry.EntryType.subSitemap);
                clientEntry.setDefaultFileType(null);
            } else if (navElement.isNavigationLevel()) {
                clientEntry.setEntryType(CmsClientSitemapEntry.EntryType.navigationLevel);
            }
            CmsLock folderLock = cms.getLock(entryFolder);
            clientEntry.setHasForeignFolderLock(!folderLock.isUnlocked() && !folderLock.isOwnedBy(cms.getRequestContext().getCurrentUser()));
            if (!cms.getRequestContext().getCurrentProject().isOnlineProject()) {
                List<CmsResource> blockingChildren = cms.getBlockingLockedResources(entryFolder);
                clientEntry.setBlockingLockedChildren(blockingChildren != null && !blockingChildren.isEmpty());
            }
        } else {
            entryPage = navElement.getResource();
            clientEntry.setName(entryPage.getName());
            if (this.isRedirectType(entryPage.getTypeId())) {
                clientEntry.setEntryType(CmsClientSitemapEntry.EntryType.redirect);
                CmsFile file = this.getCmsObject().readFile(entryPage);
                CmsXmlContent content = CmsXmlContentFactory.unmarshal(this.getCmsObject(), file);
                I_CmsXmlContentValue linkValue = content.getValue(REDIRECT_LINK_TARGET_XPATH, this.getCmsObject().getRequestContext().getLocale());
                String link = linkValue != null ? linkValue.getStringValue(this.getCmsObject()) : Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_REDIRECT_SUB_LEVEL_0");
                clientEntry.setRedirectTarget(link);
            } else {
                clientEntry.setEntryType(CmsClientSitemapEntry.EntryType.leaf);
            }
        }
        if (entryPage.isFile() && !(aliases = OpenCms.getAliasManager().getAliasesForStructureId(this.getCmsObject(), entryPage.getStructureId())).isEmpty()) {
            ArrayList<String> aliasList = new ArrayList<String>();
            for (CmsAlias alias : aliases) {
                String aliasPath = alias.getAliasPath();
                aliasList.add(aliasPath);
            }
            clientEntry.setAliases(aliasList);
        }
        if ((dateExpired = navElement.getResource().getDateExpired()) != Long.MAX_VALUE) {
            clientEntry.setDateExpired(CmsDateUtil.getDate(new Date(dateExpired), 3, this.getWorkplaceLocale()));
        }
        if ((dateReleased = navElement.getResource().getDateReleased()) != 0L) {
            clientEntry.setDateReleased(CmsDateUtil.getDate(new Date(dateReleased), 3, this.getWorkplaceLocale()));
        }
        clientEntry.setResleasedAndNotExpired(navElement.getResource().isReleasedAndNotExpired(System.currentTimeMillis()));
        String path = cms.getSitePath(entryPage);
        clientEntry.setVfsPath(path);
        clientEntry.setOwnProperties(ownProps);
        clientEntry.setDefaultFileProperties(defaultFileProps);
        clientEntry.setSitePath(entryFolder != null ? cms.getSitePath(entryFolder) : path);
        clientEntry.setLock(this.generateClientLock(entryPage));
        clientEntry.setInNavigation(isRoot || navElement.isInNavigation());
        String type = OpenCms.getResourceManager().getResourceType(ownResource).getTypeName();
        clientEntry.setResourceTypeName(type);
        clientEntry.setPermissionInfo(OpenCms.getADEManager().getPermissionInfo(cms, ownResource, null));
        return clientEntry;
    }

    private CmsSitemapChange undelete(CmsSitemapChange change) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsResource deleted = cms.readResource(change.getEntryId(), CmsResourceFilter.ALL);
        if (deleted.getState().isDeleted()) {
            this.ensureLock(deleted);
            cms.undeleteResource(this.getCmsObject().getSitePath(deleted), true);
            this.tryUnlock(deleted);
        }
        String parentPath = CmsResource.getParentFolder(cms.getSitePath(deleted));
        CmsJspNavElement navElement = this.getNavBuilder().getNavigationForResource(parentPath, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
        CmsClientSitemapEntry entry = this.toClientEntry(navElement, navElement.isInNavigation());
        entry.setSubEntries(this.getChildren(parentPath, 2, null), null);
        change.setUpdatedEntry(entry);
        change.setParentId(cms.readParentFolder(deleted.getStructureId()).getStructureId());
        return change;
    }

    private void updateNavPos(CmsResource res, CmsSitemapChange change) throws CmsException {
        if (change.hasChangedPosition()) {
            this.applyNavigationChanges(change, res);
        }
    }

    private void updateProperties(CmsObject cms, CmsResource ownRes, CmsResource defaultFileRes, List<CmsPropertyModification> propertyModifications) throws CmsException {
        Map<String, CmsProperty> ownProps = this.getPropertiesByName(cms.readPropertyObjects(ownRes, false));
        boolean changeOwnTitle = this.shouldChangeTitle(ownProps);
        boolean changeDefaultFileTitle = false;
        Map<String, CmsProperty> defaultFileProps = Collections.emptyMap();
        if (defaultFileRes != null) {
            defaultFileProps = this.getPropertiesByName(cms.readPropertyObjects(defaultFileRes, false));
            changeDefaultFileTitle = this.shouldChangeDefaultFileTitle(defaultFileProps, ownProps.get("NavText"));
        }
        String hasNavTextChange = null;
        ArrayList<CmsProperty> ownPropertyChanges = new ArrayList<CmsProperty>();
        ArrayList<CmsProperty> defaultFilePropertyChanges = new ArrayList<CmsProperty>();
        for (CmsPropertyModification propMod : propertyModifications) {
            CmsProperty propToModify = null;
            if (ownRes.getStructureId().equals(propMod.getId())) {
                if ("NavText".equals(propMod.getName())) {
                    hasNavTextChange = propMod.getValue();
                } else if ("Title".equals(propMod.getName())) {
                    changeOwnTitle = false;
                }
                propToModify = ownProps.get(propMod.getName());
                if (propToModify == null) {
                    propToModify = new CmsProperty(propMod.getName(), null, null);
                }
                ownPropertyChanges.add(propToModify);
            } else {
                if ("Title".equals(propMod.getName())) {
                    changeDefaultFileTitle = false;
                }
                if ((propToModify = defaultFileProps.get(propMod.getName())) == null) {
                    propToModify = new CmsProperty(propMod.getName(), null, null);
                }
                defaultFilePropertyChanges.add(propToModify);
            }
            String newValue = propMod.getValue();
            if (newValue == null) {
                newValue = "";
            }
            if (propMod.isStructureValue()) {
                propToModify.setStructureValue(newValue);
                continue;
            }
            propToModify.setResourceValue(newValue);
        }
        if (hasNavTextChange != null) {
            CmsProperty titleProp;
            if (changeOwnTitle) {
                titleProp = ownProps.get("Title");
                if (titleProp == null) {
                    titleProp = new CmsProperty("Title", null, null);
                }
                titleProp.setStructureValue(hasNavTextChange);
                ownPropertyChanges.add(titleProp);
            }
            if (changeDefaultFileTitle) {
                titleProp = defaultFileProps.get("Title");
                if (titleProp == null) {
                    titleProp = new CmsProperty("Title", null, null);
                }
                titleProp.setStructureValue(hasNavTextChange);
                defaultFilePropertyChanges.add(titleProp);
            }
        }
        if (!ownPropertyChanges.isEmpty()) {
            cms.writePropertyObjects(ownRes, ownPropertyChanges);
        }
        if (!defaultFilePropertyChanges.isEmpty() && defaultFileRes != null) {
            cms.writePropertyObjects(defaultFileRes, defaultFilePropertyChanges);
        }
    }

    protected class LockInfo {
        private CmsLock m_lock;
        private boolean m_wasJustLocked;

        public LockInfo(CmsLock lock, boolean wasJustLocked) {
            this.m_lock = lock;
            this.m_wasJustLocked = wasJustLocked;
        }

        public CmsLock getLock() {
            return this.m_lock;
        }

        public boolean wasJustLocked() {
            return this.m_wasJustLocked;
        }
    }
}

