/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.sitemap.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.LinkedHashMap;
import org.opencms.ade.sitemap.shared.CmsClientSitemapEntry;
import org.opencms.util.CmsUUID;

public class CmsSitemapClipboardData
implements IsSerializable {
    private LinkedHashMap<CmsUUID, CmsClientSitemapEntry> m_deletions;
    private LinkedHashMap<CmsUUID, CmsClientSitemapEntry> m_modifications;

    public CmsSitemapClipboardData() {
        this.m_deletions = new LinkedHashMap();
        this.m_modifications = new LinkedHashMap();
    }

    public CmsSitemapClipboardData(LinkedHashMap<CmsUUID, CmsClientSitemapEntry> deletions, LinkedHashMap<CmsUUID, CmsClientSitemapEntry> modifications) {
        this.m_deletions = deletions;
        this.m_modifications = modifications;
    }

    public void addDeleted(CmsClientSitemapEntry entry) {
        if (this.m_deletions.containsKey(entry.getId())) {
            this.m_deletions.remove(entry.getId());
        }
        this.m_deletions.put(entry.getId(), entry);
    }

    public void addModified(CmsClientSitemapEntry entry) {
        if (this.m_modifications.containsKey(entry.getId())) {
            this.m_modifications.remove(entry.getId());
        }
        this.m_modifications.put(entry.getId(), entry);
    }

    public CmsSitemapClipboardData copy() {
        LinkedHashMap<CmsUUID, CmsClientSitemapEntry> deletions = new LinkedHashMap<CmsUUID, CmsClientSitemapEntry>();
        deletions.putAll(this.m_deletions);
        LinkedHashMap<CmsUUID, CmsClientSitemapEntry> modifications = new LinkedHashMap<CmsUUID, CmsClientSitemapEntry>();
        modifications.putAll(this.m_modifications);
        return new CmsSitemapClipboardData(deletions, modifications);
    }

    public LinkedHashMap<CmsUUID, CmsClientSitemapEntry> getDeletions() {
        return this.m_deletions;
    }

    public LinkedHashMap<CmsUUID, CmsClientSitemapEntry> getModifications() {
        return this.m_modifications;
    }

    public void removeDeleted(CmsClientSitemapEntry entry) {
        this.m_deletions.remove(entry.getId());
    }

    public void removeModified(CmsClientSitemapEntry entry) {
        this.m_modifications.remove(entry.getId());
    }

    public void setDeletions(LinkedHashMap<CmsUUID, CmsClientSitemapEntry> deletions) {
        this.m_deletions = deletions;
    }

    public void setModifications(LinkedHashMap<CmsUUID, CmsClientSitemapEntry> modifications) {
        this.m_modifications = modifications;
    }
}

