/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.cache;

import org.apache.commons.collections.Transformer;
import org.apache.commons.logging.Log;
import org.opencms.cache.CmsVfsCache;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.monitor.CmsMemoryMonitor;
import org.opencms.xml.Messages;

public class CmsVfsMemoryObjectCache
extends CmsVfsCache {
    private static int instanceCounter;
    private static final Log LOG;
    private static CmsVfsMemoryObjectCache m_vfsMemoryObjectCache;
    private int m_id = instanceCounter++;

    public CmsVfsMemoryObjectCache() {
        this.registerEventListener();
    }

    public static CmsVfsMemoryObjectCache getVfsMemoryObjectCache() {
        if (m_vfsMemoryObjectCache == null) {
            m_vfsMemoryObjectCache = new CmsVfsMemoryObjectCache();
        }
        return m_vfsMemoryObjectCache;
    }

    public Object getCachedObject(CmsObject cms, String rootPath) {
        String key = this.getCacheKeyForCurrentProject(cms, rootPath);
        return OpenCms.getMemoryMonitor().getCachedVfsObject(key);
    }

    public Object loadVfsObject(CmsObject cms, String rootPath, Transformer function) {
        Object result = this.getCachedObject(cms, rootPath);
        if (result == null) {
            result = function.transform((Object)rootPath);
            this.putCachedObject(cms, rootPath, result);
        }
        return result;
    }

    public void putCachedObject(CmsObject cms, String rootPath, Object value) {
        String key = this.getCacheKeyForCurrentProject(cms, rootPath);
        OpenCms.getMemoryMonitor().cacheVfsObject(key, value);
    }

    @Override
    protected void flush(boolean online) {
        OpenCms.getMemoryMonitor().flushCache(CmsMemoryMonitor.CacheType.VFS_OBJECT);
    }

    @Override
    protected void uncacheResource(CmsResource resource) {
        this.uncacheSystemId(resource.getRootPath());
    }

    private String getCacheKey(String systemId, boolean online) {
        if (online) {
            return "online_(" + this.m_id + ")_" + systemId;
        }
        return "offline_(" + this.m_id + ")_" + systemId;
    }

    private String getCacheKeyForCurrentProject(CmsObject cms, String rootPath) {
        boolean project = cms != null ? cms.getRequestContext().getCurrentProject().isOnlineProject() : false;
        return this.getCacheKey(rootPath, project);
    }

    private void uncacheSystemId(String systemId) {
        String key = this.getCacheKey(systemId, false);
        Object o = OpenCms.getMemoryMonitor().getCachedVfsObject(key);
        OpenCms.getMemoryMonitor().uncacheVfsObject(key);
        if (null != o && LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_ERR_UNCACHED_SYS_ID_1", key));
        }
    }

    static {
        LOG = CmsLog.getLog(CmsVfsMemoryObjectCache.class);
    }
}

