/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericKeyedObjectPoolFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.db.Messages;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

public final class CmsDbPool {
    public static final String DBCP_JDBC_URL_PREFIX = "jdbc:apache:commons:dbcp:";
    public static final String KEY_CONNECT_ATTEMTS = "connects";
    public static final String KEY_CONNECT_WAITS = "wait";
    public static final String KEY_DATABASE = "db.";
    public static final String KEY_DATABASE_NAME = "db.name";
    public static final String KEY_DATABASE_POOL = "db.pool";
    public static final String KEY_DATABASE_STATEMENTS = "db.statements";
    public static final String KEY_ENTITY_MANAGER_POOL_SIZE = "entityMangerPoolSize";
    public static final String KEY_CONNECTION_PROPERTIES = "connectionProperties";
    public static final String KEY_JDBC_DRIVER = "jdbcDriver";
    public static final String KEY_JDBC_URL = "jdbcUrl";
    public static final String KEY_JDBC_URL_PARAMS = "jdbcUrl.params";
    public static final String KEY_MAX_ACTIVE = "maxActive";
    public static final String KEY_MAX_IDLE = "maxIdle";
    public static final String KEY_MAX_WAIT = "maxWait";
    public static final String KEY_MIN_EVICTABLE_IDLE_TIME = "minEvictableIdleTime";
    public static final String KEY_MIN_IDLE = "minIdle";
    public static final String KEY_NUM_TESTS_PER_EVICTION_RUN = "numTestsPerEvictionRun";
    public static final String KEY_PASSWORD = "password";
    public static final String KEY_POOL_DEFAULT = "default";
    public static final String KEY_POOL_URL = "poolUrl";
    public static final String KEY_POOL_USER = "user";
    public static final String KEY_POOL_VFS = "vfs";
    public static final String KEY_POOLING = "pooling";
    public static final String KEY_TEST_ON_BORROW = "testOnBorrow";
    public static final String KEY_TEST_QUERY = "testQuery";
    public static final String KEY_TEST_WHILE_IDLE = "testWhileIdle";
    public static final String KEY_TIME_BETWEEN_EVICTION_RUNS = "timeBetweenEvictionRuns";
    public static final String KEY_USERNAME = "user";
    public static final String KEY_WHEN_EXHAUSTED_ACTION = "whenExhaustedAction";
    public static final String OPENCMS_DEFAULT_POOL_NAME = "default";
    public static final String OPENCMS_DEFAULT_POOL_URL = "opencms:default";
    public static final String OPENCMS_URL_PREFIX = "opencms:";

    private CmsDbPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PoolingDriver createDriverManagerConnectionPool(CmsParameterConfiguration config, String key) throws Exception {
        String jdbcDriver = config.get("db.pool." + key + '.' + KEY_JDBC_DRIVER);
        String jdbcUrl = config.get("db.pool." + key + '.' + KEY_JDBC_URL);
        String jdbcUrlParams = config.get("db.pool." + key + '.' + KEY_JDBC_URL_PARAMS);
        int maxActive = config.getInteger("db.pool." + key + '.' + KEY_MAX_ACTIVE, 10);
        int maxWait = config.getInteger("db.pool." + key + '.' + KEY_MAX_WAIT, 2000);
        int maxIdle = config.getInteger("db.pool." + key + '.' + KEY_MAX_IDLE, 5);
        int minEvictableIdleTime = config.getInteger("db.pool." + key + '.' + KEY_MIN_EVICTABLE_IDLE_TIME, 1800000);
        int minIdle = config.getInteger("db.pool." + key + '.' + KEY_MIN_IDLE, 0);
        int numTestsPerEvictionRun = config.getInteger("db.pool." + key + '.' + KEY_NUM_TESTS_PER_EVICTION_RUN, 3);
        int timeBetweenEvictionRuns = config.getInteger("db.pool." + key + '.' + KEY_TIME_BETWEEN_EVICTION_RUNS, 3600000);
        String testQuery = config.get("db.pool." + key + '.' + KEY_TEST_QUERY);
        String username = config.get("db.pool." + key + '.' + "user");
        username = OpenCms.getCredentialsResolver().resolveCredential("db_user", username);
        String password = config.get("db.pool." + key + '.' + KEY_PASSWORD);
        password = OpenCms.getCredentialsResolver().resolveCredential("db_password", password);
        String poolUrl = config.get("db.pool." + key + '.' + KEY_POOL_URL);
        String whenExhaustedActionValue = config.get("db.pool." + key + '.' + KEY_WHEN_EXHAUSTED_ACTION).trim();
        byte whenExhaustedAction = 0;
        boolean testOnBorrow = Boolean.valueOf(config.getString("db.pool." + key + '.' + KEY_TEST_ON_BORROW, "false").trim());
        boolean testWhileIdle = Boolean.valueOf(config.getString("db.pool." + key + '.' + KEY_TEST_WHILE_IDLE, "false").trim());
        whenExhaustedAction = "block".equalsIgnoreCase(whenExhaustedActionValue) ? (byte)1 : ("fail".equalsIgnoreCase(whenExhaustedActionValue) ? (byte)0 : ("grow".equalsIgnoreCase(whenExhaustedActionValue) ? (byte)2 : 1));
        if ("".equals(testQuery)) {
            testQuery = null;
        }
        if (username == null) {
            username = "";
        }
        if (password == null) {
            password = "";
        }
        boolean poolingStmts = Boolean.valueOf(config.getString("db.statements." + key + '.' + KEY_POOLING, CmsStringUtil.TRUE).trim());
        int maxActiveStmts = config.getInteger("db.statements." + key + '.' + KEY_MAX_ACTIVE, 25);
        int maxWaitStmts = config.getInteger("db.statements." + key + '.' + KEY_MAX_WAIT, 250);
        int maxIdleStmts = config.getInteger("db.statements." + key + '.' + KEY_MAX_IDLE, 15);
        String whenStmtsExhaustedActionValue = config.get("db.statements." + key + '.' + KEY_WHEN_EXHAUSTED_ACTION);
        byte whenStmtsExhaustedAction = 2;
        if (whenStmtsExhaustedActionValue != null) {
            whenStmtsExhaustedAction = "block".equalsIgnoreCase(whenStmtsExhaustedActionValue = whenStmtsExhaustedActionValue.trim()) ? (byte)1 : ("fail".equalsIgnoreCase(whenStmtsExhaustedActionValue) ? (byte)0 : 2);
        }
        int connectionAttempts = config.getInteger("db.pool." + key + '.' + KEY_CONNECT_ATTEMTS, 10);
        int connetionsWait = config.getInteger("db.pool." + key + '.' + KEY_CONNECT_WAITS, 5000);
        Class.forName(jdbcDriver).newInstance();
        GenericObjectPool connectionPool = new GenericObjectPool(null);
        connectionPool.setMaxActive(maxActive);
        connectionPool.setMaxIdle(maxIdle);
        connectionPool.setMinIdle(minIdle);
        connectionPool.setMaxWait((long)maxWait);
        connectionPool.setWhenExhaustedAction(whenExhaustedAction);
        if (testQuery != null) {
            connectionPool.setTestOnBorrow(testOnBorrow);
            connectionPool.setTestWhileIdle(testWhileIdle);
            connectionPool.setTimeBetweenEvictionRunsMillis((long)timeBetweenEvictionRuns);
            connectionPool.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
            connectionPool.setMinEvictableIdleTimeMillis((long)minEvictableIdleTime);
        }
        if (jdbcUrlParams != null) {
            jdbcUrl = jdbcUrl + jdbcUrlParams;
        }
        Properties connectionProperties = config.getPrefixedProperties("db.pool." + key + '.' + KEY_CONNECTION_PROPERTIES);
        connectionProperties.put("user", username);
        connectionProperties.put(KEY_PASSWORD, password);
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(jdbcUrl, connectionProperties);
        GenericKeyedObjectPoolFactory statementFactory = null;
        if (poolingStmts) {
            statementFactory = new GenericKeyedObjectPoolFactory(null, maxActiveStmts, whenStmtsExhaustedAction, (long)maxWaitStmts, maxIdleStmts);
        }
        new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, statementFactory, testQuery, false, true);
        PoolingDriver driver = new PoolingDriver();
        driver.registerPool(poolUrl, (ObjectPool)connectionPool);
        Connection con = null;
        boolean connect = false;
        int connectionTests = 0;
        do {
            try {
                con = connectionFactory.createConnection();
                connect = true;
            }
            catch (Exception e) {
                ++connectionTests;
                if (CmsLog.INIT.isInfoEnabled()) {
                    CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_WAIT_FOR_DB_4", new Object[]{poolUrl, jdbcUrl, new Integer(connectionTests), new Integer(connetionsWait)}));
                }
                Thread.sleep(connetionsWait);
            }
            finally {
                if (con != null) {
                    con.close();
                }
            }
        } while (!connect && connectionTests < connectionAttempts);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_JDBC_POOL_2", poolUrl, jdbcUrl));
        }
        return driver;
    }

    public static String getDbPoolName(CmsParameterConfiguration configuration, String key) {
        return configuration.get("db.pool." + key + '.' + KEY_POOL_URL);
    }

    public static List<String> getDbPoolUrls(CmsParameterConfiguration configuration) {
        ArrayList<String> dbPoolNames = new ArrayList<String>();
        List<String> driverPoolNames = configuration.getList("db.pools");
        for (String driverPoolName : driverPoolNames) {
            dbPoolNames.add(CmsDbPool.getDbPoolName(configuration, driverPoolName));
        }
        return dbPoolNames;
    }

    public static String getDefaultDbPoolName() {
        return "default";
    }
}

