/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.collectors;

import java.io.Serializable;
import java.text.Collator;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.opencms.db.CmsDbEntryNotFoundException;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.collectors.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsPropertyResourceComparator
implements Serializable,
Comparator<CmsResource> {
    private static final long serialVersionUID = -7943213182160054552L;
    private boolean m_asc;
    private transient CmsObject m_cms;
    private Map<CmsUUID, CmsPropertyResourceComparator> m_keys;
    private String m_property;
    private String m_propertyValue;

    public CmsPropertyResourceComparator(CmsObject cms, String property, boolean asc) {
        this.m_property = property;
        this.m_asc = asc;
        this.m_cms = cms;
        this.m_keys = new HashMap<CmsUUID, CmsPropertyResourceComparator>();
    }

    private static CmsPropertyResourceComparator create(CmsResource resource, CmsObject cms, String property) {
        CmsPropertyResourceComparator result = new CmsPropertyResourceComparator(null, null, false);
        result.init(resource, cms, property);
        return result;
    }

    @Override
    public int compare(CmsResource res0, CmsResource res1) {
        if (res0 == res1) {
            return 0;
        }
        CmsPropertyResourceComparator key0 = this.m_keys.get(res0.getStructureId());
        CmsPropertyResourceComparator key1 = this.m_keys.get(res1.getStructureId());
        if (key0 == null) {
            key0 = CmsPropertyResourceComparator.create(res0, this.m_cms, this.m_property);
            this.m_keys.put(res0.getStructureId(), key0);
        }
        if (key1 == null) {
            key1 = CmsPropertyResourceComparator.create(res1, this.m_cms, this.m_property);
            this.m_keys.put(res1.getStructureId(), key1);
        }
        if (this.isNumeric(key0.getPropertyValue()) && this.isNumeric(key1.getPropertyValue())) {
            double dKey0 = Double.parseDouble(key0.getPropertyValue());
            double dKey1 = Double.parseDouble(key1.getPropertyValue());
            if (this.m_asc) {
                if (dKey0 > dKey1) {
                    return 1;
                }
                if (dKey0 < dKey1) {
                    return -1;
                }
            } else {
                if (dKey0 > dKey1) {
                    return -1;
                }
                if (dKey0 < dKey1) {
                    return 1;
                }
            }
        } else {
            Collator collator = Collator.getInstance(this.m_cms.getRequestContext().getLocale());
            if (this.m_asc) {
                return collator.compare(key0.getPropertyValue(), key1.getPropertyValue());
            }
            return collator.compare(key1.getPropertyValue(), key0.getPropertyValue());
        }
        return 0;
    }

    public String getPropertyValue() {
        if (!CmsStringUtil.isEmpty(this.m_propertyValue)) {
            return this.m_propertyValue.trim();
        }
        return "";
    }

    private void init(CmsResource resource, CmsObject cms, String property) {
        try {
            cms.readPropertyDefinition(property);
            CmsProperty prop = cms.readPropertyObject(resource, property, false);
            this.m_propertyValue = prop == CmsProperty.getNullProperty() ? "" : prop.getValue();
        }
        catch (CmsDbEntryNotFoundException dbe) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_COLLECTOR_PARAM_PROPERTY_NOT_FOUND_1", property));
        }
        catch (CmsException cmse) {
            cmse.printStackTrace();
        }
    }

    private boolean isNumeric(String value) {
        if (!CmsStringUtil.isEmpty(value)) {
            NumberFormat formatter = NumberFormat.getInstance();
            ParsePosition pos = new ParsePosition(0);
            formatter.parse(value, pos);
            return value.length() == pos.getIndex();
        }
        return false;
    }
}

