/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.db.CmsSecurityManager;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.A_CmsResourceTypeLinkParseable;
import org.opencms.file.types.Messages;
import org.opencms.loader.CmsLoaderException;
import org.opencms.loader.CmsXmlContentLoader;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsLink;
import org.opencms.relations.CmsRelationType;
import org.opencms.security.CmsPermissionSet;
import org.opencms.staticexport.CmsLinkTable;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlEntityResolver;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.types.A_CmsXmlContentValue;
import org.opencms.xml.types.CmsXmlHtmlValue;
import org.opencms.xml.types.CmsXmlVarLinkValue;
import org.opencms.xml.types.CmsXmlVfsFileValue;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsResourceTypeXmlContent
extends A_CmsResourceTypeLinkParseable {
    public static final String CONFIGURATION_SCHEMA = "schema";
    private static final Log LOG = CmsLog.getLog(CmsResourceTypeXmlContent.class);
    private String m_schema;

    public static boolean isXmlContent(CmsResource resource) {
        boolean result = false;
        if (resource != null && !resource.isFolder()) {
            try {
                result = OpenCms.getResourceManager().getLoader(resource) instanceof CmsXmlContentLoader;
            }
            catch (CmsLoaderException cmsLoaderException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public void addConfigurationParameter(String paramName, String paramValue) {
        super.addConfigurationParameter(paramName, paramValue);
        if (CONFIGURATION_SCHEMA.equalsIgnoreCase(paramName)) {
            this.m_schema = paramValue.trim();
        }
    }

    @Override
    public CmsResource createResource(CmsObject cms, CmsSecurityManager securityManager, String resourcename, byte[] content, List<CmsProperty> properties) throws CmsException {
        boolean hasModelUri = false;
        CmsXmlContent newContent = null;
        if (this.m_schema != null && (content == null || content.length == 0)) {
            CmsXmlContentDefinition contentDefinition = CmsXmlContentDefinition.unmarshal(cms, this.m_schema);
            Locale locale = this.getLocaleForNewContent(cms, securityManager, resourcename, properties);
            String modelUri = (String)cms.getRequestContext().getAttribute(CmsRequestContext.ATTRIBUTE_MODEL);
            CmsObject newCms = OpenCms.initCmsObject(cms);
            newCms.getRequestContext().setUri(CmsResource.getParentFolder(resourcename));
            if (modelUri != null) {
                newContent = CmsXmlContentFactory.createDocument(newCms, locale, modelUri);
                hasModelUri = true;
            } else {
                newContent = CmsXmlContentFactory.createDocument(newCms, locale, OpenCms.getSystemInfo().getDefaultEncoding(), contentDefinition);
            }
            content = newContent.marshal();
        }
        CmsResource resource = super.createResource(cms, securityManager, resourcename, content, properties);
        if (hasModelUri) {
            CmsFile file = cms.readFile(resource);
            newContent = CmsXmlContentFactory.unmarshal(cms, file);
            resource = newContent.getHandler().prepareForWrite(cms, newContent, file);
        }
        return resource;
    }

    @Override
    public String getCachePropertyDefault() {
        return "element;locale;";
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        CmsParameterConfiguration result = new CmsParameterConfiguration();
        CmsParameterConfiguration additional = super.getConfiguration();
        if (additional != null) {
            result.putAll(additional);
        }
        if (this.m_schema != null) {
            result.put(CONFIGURATION_SCHEMA, this.m_schema);
        }
        return result;
    }

    @Override
    public CmsFormatterConfiguration getFormattersForResource(CmsObject cms, CmsResource resource) {
        CmsFormatterConfiguration result = null;
        CmsXmlContentDefinition cd = null;
        try {
            cd = CmsXmlContentDefinition.getContentDefinitionForResource(cms, resource);
            result = cd.getContentHandler().getFormatterConfiguration(cms, resource);
        }
        catch (CmsException e) {
            // empty catch block
        }
        if (result == null) {
            LOG.warn((Object)Messages.get().getBundle().key("LOG_WARN_NO_FORMATTERS_DEFINED_1", cd == null ? resource.getRootPath() : cd.getSchemaLocation()));
            result = CmsFormatterConfiguration.EMPTY_CONFIGURATION;
        }
        return result;
    }

    @Override
    public String getGalleryPreviewProvider() {
        if (this.m_galleryPreviewProvider == null) {
            this.m_galleryPreviewProvider = this.getConfiguration().getString("gallery.preview.provider", "org.opencms.ade.galleries.preview.CmsBinaryPreviewProvider");
        }
        return this.m_galleryPreviewProvider;
    }

    @Override
    public int getLoaderId() {
        return 10;
    }

    public String getSchema() {
        return this.m_schema;
    }

    @Override
    public void initialize(CmsObject cms) {
        super.initialize(cms);
        if (this.m_schema != null) {
            try {
                if (cms.existsResource(this.m_schema)) {
                    CmsXmlContentDefinition.unmarshal(cms, this.m_schema);
                } else {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_WARN_SCHEMA_RESOURCE_DOES_NOT_EXIST_2", this.m_schema, this.getTypeName()));
                }
            }
            catch (Throwable e) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_BAD_XML_SCHEMA_2", this.m_schema, this.getTypeName()), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CmsLink> parseLinks(CmsObject cms, CmsFile file) {
        CmsXmlContent xmlContent;
        if (file.getLength() == 0) {
            return Collections.emptyList();
        }
        long requestTime = cms.getRequestContext().getRequestTime();
        try {
            cms.getRequestContext().setRequestTime(Long.MIN_VALUE);
            xmlContent = CmsXmlContentFactory.unmarshal(cms, file);
        }
        catch (CmsException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)org.opencms.db.Messages.get().getBundle().key("ERR_READ_RESOURCE_1", cms.getSitePath(file)), (Throwable)e);
            }
            List<CmsLink> list = Collections.emptyList();
            return list;
        }
        finally {
            cms.getRequestContext().setRequestTime(requestTime);
        }
        HashSet<CmsLink> links = new HashSet<CmsLink>();
        CmsLink xsdLink = this.getXsdLink(cms, xmlContent);
        if (xsdLink != null) {
            links.add(xsdLink);
        }
        List<Locale> locales = xmlContent.getLocales();
        for (Locale locale : locales) {
            List<I_CmsXmlContentValue> values = xmlContent.getValues(locale);
            for (I_CmsXmlContentValue value : values) {
                CmsLink link;
                A_CmsXmlContentValue refValue;
                if (value instanceof CmsXmlHtmlValue) {
                    CmsXmlHtmlValue htmlValue = (CmsXmlHtmlValue)value;
                    CmsLinkTable linkTable = htmlValue.getLinkTable();
                    Iterator<CmsLink> k = linkTable.iterator();
                    while (k.hasNext()) {
                        CmsLink link2 = k.next();
                        if (!link2.isInternal()) continue;
                        link2.checkConsistency(cms);
                        links.add(link2);
                    }
                    continue;
                }
                if (value instanceof CmsXmlVfsFileValue) {
                    refValue = (CmsXmlVfsFileValue)value;
                    link = ((CmsXmlVfsFileValue)refValue).getLink(cms);
                    if (link == null) continue;
                    links.add(link);
                    continue;
                }
                if (!(value instanceof CmsXmlVarLinkValue) || (link = ((CmsXmlVarLinkValue)(refValue = (CmsXmlVarLinkValue)value)).getLink(cms)) == null || !link.isInternal()) continue;
                links.add(link);
            }
        }
        return new ArrayList<CmsLink>(links);
    }

    @Override
    public CmsFile writeFile(CmsObject cms, CmsSecurityManager securityManager, CmsFile resource) throws CmsException {
        securityManager.checkPermissions(cms.getRequestContext(), (CmsResource)resource, CmsPermissionSet.ACCESS_WRITE, true, CmsResourceFilter.ALL);
        CmsXmlContent xmlContent = CmsXmlContentFactory.unmarshal(cms, resource, false);
        resource = xmlContent.getHandler().prepareForWrite(cms, xmlContent, resource);
        return super.writeFile(cms, securityManager, resource);
    }

    protected Locale getLocaleForNewContent(CmsObject cms, CmsSecurityManager securityManager, String resourcename, List<CmsProperty> properties) {
        Locale locale = (Locale)cms.getRequestContext().getAttribute(CmsRequestContext.ATTRIBUTE_NEW_RESOURCE_LOCALE);
        if (locale != null) {
            return locale;
        }
        List<Locale> locales = OpenCms.getLocaleManager().getDefaultLocales(cms, CmsResource.getParentFolder(resourcename));
        return locales.get(0);
    }

    protected CmsLink getXsdLink(CmsObject cms, CmsXmlContent xmlContent) {
        String schema = xmlContent.getContentDefinition().getSchemaLocation();
        if (schema.startsWith("opencms://")) {
            if (CmsXmlEntityResolver.isInternalId(schema)) {
                return null;
            }
            schema = schema.substring("opencms://".length() - 1);
        } else if (CmsXmlEntityResolver.isCachedSystemId(schema)) {
            return null;
        }
        try {
            CmsResource schemaRes = cms.readResource(cms.getRequestContext().removeSiteRoot(schema));
            CmsLink xsdLink = new CmsLink(null, CmsRelationType.XSD, schemaRes.getStructureId(), schemaRes.getRootPath(), true);
            return xsdLink;
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }
}

