/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.ade.containerpage.CmsRelationTargetListBean;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.types.CmsResourceTypeJsp;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.gwt.CmsResourceStatusConstants;
import org.opencms.gwt.CmsVfsService;
import org.opencms.gwt.shared.CmsListInfoBean;
import org.opencms.gwt.shared.CmsPermissionInfo;
import org.opencms.gwt.shared.CmsResourceStatusBean;
import org.opencms.gwt.shared.CmsResourceStatusRelationBean;
import org.opencms.gwt.shared.CmsResourceStatusTabId;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.relations.CmsRelationType;
import org.opencms.relations.I_CmsLinkParseable;
import org.opencms.search.galleries.CmsGallerySearch;
import org.opencms.search.galleries.CmsGallerySearchResult;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.workplace.list.Messages;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;

public class CmsDefaultResourceStatusProvider {
    private static final Log LOG = CmsLog.getLog(CmsDefaultResourceStatusProvider.class);

    public static CmsRelationTargetListBean getContainerpageRelationTargets(CmsObject cms, CmsUUID source, List<CmsUUID> additionalIds, boolean cancelIfChanged) throws CmsException {
        CmsRelationTargetListBean result = new CmsRelationTargetListBean();
        CmsResource content = cms.readResource(source, CmsResourceFilter.ALL);
        boolean isContainerPage = CmsResourceTypeXmlContainerPage.isContainerPage(content);
        for (CmsUUID structureId : additionalIds) {
            try {
                CmsResource res = cms.readResource(structureId, CmsResourceFilter.ALL);
                result.add(res);
                if (!res.getState().isChanged() || !cancelIfChanged) continue;
                return result;
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        List<CmsRelation> relations = cms.readRelations(CmsRelationFilter.relationsFromStructureId(source));
        for (CmsRelation relation : relations) {
            if (relation.getType() == CmsRelationType.XSD) continue;
            try {
                CmsResource target = relation.getTarget(cms, CmsResourceFilter.ALL);
                I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(target);
                if (isContainerPage && type instanceof CmsResourceTypeJsp) continue;
                result.add(target);
                if (!target.getState().isChanged() || !cancelIfChanged) continue;
                return result;
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public CmsResourceStatusBean getResourceStatus(CmsObject cms, CmsUUID structureId, String contentLocale, boolean includeTargets, List<CmsUUID> additionalStructureIds) throws CmsException {
        String lastProject;
        Locale realLocale;
        CmsGallerySearchResult result;
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        cms.getRequestContext().setLocale(locale);
        CmsResource resource = cms.readResource(structureId, CmsResourceFilter.ALL);
        String localizedTitle = null;
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(contentLocale) && !CmsStringUtil.isEmptyOrWhitespaceOnly((result = CmsGallerySearch.searchById(cms, structureId, realLocale = CmsLocaleManager.getLocale(contentLocale))).getTitle())) {
            localizedTitle = result.getTitle();
        }
        CmsResourceUtil resourceUtil = new CmsResourceUtil(cms, resource);
        List<CmsProperty> properties = cms.readPropertyObjects(resource, false);
        CmsResourceStatusBean result2 = new CmsResourceStatusBean();
        result2.setDateCreated(CmsVfsService.formatDateTime(cms, resource.getDateCreated()));
        long dateExpired = resource.getDateExpired();
        if (dateExpired != Long.MAX_VALUE) {
            result2.setDateExpired(CmsVfsService.formatDateTime(cms, dateExpired));
        }
        result2.setDateLastModified(CmsVfsService.formatDateTime(cms, resource.getDateLastModified()));
        long dateReleased = resource.getDateReleased();
        if (dateReleased != 0L) {
            result2.setDateReleased(CmsVfsService.formatDateTime(cms, dateReleased));
        }
        if ("".equals(lastProject = resourceUtil.getLockedInProjectName())) {
            lastProject = null;
        }
        result2.setLastProject(lastProject);
        result2.setListInfo(CmsVfsService.getPageInfo(cms, resource));
        CmsLock lock = cms.getLock(resource);
        CmsUser lockOwner = null;
        if (!lock.isUnlocked()) {
            lockOwner = cms.readUser(lock.getUserId());
            result2.setLockState(Messages.get().getBundle(locale).key("GUI_EXPLORER_LIST_ACTION_LOCK_NAME_2", lockOwner.getName(), lastProject));
        } else {
            result2.setLockState(Messages.get().getBundle(locale).key("GUI_EXPLORER_LIST_ACTION_UNLOCK_NAME_0"));
        }
        CmsProperty navText = CmsProperty.get("NavText", properties);
        if (navText != null) {
            result2.setNavText(navText.getValue());
        }
        result2.setPermissions(resourceUtil.getPermissionString());
        result2.setSize(resource.getLength());
        result2.setStateBean(resource.getState());
        CmsProperty title = CmsProperty.get("Title", properties);
        if (localizedTitle != null) {
            result2.setTitle(localizedTitle);
            result2.getListInfo().setTitle(localizedTitle);
        } else if (title != null) {
            result2.setTitle(title.getValue());
        }
        result2.setUserCreated(resourceUtil.getUserCreated());
        result2.setUserLastModified(resourceUtil.getUserLastModified());
        I_CmsResourceType resType = OpenCms.getResourceManager().getResourceType(resource.getTypeId());
        result2.setResourceType(resType.getTypeName());
        result2.setStructureId(resource.getStructureId());
        if (resType instanceof CmsResourceTypeXmlContent) {
            CmsFile file = cms.readFile(resource);
            CmsXmlContent content = CmsXmlContentFactory.unmarshal(cms, file);
            List<Locale> locales = content.getLocales();
            ArrayList<String> localeStrings = new ArrayList<String>();
            for (Locale l : locales) {
                localeStrings.add(l.toString());
            }
            result2.setLocales(localeStrings);
        }
        List<CmsRelation> relations = cms.readRelations(CmsRelationFilter.relationsToStructureId(resource.getStructureId()));
        HashMap<CmsUUID, CmsResource> relationSources = new HashMap<CmsUUID, CmsResource>();
        if (CmsResourceTypeXmlContainerPage.isContainerPage(resource)) {
            try {
                CmsResource parent = cms.readParentFolder(resource.getStructureId());
                List<CmsRelation> parentRelations = cms.readRelations(CmsRelationFilter.relationsToStructureId(parent.getStructureId()));
                relations.addAll(parentRelations);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        for (CmsRelation relation : relations) {
            CmsResource currentSource = relation.getSource(cms, CmsResourceFilter.ALL);
            relationSources.put(currentSource.getStructureId(), currentSource);
        }
        for (CmsResource relationResource : relationSources.values()) {
            try {
                CmsPermissionInfo permissionInfo = OpenCms.getADEManager().getPermissionInfo(cms, relationResource, resource.getRootPath());
                if (!permissionInfo.hasViewPermission()) continue;
                CmsResourceStatusRelationBean relationBean = this.createRelationBean(cms, contentLocale, relationResource, permissionInfo);
                result2.getRelationSources().add(relationBean);
            }
            catch (CmsVfsResourceNotFoundException notfound) {
                LOG.error((Object)notfound.getLocalizedMessage(), (Throwable)notfound);
            }
        }
        if (includeTargets) {
            result2.getRelationTargets().addAll(this.getTargets(cms, contentLocale, resource, additionalStructureIds));
        }
        result2.setTabs(this.getTabClientData(cms, resource));
        return result2;
    }

    protected List<CmsResourceStatusRelationBean> getTargets(CmsObject cms, String locale, CmsResource resource, List<CmsUUID> additionalStructureIds) throws CmsException {
        CmsRelationTargetListBean listBean = CmsDefaultResourceStatusProvider.getContainerpageRelationTargets(cms, resource.getStructureId(), additionalStructureIds, false);
        ArrayList<CmsResourceStatusRelationBean> result = new ArrayList<CmsResourceStatusRelationBean>();
        for (CmsResource target : listBean.getResources()) {
            try {
                CmsPermissionInfo permissionInfo = OpenCms.getADEManager().getPermissionInfo(cms, target, resource.getRootPath());
                if (!permissionInfo.hasViewPermission()) continue;
                CmsResourceStatusRelationBean relationBean = this.createRelationBean(cms, locale, target, permissionInfo);
                result.add(relationBean);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    CmsResourceStatusRelationBean createRelationBean(CmsObject cms, String locale, CmsResource relationResource, CmsPermissionInfo permissionInfo) throws CmsException {
        CmsListInfoBean sourceBean = CmsVfsService.getPageInfo(cms, relationResource);
        sourceBean.setMarkChangedState(true);
        sourceBean.setResourceState(relationResource.getState());
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(locale)) {
            Locale realLocale = CmsLocaleManager.getLocale(locale);
            CmsGallerySearchResult result = CmsGallerySearch.searchById(cms, relationResource.getStructureId(), realLocale);
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly(result.getTitle())) {
                sourceBean.setTitle(result.getTitle());
            }
        }
        String link = null;
        try {
            link = OpenCms.getLinkManager().substituteLink(cms, relationResource);
        }
        catch (Exception e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        CmsResourceStatusRelationBean relationBean = new CmsResourceStatusRelationBean(sourceBean, link, relationResource.getStructureId(), permissionInfo);
        if (CmsResourceTypeXmlContent.isXmlContent(relationResource)) {
            relationBean.setIsXmlContent(true);
        }
        String sitePath = cms.getSitePath(relationResource);
        relationBean.setSitePath(sitePath);
        return relationBean;
    }

    private LinkedHashMap<CmsResourceStatusTabId, String> getTabClientData(CmsObject cms, CmsResource res) {
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        LinkedHashMap<CmsResourceStatusTabId, String> result = new LinkedHashMap<CmsResourceStatusTabId, String>();
        Map<CmsResourceStatusTabId, CmsMessageContainer> tabs = this.getTabData(res);
        for (Map.Entry<CmsResourceStatusTabId, CmsMessageContainer> entry : tabs.entrySet()) {
            result.put(entry.getKey(), entry.getValue().key(locale));
        }
        return result;
    }

    private Map<CmsResourceStatusTabId, CmsMessageContainer> getTabData(CmsResource res) {
        Map<CmsResourceStatusTabId, CmsMessageContainer> tabs = CmsResourceTypeXmlContainerPage.isContainerPage(res) ? CmsResourceStatusConstants.STATUS_TABS_CONTAINER_PAGE : (OpenCms.getResourceManager().getResourceType(res) instanceof I_CmsLinkParseable ? CmsResourceStatusConstants.STATUS_TABS_CONTENT : CmsResourceStatusConstants.STATUS_TABS_OTHER);
        return tabs;
    }
}

