/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt;

import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RPC;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.gwt.ClientMessages;
import org.opencms.gwt.CmsCoreService;
import org.opencms.gwt.CmsPrefetchSerializationPolicy;
import org.opencms.gwt.Messages;
import org.opencms.gwt.shared.CmsCoreData;
import org.opencms.gwt.shared.rpc.I_CmsCoreService;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;

public class CmsGwtActionElement
extends CmsJspActionElement {
    protected static final String SCRIPT_TAG_CLOSE = "\n//-->\n</script>";
    protected static final String SCRIPT_TAG_OPEN = "<script type=\"text/javascript\">\n<!--\n";
    private static final String CMS_NO_PERMUTATION_MESSAGE = "CMS_NO_PERMUTATION_MESSAGE";
    private static final String ICON_CSS_URI = "/system/modules/org.opencms.gwt/resourceIcon.css";
    private CmsCoreData m_coreData;

    public CmsGwtActionElement(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        super(context, req, res);
    }

    public static String createNoCacheScript(String moduleName, String moduleVersion) {
        String result = "<script type=\"text/javascript\" src=\"" + CmsWorkplace.getResourceUri("ade/" + moduleName + "/" + moduleName + ".nocache.js");
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(moduleVersion)) {
            result = result + "?version=" + moduleVersion;
        }
        result = result + "\"></script>";
        return result;
    }

    public static String exportDictionary(String name, Method method, Object data) throws SerializationException {
        return CmsGwtActionElement.exportDictionary(name, CmsGwtActionElement.serialize(method, data));
    }

    public static String exportDictionary(String name, String data) {
        StringBuffer sb = new StringBuffer();
        sb.append("<meta name=\"").append(name).append("\" content=\"").append(data).append("\" />");
        return sb.toString();
    }

    public static String exportMeta(String name, String data) {
        String escName = CmsEncoder.escapeXml(name);
        String escData = CmsEncoder.escapeXml(data);
        return "<meta name=\"" + escName + "\" content=\"" + escData + "\" />";
    }

    public static String serialize(Method method, Object data) throws SerializationException {
        String result = RPC.encodeResponseForSuccess((Method)method, (Object)data, (SerializationPolicy)CmsPrefetchSerializationPolicy.instance());
        result = CmsEncoder.escapeXml(result, true);
        return result;
    }

    public static StringBuffer wrapScript(StringBuffer sb) {
        sb.insert(0, SCRIPT_TAG_OPEN);
        sb.append(SCRIPT_TAG_CLOSE).append("\n");
        return sb;
    }

    @Deprecated
    public String createNoCacheScript(String moduleName) {
        return CmsGwtActionElement.createNoCacheScript(moduleName, null);
    }

    public String export() throws Exception {
        return this.export(null);
    }

    public String export(String iconCssClassPrefix) throws Exception {
        String wpLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(this.getCmsObject()).getLanguage();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(wpLocale)) {
            wpLocale = Locale.ENGLISH.getLanguage();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("var ").append(CMS_NO_PERMUTATION_MESSAGE).append("='").append(Messages.get().getBundle(OpenCms.getWorkplaceManager().getWorkplaceLocale(this.getCmsObject())).key("ERR_NO_PERMUTATION_AVAILABLE_0")).append("';\n");
        CmsGwtActionElement.wrapScript(sb);
        sb.append("<meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\" />");
        String prefetchedData = CmsGwtActionElement.exportDictionary("org_opencms_gwt", I_CmsCoreService.class.getMethod("prefetch", new Class[0]), this.getCoreData());
        sb.append(prefetchedData);
        sb.append(ClientMessages.get().export(this.getRequest()));
        sb.append("<style type=\"text/css\">\n @import url(\"").append(this.iconCssLink(iconCssClassPrefix)).append("\");\n</style>\n");
        sb.append("<meta name=\"gwt:property\" content=\"locale=").append(wpLocale).append("\" />\n");
        return sb.toString();
    }

    public String exportAll() throws Exception {
        return this.export();
    }

    public String exportAll(String cssIconClassPrefix) throws Exception {
        return this.export(cssIconClassPrefix);
    }

    public CmsCoreData getCoreData() {
        if (this.m_coreData == null) {
            this.m_coreData = CmsCoreService.prefetch(this.getRequest());
        }
        return this.m_coreData;
    }

    public Locale getWorkplaceLocale() {
        return OpenCms.getWorkplaceManager().getWorkplaceLocale(this.getCmsObject());
    }

    private String iconCssLink(String prefix) {
        String param = "";
        if (!CmsStringUtil.isEmpty(prefix)) {
            try {
                param = "?prefix=" + URLEncoder.encode(prefix, OpenCms.getSystemInfo().getDefaultEncoding());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return this.link(ICON_CSS_URI) + param;
    }
}

