/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import org.opencms.gwt.shared.CmsCategoryTreeEntry;
import org.opencms.gwt.shared.sort.I_CmsHasPath;
import org.opencms.gwt.shared.sort.I_CmsHasTitle;
import org.opencms.relations.CmsCategory;
import org.opencms.util.CmsUUID;

public class CmsCategoryBean
implements I_CmsHasTitle,
I_CmsHasPath,
IsSerializable {
    private String m_basePath;
    private String m_description;
    private CmsUUID m_id;
    private String m_path;
    private String m_rootPath;
    private String m_sitePath;
    private String m_title;

    public CmsCategoryBean(CmsCategory category) {
        this(category.getId(), category.getTitle(), category.getDescription(), category.getPath(), category.getBasePath(), category.getRootPath());
    }

    public CmsCategoryBean(CmsCategoryTreeEntry categoryTreeEntry) {
        this(categoryTreeEntry.getId(), categoryTreeEntry.getTitle(), categoryTreeEntry.getDescription(), categoryTreeEntry.getPath(), categoryTreeEntry.getBasePath(), categoryTreeEntry.getRootPath());
        this.m_sitePath = categoryTreeEntry.getSitePath();
    }

    public CmsCategoryBean(CmsUUID id, String title, String description, String path, String basePath, String rootPath) {
        this.m_id = id;
        this.m_title = title;
        this.m_description = description;
        this.m_path = path;
        this.m_basePath = basePath;
        this.m_rootPath = rootPath;
    }

    protected CmsCategoryBean() {
    }

    public String getBasePath() {
        return this.m_basePath;
    }

    public String getDescription() {
        return this.m_description;
    }

    public CmsUUID getId() {
        return this.m_id;
    }

    @Override
    public String getPath() {
        return this.m_path;
    }

    public String getRootPath() {
        return this.m_rootPath;
    }

    public String getSitePath() {
        return this.m_sitePath;
    }

    @Override
    public String getTitle() {
        return this.m_title;
    }

    public boolean matchesFilter(String filter) {
        filter = filter.toLowerCase();
        return this.m_title.toLowerCase().contains(filter) || this.m_path.toLowerCase().contains(filter);
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setPath(String path) {
        this.m_path = path;
    }

    public void setSitePath(String sitePath) {
        this.m_sitePath = sitePath;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }
}

