/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.i18n;

import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.opencms.i18n.CmsMessageException;
import org.opencms.i18n.CmsMultiMessages;
import org.opencms.i18n.CmsResourceBundleLoader;
import org.opencms.i18n.CmsVfsResourceBundle;
import org.opencms.i18n.Messages;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsDateUtil;
import org.opencms.util.CmsStringUtil;

public class CmsMessages {
    public static final String KEY_SHORT_SUFFIX = ".short";
    public static final String UNKNOWN_KEY_EXTENSION = "???";
    private static final Log LOG = CmsLog.getLog(CmsMessages.class);
    private String m_bundleName;
    private Locale m_locale;
    private ResourceBundle m_resourceBundle;

    public CmsMessages(String bundleName, Locale locale) {
        try {
            this.m_locale = locale;
            this.m_bundleName = bundleName;
            this.m_resourceBundle = CmsResourceBundleLoader.getBundle(bundleName, this.m_locale);
        }
        catch (MissingResourceException e) {
            this.m_resourceBundle = null;
        }
        catch (Exception e) {
            this.m_resourceBundle = null;
            LOG.error((Object)Messages.get().getBundle().key("ERR_CREATING_MESSAGES_2", bundleName, this.m_locale), (Throwable)e);
        }
    }

    public CmsMessages(String bundleName, String language) {
        this(bundleName, language, "", "");
    }

    public CmsMessages(String bundleName, String language, String country) {
        this(bundleName, language, country, "");
    }

    public CmsMessages(String bundleName, String language, String country, String variant) {
        this(bundleName, new Locale(language, country, variant));
    }

    protected CmsMessages() {
    }

    public static String formatUnknownKey(String keyName) {
        StringBuffer buf = new StringBuffer(64);
        buf.append(UNKNOWN_KEY_EXTENSION);
        buf.append(" ");
        buf.append(keyName);
        buf.append(" ");
        buf.append(UNKNOWN_KEY_EXTENSION);
        return buf.toString();
    }

    public static boolean isUnknownKey(String value) {
        return value == null || value.startsWith(UNKNOWN_KEY_EXTENSION);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsMultiMessages) {
            return false;
        }
        if (obj instanceof CmsMessages) {
            CmsMessages other = (CmsMessages)obj;
            return other.getBundleName().equals(this.m_bundleName) && other.getLocale().equals(this.m_locale);
        }
        return false;
    }

    public String getDate(Date date) {
        return CmsDateUtil.getDate(date, 3, this.m_locale);
    }

    public String getDate(Date date, int format) {
        return CmsDateUtil.getDate(date, format, this.m_locale);
    }

    public String getDate(long time) {
        return CmsDateUtil.getDate(new Date(time), 3, this.m_locale);
    }

    public String getDateTime(Date date) {
        return CmsDateUtil.getDateTime(date, 3, this.m_locale);
    }

    public String getDateTime(Date date, int format) {
        return CmsDateUtil.getDateTime(date, format, this.m_locale);
    }

    public String getDateTime(long time) {
        return CmsDateUtil.getDateTime(new Date(time), 3, this.m_locale);
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public ResourceBundle getResourceBundle() {
        return this.m_resourceBundle;
    }

    public String getString(String keyName) throws CmsMessageException {
        if (this.m_resourceBundle != null) {
            try {
                return this.m_resourceBundle.getString(keyName);
            }
            catch (MissingResourceException e) {
                throw new CmsMessageException(Messages.get().container("ERR_CANT_FIND_RESOURCE_FOR_BUNDLE_2", keyName, this.m_bundleName));
            }
        }
        throw new CmsMessageException(Messages.get().container("ERR_MESSAGE_BUNDLE_NOT_INITIALIZED_1", this.m_bundleName));
    }

    public int hashCode() {
        return this.m_locale.hashCode() + (this.m_bundleName == null ? 0 : this.m_bundleName.hashCode());
    }

    public boolean isInitialized() {
        return this.m_resourceBundle != null;
    }

    public boolean isUncacheable() {
        return this.m_resourceBundle instanceof CmsVfsResourceBundle;
    }

    public String key(String keyName) {
        return this.key(keyName, false);
    }

    public String key(String keyName, boolean allowNull) {
        block3: {
            try {
                if (this.m_resourceBundle != null) {
                    return this.m_resourceBundle.getString(keyName);
                }
            }
            catch (MissingResourceException e) {
                if (!allowNull) break block3;
                return null;
            }
        }
        return CmsMessages.formatUnknownKey(keyName);
    }

    public String key(String key, Object arg0) {
        return this.key(key, new Object[]{arg0});
    }

    public String key(String key, Object arg0, Object arg1) {
        return this.key(key, new Object[]{arg0, arg1});
    }

    public String key(String key, Object arg0, Object arg1, Object arg2) {
        return this.key(key, new Object[]{arg0, arg1, arg2});
    }

    public String key(String key, Object[] args) {
        if (args == null || args.length == 0) {
            return this.key(key);
        }
        String result = this.key(key, true);
        if (result == null) {
            result = CmsMessages.formatUnknownKey(key);
        } else {
            MessageFormat formatter = new MessageFormat(result, this.m_locale);
            result = formatter.format(args);
        }
        return result;
    }

    public String keyDefault(String keyName, String defaultValue) {
        String result = this.key(keyName, true);
        return result == null ? defaultValue : result;
    }

    public String keyWithParams(String keyName) {
        if (keyName.indexOf(124) == -1) {
            return this.key(keyName, false);
        }
        String[] values = CmsStringUtil.splitAsArray(keyName, '|');
        String cutKeyName = values[0];
        Object[] params = new String[values.length - 1];
        System.arraycopy(values, 1, params, 0, params.length);
        return this.key(cutKeyName, params);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append('[');
        result.append(this.getClass().getName());
        result.append(", baseName: ");
        result.append(this.m_bundleName);
        result.append(", locale: ");
        result.append(this.getLocale());
        result.append(']');
        return result.toString();
    }

    protected String getBundleName() {
        return this.m_bundleName;
    }

    protected void setBundleName(String bundleName) {
        this.m_bundleName = bundleName;
    }

    protected void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    protected void setResourceBundle(ResourceBundle resourceBundle) {
        this.m_resourceBundle = resourceBundle;
    }
}

