/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsObject;
import org.opencms.flex.CmsFlexController;
import org.opencms.jsp.CmsJspScopedVarBodyTagSuport;
import org.opencms.jsp.util.CmsJspNavigationBean;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.util.CmsStringUtil;

public class CmsJspTagNavigation
extends CmsJspScopedVarBodyTagSuport {
    private static final long serialVersionUID = 8589202895748764705L;
    protected transient CmsObject m_cms;
    protected String m_endLevel;
    protected String m_param;
    protected String m_resource;
    protected String m_startLevel;
    protected Type m_type;

    public CmsJspTagNavigation() {
    }

    public CmsJspTagNavigation(PageContext context) {
        this.setPageContext(context);
        this.init();
    }

    public int doStartTag() throws CmsIllegalArgumentException {
        this.init();
        return 0;
    }

    public String getEndLevel() {
        return this.m_endLevel;
    }

    public String getParam() {
        return this.m_param;
    }

    public String getResource() {
        return this.m_resource;
    }

    public String getStartLevel() {
        return this.m_startLevel;
    }

    public String getType() {
        return this.m_type == null ? null : this.m_type.toString();
    }

    @Override
    public void release() {
        this.m_cms = null;
        this.m_startLevel = null;
        this.m_endLevel = null;
        this.m_resource = null;
        this.m_type = null;
        super.release();
    }

    public void setEndLevel(String endLevel) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(endLevel)) {
            this.m_endLevel = endLevel.trim();
        }
    }

    public void setParam(String param) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(param)) {
            this.m_param = param.trim();
        }
    }

    public void setResource(String resource) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(resource)) {
            this.m_resource = resource.trim();
        }
    }

    public void setStartLevel(String startLevel) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(startLevel)) {
            this.m_startLevel = startLevel.trim();
        }
    }

    public void setType(String type) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(type)) {
            this.m_type = Type.parse(type.trim());
        }
    }

    protected void init() {
        CmsFlexController controller = CmsFlexController.getController(this.pageContext.getRequest());
        this.m_cms = controller.getCmsObject();
        int startLevel = this.m_startLevel == null ? Integer.MIN_VALUE : Integer.parseInt(this.m_startLevel);
        int endLevel = this.m_endLevel == null ? Integer.MIN_VALUE : Integer.parseInt(this.m_endLevel);
        CmsJspNavigationBean bean = new CmsJspNavigationBean(this.m_cms, this.m_type, startLevel, endLevel, this.m_resource, this.m_param);
        this.storeAttribute(this.getVar(), bean);
    }

    public static enum Type {
        breadCrumb,
        forFolder,
        forResource,
        forSite,
        treeForFolder;


        public static Type parse(String name) throws IllegalArgumentException {
            return Enum.valueOf(Type.class, name);
        }
    }
}

